/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.twa.tmx.core.valueobject;

/**
 * 処理クラス [BentenMergeTmxProcess]の入力バリューオブジェクトクラスです。
 */
public class BentenMergeTmxProcessInput {
    /**
     * verboseモードで動作させるかどうか。
     *
     * フィールド: [verbose]。
     * デフォルト: [false]。
     */
    private boolean fVerbose = false;

    /**
     * マージ元となる TMX フラグメント・ファイル。
     *
     * フィールド: [sourcefile]。
     */
    private String fSourcefile;

    /**
     * マージ先となる TMX ファイル。
     *
     * フィールド: [targetfile]。
     */
    private String fTargetfile;

    /**
     * 翻訳元言語
     *
     * フィールド: [transsourcelang]。
     * デフォルト: [en-US]。
     */
    private String fTranssourcelang = "en-US";

    /**
     * 翻訳先言語
     *
     * フィールド: [transtargetlang]。
     * デフォルト: [ja-JP]。
     */
    private String fTranstargetlang = "ja-JP";

    /**
     * フィールド [verbose] の値を設定します。
     *
     * フィールドの説明: [verboseモードで動作させるかどうか。]。
     *
     * @param argVerbose フィールド[verbose]に設定する値。
     */
    public void setVerbose(final boolean argVerbose) {
        fVerbose = argVerbose;
    }

    /**
     * フィールド [verbose] の値を取得します。
     *
     * フィールドの説明: [verboseモードで動作させるかどうか。]。
     * デフォルト: [false]。
     *
     * @return フィールド[verbose]から取得した値。
     */
    public boolean getVerbose() {
        return fVerbose;
    }

    /**
     * フィールド [sourcefile] の値を設定します。
     *
     * フィールドの説明: [マージ元となる TMX フラグメント・ファイル。]。
     *
     * @param argSourcefile フィールド[sourcefile]に設定する値。
     */
    public void setSourcefile(final String argSourcefile) {
        fSourcefile = argSourcefile;
    }

    /**
     * フィールド [sourcefile] の値を取得します。
     *
     * フィールドの説明: [マージ元となる TMX フラグメント・ファイル。]。
     *
     * @return フィールド[sourcefile]から取得した値。
     */
    public String getSourcefile() {
        return fSourcefile;
    }

    /**
     * フィールド [targetfile] の値を設定します。
     *
     * フィールドの説明: [マージ先となる TMX ファイル。]。
     *
     * @param argTargetfile フィールド[targetfile]に設定する値。
     */
    public void setTargetfile(final String argTargetfile) {
        fTargetfile = argTargetfile;
    }

    /**
     * フィールド [targetfile] の値を取得します。
     *
     * フィールドの説明: [マージ先となる TMX ファイル。]。
     *
     * @return フィールド[targetfile]から取得した値。
     */
    public String getTargetfile() {
        return fTargetfile;
    }

    /**
     * フィールド [transsourcelang] の値を設定します。
     *
     * フィールドの説明: [翻訳元言語]。
     *
     * @param argTranssourcelang フィールド[transsourcelang]に設定する値。
     */
    public void setTranssourcelang(final String argTranssourcelang) {
        fTranssourcelang = argTranssourcelang;
    }

    /**
     * フィールド [transsourcelang] の値を取得します。
     *
     * フィールドの説明: [翻訳元言語]。
     * デフォルト: [en-US]。
     *
     * @return フィールド[transsourcelang]から取得した値。
     */
    public String getTranssourcelang() {
        return fTranssourcelang;
    }

    /**
     * フィールド [transtargetlang] の値を設定します。
     *
     * フィールドの説明: [翻訳先言語]。
     *
     * @param argTranstargetlang フィールド[transtargetlang]に設定する値。
     */
    public void setTranstargetlang(final String argTranstargetlang) {
        fTranstargetlang = argTranstargetlang;
    }

    /**
     * フィールド [transtargetlang] の値を取得します。
     *
     * フィールドの説明: [翻訳先言語]。
     * デフォルト: [ja-JP]。
     *
     * @return フィールド[transtargetlang]から取得した値。
     */
    public String getTranstargetlang() {
        return fTranstargetlang;
    }

    /**
     * このバリューオブジェクトの文字列表現を取得します。
     *
     * <P>使用上の注意</P>
     * <UL>
     * <LI>オブジェクトのシャロー範囲のみ文字列化の処理対象となります。
     * <LI>オブジェクトが循環参照している場合には、このメソッドは使わないでください。
     * </UL>
     *
     * @return バリューオブジェクトの文字列表現。
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("benten.twa.tmx.core.valueobject.BentenMergeTmxProcessInput[");
        buf.append("verbose=" + fVerbose);
        buf.append(",sourcefile=" + fSourcefile);
        buf.append(",targetfile=" + fTargetfile);
        buf.append(",transsourcelang=" + fTranssourcelang);
        buf.append(",transtargetlang=" + fTranstargetlang);
        buf.append("]");
        return buf.toString();
    }
}
