/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.tmx.wizards;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;

import benten.twa.tmx.dialogs.MergeTmxDialog;
import benten.twa.tmx.messages.BentenMergeTmxMessages;
import benten.twa.ui.dialogs.AbstractWorkflowDialog;
import benten.twa.ui.wizards.AbstractWorkflowDialogWizardPage;

/**
 * TMX フラグメントのマージ
 *
 * <pre>
 * TMX フラグメントを TMX にマージします。
 *   1.  TMX の内容を、別の TMX にマージします。
 * </pre>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳メモリー断片抽出・マージ機能: TMXフラグメント・マージ機能」に対応します。
 *
 * @author YAMAMOTO Koji
 */
public class MergeTmxWizardPage2 extends AbstractWorkflowDialogWizardPage {
	/**
	 * TMXマージ機能のためのメッセージ。
	 */
	protected static final BentenMergeTmxMessages fMsg = new BentenMergeTmxMessages();

	/**
	 * コンストラクター。
	 * @param selection 選択
	 */
	protected MergeTmxWizardPage2(final IStructuredSelection selection) {
		super(selection);
		setTitle(fMsg.getWizardPage2Title());
		setDescription(fMsg.getWizardPage2Description());
	}

	@Override
	public AbstractWorkflowDialog createWorkflowDialog(final Composite parent, final IStructuredSelection selection) {
		return new MergeTmxDialog(parent.getShell(), selection);
	}
}
