/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.cat.ui.messages;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * CAT プラグイン設定ページのためのメッセージ。
 *
 * リソースバンドル定義: [CatPreferencePageMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class CatPreferencePageMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * CatPreferencePageMessagesクラスのコンストラクタ。
     *
     * 基底名[CatPreferencePageMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public CatPreferencePageMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/ui/messages/CatPreferencePageMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * CatPreferencePageMessagesクラスのコンストラクタ。
     *
     * 基底名[CatPreferencePageMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public CatPreferencePageMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/ui/messages/CatPreferencePageMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * CatPreferencePageMessagesクラスのコンストラクタ。
     *
     * 基底名[CatPreferencePageMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public CatPreferencePageMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/ui/messages/CatPreferencePageMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[CatPreferencePageMessages], key[Label.1]
     *
     * [Show Text of Translation Unit Tab] (en)<br>
     * [翻訳単位タブのテキスト表示] (ja)<br>
     *
     * @return key[Label.1]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabel1() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Show Text of Translation Unit Tab";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.1");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatPreferencePageMessages], key[Label.2]
     *
     * [Make Visible New&amp;lines, Tabs, Single-byte spaces] (en)<br>
     * [改行、タブ、半角空白を可視化(&amp;L)] (ja)<br>
     *
     * @return key[Label.2]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabel2() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Make Visible New&lines, Tabs, Single-byte spaces";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.2");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatPreferencePageMessages], key[Label.GroupTransLang]
     *
     * [Translation Language Settings] (en)<br>
     * [翻訳言語の設定] (ja)<br>
     *
     * @return key[Label.GroupTransLang]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelGroupTransLang() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Translation Language Settings";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.GroupTransLang");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatPreferencePageMessages], key[Label.SourceLang]
     *
     * [Translation Source Language:] (en)<br>
     * [翻訳元の言語:] (ja)<br>
     *
     * @return key[Label.SourceLang]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelSourceLang() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Translation Source Language:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.SourceLang");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatPreferencePageMessages], key[Label.TargetLang]
     *
     * [Translation Target Language:] (en)<br>
     * [翻訳先の言語:] (ja)<br>
     *
     * @return key[Label.TargetLang]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelTargetLang() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Translation Target Language:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.TargetLang");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatPreferencePageMessages], key[Label.PivotLang]
     *
     * [Translation Pivot Language:] (en)<br>
     * [基軸言語:] (ja)<br>
     *
     * @return key[Label.PivotLang]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelPivotLang() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Translation Pivot Language:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.PivotLang");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatPreferencePageMessages], key[Label.PivotLang.Tooltip]
     *
     * [翻訳の中心に位置する言語。\n現時点では、用語集の TSV ファイル読み込み時の列判定にのみ利用。\n例: TSV の 1 列目が en-US の場合には、基軸言語に en-US を設定。] (en)<br>
     * [翻訳の中心に位置する言語。\n現時点では、用語集の TSV ファイル読み込み時の列判定にのみ利用。\n例: TSV の 1 列目が en-US の場合には、基軸言語に en-US を設定。] (ja)<br>
     *
     * @return key[Label.PivotLang.Tooltip]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelPivotLangTooltip() {
        // 初期値として定義書の値を利用します。
        String strFormat = "翻訳の中心に位置する言語。\n現時点では、用語集の TSV ファイル読み込み時の列判定にのみ利用。\n例: TSV の 1 列目が en-US の場合には、基軸言語に en-US を設定。";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.PivotLang.Tooltip");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatPreferencePageMessages], key[Button.Reverse]
     *
     * [Reverse translation language] (en)<br>
     * [翻訳言語の反転] (ja)<br>
     *
     * @return key[Button.Reverse]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getButtonReverse() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Reverse translation language";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Button.Reverse");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatPreferencePageMessages], key[DefaultTransPivotLang]
     *
     * [en-US] (en)<br>
     * [en-US] (ja)<br>
     *
     * @return key[DefaultTransPivotLang]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDefaultTransPivotLang() {
        // 初期値として定義書の値を利用します。
        String strFormat = "en-US";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DefaultTransPivotLang");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatPreferencePageMessages], key[DefaultTransSourceLang]
     *
     * [en-US] (en)<br>
     * [en-US] (ja)<br>
     *
     * @return key[DefaultTransSourceLang]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDefaultTransSourceLang() {
        // 初期値として定義書の値を利用します。
        String strFormat = "en-US";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DefaultTransSourceLang");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatPreferencePageMessages], key[DefaultTransTargetLang]
     *
     * [ja-JP] (en)<br>
     * [ja-JP] (ja)<br>
     *
     * @return key[DefaultTransTargetLang]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDefaultTransTargetLang() {
        // 初期値として定義書の値を利用します。
        String strFormat = "ja-JP";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DefaultTransTargetLang");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatPreferencePageMessages], key[Dlg.Error.0]
     *
     * [翻訳元の言語と翻訳先の言語は異なるようにしてください。] (en)<br>
     * [翻訳元の言語と翻訳先の言語は異なるようにしてください。] (ja)<br>
     *
     * @return key[Dlg.Error.0]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDlgError0() {
        // 初期値として定義書の値を利用します。
        String strFormat = "翻訳元の言語と翻訳先の言語は異なるようにしてください。";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Dlg.Error.0");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatPreferencePageMessages], key[Dlg.Error.1]
     *
     * [翻訳元の言語または翻訳先の言語のいずれかが、基軸言語と一致するようにしてください。] (en)<br>
     * [翻訳元の言語または翻訳先の言語のいずれかが、基軸言語と一致するようにしてください。] (ja)<br>
     *
     * @return key[Dlg.Error.1]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDlgError1() {
        // 初期値として定義書の値を利用します。
        String strFormat = "翻訳元の言語または翻訳先の言語のいずれかが、基軸言語と一致するようにしてください。";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Dlg.Error.1");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatPreferencePageMessages], key[Dlg.Error.2]
     *
     * [TM の再読込時に例外が発生: {0}] (en)<br>
     * [TM の再読込時に例外が発生: {0}] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[Dlg.Error.2]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDlgError2(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "TM の再読込時に例外が発生: {0}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Dlg.Error.2");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[CatPreferencePageMessages], key[Dlg.Error.3]
     *
     * [用語集の再読込時に例外が発生: {0}] (en)<br>
     * [用語集の再読込時に例外が発生: {0}] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[Dlg.Error.3]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDlgError3(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "用語集の再読込時に例外が発生: {0}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Dlg.Error.3");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[CatPreferencePageMessages], key[Dlg.Error.Lang.Title]
     *
     * [翻訳言語に関する設定] (en)<br>
     * [翻訳言語に関する設定] (ja)<br>
     *
     * @return key[Dlg.Error.Lang.Title]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDlgErrorLangTitle() {
        // 初期値として定義書の値を利用します。
        String strFormat = "翻訳言語に関する設定";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Dlg.Error.Lang.Title");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }
}
