package blanco.terasoluna.blogic;

import java.io.File;
import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.transformer.java.BlancoCgJavaSourceTransformer;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgInterface;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgParameter;
import blanco.cg.valueobject.BlancoCgReturn;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.cg.valueobject.BlancoCgType;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.terasoluna.blogic.valueobject.BlancoTerasolunaBLogicStructure;

public class BlancoTerasolunaBLogic {
    private BlancoCgObjectFactory fCgFactory;

    private BlancoTerasolunaBLogicStructure fStructure;

    public void process(final BlancoTerasolunaBLogicStructure argStructure) {
        fStructure = argStructure;

        fCgFactory = BlancoCgObjectFactory.getInstance();

        generateBLogicProxy();
        generateBLogicInterface();

        if (fStructure.getUseProxy()) {
            generateAbstractBLogic();
        }
    }

    private void generateBLogicProxy() {
        final BlancoCgSourceFile cgSource = fCgFactory.createSourceFile(
                fStructure.getPackage(), null);
        final BlancoCgClass cgClass = fCgFactory
                .createClass(
                        BlancoNameAdjuster.toClassName(fStructure.getName())
                                + "BLogicProxy",
                        "["
                                + fStructure.getName()
                                + "] ["
                                + fStructure.getDescription()
                                + "]rWlXWbÑvLVNXBTERASOLUNAɈˑLqɂāA\Ȍ ̃NXɏW񂳂Ă܂B");
        cgSource.getClassList().add(cgClass);
        final BlancoCgType cgType = fCgFactory
                .createType("jp.terasoluna.fw.service.thin.BLogic<"
                        + fStructure.getInput() + ">");
        cgClass.getImplementInterfaceList().add(cgType);

        {
            final BlancoCgMethod cgMethod = fCgFactory.createMethod("execute",
                    "rWlXWbÑGg|CgB");
            cgClass.getMethodList().add(cgMethod);
            final BlancoCgParameter cgParameter = fCgFactory.createParameter(
                    "input", fStructure.getInput(), "rWlXWbN̓́B");
            cgMethod.getParameterList().add(cgParameter);
            cgSource.getImportList().add(fStructure.getInput());

            final BlancoCgReturn cgReturn = fCgFactory.createReturn(
                    "jp.terasoluna.fw.service.thin.BLogicResult",
                    "TERASOLUNA Œ߂ꂽrWlXWbN̏óB");
            cgMethod.setReturn(cgReturn);

            final List<java.lang.String> listLine = cgMethod.getLineList();
            listLine.add("final BLogicResult result = new BLogicResult();");
            listLine.add("");
            listLine.add("// ̉ӏŃRpCG[oꍇɂ́Ȁꍇ ["
                    + BlancoNameAdjuster.toClassName(fStructure.getName())
                    + "BLogicImpl] NX쐬ĂȂƂƍl܂B");
            listLine.add("final Abstract"
                    + BlancoNameAdjuster.toClassName(fStructure.getName())
                    + "BLogic impl = new "
                    + BlancoNameAdjuster.toClassName(fStructure.getName())
                    + "BLogicImpl();");
            listLine.add("");
            listLine.add("result.setResultObject(impl.execute(input));");
            listLine.add("result.setResultString(impl.getResultString());");
            listLine.add("return result;");

        }

        new BlancoCgJavaSourceTransformer().transform(cgSource, new File(
                "blanco/main"));
    }

    private void generateBLogicInterface() {
        final BlancoCgSourceFile cgSource = fCgFactory.createSourceFile(
                fStructure.getPackage(), null);
        final BlancoCgInterface cgInterface = fCgFactory
                .createInterface(BlancoNameAdjuster.toClassName(fStructure
                        .getName())
                        + "BLogic", "[" + fStructure.getName() + "] ["
                        + fStructure.getDescription() + "]rWlXWbÑC^tF[XB");
        cgSource.getInterfaceList().add(cgInterface);

        {
            final BlancoCgMethod cgMethod = fCgFactory.createMethod("execute",
                    "rWlXWbÑGg|CgB");
            cgInterface.getMethodList().add(cgMethod);
            final BlancoCgParameter cgParameter = fCgFactory.createParameter(
                    "input", fStructure.getInput(), "rWlXWbN̓́B");
            cgMethod.getParameterList().add(cgParameter);
            cgSource.getImportList().add(fStructure.getInput());

            final BlancoCgReturn cgReturn = fCgFactory.createReturn(fStructure
                    .getOutput(), "rWlXWbN̏óB");
            cgMethod.setReturn(cgReturn);
            cgSource.getImportList().add(fStructure.getOutput());
        }

        new BlancoCgJavaSourceTransformer().transform(cgSource, new File(
                "blanco/main"));
    }

    private void generateAbstractBLogic() {
        final BlancoCgSourceFile cgSource = fCgFactory.createSourceFile(
                fStructure.getPackage(), null);
        final BlancoCgClass cgClass = fCgFactory.createClass("Abstract"
                + BlancoNameAdjuster.toClassName(fStructure.getName())
                + "BLogic", "[" + fStructure.getName() + "] ["
                + fStructure.getDescription()
                + "]rWlXWbN̒ۃNXBStruts̑Jڐ DAOw̋LqȂǂ܂܂܂B");
        cgSource.getClassList().add(cgClass);

        cgClass.setAbstract(true);
        final BlancoCgType cgType = fCgFactory.createType(fStructure
                .getPackage()
                + "."
                + BlancoNameAdjuster.toClassName(fStructure.getName())
                + "BLogic");
        cgClass.getImplementInterfaceList().add(cgType);

        {
            final BlancoCgField cgField = fCgFactory.createField(
                    "fResultString", "java.lang.String",
                    "rWlXWbŇʕBStrutsForwardŗpB");
            cgClass.getFieldList().add(cgField);
            cgField.setDefault("\"success\"");
        }

        {
            final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                    "getResultString", "rWlXWbŇʕ擾B");
            cgClass.getMethodList().add(cgMethod);
            final BlancoCgReturn cgReturn = fCgFactory.createReturn(
                    "java.lang.String", "rWlXWbŇʕBStrutsForwardŗpB");
            cgMethod.setReturn(cgReturn);
            cgMethod.getLineList().add("return fResultString;");
        }

        {
            final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                    "setResultString", "rWlXWbŇʕݒ肷B");
            cgClass.getMethodList().add(cgMethod);
            final BlancoCgParameter cgParameter = fCgFactory.createParameter(
                    "argResult", "java.lang.String",
                    "rWlXWbŇʕBStrutsForwardŗpB");
            cgMethod.getParameterList().add(cgParameter);
            cgMethod.getLineList().add("fResultString = argResult;");
        }

        // DAO w
        if (fStructure.getUseQueryDao()) {
            {
                final BlancoCgField cgField = fCgFactory.createField(
                        "fQueryDao", "jp.terasoluna.fw.dao.QueryDAO",
                        "TERASOLUNA QueryDAO IuWFNgB");
                cgClass.getFieldList().add(cgField);
            }

            {
                final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                        "getQueryDao", "TERASOLUNA QueryDAO IuWFNg擾B");
                cgClass.getMethodList().add(cgMethod);
                final BlancoCgReturn cgReturn = fCgFactory.createReturn(
                        "jp.terasoluna.fw.dao.QueryDAO",
                        "TERASOLUNA QueryDAO IuWFNgB");
                cgMethod.setReturn(cgReturn);
                cgMethod.getLineList().add("return fQueryDao;");
            }

            {
                final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                        "setQueryDao", "TERASOLUNA QueryDAO IuWFNgݒ肷B");
                cgClass.getMethodList().add(cgMethod);
                final BlancoCgParameter cgParameter = fCgFactory
                        .createParameter("argDao",
                                "jp.terasoluna.fw.dao.QueryDAO",
                                "TERASOLUNA QueryDAO IuWFNg");
                cgMethod.getParameterList().add(cgParameter);
                cgMethod.getLineList().add("fQueryDao = argDao;");
            }
        }

        if (fStructure.getUseUpdateDao()) {
            {
                final BlancoCgField cgField = fCgFactory.createField(
                        "fUpdateDao", "jp.terasoluna.fw.dao.UpdateDAO",
                        "TERASOLUNA UpdateDAOIuWFNgB");
                cgClass.getFieldList().add(cgField);
            }

            {
                final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                        "getUpdateDao", "TERASOLUNA UpdateDAO IuWFNg擾B");
                cgClass.getMethodList().add(cgMethod);
                final BlancoCgReturn cgReturn = fCgFactory.createReturn(
                        "jp.terasoluna.fw.dao.UpdateDAO",
                        "TERASOLUNA UpdateDAO IuWFNgB");
                cgMethod.setReturn(cgReturn);
                cgMethod.getLineList().add("return fUpdateDao;");
            }

            {
                final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                        "setUpdateDao", "TERASOLUNA UpdateDAO IuWFNgݒ肷B");
                cgClass.getMethodList().add(cgMethod);
                final BlancoCgParameter cgParameter = fCgFactory
                        .createParameter("argDao",
                                "jp.terasoluna.fw.dao.UpdateDAO",
                                "TERASOLUNA UpdateDAO IuWFNg");
                cgMethod.getParameterList().add(cgParameter);
                cgMethod.getLineList().add("fUpdateDao = argDao;");
            }
        }

        new BlancoCgJavaSourceTransformer().transform(cgSource, new File(
                "blanco/main"));
    }
}
