/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.meta2xml;

import java.io.File;
import java.io.IOException;
import java.util.List;

import javax.xml.transform.dom.DOMResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoStringUtil;
import blanco.commons.util.BlancoXmlUtil;
import blanco.meta2xml.valueobject.BlancoMeta2XmlStructure;

/**
 * blancoValueObject̎傽NXB
 * 
 * blancoValueObject\XMLt@C Java\[XR[h܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoMeta2XmlXml2JavaClass {
    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgClass fCgClass = null;

    /**
     * \[Xt@C̕GR[fBOB
     */
    private String fEncoding = null;

    public void setEncoding(final String argEncoding) {
        fEncoding = argEncoding;
    }

    /**
     * ValueObject\XMLt@C Java\[XR[h܂B
     * 
     * @param metaXmlSourceFile
     *            ValueObjectɊւ郁^񂪊܂܂ĂXMLt@C
     * @param directoryTarget
     *            \[XR[hfBNg
     * @throws IOException
     *             o͗Oꍇ
     */
    public void process(final File metaXmlSourceFile, final File directoryTarget)
            throws IOException {

        final DOMResult result = BlancoXmlUtil
                .transformFile2Dom(metaXmlSourceFile);

        final Node rootNode = result.getNode();
        if (rootNode instanceof Document) {
            // ꂪnBhLg[g擾
            final Document rootDocument = (Document) rootNode;
            final NodeList listSheet = rootDocument
                    .getElementsByTagName("sheet");
            final int sizeListSheet = listSheet.getLength();
            for (int index = 0; index < sizeListSheet; index++) {
                final Element elementCommon = BlancoXmlUtil.getElement(
                        listSheet.item(index), "blancometa2xml-process-common");
                if (elementCommon == null) {
                    // commonꍇɂ̓XLbv܂B
                    continue;
                }

                final String name = BlancoXmlUtil.getTextContent(elementCommon,
                        "name");
                if (name == null || name.trim().length() == 0) {
                    continue;
                }

                expandSheet(elementCommon, directoryTarget);
            }
        }
    }

    /**
     * V[gWJ܂B
     * 
     * @param elementCommon
     *            ݏĂCommonm[h
     * @param directoryTarget
     *            o͐tH_B
     */
    private void expandSheet(final Element elementCommon,
            final File directoryTarget) {
        final BlancoMeta2XmlStructure processStructure = new BlancoMeta2XmlStructure();
        processStructure.setName(BlancoXmlUtil.getTextContent(elementCommon,
                "name"));
        processStructure.setPackage(BlancoXmlUtil.getTextContent(elementCommon,
                "package"));
        if (processStructure.getPackage() == null
                || processStructure.getPackage().trim().length() == 0) {
            throw new IllegalArgumentException("^t@C-XMLϊ` NX["
                    + processStructure.getName() + "]̃pbP[Ww肳Ă܂B");
        }

        if (BlancoXmlUtil.getTextContent(elementCommon, "description") != null) {
            processStructure.setDescription(BlancoXmlUtil.getTextContent(
                    elementCommon, "description"));
        }
        if (BlancoXmlUtil.getTextContent(elementCommon, "fileDescription") != null) {
            processStructure.setFileDescription(BlancoXmlUtil.getTextContent(
                    elementCommon, "fileDescription"));
        }

        processStructure.setConvertDefFile(BlancoXmlUtil.getTextContent(
                elementCommon, "convertDefFile"));
        if (processStructure.getConvertDefFile() == null
                || processStructure.getConvertDefFile().trim().length() == 0) {
            throw new IllegalArgumentException("^t@C-XMLϊ` NX["
                    + processStructure.getName() + "]̕ϊ`t@Cw肳Ă܂B");
        }

        if (BlancoXmlUtil.getTextContent(elementCommon, "inputFileExt") != null) {
            processStructure.setInputFileExt(BlancoXmlUtil.getTextContent(
                    elementCommon, "inputFileExt"));
        }
        if (BlancoXmlUtil.getTextContent(elementCommon, "outputFileExt") != null) {
            processStructure.setOutputFileExt(BlancoXmlUtil.getTextContent(
                    elementCommon, "outputFileExt"));
        }

        expandJavaSource(processStructure, directoryTarget);
    }

    /**
     * WꂽɁAJava\[XR[ho͂܂B
     * 
     * @param processStructure
     *            \
     * @param directoryTarget
     *            o͐tH_B
     */
    private void expandJavaSource(
            final BlancoMeta2XmlStructure processStructure,
            final File directoryTarget) {
        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(directoryTarget.getAbsolutePath()
                + "/main");

        fCgFactory = BlancoCgObjectFactory.getInstance();
        fCgSourceFile = fCgFactory.createSourceFile(processStructure
                .getPackage(), "̃\[XR[h blanco FrameworkɂĎĂ܂B");
        fCgSourceFile.setEncoding(fEncoding);
        if (processStructure.getFileDescription() != null) {
            fCgSourceFile.getLangDoc().getDescriptionList().add(
                    processStructure.getFileDescription());
        }

        fCgClass = fCgFactory.createClass(processStructure.getName(),
                BlancoStringUtil.null2Blank(processStructure.getDescription()));
        fCgSourceFile.getClassList().add(fCgClass);

        fCgSourceFile.getImportList().add("java.io.BufferedInputStream");
        fCgSourceFile.getImportList().add("java.io.BufferedOutputStream");
        fCgSourceFile.getImportList().add("java.io.FileInputStream");
        fCgSourceFile.getImportList().add("java.io.FileOutputStream");
        fCgSourceFile.getImportList().add("java.io.IOException");
        fCgSourceFile.getImportList().add("java.io.InputStream");
        fCgSourceFile.getImportList().add("java.io.OutputStream");
        fCgSourceFile.getImportList().add(
                "javax.xml.transform.TransformerException");
        fCgSourceFile.getImportList().add(
                "blanco.commons.calc.parser.BlancoCalcParser");

        {
            final BlancoCgField field = fCgFactory.createField(
                    "fCacheMeta2Xml", "boolean",
                    "`^t@C璆XMLt@Cւ̕ϊLbVōς܂ǂ̃tOB");
            fCgClass.getFieldList().add(field);
            field.setAccess("protected");
            field.setDefault("false");
        }

        {
            final BlancoCgField field = fCgFactory.createField(
                    "fCacheMeta2XmlCount", "int",
                    "`^t@C璆XMLt@Cւ̕ϊLbVōς܂񐔁B");
            fCgClass.getFieldList().add(field);
            field.setAccess("protected");
            field.setDefault("0");
        }

        {
            final BlancoCgField field = fCgFactory.createField(
                    "fCacheMetaDefXml", "byte[]",
                    "NX[_̒`\XMLt@C̓Ǎ񐔂炷߂̃LbVB");
            fCgClass.getFieldList().add(field);
            field.setAccess("protected");
            field.setDefault("null");
        }

        {
            final BlancoCgMethod method = fCgFactory.createMethod(
                    "setCacheMeta2Xml",
                    "`^t@C璆XMLt@Cւ̕ϊLbVōς܂ǂ̃tOw肵܂B");
            fCgClass.getMethodList().add(method);

            method.getParameterList().add(
                    fCgFactory.createParameter("argCacheMeta2Xml", "boolean",
                            "`^t@C璆XMLt@Cւ̕ϊLbVōς܂ǂB"));

            final List<java.lang.String> listLine = method.getLineList();
            listLine.add("fCacheMeta2Xml = argCacheMeta2Xml;");
        }

        {
            final BlancoCgMethod methodProcess1 = fCgFactory.createMethod(
                    "process", "Excelt@C̃Xg[XMLt@C̃Xg[ɕϊ܂B");
            fCgClass.getMethodList().add(methodProcess1);
            methodProcess1.getLangDoc().getDescriptionList().add(
                    "`t@C͓IɃpXێĂ܂B");
            methodProcess1.getParameterList().add(
                    fCgFactory.createParameter("inStreamMetaSource",
                            "java.io.InputStream", "^t@C̓̓Xg[B"));
            methodProcess1.getParameterList().add(
                    fCgFactory.createParameter("outStreamTarget",
                            "java.io.OutputStream", "XMLt@C̏o̓Xg[B"));
            methodProcess1.getThrowList().add(
                    fCgFactory.createException("java.io.IOException",
                            "o͗OꍇB"));
            methodProcess1.getThrowList().add(
                    fCgFactory.createException(
                            "javax.xml.transform.TransformerException",
                            "XMLϊOꍇB"));
            final List<java.lang.String> listLine = methodProcess1
                    .getLineList();
            listLine.add("if (inStreamMetaSource == null) {");

            listLine.add("throw new IllegalArgumentException(\""
                    + processStructure.getName()
                    + ": Invalid argument: inStreamMetaSource is null.\");");
            listLine.add("}");
            listLine.add("if (outStreamTarget == null) {");
            listLine.add("throw new IllegalArgumentException(\""
                    + processStructure.getName()
                    + ": Invalid argument: outStreamTarget is null.\");");
            listLine.add("}");
            listLine.add("");
            listLine.add("if (fCacheMetaDefXml == null) {");
            listLine.add("// ̃NXgƂȂNX[_XMLݒt@C̃[hȂ܂B");
            listLine
                    .add("final InputStream meta2xmlStream = getClass().getClassLoader().getResourceAsStream(\""
                            + processStructure.getConvertDefFile() + "\");");
            listLine.add("if (meta2xmlStream == null) {");
            listLine
                    .add("throw new IllegalArgumentException(\""
                            + processStructure.getName() + ": \[X["
                            + processStructure.getConvertDefFile()
                            + "]̎擾Ɏs܂.\");");
            listLine.add("}");
            fCgSourceFile.getImportList().add("java.io.ByteArrayOutputStream");
            fCgSourceFile.getImportList().add("java.io.ByteArrayInputStream");
            listLine
                    .add("final ByteArrayOutputStream outStream = new ByteArrayOutputStream();");
            listLine.add("final byte[] bufWrk = new byte[8192];");
            listLine.add("for (;;) {");
            listLine.add("final int readLength = meta2xmlStream.read(bufWrk);");
            listLine.add("if (readLength <= 0) {");
            listLine.add("break;");
            listLine.add("}");
            listLine.add("outStream.write(bufWrk, 0, readLength);");
            listLine.add("}");
            listLine.add("outStream.flush();");
            listLine.add("meta2xmlStream.close();");
            listLine.add("fCacheMetaDefXml = outStream.toByteArray();");

            listLine.add("}");
            listLine.add("");
            listLine
                    .add("InputStream inStreamDef = new ByteArrayInputStream(fCacheMetaDefXml);");
            listLine.add("try {");
            listLine
                    .add("new BlancoCalcParser().process(inStreamDef, inStreamMetaSource, outStreamTarget);");
            listLine.add("} finally {");
            listLine.add("if (inStreamDef != null) {");
            listLine.add("inStreamDef.close();");
            listLine.add("}");
            listLine.add("}");
        }

        {
            final BlancoCgMethod methodProcess2 = fCgFactory.createMethod(
                    "process", "Excelt@CXMLt@Cɕϊ܂B");
            fCgClass.getMethodList().add(methodProcess2);
            methodProcess2.getParameterList().add(
                    fCgFactory.createParameter("fileMeta", "java.io.File",
                            "^t@C̓̓t@CB"));
            methodProcess2.getParameterList().add(
                    fCgFactory.createParameter("fileOutput", "java.io.File",
                            "XMLt@C̏óB"));
            methodProcess2.getThrowList().add(
                    fCgFactory.createException("java.io.IOException",
                            "o͗OꍇB"));
            methodProcess2.getThrowList().add(
                    fCgFactory.createException(
                            "javax.xml.transform.TransformerException",
                            "XMLϊOꍇB"));
            final List<java.lang.String> listLine = methodProcess2
                    .getLineList();

            listLine.add("if (fileMeta == null) {");
            listLine.add("throw new IllegalArgumentException(\""
                    + processStructure.getName()
                    + ": Invalid argument: fileMeta is null.\");");
            listLine.add("}");
            listLine.add("if (fileOutput == null) {");
            listLine.add("throw new IllegalArgumentException(\""
                    + processStructure.getName()
                    + ": Invalid argument: fileOutput is null.\");");
            listLine.add("}");
            listLine.add("if (fileMeta.exists() == false) {");
            listLine
                    .add("throw new IllegalArgumentException(\""
                            + processStructure.getName()
                            + ": Invalid argument: file file [\" + fileMeta.getAbsolutePath() + \"] not found.\");");
            listLine.add("}");
            listLine.add("");
            listLine
                    .add("if (fCacheMeta2Xml && fileMeta.lastModified() < fileOutput.lastModified()) {");
            listLine.add("// LbV𗘗pāAXLbv܂B");
            listLine.add("fCacheMeta2XmlCount++;");
            listLine.add("return;");
            listLine.add("}");
            listLine.add("");
            listLine.add("InputStream inStream = null;");
            listLine.add("OutputStream outStream = null;");
            listLine.add("try {");
            listLine
                    .add("inStream = new BufferedInputStream(new FileInputStream(fileMeta), 8192);");
            listLine
                    .add("outStream = new BufferedOutputStream(new FileOutputStream(fileOutput), 8192);");
            listLine.add("");
            listLine.add("// Xg[̏ł̂ŁAۂ̏Ȃ܂B");
            listLine.add("process(inStream, outStream);");
            listLine.add("");
            listLine.add("outStream.flush();");
            listLine.add("} finally {");
            listLine.add("if (inStream != null) {");
            listLine.add("inStream.close();");
            listLine.add("}");
            listLine.add("if (outStream != null) {");
            listLine.add("outStream.close();");
            listLine.add("}");
            listLine.add("}");
        }

        {
            final BlancoCgMethod methodProcessDirectory = fCgFactory
                    .createMethod("processDirectory",
                            "wfBNgExcelt@CXMLt@Cɕϊ܂B");
            fCgClass.getMethodList().add(methodProcessDirectory);
            methodProcessDirectory.getLangDoc().getDescriptionList().add(
                    "w肳ꂽtH_̊gq[" + processStructure.getInputFileExt()
                            + "]̃t@C܂B<br>");
            methodProcessDirectory.getLangDoc().getDescriptionList().add(
                    "f[^ Ƃ̃t@CɊgq["
                            + processStructure.getOutputFileExt()
                            + "]t^t@C֕ۑ܂B");
            methodProcessDirectory.getParameterList().add(
                    fCgFactory.createParameter("fileMetadir", "java.io.File",
                            "^t@Ci[Ă̓fBNgB"));
            methodProcessDirectory.getParameterList().add(
                    fCgFactory.createParameter("targetDirectory",
                            "java.lang.String", "o̓fBNgB"));
            methodProcessDirectory.getThrowList().add(
                    fCgFactory.createException("java.io.IOException",
                            "o͗OꍇB"));
            methodProcessDirectory.getThrowList().add(
                    fCgFactory.createException(
                            "javax.xml.transform.TransformerException",
                            "XMLϊOꍇB"));
            final List<java.lang.String> listLine = methodProcessDirectory
                    .getLineList();

            listLine.add("System.out.println(\"m2x: begin.\");");
            listLine.add("final long startMills = System.currentTimeMillis();");
            listLine.add("long totalFileCount = 0;");
            listLine.add("long totalFileBytes = 0;");
            listLine.add("");
            listLine.add("if (fileMetadir == null) {");
            listLine.add("throw new IllegalArgumentException(\""
                    + processStructure.getName()
                    + ": Invalid argument: fileMetadir is null.\");");
            listLine.add("}");
            listLine.add("if (targetDirectory == null) {");
            listLine.add("throw new IllegalArgumentException(\""
                    + processStructure.getName()
                    + ": Invalid argument: targetDirectory is null.\");");
            listLine.add("}");
            listLine.add("if (fileMetadir.exists() == false) {");
            listLine
                    .add("throw new IllegalArgumentException(\""
                            + processStructure.getName()
                            + ": Invalid argument: file [\" + fileMetadir.getAbsolutePath() + \"] not found.\");");
            listLine.add("}");
            listLine
                    .add("final File fileTargetDirectory = new File(targetDirectory);");
            listLine.add("if (fileTargetDirectory.exists() == false) {");
            listLine.add("// o͐fBNg݂Ȃ̂ŁAOɍ쐬܂B");
            listLine.add("fileTargetDirectory.mkdirs();");
            listLine.add("}");
            listLine.add("");
            listLine.add("// w肳ꂽfBNg̃t@Cꗗ擾܂B");
            listLine.add("final File[] fileMeta = fileMetadir.listFiles();");
            listLine.add("if (fileMeta == null) {");
            listLine
                    .add("throw new IllegalArgumentException(\"BlancoMeta2XmlProcessMeta2Xml: list directory [\" + fileMetadir.getAbsolutePath() + \"] is failed.\");");
            listLine.add("}");
            listLine
                    .add("for (int index = 0; index < fileMeta.length; index++) {");
            listLine.add("if (fileMeta[index].getName().endsWith(\""
                    + BlancoJavaSourceUtil
                            .escapeStringAsJavaSource(processStructure
                                    .getInputFileExt()) + "\") == false) {");
            listLine.add("// t@C̊gqׂ̂Ƃ͈قȂ邽ߏXLbv܂BB");
            listLine.add("continue;");
            listLine.add("}");
            listLine.add("");

            listLine
                    .add("if (progress(index + 1, fileMeta.length, fileMeta[index].getName()) == false) {");
            listLine.add("// i\珈f̎ŵŁAf܂B");
            listLine.add("break;");
            listLine.add("}");

            listLine.add("");
            listLine.add("try {");
            listLine.add("totalFileCount++;");
            listLine.add("totalFileBytes += fileMeta[index].length();");
            listLine
                    .add("process(fileMeta[index], new File(targetDirectory + \"/\" + fileMeta[index].getName() + \""
                            + BlancoJavaSourceUtil
                                    .escapeStringAsJavaSource(processStructure
                                            .getOutputFileExt()) + "\"));");
            listLine.add("} catch (Exception ex) {");
            listLine.add("ex.printStackTrace();");
            listLine
                    .add("throw new IllegalArgumentException(\""
                            + processStructure.getName()
                            + ": Exception occurs during processing the file [\" + fileMeta[index].getAbsolutePath() + \"]. \" + ex.toString());");
            listLine.add("}");
            listLine.add("}");
            listLine.add("");
            listLine.add("if (fCacheMeta2Xml) {");
            listLine
                    .add("System.out.println(\"m2x: cache: \" + fCacheMeta2XmlCount + \" file skipped.\");");
            listLine.add("}");
            listLine
                    .add("final long costMills = System.currentTimeMillis() - startMills + 1;");
            listLine
                    .add("System.out.println(\"m2x: end: \" + (costMills / 1000) + \" sec, \" + totalFileCount + \" file, \" + totalFileBytes + \" byte (\" + (totalFileBytes * 1000 / costMills) + \" byte/sec).\");");
        }

        {
            final BlancoCgMethod methodProgress = fCgFactory.createMethod(
                    "progress", "̐i܂B");
            fCgClass.getMethodList().add(methodProgress);
            methodProgress.setAccess("protected");
            methodProgress.getLangDoc().getDescriptionList().add(
                    "i\ꍇɂ͌pď肱݂܂B");
            methodProgress.getParameterList().add(
                    fCgFactory.createParameter("progressCurrent", "int",
                            "ݏĂ錏̔ԍB"));
            methodProgress.getParameterList().add(
                    fCgFactory
                            .createParameter("progressTotal", "int", "B"));
            methodProgress.getParameterList().add(
                    fCgFactory.createParameter("progressItem",
                            "java.lang.String", "ĂACeB"));
            methodProgress.setReturn(fCgFactory.createReturn("boolean",
                    "𑱍sĂ悢ǂBfalseȂ珈fB"));
            final List<java.lang.String> listLine = methodProgress
                    .getLineList();

            listLine.add("// ɏs true ߂܂B");
            listLine.add("return true;");
        }

        BlancoCgTransformerFactory.getJavaSourceTransformer().transform(
                fCgSourceFile, fileBlancoMain);
    }
}
