package blanco.csv.task;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;

import blanco.csv.BlancoCsvDotNetConstants;
import blanco.csv.BlancoCsvDotNetMeta2Xml;
import blanco.csv.BlancoCsvXml2CsClass;
import blanco.csv.resourcebundle.BlancoCsvDotNetResourceBundle;
import blanco.csv.task.valueobject.BlancoCsvDotNetProcessInput;

public class BlancoCsvDotNetProcessImpl implements BlancoCsvDotNetProcess {
    private final BlancoCsvDotNetResourceBundle fBundle = new BlancoCsvDotNetResourceBundle();

    @Override
    public int execute(BlancoCsvDotNetProcessInput input) throws IOException,
            IllegalArgumentException {
        try {
            final File blancoTmpDirectory = new File(input.getTmpdir()
                    + BlancoCsvDotNetConstants.TARGET_SUBDIRECTORY);
            blancoTmpDirectory.mkdirs();

            final File fileMetadir = new File(input.getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException(fBundle
                        .getAnttaskErr001(input.getMetadir()));
            }

            new BlancoCsvDotNetMeta2Xml().processDirectory(fileMetadir, input
                    .getTmpdir()
                    + BlancoCsvDotNetConstants.TARGET_SUBDIRECTORY);

            final File tempValueObjectFolder = new File(input.getTmpdir()
                    + BlancoCsvDotNetConstants.TARGET_SUBDIRECTORY
                    + BlancoCsvDotNetConstants.VALUE_OBJECT_DIRECTORY);
            tempValueObjectFolder.mkdirs();

            final File[] fileTmp = blancoTmpDirectory.listFiles();
            for (int index = 0; index < fileTmp.length; index++) {
                if (fileTmp[index].getName().endsWith(".xml")) {
                    final BlancoCsvXml2CsClass xml2Source = new BlancoCsvXml2CsClass();
                    xml2Source.setEncoding(input.getEncoding());
                    xml2Source.process(fileTmp[index], input
                            .getRuntimepackage(), tempValueObjectFolder,
                            new File(input.getTargetdir()));
                }
            }
        } catch (TransformerException e) {
            throw new IllegalArgumentException(e.toString());
        } catch (IOException e) {
            throw new IllegalArgumentException(e.toString());
        }
        return 0;
    }

    @Override
    public boolean progress(String argProgressMessage) {
        // TODO Auto-generated method stub
        return false;
    }
}
