/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.batchprocess.resourcebundle;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * BlancoBatchProcessp郊\[Xoh~܂B
 *
 * \[Xoh`: [BlancoBatchProcess]B<BR>
 * ̃NX̓\[Xoh`玩ꂽ\[XohNXłB<BR>
 * m̃P[<BR>
 * <UL>
 * <LI>ja
 * </UL>
 */
public class BlancoBatchProcessResourceBundle {
    /**
     * \[XohIuWFNgB
     *
     * IɎۂɓ͂s\[XohL܂B
     */
    private ResourceBundle fResourceBundle;

    /**
     * BlancoBatchProcessResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoBatchProcess]AftHg̃P[AĂяõNX[_gpāA\[Xoh擾܂B
     */
    public BlancoBatchProcessResourceBundle() {
        try {
            fResourceBundle = ResourceBundle.getBundle("blanco/batchprocess/resourcebundle/BlancoBatchProcess");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BlancoBatchProcessResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoBatchProcess]Aw肳ꂽP[AĂяõNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     */
    public BlancoBatchProcessResourceBundle(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("blanco/batchprocess/resourcebundle/BlancoBatchProcess", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BlancoBatchProcessResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoBatchProcess]Aw肳ꂽP[Aw肳ꂽNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     * @param loader NX[_̎w
     */
    public BlancoBatchProcessResourceBundle(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("blanco/batchprocess/resourcebundle/BlancoBatchProcess", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * IɕێĂ郊\[XohIuWFNg擾܂B
     *
     * @return IɕێĂ郊\[XohIuWFNgB
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[BlancoBatchProcess], key[METAFILE_DISPLAYNAME]
     *
     * [ob``] (ja)<br>
     *
     * @return key[METAFILE_DISPLAYNAME]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMetafileDisplayname() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "ob``";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("METAFILE_DISPLAYNAME");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }
}
