/*
 * blancoCsv Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.csv.expand;

import java.io.File;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.csv.resourcebundle.BlancoCsvDotNetResourceBundle;
import blanco.csv.resourcebundle.BlancoCsvReaderDotNetResourceBundle;
import blanco.csv.valueobject.BlancoCsvFieldStructureDotNet;
import blanco.csv.valueobject.BlancoCsvStructureDotNet;

public class BlancoCsvExpandReaderDotNet {
    final BlancoCsvDotNetResourceBundle bundle = new BlancoCsvDotNetResourceBundle();

    final BlancoCsvReaderDotNetResourceBundle readerBundle = new BlancoCsvReaderDotNetResourceBundle();

    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgClass fCgClass = null;

    /**
     * \[Xt@C̕GR[fBOB
     */
    private String fEncoding = null;

    public void setEncoding(final String argEncoding) {
        fEncoding = argEncoding;
    }

    public void expand(final BlancoCsvStructureDotNet processStructure,
            final File directoryTarget) {
        final String className = BlancoNameAdjuster
                .toClassName(processStructure.getFileDefinitionId())
                + readerBundle.getClassNameSuffix();

        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(directoryTarget.getAbsolutePath()
                + "/main");

        // BlancoCgObjectFactoryNX̃CX^X擾܂B
        fCgFactory = BlancoCgObjectFactory.getInstance();

        fCgSourceFile = fCgFactory.createSourceFile(processStructure
                .getPackageName()
                + readerBundle.getPackagePrefix(), null);
        fCgSourceFile.setEncoding(fEncoding);

        // NX쐬܂B
        fCgClass = fCgFactory.createClass(className, null);
        fCgSourceFile.getClassList().add(fCgClass);

        fCgSourceFile.getImportList().add(
                processStructure.getRuntimePackage()
                        + readerBundle.getAddusingtype01Suffix());

        // SystemOԂusing܂B
        fCgSourceFile.getImportList().add("System.String");
        fCgSourceFile.getLangDoc().getDescriptionList().add(
                readerBundle.getFilecomment());

        fCgClass
                .getLangDoc()
                .getDescriptionList()
                .add(
                        readerBundle
                                .getClasscomment01(processStructure
                                        .getFileDefinitionId()
                                        + (processStructure
                                                .getFileDescription() == null ? ""
                                                : "/"
                                                        + processStructure
                                                                .getFileDescription())));
        fCgClass.getLangDoc().getDescriptionList().add(
                readerBundle.getClasscomment02());
        if (processStructure.getEncoding() == null) {
            fCgClass.getLangDoc().getDescriptionList().add(
                    readerBundle.getClasscomment03Case01());
        } else {
            fCgClass.getLangDoc().getDescriptionList().add(
                    readerBundle.getClasscomment03Case02(processStructure
                            .getEncoding()));
        }
        fCgClass.getLangDoc().getDescriptionList().add(
                readerBundle.getClasscomment04());

        {
            final BlancoCgField cgField = fCgFactory.createField(readerBundle
                    .getFieldReaderName(), readerBundle.getFieldReaderType(),
                    null);
            fCgClass.getFieldList().add(cgField);

            cgField.getLangDoc().getDescriptionList().add(
                    readerBundle.getFieldReaderJavadoc01());
            cgField.getLangDoc().getDescriptionList().add(
                    readerBundle.getFieldReaderJavadoc02());
        }

        {
            final BlancoCgField cgField = fCgFactory.createField(readerBundle
                    .getFieldLineCounterName(), readerBundle
                    .getFieldLineCounterType(), null);
            fCgClass.getFieldList().add(cgField);

            cgField.getLangDoc().getDescriptionList().add(
                    readerBundle.getFieldLineCounterJavadoc01());
            cgField.getLangDoc().getDescriptionList().add(
                    readerBundle.getFieldLineCounterJavadoc02());
            cgField.setDefault(readerBundle.getFieldLineCounterDefault());
        }

        {
            // uvΉ
            for (int indexField = 0; indexField < processStructure
                    .getListField().size(); indexField++) {
                final BlancoCsvFieldStructureDotNet csvField = (BlancoCsvFieldStructureDotNet) processStructure
                        .getListField().get(indexField);

                if (csvField.getType().equals("System.DateTime")) {
                    final BlancoCgField cgField = fCgFactory.createField(
                            readerBundle.getFieldSimpleDateFormatNamePrefix()
                                    + BlancoNameAdjuster.toClassName(csvField
                                            .getName()), readerBundle
                                    .getFieldSimpleDateFormatType(), null);
                    fCgClass.getFieldList().add(cgField);

                    cgField.getLangDoc().getDescriptionList().add(
                            readerBundle
                                    .getFieldSimpleDateFormatJavadoc01(csvField
                                            .getName()));
                    cgField.getLangDoc().getDescriptionList().add(
                            readerBundle.getFieldSimpleDateFormatJavadoc02());
                }
            }
        }

        {
            final BlancoCgMethod cgMethod = fCgFactory.createMethod(className,
                    null);
            fCgClass.getMethodList().add(cgMethod);

            cgMethod.setConstructor(true);
            cgMethod.getLangDoc().getDescriptionList().add(
                    readerBundle.getConstructor01Javadoc01());
            cgMethod.getLangDoc().getDescriptionList().add(
                    readerBundle.getConstructor01Javadoc02());
            cgMethod.getParameterList().add(
                    fCgFactory.createParameter("arg", readerBundle
                            .getConstructor01Arg01Type(), readerBundle
                            .getConstructor01Arg01Javadoc01()));

            cgMethod.getLineList().add("fReader = arg;");

            // uvΉ
            for (int indexField = 0; indexField < processStructure
                    .getListField().size(); indexField++) {
                final BlancoCsvFieldStructureDotNet csvField = (BlancoCsvFieldStructureDotNet) processStructure
                        .getListField().get(indexField);

                if (csvField.getType().equals("System.DateTime")) {
                    cgMethod
                            .getLineList()
                            .add(
                                    readerBundle
                                            .getFieldSimpleDateFormatNamePrefix()
                                            + BlancoNameAdjuster
                                                    .toClassName(csvField
                                                            .getName())
                                            + " = "
                                            + (csvField.getFormat() == null ? "\"yyyy/MM/dd\""
                                                    : "\""
                                                            + csvField
                                                                    .getFormat()
                                                            + "\"") + ";");
                }
            }
        }

        final String recordClassName = processStructure.getPackageName()
                + ".record."
                + BlancoNameAdjuster.toClassName(processStructure
                        .getFileDefinitionId()) + "CsvRecord";

        {
            final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                    "ReadRecord", readerBundle.getReadrecordJavadoc());
            fCgClass.getMethodList().add(cgMethod);

            // \bh̃VOj`w
            cgMethod.setReturn(fCgFactory.createReturn(recordClassName,
                    readerBundle.getReadrecordReturnJavadoc()));

            // \bh̎
            cgMethod.getLineList().add("string line = fReader.ReadLine();");
            cgMethod.getLineList().add("if (line == null) {");
            cgMethod.getLineList().add(readerBundle.getReadrecordLine03());
            cgMethod.getLineList().add("return null;");
            cgMethod.getLineList().add("}");
            cgMethod.getLineList().add("fLineCounter++;");
            cgMethod.getLineList().add(
                    readerBundle
                            .getReadrecordLine07(BlancoNameAdjuster
                                    .toClassName(processStructure
                                            .getFileDefinitionId())));
            fCgSourceFile.getImportList().add("System.IO.StringReader");
            cgMethod.getLineList().add(
                    "StringReader reader = new StringReader(line);");
            cgMethod.getLineList().add("string tokenString = null;");

            for (int indexField = 0; indexField < processStructure
                    .getListField().size(); indexField++) {
                final BlancoCsvFieldStructureDotNet csvField = (BlancoCsvFieldStructureDotNet) processStructure
                        .getListField().get(indexField);

                cgMethod.getLineList().add("");
                cgMethod
                        .getLineList()
                        .add(
                                (readerBundle
                                        .getReadrecordLine12(
                                                (csvField.getNo() == null ? ""
                                                        : bundle
                                                                .getFieldNo(csvField
                                                                        .getNo())),
                                                csvField.getName()
                                                        + (csvField
                                                                .getDescription() == null ? ""
                                                                : "/"
                                                                        + csvField
                                                                                .getDescription()))));

                // ^̗pǉ܂B
                fCgSourceFile.getImportList().add(
                        processStructure.getRuntimePackage()
                                + ".util.BlancoCsvRuntimeUtil");

                if (csvField.getType().endsWith("(quote)")) {
                    cgMethod.getLineList().add(
                            readerBundle.getReadrecordLine21());
                    cgMethod.getLineList().add(
                            readerBundle
                                    .getReadrecordLine22Case01(processStructure
                                            .getDelimiter()));
                } else {
                    cgMethod.getLineList().add(
                            readerBundle.getReadrecordLine22Case02(
                                    processStructure.getDelimiter(),
                                    (indexField == processStructure
                                            .getListField().size() - 1 ? "true"
                                            : "false")));
                }
                cgMethod.getLineList().add("if (tokenString == null) {");
                cgMethod.getLineList().add(
                        "throw new BlancoCsvIOException(\""
                                + bundle.getCsvReaderErr001(getLocationString(
                                        indexField, csvField.getNo(), csvField
                                                .getName(), csvField
                                                .getDescription())) + "\");");
                cgMethod.getLineList().add("}");

                if (csvField.getRequired()) {
                    cgMethod.getLineList().add("// K{ځB");
                    cgMethod.getLineList()
                            .add("if (tokenString.Length == 0) {");
                    cgMethod
                            .getLineList()
                            .add(
                                    "throw new BlancoCsvIOException(\""
                                            + bundle
                                                    .getCsvReaderErr008(getLocationString(
                                                            indexField,
                                                            csvField.getNo(),
                                                            csvField.getName(),
                                                            csvField
                                                                    .getDescription()))
                                            + "\");");
                    cgMethod.getLineList().add("}");
                } else {
                    cgMethod.getLineList().add("// CӍځB");
                    cgMethod.getLineList()
                            .add("if (tokenString.Length == 0) {");
                    if (csvField.getType().startsWith("string")) {
                        cgMethod
                                .getLineList()
                                .add(
                                        "// K{ڂł͂Ȃ񍀖ڂɒ0̒lǂݍ܂ꂽꍇɂ́Aǂݍ݌̒lƂĂ0̕Ƃ܂B");
                        cgMethod.getLineList()
                                .add(
                                        "record.Set"
                                                + BlancoNameAdjuster
                                                        .toClassName(csvField
                                                                .getName())
                                                + "(tokenString);");
                    } else if (csvField.getType().equals("int")
                            || csvField.getType().equals("long")
                            || csvField.getType().equals("decimal")
                            || csvField.getType().equals("System.DateTime")) {
                        cgMethod
                                .getLineList()
                                .add(
                                        "// K{ڂł͂Ȃڂɒ0̒lǂݍ܂ꂽꍇɂ́AlƂĂ͍̑s܂B");
                        cgMethod.getLineList()
                                .add(
                                        "record.Set"
                                                + BlancoNameAdjuster
                                                        .toClassName(csvField
                                                                .getName())
                                                + "(" + csvField.getType()
                                                + ".MinValue);");
                    } else {
                        cgMethod.getLineList().add(
                                "// T|[gȂ^(" + csvField.getType()
                                        + ")^܂B");
                    }
                    cgMethod.getLineList().add("} else {");
                }

                if (csvField.getMinLength() != null) {
                    // ^̗pǉ܂B
                    fCgSourceFile.getImportList().add(
                            processStructure.getRuntimePackage()
                                    + ".util.BlancoCsvRuntimeUtil");

                    cgMethod.getLineList().add(
                            "if (BlancoCsvRuntimeUtil.GetBytes(tokenString"
                                    + ").Length < " + csvField.getMinLength()
                                    + ") {");
                    cgMethod.getLineList().add(
                            "throw new BlancoCsvIOException(\""
                                    + bundle.getCsvReaderErr002(
                                            getLocationString(indexField,
                                                    csvField.getNo(), csvField
                                                            .getName(),
                                                    csvField.getDescription()),
                                            csvField.getMinLength()) + "\");");
                    cgMethod.getLineList().add("}");
                }

                if (csvField.getMaxLength() != null) {
                    // ^̗pǉ܂B
                    fCgSourceFile.getImportList().add(
                            processStructure.getRuntimePackage()
                                    + ".util.BlancoCsvRuntimeUtil");

                    cgMethod.getLineList().add(
                            "if (BlancoCsvRuntimeUtil.GetBytes(tokenString"
                                    + ").Length > " + csvField.getMaxLength()
                                    + ") {");
                    cgMethod.getLineList().add(
                            "throw new BlancoCsvIOException(\""
                                    + bundle.getCsvReaderErr003(
                                            getLocationString(indexField,
                                                    csvField.getNo(), csvField
                                                            .getName(),
                                                    csvField.getDescription()),
                                            csvField.getMaxLength()) + "\");");
                    cgMethod.getLineList().add("}");
                }

                if (csvField.getType().equals("string")
                        || csvField.getType().equals("string(quote)")) {
                    cgMethod.getLineList().add(
                            "record.Set"
                                    + BlancoNameAdjuster.toClassName(csvField
                                            .getName()) + "(tokenString);");
                } else if (csvField.getType().equals("int")) {
                    cgMethod.getLineList().add("try {");
                    cgMethod.getLineList().add(
                            "record.Set"
                                    + BlancoNameAdjuster.toClassName(csvField
                                            .getName())
                                    + "(Int32.Parse(tokenString));");
                    cgMethod.getLineList()
                            .add("} catch (FormatException ex) {");
                    cgMethod
                            .getLineList()
                            .add(
                                    "throw new BlancoCsvIOException(\""
                                            + bundle
                                                    .getCsvReaderErr004(getLocationString(
                                                            indexField,
                                                            csvField.getNo(),
                                                            csvField.getName(),
                                                            csvField
                                                                    .getDescription()))
                                            + "\" + ex.ToString(), ex);");
                    cgMethod.getLineList().add("}");
                } else if (csvField.getType().equals("long")) {
                    cgMethod.getLineList().add("try {");
                    cgMethod.getLineList().add(
                            "record.Set"
                                    + BlancoNameAdjuster.toClassName(csvField
                                            .getName())
                                    + "(Int64.Parse(tokenString));");
                    cgMethod.getLineList()
                            .add("} catch (FormatException ex) {");
                    cgMethod
                            .getLineList()
                            .add(
                                    "throw new BlancoCsvIOException(\""
                                            + bundle
                                                    .getCsvReaderErr005(getLocationString(
                                                            indexField,
                                                            csvField.getNo(),
                                                            csvField.getName(),
                                                            csvField
                                                                    .getDescription()))
                                            + "\" + ex.ToString(), ex);");
                    cgMethod.getLineList().add("}");
                } else if (csvField.getType().equals("decimal")) {
                    cgMethod.getLineList().add("try {");
                    cgMethod.getLineList().add(
                            "record.Set"
                                    + BlancoNameAdjuster.toClassName(csvField
                                            .getName())
                                    + "(Convert.ToDecimal(tokenString));");
                    cgMethod.getLineList()
                            .add("} catch (FormatException ex) {");
                    cgMethod
                            .getLineList()
                            .add(
                                    "throw new BlancoCsvIOException(\""
                                            + bundle
                                                    .getCsvReaderErr007(getLocationString(
                                                            indexField,
                                                            csvField.getNo(),
                                                            csvField.getName(),
                                                            csvField
                                                                    .getDescription()))
                                            + "\" + ex.ToString(), ex);");
                    cgMethod.getLineList().add("}");
                } else if (csvField.getType().equals("System.DateTime")) {
                    fCgSourceFile.getImportList().add("System.FormatException");
                    cgMethod.getLineList().add("try {");
                    cgMethod
                            .getLineList()
                            .add(
                                    "record.Set"
                                            + BlancoNameAdjuster
                                                    .toClassName(csvField
                                                            .getName())
                                            + "(DateTime.ParseExact(tokenString, fSimpleDateFormat"
                                            + BlancoNameAdjuster
                                                    .toClassName(csvField
                                                            .getName())
                                            + ", null));");
                    cgMethod.getLineList()
                            .add("} catch (FormatException ex) {");
                    cgMethod.getLineList().add(
                            "throw new BlancoCsvIOException(\""
                                    + bundle.getCsvReaderErr006(
                                            getLocationString(indexField,
                                                    csvField.getNo(), csvField
                                                            .getName(),
                                                    csvField.getDescription()),
                                            BlancoNameAdjuster
                                                    .toClassName(csvField
                                                            .getName()))
                                    + "\" + ex.ToString(), ex);");
                    cgMethod.getLineList().add("}");
                } else {
                    cgMethod.getLineList().add(
                            bundle.getNotSupportedType(csvField.getType()));
                }

                if (csvField.getRequired()) {
                    // K{ځB
                } else {
                    cgMethod.getLineList().add("}");
                }
            }

            cgMethod.getLineList().add("return record;");
        }

        {
            final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                    "GetLineCounter", "ݏ̍sJE^Ԃ܂B");
            fCgClass.getMethodList().add(cgMethod);

            cgMethod.setReturn(fCgFactory.createReturn("long", "ݏ̍sJE^B"));
            // \bh̎
            cgMethod.getLineList().add("return fLineCounter;");
        }

        {
            final BlancoCgMethod cgMethod = fCgFactory.createMethod("Close",
                    null);
            fCgClass.getMethodList().add(cgMethod);

            // \bh̃VOj`w
            cgMethod.getLangDoc().getDescriptionList().add(
                    readerBundle.getCloseJavadoc01());
            cgMethod.getLangDoc().getDescriptionList().add(
                    readerBundle.getCloseJavadoc02());

            // \bh̎
            cgMethod.getLineList().add("fReader.Close();");
        }

        // WꂽɎۂ̃\[XR[hB
        BlancoCgTransformerFactory.getCsSourceTransformer().transform(
                fCgSourceFile, fileBlancoMain);
    }

    private String getLocationString(int indexField, String fieldNo,
            String fieldName, String fieldDescription) {
        return readerBundle.getGetlocationstringLine01("" + (indexField + 1),
                (fieldNo == null ? "" : bundle.getFieldNo(fieldNo) + " "),
                fieldName
                        + (fieldDescription == null ? "" : "/"
                                + fieldDescription));
    }
}
