/*
 * Minimal GCC Frontend for gcc-4.3.0 (or maybe latter)
 *
 * Copyright (C) 2007 2008 - WAKATSUKI toshihiro <alohakun _AT_ gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/* Some code and ideas were taken from a hello-world gcc frontend
 * http://svn.gna.org/viewcvs/gsc/branches/hello-world/
 * and gcc/treelang sample frontend.
 *
 * And thanks for SATO daisuke's very good advices and efforts
 * about add_builtin_functions()
 */

#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "tm.h"
#include "toplev.h"
#include "ggc.h"
#include "cgraph.h"
#include "tree-dump.h"
#include "tree-gimple.h"
#include "langhooks-def.h"
#include "langhooks.h"

static void bl_parse_file(int debug) {
  /* function prototype : int main(); */
  tree main_type   = build_function_type(integer_type_node, NULL_TREE);
  tree main_fndecl = build_fn_decl("main", main_type);
  DECL_EXTERNAL(main_fndecl) = false;
  DECL_ARTIFICIAL(main_fndecl) = false;
  TREE_STATIC(main_fndecl) = true;
  TREE_PUBLIC(main_fndecl) = true;
  DECL_CONTEXT(main_fndecl) = NULL_TREE;
  tree stmts = alloc_stmt_list();
  tree  block = build_block(/* variables */NULL_TREE,
      /* subblocks */NULL_TREE, /* supercontext */NULL_TREE,
      /* next same level block */NULL_TREE);
  DECL_INITIAL(main_fndecl) = block;
  DECL_SAVED_TREE (main_fndecl) = build3(BIND_EXPR, void_type_node,
      BLOCK_VARS(block), stmts, block);
  /* create the result variable */
  tree resdecl = build_decl(RESULT_DECL, NULL_TREE, integer_type_node);
  DECL_CONTEXT(resdecl) = main_fndecl;
  DECL_RESULT(main_fndecl) = resdecl;
  /* return 0 */
  tree main_setret = fold_build2(MODIFY_EXPR, TREE_TYPE(main_fndecl),
      DECL_RESULT(main_fndecl), integer_zero_node);
  TREE_SIDE_EFFECTS(main_setret) = true;
  TREE_USED(main_setret) = true;
  tree main_ret = fold_build1(RETURN_EXPR, void_type_node, main_setret);
  append_to_statement_list(main_ret, &stmts);
  allocate_struct_function(main_fndecl, false);
  dump_function (TDI_original, main_fndecl);
  gimplify_function_tree(main_fndecl);
  dump_function (TDI_generic, main_fndecl);
  cgraph_node(main_fndecl);
  cgraph_finalize_function(main_fndecl, /* nested function ? */false);
  cgraph_finalize_compilation_unit();
  cgraph_optimize();
}

static void insert_block (tree block) {}
static int global_bindings_p (void) {}
static tree pushdecl(tree decl) {}
static tree getdecls (void) {}
tree convert(tree type, tree expr) {}
static tree bl_type_for_size(unsigned precision, int unsignedp) {}
static tree bl_type_for_mode(enum machine_mode mode, int unsignedp) {}
static void bl_finish(void) {}
static unsigned int bl_init_options (unsigned int argc, const char **argv) {}
static int bl_handle_option(size_t scode, const char  *arg, int value) {}
static bool bl_mark_addressable(tree exp) {}

static bool bl_init(void) {
  build_common_tree_nodes(false, false);
  build_common_tree_nodes_2(false);
  //build_common_builtin_nodes();
  return true;
}

struct lang_identifier GTY(()) {
  struct tree_identifier common;
};

union lang_tree_node  GTY((desc ("TREE_CODE (&%h.generic) == IDENTIFIER_NODE"))) {
  union tree_node GTY ((tag ("0"), desc ("tree_node_structure (&%h)"))) generic;
  struct lang_identifier GTY ((tag ("1"))) identifier;
};

struct lang_type GTY(()) {
  char dummy;
};
struct lang_decl GTY(()) {
  char dummy;
};
struct language_function GTY(()) {
  char dummy;
};

#undef  LANG_HOOKS_NAME
#define LANG_HOOKS_NAME                      "bl"

#undef  LANG_HOOKS_INIT
#define LANG_HOOKS_INIT                      bl_init

#undef  LANG_HOOKS_INIT_OPTIONS
#define LANG_HOOKS_INIT_OPTIONS              bl_init_options

#undef LANG_HOOKS_FINISH
#define LANG_HOOKS_FINISH                    bl_finish

#undef  LANG_HOOKS_HANDLE_OPTION
#define LANG_HOOKS_HANDLE_OPTION             bl_handle_option

#undef  LANG_HOOKS_PARSE_FILE
#define LANG_HOOKS_PARSE_FILE                bl_parse_file

#undef  LANG_HOOKS_MARK_ADDRESSABLE
#define LANG_HOOKS_MARK_ADDRESSABLE          bl_mark_addressable

#undef  LANG_HOOKS_TYPE_FOR_MODE
#define LANG_HOOKS_TYPE_FOR_MODE             bl_type_for_mode

#undef  LANG_HOOKS_TYPE_FOR_SIZE
#define LANG_HOOKS_TYPE_FOR_SIZE             bl_type_for_size

#undef LANG_HOOKS_CALLGRAPH_EXPAND_FUNCTION
#define LANG_HOOKS_CALLGRAPH_EXPAND_FUNCTION tree_rest_of_compilation

const struct lang_hooks lang_hooks = LANG_HOOKS_INITIALIZER;

#define DEFTREECODE(SYM, NAME, TYPE, LENGTH) TYPE,
const enum tree_code_class tree_code_type[] = {
#include "tree.def"
  tcc_exceptional
};
#undef DEFTREECODE

#define DEFTREECODE(SYM, NAME, TYPE, LENGTH) LENGTH,
const unsigned char tree_code_length[] = {
#include "tree.def"
  0
};
#undef DEFTREECODE

#define DEFTREECODE(SYM, NAME, TYPE, LEN) NAME,
const char *const tree_code_name[] = {
#include "tree.def"
  "@@dummy"
};
#undef DEFTREECODE

#include "debug.h"
#include "gt-bl-bl1.h"
#include "gtype-bl.h"
