<?php
/**
 * EZweb.php
 *
 * PHP versions 4 and 5
 *
 * @package   Blocken
 * @author    Kouhei Suzuki <k_suzuki@smartnetwork.co.jp>
 * @copyright 2006-2008 SmartNetwork Inc.
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version   $Id: EZweb.php 3 2008-03-08 07:25:00Z sigmax $
 */
if( basename( $_SERVER['SCRIPT_NAME'] ) == basename( __FILE__ ) ) { exit; }

require_once 'Net/UserAgent/Mobile/EZweb.php';

class BlockenMobile_EZweb extends Net_UserAgent_Mobile_EZweb
{
    /**
     * isFlash()
     *
     * @access public
     * @param  float  $fVersion
     * @return mixed            float | boolean
     */
    function isFlash( $fVersion = 0 )
    {
        if( ( 1.1 == $fVersion || 0 == $fVersion ) &&
            '1' == substr( $this->getHeader( 'X-UP-DEVCAP-MULTIMEDIA' ), 12, 1 ) )
        {
            return 1.1;
        }

        if( ( 2.0 == $fVersion || 0 == $fVersion ) &&
            '2' == substr( $this->getHeader( 'X-UP-DEVCAP-MULTIMEDIA' ), 12, 1 ) )
        {
            return 2.0;
        }

        return false;
    }

    /**
     * isPdf()
     *
     * @access public
     * @return boolean
     */
    function isPdf()
    {
        return false;
    }

    /**
     * isSimulator()
     *
     * @access public
     * @return boolean
     */
    function isSimulator()
    {
        return false;
    }

    /**
     * hasEmoji()
     *
     * @access public
     * @param  string  $sMsg
     * @return boolean
     */
    function hasEmoji( $sMsg )
    {
        $sMsg = mb_convert_encoding( $sMsg, 'UTF-8', 'SJIS' );
        $bRet = preg_match( '/〓/', $sMsg );

        return ( 1 == $bRet ) ? true : false;
    }

    /**
     * &convertEmoji()
     *
     * @access public
     * @return array
     */
    function &convertEmoji()
    {
        $aryEmoji = array(
            '/&#63861;/'  => '&#xF794;',
            '/&#63862;/'  => '&#xF794;',
            '/&#63864;/'  => '&#xF794;',
            '/&#63865;/'  => '&#xF794;',
            '/&#63876;/'  => '&#xF74F;',
            '/&#63877;/'  => '&#xF489;',
            '/&#63878;/'  => '&#xF748;',
            '/&#63830;/'  => '&#xF657;',
            '/&#xF9B1;/i' => '&#xF48F;',
            '/&#xF9B2;/i' => '&#xF48F;',
            '/&#xF9B9;/i' => '&#xF675;',
            '/&#xF9D4;/i' => '&#xF3AB;',
            '/&#xF9DD;/i' => '&#xF75D;',
            '/&#xF9DF;/i' => '&#xF36C;',
            '/&copy;/i'   => '&#xF9D6;'
        );

        return $aryEmoji;
    }
}
?>
