<?php
/**
 * NonMobile.php
 *
 * PHP versions 4 and 5
 *
 * @package   Blocken
 * @author    Kouhei Suzuki <k_suzuki@smartnetwork.co.jp>
 * @copyright 2006-2008 SmartNetwork Inc.
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version   $Id: NonMobile.php 3 2008-03-08 07:25:00Z sigmax $
 */
if( basename( $_SERVER['SCRIPT_NAME'] ) == basename( __FILE__ ) ) { exit; }

require_once 'Net/UserAgent/Mobile/NonMobile.php';

class BlockenMobile_NonMobile extends Net_UserAgent_Mobile_NonMobile
{
    /**
     * isFlash()
     *
     * @access public
     * @param  float  $fVersion
     * @return float
     */
    function isFlash( $fVersion = 0 )
    {
        return 2.0;
    }

    /**
     * isPdf()
     *
     * @access public
     * @return boolean
     */
    function isPdf()
    {
        return true;
    }

    /**
     * isSimulator()
     *
     * @access public
     * @return boolean
     */
    function isSimulator()
    {
        return false;
    }

    /**
     * hasEmoji()
     *
     * @access public
     * @param  string  $sMsg
     * @return boolean
     */
    function hasEmoji( $sMsg )
    {
        return false;
    }

    /**
     * &convertEmoji()
     *
     * @access public
     * @return array
     */
    function &convertEmoji()
    {
        $aryEmoji = array(
                    '/&#(\d{5});/e'  => "sprintf( '<img src=\"%s/%4x.gif\" width=\"12\" height=\"12\" border=\"0\" />', BLOCKEN_EMOJI_PATH, '\\1' )",
                    '/&#x(\w{4});/e' => "sprintf( '<img src=\"%s/%s.gif\" width=\"12\" height=\"12\" border=\"0\" />', BLOCKEN_EMOJI_PATH, strtolower( '\\1' ) )"
                );

        return $aryEmoji;
    }
}
?>
