<?php
/**
 * DoCoMo.php
 *
 * PHP versions 4 and 5
 *
 * @package   Blocken
 * @author    Kouhei Suzuki <sigma@mfer.jp>
 * @copyright 2006-2008 SIGMA Project
 * @license   http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version   $Id: DoCoMo.php 25 2008-11-15 03:43:18Z sigmax $
 */
if ( basename( $_SERVER[ 'SCRIPT_NAME' ] ) == basename( __FILE__ ) ) { exit; }

require_once 'Net/UserAgent/Mobile/DoCoMo.php';

class BlockenMobile_DoCoMo extends Net_UserAgent_Mobile_DoCoMo
{
    /**
     * isFlash()
     *
     * @access public
     * @param  float  $fVersion
     * @return mixed            float | boolean
     */
    function isFlash( $fVersion = 0 )
    {
        if ( ( 1.0 == $fVersion || 0 == $fVersion ) &&
            preg_match( '/(?:50[56]|900)/', $this->getModel() ) )
        {
            return 1.0;
        }

        if ( ( 1.1 == $fVersion || 0 == $fVersion ) &&
            preg_match( '/(?:601|70[0-4]|[^NP]705|80\d|851|88[2-9]|90[1-4])/',
                        $this->getModel() ) )
        {
            return 1.1;
        }

        if ( ( 3.0 == $fVersion || 0 == $fVersion ) &&
            preg_match( '/(?:[NP]705|70[6-9]|90[5-9]|ISIM040[1-4])/', $this->getModel() ) )
        {
            return 3.0;
        }

        return false;
    }

    /**
     * isPdf()
     *
     * @access public
     * @return boolean
     */
    function isPdf()
    {
        $bRet = preg_match( '/(?:F702ID|D704I|70[5-9]|90[1-9]|ISIM040[1-4])/', $this->getModel() );

        return ( 1 == $bRet ) ? true : false;
    }

    /**
     * isSimulator()
     *
     * @access public
     * @return boolean
     */
    function isSimulator()
    {
        $bRet = preg_match( '/ISIM/', $this->getModel() );

        return ( 1 == $bRet ) ? true : false;
    }

    /**
     * hasEmoji()
     *
     * @access public
     * @param  string  $sMsg
     * @return boolean
     */
    function hasEmoji( $sMsg )
    {
        $sMsg = mb_convert_encoding( $sMsg, 'UTF-8', 'SJIS' );
        $bRet = preg_match( '/〓/', $sMsg );

        return ( 1 == $bRet ) ? true : false;
    }

    /**
     * &convertEmoji()
     *
     * @access public
     * @return array
     */
    function &convertEmoji()
    {
        $aryEmoji = array();

        return $aryEmoji;
    }

    /**
     * makeDisplay()
     *
     * @access public
     * @return object Net_UserAgent_Mobile_Display
     */
    function makeDisplay()
    {
        static $aryDisplayMap;

        if ( ! isset( $aryDisplayMap ) )
        {
            $sXml = file_get_contents( BLOCKEN_MOBI_D_MAP );

            $aryValues  = array();
            $aryIndexes = array();

            $resParser = xml_parser_create();
            xml_parse_into_struct( $resParser, $sXml, $aryValues, $aryIndexes );
            xml_parser_free( $resParser );

            foreach ( $aryIndexes[ 'TERMINAL' ] as $iModelIndexes )
            {
                $sModelName = $aryValues[ $iModelIndexes ][ 'attributes' ][ 'MODEL' ];
                $aryDisplayMap[ $sModelName ] = array();
                foreach ( $aryValues[ $iModelIndexes ][ 'attributes' ] as $sAttributeName => $sAttributeValue )
                {
                    $aryDisplayMap[ $sModelName ][ strtolower( $sAttributeName ) ] = $sAttributeValue;
                }
            }
        }

        $aryDisplay = array();

        if ( isset( $aryDisplayMap[ strtoupper( $this->getModel() ) ] ) )
        {
            $aryDisplay = $aryDisplayMap[ strtoupper( $this->getModel() ) ];
        }

        if ( ! is_null( $this->_displayBytes ) )
        {
            list( $aryDisplay[ 'width_bytes' ], $aryDisplay[ 'height_bytes' ] ) = explode( '*', $this->_displayBytes );
        }

        return new Net_UserAgent_Mobile_Display( $aryDisplay );
    }
}
?>
