/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.extension.xmlrpc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcServer;
import org.blojsom.BlojsomException;
import org.blojsom.authorization.AuthorizationProvider;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfigurationException;
import org.blojsom.extension.xmlrpc.BlojsomXMLRPCConstants;
import org.blojsom.extension.xmlrpc.handlers.AbstractBlojsomAPIHandler;
import org.blojsom.fetcher.BlojsomFetcherException;
import org.blojsom.servlet.BlojsomBaseServlet;
import org.blojsom.util.BlojsomProperties;
import org.blojsom.util.BlojsomUtils;

public class BlojsomXMLRPCServlet
extends BlojsomBaseServlet
implements BlojsomXMLRPCConstants {
    private Log _logger = LogFactory.getLog((Class)BlojsomXMLRPCServlet.class);
    protected AuthorizationProvider _authorizationProvider;
    protected ServletConfig _servletConfig;
    public static final int XMLRPC_DISABLED = 4000;
    public static final String XMLRPC_DISABLED_MESSAGE = "XML-RPC disabled for the requested blog";

    protected void configureAuthorization() throws ServletException {
        try {
            Class<?> authorizationProviderClass = Class.forName(this._blojsomConfiguration.getAuthorizationProvider());
            this._authorizationProvider = (AuthorizationProvider)authorizationProviderClass.newInstance();
            this._authorizationProvider.init(this._servletConfig, this._blojsomConfiguration);
        }
        catch (ClassNotFoundException e) {
            throw new ServletException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ServletException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServletException((Throwable)e);
        }
        catch (BlojsomConfigurationException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void configureFlavorsForUser(ServletConfig servletConfig, BlogUser blogUser) throws ServletException {
        String flavorConfiguration = servletConfig.getInitParameter("flavor-configuration");
        if (BlojsomUtils.checkNullOrBlank((String)flavorConfiguration)) {
            flavorConfiguration = "flavor.properties";
        }
        HashMap<String, String> flavors = new HashMap<String, String>();
        HashMap<String, String> flavorToTemplateMap = new HashMap<String, String>();
        HashMap<String, String> flavorToContentTypeMap = new HashMap<String, String>();
        String user = blogUser.getId();
        Properties flavorProperties = new Properties();
        InputStream is = servletConfig.getServletContext().getResourceAsStream(this._baseConfigurationDirectory + user + '/' + flavorConfiguration);
        try {
            flavorProperties.load(is);
            is.close();
            this._logger.debug((Object)("Loaded flavor information for user: " + user));
            Iterator<Object> flavorIterator = flavorProperties.keySet().iterator();
            while (flavorIterator.hasNext()) {
                String flavor = (String)flavorIterator.next();
                String[] flavorMapping = BlojsomUtils.parseCommaList((String)flavorProperties.getProperty(flavor));
                flavors.put(flavor, flavor);
                flavorToTemplateMap.put(flavor, flavorMapping[0]);
                flavorToContentTypeMap.put(flavor, flavorMapping[1]);
            }
            blogUser.setFlavors(flavors);
            blogUser.setFlavorToTemplate(flavorToTemplateMap);
            blogUser.setFlavorToContentType(flavorToContentTypeMap);
        }
        catch (IOException e) {
            this._logger.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    protected XmlRpcServer configureXMLRPCServer(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String userID) throws ServletException {
        XmlRpcServer xmlRpcServer = new XmlRpcServer();
        String xmlrpcConfigurationFile = this._servletConfig.getInitParameter("blog-xmlrpc-configuration");
        Properties handlerMapProperties = new Properties();
        InputStream is = this._servletConfig.getServletContext().getResourceAsStream(xmlrpcConfigurationFile);
        try {
            handlerMapProperties.load(is);
            is.close();
            String defaultXMLRPCHandler = handlerMapProperties.getProperty("$default");
            handlerMapProperties.remove("$default");
            BlogUser blogUser = new BlogUser();
            blogUser.setId(userID);
            BlojsomProperties blogProperties = new BlojsomProperties();
            is = this._servletConfig.getServletContext().getResourceAsStream(this._baseConfigurationDirectory + userID + '/' + "blog.properties");
            if (is == null) {
                return null;
            }
            try {
                blogProperties.load(is);
                is.close();
            }
            catch (IOException e) {
                this._logger.error((Object)e);
                throw new BlojsomConfigurationException((Throwable)e);
            }
            if (!BlojsomUtils.checkNullOrBlank((String)this._blojsomConfiguration.getGlobalBlogHome()) && !blogProperties.containsKey("blog-home")) {
                String usersBlogHome = this._blojsomConfiguration.getGlobalBlogHome() + userID + "/";
                File blogHomeDirectory = new File(usersBlogHome);
                if (!blogHomeDirectory.exists()) {
                    this._logger.error((Object)("Unable to use blog-home directory for user: " + blogHomeDirectory.toString()));
                    throw new BlojsomConfigurationException("Unable to use blog-home directory for user: " + blogHomeDirectory.toString());
                }
                blogProperties.setProperty("blog-home", usersBlogHome);
                this._logger.debug((Object)("Setting user blog-home directory: " + usersBlogHome));
            }
            Blog blog = null;
            try {
                blog = new Blog((Properties)blogProperties);
                BlojsomUtils.resolveDynamicBaseAndBlogURL((HttpServletRequest)httpServletRequest, (Blog)blog, (String)userID);
                blogUser.setBlog(blog);
                this._logger.debug((Object)("Configured blojsom user: " + blogUser.getId()));
            }
            catch (BlojsomConfigurationException e) {
                this._logger.error((Object)e);
                throw new BlojsomConfigurationException((Throwable)e);
            }
            if (!blog.getXmlrpcEnabled().booleanValue()) {
                this._logger.error((Object)XMLRPC_DISABLED_MESSAGE);
                throw new ServletException((Throwable)new XmlRpcException(4000, XMLRPC_DISABLED_MESSAGE));
            }
            this._authorizationProvider.loadAuthenticationCredentials(blogUser);
            this.configureFlavorsForUser(this._servletConfig, blogUser);
            Iterator<Object> handlerIterator = handlerMapProperties.keySet().iterator();
            while (handlerIterator.hasNext()) {
                String handlerName = (String)handlerIterator.next();
                String handlerClassName = handlerMapProperties.getProperty(handlerName);
                Class<?> handlerClass = Class.forName(handlerClassName);
                AbstractBlojsomAPIHandler handler = (AbstractBlojsomAPIHandler)handlerClass.newInstance();
                handler.setFetcher(this._fetcher);
                handler.setConfiguration(this._blojsomConfiguration);
                handler.setBlogUser(blogUser);
                handler.setAuthorizationProvider(this._authorizationProvider);
                handler.setServletConfig(this._servletConfig);
                handler.setHttpServletRequest(httpServletRequest);
                handler.setHttpServletResponse(httpServletResponse);
                xmlRpcServer.addHandler(handler.getName(), (Object)handler);
                if (defaultXMLRPCHandler != null && defaultXMLRPCHandler.equals(handlerName)) {
                    xmlRpcServer.addHandler("$default", (Object)handler);
                    this._logger.debug((Object)("Added default XML-RPC handler: " + handlerClass + " for user: " + userID));
                }
                this._logger.debug((Object)("Added [" + handler.getName() + "] API Handler : " + handlerClass + " for user: " + userID));
            }
            return xmlRpcServer;
        }
        catch (InstantiationException e) {
            throw new ServletException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServletException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new ServletException((Throwable)e);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
        catch (BlojsomException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this._servletConfig = servletConfig;
        XmlRpc.setEncoding((String)"UTF-8");
        this.configureBlojsom(this._servletConfig);
        this.configureAuthorization();
        this._logger.debug((Object)"blojsom XML-RPC: All Your Blog Are Belong To Us");
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            httpServletRequest.setCharacterEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this._logger.error((Object)e);
        }
        String user = BlojsomUtils.getUserFromPath((String)httpServletRequest.getPathInfo());
        if (BlojsomUtils.checkNullOrBlank((String)user) || "/".equals(user)) {
            httpServletResponse.sendError(404, "Requested user not found: " + user);
            return;
        }
        XmlRpcServer xmlRpcServer = this.configureXMLRPCServer(httpServletRequest, httpServletResponse, user);
        if (xmlRpcServer == null) {
            httpServletResponse.sendError(404, "Requested user not found: " + user);
            return;
        }
        byte[] result = xmlRpcServer.execute((InputStream)httpServletRequest.getInputStream());
        httpServletResponse.setContentType("text/xml; charset=UTF-8");
        httpServletResponse.setContentLength(result.length);
        ServletOutputStream os = httpServletResponse.getOutputStream();
        os.write(result);
        os.flush();
    }

    public void destroy() {
        try {
            this._fetcher.destroy();
        }
        catch (BlojsomFetcherException e) {
            this._logger.error((Object)e);
        }
    }
}

