/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.extension.xmlrpc.handlers;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlrpc.XmlRpcException;
import org.blojsom.BlojsomException;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogCategory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.event.BlojsomEvent;
import org.blojsom.extension.xmlrpc.handlers.AbstractBlojsomAPIHandler;
import org.blojsom.plugin.admin.event.AddBlogEntryEvent;
import org.blojsom.plugin.admin.event.DeletedBlogEntryEvent;
import org.blojsom.plugin.admin.event.UpdatedBlogEntryEvent;
import org.blojsom.util.BlojsomUtils;

public class MetaWeblogAPIHandler
extends AbstractBlojsomAPIHandler {
    private static final String METAWEBLOG_ACCEPTED_TYPES_IP = "blojsom-extension-metaweblog-accepted-types";
    private static final String MEMBER_BLOGID = "blogid";
    private static final String MEMBER_BLOGNAME = "blogName";
    private static final String MEMBER_DESCRIPTION = "description";
    private static final String MEMBER_HTML_URL = "htmlUrl";
    private static final String MEMBER_RSS_URL = "rssUrl";
    private static final String MEMBER_TITLE = "title";
    private static final String MEMBER_LINK = "link";
    private static final String MEMBER_NAME = "name";
    private static final String MEMBER_TYPE = "type";
    private static final String MEMBER_BITS = "bits";
    private static final String MEMBER_PERMALINK = "permaLink";
    private static final String MEMBER_DATE_CREATED = "dateCreated";
    private static final String MEMBER_CATEGORIES = "categories";
    private static final String MEMBER_POSTID = "postid";
    private static final String MEMBER_URL = "url";
    private static final String METAWEBLOG_API_PERMISSION = "post_via_metaweblog_api";
    public static final String API_PREFIX = "metaWeblog";
    private String _uploadDirectory;
    private HashMap _acceptedMimeTypes;
    private String _staticURLPrefix;
    private Log _logger = LogFactory.getLog((Class)MetaWeblogAPIHandler.class);

    public String getName() {
        return API_PREFIX;
    }

    public void setBlogUser(BlogUser blogUser) throws BlojsomException {
        this._blogUser = blogUser;
        this._blog = this._blogUser.getBlog();
        this._blogEntryExtension = this._blog.getBlogProperty("blog-xmlrpc-entry-extension");
        if (BlojsomUtils.checkNullOrBlank((String)this._blogEntryExtension)) {
            this._blogEntryExtension = ".html";
        }
        this._uploadDirectory = this._configuration.getQualifiedResourceDirectory();
        if (BlojsomUtils.checkNullOrBlank((String)this._uploadDirectory)) {
            throw new BlojsomException("No upload directory specified in blog configuration");
        }
        if (!this._uploadDirectory.endsWith("/")) {
            this._uploadDirectory = this._uploadDirectory + "/";
        }
        this._logger.debug((Object)("Upload directory for user [" + this._blogUser.getId() + "] is " + this._uploadDirectory));
        this._acceptedMimeTypes = new HashMap(3);
        String acceptedMimeTypes = this._blog.getBlogProperty(METAWEBLOG_ACCEPTED_TYPES_IP);
        if (acceptedMimeTypes != null && !"".equals(acceptedMimeTypes)) {
            String[] types = BlojsomUtils.parseCommaList((String)acceptedMimeTypes);
            for (int i = 0; i < types.length; ++i) {
                String type = types[i];
                type = type.toLowerCase();
                this._acceptedMimeTypes.put(type, type);
            }
        }
        this._staticURLPrefix = this._configuration.getResourceDirectory();
        if (!this._staticURLPrefix.endsWith("/")) {
            this._staticURLPrefix = this._staticURLPrefix + "/";
        }
    }

    public Object getUsersBlogs(String appkey, String userid, String password) throws Exception {
        this._logger.debug((Object)"getUsersBlogs() Called ===[ SUPPORTED ]=======");
        this._logger.debug((Object)("     Appkey: " + appkey));
        this._logger.debug((Object)("     UserId: " + userid));
        this._logger.debug((Object)"   Password: *********");
        try {
            this._authorizationProvider.loadAuthenticationCredentials(this._blogUser);
            this._authorizationProvider.authorize(this._blogUser, null, userid, password);
            this.checkXMLRPCPermission(userid, METAWEBLOG_API_PERMISSION);
            Vector result = new Vector();
            BlogCategory[] _categories = this._fetcher.fetchCategories(null, this._blogUser);
            if (_categories != null) {
                for (int x = 0; x < _categories.length; ++x) {
                    Hashtable<String, String> _bloglist = new Hashtable<String, String>(3);
                    BlogCategory _category = _categories[x];
                    String _blogid = _category.getCategory();
                    if (_blogid.length() > 1) {
                        _blogid = BlojsomUtils.removeInitialSlash((String)_blogid);
                    }
                    String _description = "";
                    Map _metadata = _category.getMetaData();
                    _description = _metadata != null && _metadata.containsKey("blojsom.name") ? (String)_metadata.get("blojsom.name") : _category.getEncodedCategory();
                    _bloglist.put(MEMBER_URL, _category.getCategoryURL());
                    _bloglist.put(MEMBER_BLOGID, _blogid);
                    _bloglist.put(MEMBER_BLOGNAME, _description);
                    result.add(_bloglist);
                }
            }
            return result;
        }
        catch (BlojsomException e) {
            this._logger.error((Object)("Failed to authenticate user [" + userid + "] with password [" + password + "]"));
            throw new XmlRpcException(1, "Invalid username and/or password");
        }
    }

    public Object getCategories(String blogid, String userid, String password) throws Exception {
        this._logger.debug((Object)"getCategories() Called =====[ SUPPORTED ]=====");
        this._logger.debug((Object)("     BlogId: " + blogid));
        this._logger.debug((Object)("     UserId: " + userid));
        this._logger.debug((Object)"   Password: *********");
        try {
            Hashtable result;
            this._authorizationProvider.loadAuthenticationCredentials(this._blogUser);
            this._authorizationProvider.authorize(this._blogUser, null, userid, password);
            this.checkXMLRPCPermission(userid, METAWEBLOG_API_PERMISSION);
            BlogCategory[] categories = this._fetcher.fetchCategories(null, this._blogUser);
            if (categories != null) {
                result = new Hashtable(categories.length);
                for (int x = 0; x < categories.length; ++x) {
                    Map metadata;
                    Hashtable<String, String> catlist = new Hashtable<String, String>(3);
                    BlogCategory category = categories[x];
                    String categoryId = category.getCategory();
                    if (categoryId.length() > 1) {
                        categoryId = BlojsomUtils.removeInitialSlash((String)categoryId);
                    }
                    String description = (metadata = category.getMetaData()) != null && metadata.containsKey("blojsom.description") ? (String)metadata.get("blojsom.description") : category.getEncodedCategory();
                    catlist.put(MEMBER_DESCRIPTION, description);
                    catlist.put(MEMBER_HTML_URL, category.getCategoryURL());
                    catlist.put(MEMBER_RSS_URL, category.getCategoryURL() + "?flavor=rss2");
                    result.put(categoryId, catlist);
                }
            } else {
                throw new XmlRpcException(3000, "There are no categories defined");
            }
            return result;
        }
        catch (BlojsomException e) {
            this._logger.error((Object)("Failed to authenticate user [" + userid + "] with password [" + password + "]"));
            throw new XmlRpcException(1, "Invalid username and/or password");
        }
    }

    public String newPost(String blogid, String userid, String password, Hashtable struct, boolean publish) throws Exception {
        Vector categories;
        this._logger.debug((Object)"newPost() Called ===========[ SUPPORTED ]=====");
        this._logger.debug((Object)("     BlogId: " + blogid));
        this._logger.debug((Object)("     UserId: " + userid));
        this._logger.debug((Object)"   Password: *********");
        this._logger.debug((Object)("    Publish: " + publish));
        blogid = BlojsomUtils.normalize((String)blogid);
        if (struct.containsKey(MEMBER_CATEGORIES) && (categories = (Vector)struct.get(MEMBER_CATEGORIES)).size() > 0) {
            String categoryForPost = (String)categories.get(0);
            blogid = BlojsomUtils.normalize((String)categoryForPost);
        }
        try {
            this._authorizationProvider.loadAuthenticationCredentials(this._blogUser);
            this._authorizationProvider.authorize(this._blogUser, null, userid, password);
            this.checkXMLRPCPermission(userid, METAWEBLOG_API_PERMISSION);
            String result = null;
            Hashtable postcontent = struct;
            String title = (String)postcontent.get(MEMBER_TITLE);
            String description = (String)postcontent.get(MEMBER_DESCRIPTION);
            Date dateCreated = (Date)postcontent.get(MEMBER_DATE_CREATED);
            try {
                String postid;
                BlogEntry entry = this._fetcher.newBlogEntry();
                HashMap<String, String> blogEntryMetaData = new HashMap<String, String>();
                entry.setCategory(blogid);
                if (BlojsomUtils.checkNullOrBlank((String)title)) {
                    title = null;
                }
                entry.setTitle(title);
                entry.setDescription(description);
                blogEntryMetaData.put("blog-entry-author", userid);
                if (dateCreated == null) {
                    blogEntryMetaData.put("blog-entry-metadata-timestamp", new Long(new Date().getTime()).toString());
                } else {
                    blogEntryMetaData.put("blog-entry-metadata-timestamp", this.convertDateCreated(dateCreated, this._blog));
                }
                entry.setMetaData(blogEntryMetaData);
                entry.save(this._blogUser);
                entry.load(this._blogUser);
                result = postid = blogid + "?" + "permalink" + "=" + entry.getPermalink();
                this._configuration.getEventBroadcaster().broadcastEvent((BlojsomEvent)new AddBlogEntryEvent((Object)this, new Date(), entry, this._blogUser));
            }
            catch (BlojsomException e) {
                this._logger.error((Object)e);
                throw new XmlRpcException(1000, "An error occured processing your request");
            }
            return result;
        }
        catch (BlojsomException e) {
            this._logger.error((Object)("Failed to authenticate user [" + userid + "] with password [" + password + "]"));
            throw new XmlRpcException(1, "Invalid username and/or password");
        }
    }

    public boolean editPost(String postid, String userid, String password, Hashtable struct, boolean publish) throws Exception {
        this._logger.debug((Object)"editPost() Called ========[ SUPPORTED ]=====");
        this._logger.debug((Object)("     PostId: " + postid));
        this._logger.debug((Object)("     UserId: " + userid));
        this._logger.debug((Object)"   Password: *********");
        this._logger.debug((Object)("    Publish: " + publish));
        try {
            this._authorizationProvider.loadAuthenticationCredentials(this._blogUser);
            this._authorizationProvider.authorize(this._blogUser, null, userid, password);
            this.checkXMLRPCPermission(userid, METAWEBLOG_API_PERMISSION);
            boolean result = false;
            String category = null;
            String permalink = null;
            String match = "?permalink=";
            int pos = postid.indexOf(match);
            if (pos == -1) {
                Vector categories = (Vector)struct.get(MEMBER_CATEGORIES);
                if (categories == null) {
                    throw new XmlRpcException(2000, "The entry postid you submitted is invalid");
                }
                category = (String)categories.get(0);
                permalink = postid;
            } else if (pos != -1) {
                category = postid.substring(0, pos);
                category = BlojsomUtils.normalize((String)category);
                category = BlojsomUtils.urlDecode((String)category);
                permalink = postid.substring(pos + match.length());
            }
            BlogCategory blogCategory = this._fetcher.newBlogCategory();
            blogCategory.setCategory(category);
            blogCategory.setCategoryURL(this._blog.getBlogURL() + category);
            HashMap<String, Object> fetchMap = new HashMap<String, Object>();
            fetchMap.put("FETCHER_CATEGORY", blogCategory);
            fetchMap.put("FETCHER_PERMALINK", permalink);
            BlogEntry[] entries = this._fetcher.fetchEntries(fetchMap, this._blogUser);
            if (entries != null && entries.length > 0) {
                BlogEntry entry = entries[0];
                try {
                    Hashtable postcontent = struct;
                    String title = (String)postcontent.get(MEMBER_TITLE);
                    String description = (String)postcontent.get(MEMBER_DESCRIPTION);
                    Date dateCreated = (Date)postcontent.get(MEMBER_DATE_CREATED);
                    if (title == null) {
                        title = "No Title";
                    }
                    String hashable = description;
                    if (description.length() > 300) {
                        hashable = hashable.substring(0, 300);
                    }
                    Map blogEntryMetaData = entry.getMetaData();
                    entry.setTitle(title);
                    entry.setDescription(description);
                    if (dateCreated != null) {
                        blogEntryMetaData.put("blog-entry-metadata-timestamp", this.convertDateCreated(dateCreated, this._blog));
                    }
                    entry.save(this._blogUser);
                    result = true;
                    this._configuration.getEventBroadcaster().broadcastEvent((BlojsomEvent)new UpdatedBlogEntryEvent((Object)this, new Date(), entry, this._blogUser));
                }
                catch (BlojsomException e) {
                    this._logger.error((Object)e);
                    throw new XmlRpcException(1000, "An error occured processing your request");
                }
            } else {
                throw new XmlRpcException(2000, "The entry postid you submitted is invalid");
            }
            return result;
        }
        catch (BlojsomException e) {
            this._logger.error((Object)("Failed to authenticate user [" + userid + "] with password [" + password + "]"));
            throw new XmlRpcException(1, "Invalid username and/or password");
        }
    }

    public Object getPost(String postid, String userid, String password) throws Exception {
        this._logger.debug((Object)"getPost() Called =========[ SUPPORTED ]=====");
        this._logger.debug((Object)("     PostId: " + postid));
        this._logger.debug((Object)("     UserId: " + userid));
        this._logger.debug((Object)"   Password: *********");
        try {
            this._authorizationProvider.loadAuthenticationCredentials(this._blogUser);
            this._authorizationProvider.authorize(this._blogUser, null, userid, password);
            this.checkXMLRPCPermission(userid, METAWEBLOG_API_PERMISSION);
            String match = "?permalink=";
            int pos = postid.indexOf(match);
            if (pos != -1) {
                String category = postid.substring(0, pos);
                category = BlojsomUtils.normalize((String)category);
                category = BlojsomUtils.urlDecode((String)category);
                String permalink = postid.substring(pos + match.length());
                BlogCategory blogCategory = this._fetcher.newBlogCategory();
                blogCategory.setCategory(category);
                blogCategory.setCategoryURL(this._blog.getBlogURL() + category);
                HashMap<String, Object> fetchMap = new HashMap<String, Object>();
                fetchMap.put("FETCHER_CATEGORY", blogCategory);
                fetchMap.put("FETCHER_PERMALINK", permalink);
                BlogEntry[] entries = this._fetcher.fetchEntries(fetchMap, this._blogUser);
                if (entries != null && entries.length > 0) {
                    BlogEntry entry = entries[0];
                    Hashtable<String, Object> postcontent = new Hashtable<String, Object>(3);
                    postcontent.put(MEMBER_TITLE, entry.getTitle());
                    postcontent.put(MEMBER_LINK, entry.getPermalink());
                    postcontent.put(MEMBER_DESCRIPTION, entry.getDescription());
                    postcontent.put(MEMBER_DATE_CREATED, entry.getDate());
                    postcontent.put(MEMBER_PERMALINK, entry.getLink());
                    postcontent.put(MEMBER_POSTID, entry.getId());
                    Vector<String> postCategories = new Vector<String>(1);
                    postCategories.add(entry.getCategory());
                    postcontent.put(MEMBER_CATEGORIES, postCategories);
                    return postcontent;
                }
                throw new XmlRpcException(2000, "The entry postid you submitted is invalid");
            }
            throw new XmlRpcException(2000, "The entry postid you submitted is invalid");
        }
        catch (BlojsomException e) {
            this._logger.error((Object)("Failed to authenticate user [" + userid + "] with password [" + password + "]"));
            throw new XmlRpcException(1, "Invalid username and/or password");
        }
    }

    public boolean deletePost(String appkey, String postid, String userid, String password, boolean publish) throws Exception {
        boolean result;
        block5: {
            this._logger.debug((Object)"deletePost() Called =====[ SUPPORTED ]=====");
            this._logger.debug((Object)("     Appkey: " + appkey));
            this._logger.debug((Object)("     PostId: " + postid));
            this._logger.debug((Object)("     UserId: " + userid));
            this._logger.debug((Object)"   Password: *********");
            result = false;
            try {
                this._authorizationProvider.loadAuthenticationCredentials(this._blogUser);
                this._authorizationProvider.authorize(this._blogUser, null, userid, password);
                this.checkXMLRPCPermission(userid, METAWEBLOG_API_PERMISSION);
                String match = "?permalink=";
                int pos = postid.indexOf(match);
                if (pos == -1) break block5;
                String category = postid.substring(0, pos);
                category = BlojsomUtils.normalize((String)category);
                category = BlojsomUtils.urlDecode((String)category);
                String permalink = postid.substring(pos + match.length());
                HashMap<String, Object> fetchMap = new HashMap<String, Object>();
                BlogCategory blogCategory = this._fetcher.newBlogCategory();
                blogCategory.setCategory(category);
                blogCategory.setCategoryURL(this._blog.getBlogURL() + category);
                fetchMap.put("FETCHER_CATEGORY", blogCategory);
                fetchMap.put("FETCHER_PERMALINK", permalink);
                BlogEntry[] _entries = this._fetcher.fetchEntries(fetchMap, this._blogUser);
                if (_entries != null && _entries.length > 0) {
                    try {
                        _entries[0].delete(this._blogUser);
                    }
                    catch (BlojsomException e) {
                        this._logger.error((Object)e);
                        throw new XmlRpcException(1000, "An error occured processing your request");
                    }
                    result = true;
                    this._configuration.getEventBroadcaster().broadcastEvent((BlojsomEvent)new DeletedBlogEntryEvent((Object)this, new Date(), _entries[0], this._blogUser));
                    break block5;
                }
                throw new XmlRpcException(2000, "The entry postid you submitted is invalid");
            }
            catch (BlojsomException e) {
                this._logger.error((Object)("Failed to authenticate user [" + userid + "] with password [" + password + "]"));
                throw new XmlRpcException(1, "Invalid username and/or password");
            }
        }
        return result;
    }

    public Object getRecentPosts(String blogid, String userid, String password, int numberOfPosts) throws Exception {
        this._logger.debug((Object)"getRecentPosts() Called =========[ SUPPORTED ]=====");
        this._logger.debug((Object)("     BlogId: " + blogid));
        this._logger.debug((Object)("     UserId: " + userid));
        this._logger.debug((Object)"   Password: *********");
        try {
            this._authorizationProvider.loadAuthenticationCredentials(this._blogUser);
            this._authorizationProvider.authorize(this._blogUser, null, userid, password);
            this.checkXMLRPCPermission(userid, METAWEBLOG_API_PERMISSION);
            blogid = BlojsomUtils.normalize((String)blogid);
            BlogCategory category = this._fetcher.newBlogCategory();
            category.setCategory(blogid);
            category.setCategoryURL(this._blog.getBlogURL() + blogid);
            HashMap<String, Object> fetchMap = new HashMap<String, Object>();
            fetchMap.put("FETCHER_CATEGORY", category);
            fetchMap.put("FETCHER_NUM_POSTS_INTEGER", new Integer(numberOfPosts));
            BlogEntry[] entries = this._fetcher.fetchEntries(fetchMap, this._blogUser);
            Vector blogEntries = new Vector();
            if (entries != null && entries.length > 0) {
                blogEntries = new Vector(entries.length);
                for (int i = 0; i < entries.length; ++i) {
                    BlogEntry entry = entries[i];
                    Hashtable<String, Object> postcontent = new Hashtable<String, Object>(7);
                    postcontent.put(MEMBER_TITLE, entry.getTitle());
                    postcontent.put(MEMBER_LINK, entry.getPermalink());
                    postcontent.put(MEMBER_DESCRIPTION, entry.getDescription());
                    postcontent.put(MEMBER_DATE_CREATED, entry.getDate());
                    postcontent.put(MEMBER_PERMALINK, entry.getLink());
                    postcontent.put(MEMBER_POSTID, entry.getId());
                    Vector<String> postCategories = new Vector<String>(1);
                    postCategories.add(entry.getCategory());
                    postcontent.put(MEMBER_CATEGORIES, postCategories);
                    blogEntries.add(postcontent);
                }
            }
            return blogEntries;
        }
        catch (BlojsomException e) {
            this._logger.error((Object)("Failed to authenticate user [" + userid + "] with password [" + password + "]"));
            throw new XmlRpcException(1, "Invalid username and/or password");
        }
    }

    public Object newMediaObject(String blogid, String userid, String password, Hashtable struct) throws Exception {
        this._logger.debug((Object)"newMediaObject() Called =[ SUPPORTED ]=====");
        this._logger.debug((Object)("     BlogId: " + blogid));
        this._logger.debug((Object)("     UserId: " + userid));
        this._logger.debug((Object)"   Password: *********");
        try {
            this._authorizationProvider.loadAuthenticationCredentials(this._blogUser);
            this._authorizationProvider.authorize(this._blogUser, null, userid, password);
            this.checkXMLRPCPermission(userid, METAWEBLOG_API_PERMISSION);
            String name = (String)struct.get(MEMBER_NAME);
            name = BlojsomUtils.getFilenameFromPath((String)name);
            this._logger.debug((Object)("newMediaObject name: " + name));
            String type = (String)struct.get(MEMBER_TYPE);
            this._logger.debug((Object)("newMediaObject type: " + type));
            byte[] bits = (byte[])struct.get(MEMBER_BITS);
            File uploadDirectory = new File(this._uploadDirectory);
            if (!uploadDirectory.exists()) {
                this._logger.error((Object)("Upload directory does not exist: " + uploadDirectory.toString()));
                throw new XmlRpcException(1000, "Upload directory does not exist: " + uploadDirectory.toString());
            }
            if (this._acceptedMimeTypes.containsKey(type.toLowerCase())) {
                try {
                    File uploadDirectoryForUser = new File(uploadDirectory, this._blogUser.getId());
                    if (!uploadDirectoryForUser.exists() && !uploadDirectoryForUser.mkdir()) {
                        this._logger.error((Object)("Could not create upload directory for user: " + uploadDirectoryForUser.toString()));
                        throw new XmlRpcException(1000, "Could not create upload directory for user: " + this._blogUser.getId());
                    }
                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(uploadDirectoryForUser, name)));
                    bos.write(bits);
                    bos.close();
                    Hashtable<String, String> returnStruct = new Hashtable<String, String>(1);
                    String mediaURL = this._blog.getBlogBaseURL() + this._staticURLPrefix + BlojsomUtils.removeTrailingSlash((String)this._blogUser.getId()) + "/" + name;
                    this._logger.debug((Object)("newMediaObject URL: " + mediaURL));
                    returnStruct.put(MEMBER_URL, mediaURL);
                    return returnStruct;
                }
                catch (IOException e) {
                    this._logger.error((Object)e);
                    throw new XmlRpcException(1000, "An error occured processing your request");
                }
            }
            this._logger.error((Object)("MIME type not accepted. Received MIME type: " + type));
            throw new XmlRpcException(1000, "MIME type not accepted. Received MIME type: " + type);
        }
        catch (BlojsomException e) {
            this._logger.error((Object)("Failed to authenticate user [" + userid + "] with password [" + password + "]"));
            throw new XmlRpcException(1, "Invalid username and/or password");
        }
    }

    public boolean setTemplate(String appkey, String blogid, String userid, String password, String template, String templateType) throws Exception {
        this._logger.debug((Object)"setTemplate() Called =====[ UNSUPPORTED ]=====");
        this._logger.debug((Object)("     Appkey: " + appkey));
        this._logger.debug((Object)("     BlogId: " + blogid));
        this._logger.debug((Object)("     UserId: " + userid));
        this._logger.debug((Object)"   Password: *********");
        this._logger.debug((Object)("   Template: " + template));
        this._logger.debug((Object)("       Type: " + templateType));
        throw new XmlRpcException(1001, "Unsupported method");
    }

    public String getTemplate(String appkey, String blogid, String userid, String password, String templateType) throws Exception {
        this._logger.debug((Object)"getTemplate() Called =====[ UNSUPPORTED ]=====");
        this._logger.debug((Object)("     Appkey: " + appkey));
        this._logger.debug((Object)("     BlogId: " + blogid));
        this._logger.debug((Object)("     UserId: " + userid));
        this._logger.debug((Object)"   Password: *********");
        this._logger.debug((Object)("       Type: " + templateType));
        throw new XmlRpcException(1001, "Unsupported method");
    }

    private String convertDateCreated(Date dateCreated, Blog blog) {
        if (dateCreated == null) {
            return Long.toString(new Date().getTime());
        }
        String timezoneID = blog.getBlogProperty("blog-timezone-id");
        String timezoneOffset = blog.getBlogProperty("blog-timezone-offset");
        if (BlojsomUtils.checkNullOrBlank((String)timezoneID)) {
            timezoneID = TimeZone.getDefault().getID();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (!BlojsomUtils.checkNullOrBlank((String)timezoneOffset)) {
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone(timezoneOffset));
        }
        Date convertedDate = dateCreated;
        String convertedDateISO8601 = simpleDateFormat.format(convertedDate);
        try {
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone(timezoneID));
            convertedDate = simpleDateFormat.parse(convertedDateISO8601);
        }
        catch (ParseException e) {
            // empty catch block
        }
        long convertedDateTime = convertedDate.getTime();
        return Long.toString(convertedDateTime);
    }
}

