/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.extension.xmlrpc.handlers;

import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlrpc.XmlRpcException;
import org.blojsom.BlojsomException;
import org.blojsom.blog.BlogCategory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.Trackback;
import org.blojsom.extension.xmlrpc.handlers.AbstractBlojsomAPIHandler;
import org.blojsom.util.BlojsomUtils;

public class MovableTypeAPIHandler
extends AbstractBlojsomAPIHandler {
    protected static final String MEMBER_DATECREATED = "dateCreated";
    protected static final String MEMBER_USERID = "userid";
    protected static final String MEMBER_POSTID = "postid";
    protected static final String MEMBER_TITLE = "title";
    protected static final String MEMBER_CATEGORYID = "categoryId";
    protected static final String MEMBER_CATEGORYNAME = "categoryName";
    protected static final String MEMBER_ISPRIMARY = "isPrimary";
    protected static final String MEMBER_KEY = "key";
    protected static final String MEMBER_LABEL = "label";
    protected static final String MEMBER_PING_TITLE = "pingTitle";
    protected static final String MEMBER_PING_URL = "pingURL";
    protected static final String MEMBER_PING_IP = "pingIP";
    private static final String MOVABLETYPE_API_PERMISSION = "post_via_movabletype_api";
    protected static final String API_PREFIX = "mt";
    protected Log _logger = LogFactory.getLog((Class)MovableTypeAPIHandler.class);

    public void setBlogUser(BlogUser blogUser) throws BlojsomException {
        this._blogUser = blogUser;
        this._blog = this._blogUser.getBlog();
        this._blogEntryExtension = this._blog.getBlogProperty("blog-xmlrpc-entry-extension");
        if (BlojsomUtils.checkNullOrBlank((String)this._blogEntryExtension)) {
            this._blogEntryExtension = ".html";
        }
    }

    public String getName() {
        return API_PREFIX;
    }

    public Object getRecentPostTitles(String blogID, String username, String password, int numberOfPosts) throws Exception {
        this._logger.debug((Object)"getRecentPostTitles() Called ===========[ SUPPORTED ]=====");
        this._logger.debug((Object)("     BlogId: " + blogID));
        this._logger.debug((Object)("     UserId: " + username));
        this._logger.debug((Object)"   Password: *********");
        this._logger.debug((Object)("   Numposts: " + numberOfPosts));
        Vector recentPosts = new Vector();
        blogID = BlojsomUtils.normalize((String)blogID);
        try {
            this._authorizationProvider.loadAuthenticationCredentials(this._blogUser);
            this._authorizationProvider.authorize(this._blogUser, null, username, password);
            this.checkXMLRPCPermission(username, MOVABLETYPE_API_PERMISSION);
            File blogCategoryFile = new File(this._blog.getBlogHome() + BlojsomUtils.removeInitialSlash((String)blogID));
            if (blogCategoryFile.exists() && blogCategoryFile.isDirectory()) {
                BlogEntry[] entries;
                String requestedCategory = BlojsomUtils.removeInitialSlash((String)blogID);
                BlogCategory blogCategory = this._fetcher.newBlogCategory();
                blogCategory.setCategory(blogID);
                blogCategory.setCategoryURL(this._blog.getBlogURL() + requestedCategory);
                HashMap<String, Object> fetchMap = new HashMap<String, Object>();
                if (BlojsomUtils.checkNullOrBlank((String)requestedCategory)) {
                    fetchMap.put("FETCHER_FLAVOR", "html");
                    fetchMap.put("FETCHER_NUM_POSTS_INTEGER", new Integer(numberOfPosts));
                    entries = this._fetcher.fetchEntries(fetchMap, this._blogUser);
                } else {
                    fetchMap.put("FETCHER_CATEGORY", blogCategory);
                    fetchMap.put("FETCHER_NUM_POSTS_INTEGER", new Integer(numberOfPosts));
                    entries = this._fetcher.fetchEntries(fetchMap, this._blogUser);
                }
                if (entries != null && entries.length > 0) {
                    for (int x = 0; x < entries.length; ++x) {
                        BlogEntry entry = entries[x];
                        Hashtable<String, Object> entrystruct = new Hashtable<String, Object>();
                        entrystruct.put(MEMBER_DATECREATED, entry.getDate());
                        if (BlojsomUtils.checkMapForKey((Map)entry.getMetaData(), (String)"blog-entry-author")) {
                            entrystruct.put(MEMBER_USERID, (String)entry.getMetaData().get("blog-entry-author"));
                        } else {
                            entrystruct.put(MEMBER_USERID, this._blog.getBlogOwner());
                        }
                        entrystruct.put(MEMBER_POSTID, entry.getId());
                        entrystruct.put(MEMBER_TITLE, entry.getTitle());
                        recentPosts.add(entrystruct);
                    }
                }
            }
            return recentPosts;
        }
        catch (BlojsomException e) {
            this._logger.error((Object)("Failed to authenticate user [" + username + "] with password [" + password + "]"));
            throw new XmlRpcException(1, "Invalid username and/or password");
        }
    }

    public Object getCategoryList(String blogID, String username, String password) throws Exception {
        this._logger.debug((Object)"getCategories() Called =====[ SUPPORTED ]=====");
        this._logger.debug((Object)("     BlogId: " + blogID));
        this._logger.debug((Object)("     UserId: " + username));
        this._logger.debug((Object)"   Password: *********");
        try {
            Vector result;
            this._authorizationProvider.loadAuthenticationCredentials(this._blogUser);
            this._authorizationProvider.authorize(this._blogUser, null, username, password);
            this.checkXMLRPCPermission(username, MOVABLETYPE_API_PERMISSION);
            BlogCategory[] categories = this._fetcher.fetchCategories(null, this._blogUser);
            if (categories != null) {
                result = new Vector(categories.length);
                for (int x = 0; x < categories.length; ++x) {
                    Map metadata;
                    Hashtable<String, String> catlist = new Hashtable<String, String>(3);
                    BlogCategory category = categories[x];
                    String categoryId = category.getCategory();
                    if (categoryId.length() > 1) {
                        categoryId = BlojsomUtils.removeInitialSlash((String)categoryId);
                    }
                    String description = (metadata = category.getMetaData()) != null && metadata.containsKey("blojsom.description") ? (String)metadata.get("blojsom.description") : category.getEncodedCategory();
                    catlist.put(MEMBER_CATEGORYID, categoryId);
                    catlist.put(MEMBER_CATEGORYNAME, description);
                    result.add(catlist);
                }
            } else {
                throw new XmlRpcException(3000, "There are no categories defined");
            }
            return result;
        }
        catch (BlojsomException e) {
            this._logger.error((Object)("Failed to authenticate user [" + username + "] with password [" + password + "]"));
            throw new XmlRpcException(1, "Invalid username and/or password");
        }
    }

    public Object getPostCategories(String postID, String username, String password) throws Exception {
        this._logger.debug((Object)"getPost() Called =========[ SUPPORTED ]=====");
        this._logger.debug((Object)("     PostId: " + postID));
        this._logger.debug((Object)("     UserId: " + username));
        this._logger.debug((Object)"   Password: *********");
        Vector result = new Vector();
        try {
            this._authorizationProvider.loadAuthenticationCredentials(this._blogUser);
            this._authorizationProvider.authorize(this._blogUser, null, username, password);
            this.checkXMLRPCPermission(username, MOVABLETYPE_API_PERMISSION);
            String match = "?permalink=";
            int pos = postID.indexOf(match);
            if (pos != -1) {
                String category = postID.substring(0, pos);
                category = BlojsomUtils.normalize((String)category);
                category = BlojsomUtils.urlDecode((String)category);
                String permalink = postID.substring(pos + match.length());
                BlogCategory blogCategory = this._fetcher.newBlogCategory();
                blogCategory.setCategory(category);
                blogCategory.setCategoryURL(this._blog.getBlogURL() + category);
                HashMap<String, Object> fetchMap = new HashMap<String, Object>();
                fetchMap.put("FETCHER_CATEGORY", blogCategory);
                fetchMap.put("FETCHER_PERMALINK", permalink);
                BlogEntry[] entries = this._fetcher.fetchEntries(fetchMap, this._blogUser);
                if (entries != null && entries.length > 0) {
                    Map metadata;
                    BlogEntry entry = entries[0];
                    Hashtable<String, Object> categoryContent = new Hashtable<String, Object>(3);
                    String categoryId = entry.getBlogCategory().getCategory();
                    if (categoryId.length() > 1) {
                        categoryId = BlojsomUtils.removeInitialSlash((String)categoryId);
                    }
                    String description = (metadata = entry.getBlogCategory().getMetaData()) != null && metadata.containsKey("blojsom.description") ? (String)metadata.get("blojsom.description") : entry.getBlogCategory().getEncodedCategory();
                    categoryContent.put(MEMBER_CATEGORYID, categoryId);
                    categoryContent.put(MEMBER_CATEGORYNAME, description);
                    categoryContent.put(MEMBER_ISPRIMARY, Boolean.TRUE);
                    result.add(categoryContent);
                    return result;
                }
                throw new XmlRpcException(2000, "The entry postid you submitted is invalid");
            }
            throw new XmlRpcException(2000, "The entry postid you submitted is invalid");
        }
        catch (BlojsomException e) {
            this._logger.error((Object)("Failed to authenticate user [" + username + "] with password [" + password + "]"));
            throw new XmlRpcException(1, "Invalid username and/or password");
        }
    }

    public boolean setPostCategories(String postID, String username, String password, Vector categories) throws Exception {
        throw new XmlRpcException(1001, "Unsupported method");
    }

    public Object supportedMethods() throws Exception {
        Vector<String> result = new Vector<String>();
        result.add("blogger.newPost");
        result.add("blogger.editPost");
        result.add("blogger.getPost");
        result.add("blogger.deletePost");
        result.add("blogger.getRecentPosts");
        result.add("blogger.getUsersBlogs");
        result.add("blogger.getUserInfo");
        result.add("metaWeblog.getUsersBlogs");
        result.add("metaWeblog.getCategories");
        result.add("metaWeblog.newPost");
        result.add("metaWeblog.editPost");
        result.add("metaWeblog.getPost");
        result.add("metaWeblog.deletePost");
        result.add("metaWeblog.getRecentPosts");
        result.add("metaWeblog.newMediaObject");
        result.add("mt.getRecentPostTitles");
        result.add("mt.getCategoryList");
        result.add("mt.getPostCategories");
        result.add("mt.supportedMethods");
        result.add("mt.supportedTextFilters");
        result.add("mt.getTrackbackPings");
        return result;
    }

    public Object supportedTextFilters() throws Exception {
        Vector result = new Vector();
        return result;
    }

    public Object getTrackbackPings(String postID) throws Exception {
        this._logger.debug((Object)"getTrackbackPings() Called =========[ SUPPORTED ]=====");
        this._logger.debug((Object)("     PostId: " + postID));
        Vector trackbackPings = new Vector();
        try {
            String match = "?permalink=";
            int pos = postID.indexOf(match);
            if (pos != -1) {
                String category = postID.substring(0, pos);
                category = BlojsomUtils.normalize((String)category);
                category = BlojsomUtils.urlDecode((String)category);
                String permalink = postID.substring(pos + match.length());
                BlogCategory blogCategory = this._fetcher.newBlogCategory();
                blogCategory.setCategory(category);
                blogCategory.setCategoryURL(this._blog.getBlogURL() + category);
                HashMap<String, Object> fetchMap = new HashMap<String, Object>();
                fetchMap.put("FETCHER_CATEGORY", blogCategory);
                fetchMap.put("FETCHER_PERMALINK", permalink);
                BlogEntry[] entries = this._fetcher.fetchEntries(fetchMap, this._blogUser);
                if (entries != null && entries.length > 0) {
                    BlogEntry entry = entries[0];
                    Trackback[] trackbacks = entry.getTrackbacksAsArray();
                    for (int i = 0; i < trackbacks.length; ++i) {
                        Hashtable<String, String> trackbackInformation = new Hashtable<String, String>(3);
                        trackbackInformation.put(MEMBER_PING_TITLE, trackbacks[i].getTitle());
                        trackbackInformation.put(MEMBER_PING_URL, trackbacks[i].getUrl());
                        if (BlojsomUtils.checkMapForKey((Map)trackbacks[i].getMetaData(), (String)"BLOJSOM_TRACKBACK_PLUGIN_METADATA_IP")) {
                            trackbackInformation.put(MEMBER_PING_IP, (String)trackbacks[i].getMetaData().get("BLOJSOM_TRACKBACK_PLUGIN_METADATA_IP"));
                        } else {
                            trackbackInformation.put(MEMBER_PING_IP, "");
                        }
                        trackbackPings.add(trackbackInformation);
                    }
                    return trackbackPings;
                }
                throw new XmlRpcException(2000, "The entry postid you submitted is invalid");
            }
            throw new XmlRpcException(2000, "The entry postid you submitted is invalid");
        }
        catch (BlojsomException e) {
            this._logger.error((Object)"An error occured processing your request", (Throwable)e);
            throw new XmlRpcException(1000, "An error occured processing your request");
        }
    }

    public boolean publishPost(String postID, String username, String password) throws Exception {
        throw new XmlRpcException(1001, "Unsupported method");
    }
}

