/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.extension.xmlrpc.handlers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlrpc.XmlRpcException;
import org.blojsom.BlojsomException;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogCategory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.Pingback;
import org.blojsom.extension.xmlrpc.handlers.AbstractBlojsomAPIHandler;
import org.blojsom.fetcher.BlojsomFetcher;
import org.blojsom.fetcher.BlojsomFetcherException;
import org.blojsom.util.BlojsomUtils;

public class PingbackHandler
extends AbstractBlojsomAPIHandler {
    private static final Log _logger = LogFactory.getLog((Class)PingbackHandler.class);
    private static final String TITLE_PATTERN = "<title>(.*)</title>";
    protected static final String API_NAME = "pingback";
    protected static final int PINGBACK_GENERIC_FAULT_CODE = 0;
    protected static final int PINGBACK_SOURCE_URI_NON_EXISTENT_CODE = 16;
    protected static final int PINGBACK_NO_LINK_TO_TARGET_URI_CODE = 17;
    protected static final int PINGBACK_TARGET_URI_NON_EXISTENT_CODE = 32;
    protected static final int PINGBACK_TARGET_URI_NOT_ENABLED_CODE = 33;
    protected static final int PINGBACK_ALREADY_REGISTERED_CODE = 48;
    protected static final int PINGBACK_ACCESS_DENIED_CODE = 49;
    protected static final int PINGBACK_UPSTREAM_SERVER_ERROR_CODE = 50;
    protected static final String PINGBACK_METADATA_IP_ADDRESS = "PINGBACK_IP_ADDRESS";

    public void setBlogUser(BlogUser blogUser) throws BlojsomException {
        this._blogUser = blogUser;
        this._blog = this._blogUser.getBlog();
        this._blogEntryExtension = this._blog.getBlogProperty("blog-xmlrpc-entry-extension");
        if (BlojsomUtils.checkNullOrBlank((String)this._blogEntryExtension)) {
            this._blogEntryExtension = ".html";
        }
    }

    public String getName() {
        return API_NAME;
    }

    protected String getTitleFromSource(String source) {
        String title = null;
        Pattern titlePattern = Pattern.compile(TITLE_PATTERN, 106);
        Matcher titleMatcher = titlePattern.matcher(source);
        if (titleMatcher.find()) {
            title = titleMatcher.group(1);
        }
        return title;
    }

    protected String getExcerptFromSource(String source, String targetURI) {
        String excerpt = null;
        int startOfTarget = source.indexOf(targetURI);
        if (startOfTarget != -1) {
            int endOfExcerpt;
            int startOfExcerpt = startOfTarget - 200;
            if (startOfExcerpt < 0) {
                startOfExcerpt = 0;
            }
            if ((endOfExcerpt = startOfTarget + 200) > source.length()) {
                endOfExcerpt = source.length();
            }
            excerpt = source.substring(startOfExcerpt, endOfExcerpt);
            excerpt = BlojsomUtils.stripHTML((String)excerpt);
        }
        return excerpt;
    }

    public String ping(String sourceURI, String targetURI) throws XmlRpcException {
        block12: {
            _logger.debug((Object)("Pingback from: " + sourceURI + " to: " + targetURI));
            if (BlojsomUtils.checkNullOrBlank((String)sourceURI)) {
                _logger.error((Object)"Pingback must include a source URI");
                throw new XmlRpcException(16, "Pingback must include a source URI");
            }
            StringBuffer sourcePage = new StringBuffer();
            try {
                String line;
                URL source = new URL(sourceURI);
                HttpURLConnection sourceConnection = (HttpURLConnection)source.openConnection();
                sourceConnection.setRequestMethod("GET");
                sourceConnection.connect();
                BufferedReader sourceReader = new BufferedReader(new InputStreamReader(sourceConnection.getInputStream(), "UTF-8"));
                sourcePage = new StringBuffer();
                while ((line = sourceReader.readLine()) != null) {
                    sourcePage.append(line);
                    sourcePage.append(LINE_SEPARATOR);
                }
            }
            catch (IOException e) {
                _logger.error((Object)e);
                throw new XmlRpcException(0, "Unable to retrieve source URI");
            }
            if (sourcePage.indexOf(targetURI) == -1) {
                _logger.error((Object)"Target URI not found in Source URI");
                throw new XmlRpcException(17, "Target URI not found in source URI");
            }
            try {
                URL target = new URL(targetURI);
                HttpURLConnection httpURLConnection = (HttpURLConnection)target.openConnection();
                httpURLConnection.setRequestMethod("HEAD");
                httpURLConnection.connect();
                if (httpURLConnection.getResponseCode() != 200) {
                    _logger.error((Object)"Target URI does not exist");
                    throw new XmlRpcException(32, "Target URI does not exist");
                }
            }
            catch (IOException e) {
                _logger.error((Object)e);
                throw new XmlRpcException(0, "Unable to retrieve target URI");
            }
            String pingbackID = BlojsomUtils.digestString((String)(sourceURI + ":" + targetURI));
            BlogCategory blogCategory = this.getBlogCategory(this._blogUser, this._httpServletRequest);
            String permalink = BlojsomUtils.getRequestValue((String)"permalink", (HttpServletRequest)this._httpServletRequest);
            try {
                BlogEntry blogEntry = BlojsomUtils.fetchEntry((BlojsomFetcher)this._fetcher, (BlogUser)this._blogUser, (String)blogCategory.getCategory(), (String)permalink);
                if (this._blog.getBlogPingbacksEnabled().booleanValue() && blogEntry.supportsPingbacks()) {
                    HashMap<String, String> pingbackMetaData = new HashMap<String, String>();
                    pingbackMetaData.put(PINGBACK_METADATA_IP_ADDRESS, this._httpServletRequest.getRemoteAddr());
                    Pingback pingback = this._fetcher.newPingback();
                    pingback.setBlogEntry(blogEntry);
                    Integer status = this.addPingback(new HashMap(), blogCategory.getCategory(), permalink, blogEntry.getTitle(), this.getExcerptFromSource(sourcePage.toString(), targetURI), sourceURI, this.getTitleFromSource(sourcePage.toString()), this._blog.getBlogFileExtensions(), this._blog.getBlogHome(), this._blog.getBlogPingbacksDirectory(), "UTF-8", pingbackMetaData, pingback, pingbackID);
                    if (status != 0) {
                        throw new XmlRpcException(status.intValue(), "Unknown exception occurred");
                    }
                    break block12;
                }
                _logger.debug((Object)"Target URI does not support pingbacks");
                throw new XmlRpcException(33, "Target URI does not support pingbacks");
            }
            catch (BlojsomFetcherException e) {
                _logger.error((Object)e);
                throw new XmlRpcException(32, "Target URI does not exist");
            }
        }
        return "Registered pingback from: " + sourceURI + " to: " + targetURI;
    }

    protected Integer addPingback(Map context, String category, String permalink, String title, String excerpt, String url, String blogName, String[] blogFileExtensions, String blogHome, String blogPingbackDirectory, String blogFileEncoding, Map pingbackMetaData, Pingback pingback, String id) throws XmlRpcException {
        block2: {
            excerpt = BlojsomUtils.escapeMetaAndLink((String)excerpt);
            pingback.setTitle(title);
            pingback.setExcerpt(excerpt);
            pingback.setUrl(url);
            pingback.setBlogName(blogName);
            pingback.setTrackbackDateLong(new Date().getTime());
            pingback.setMetaData(pingbackMetaData);
            pingback.setId(id);
            try {
                pingback.save(this._blogUser);
            }
            catch (BlojsomException e) {
                if (!(e.getCause() instanceof XmlRpcException)) break block2;
                throw (XmlRpcException)e.getCause();
            }
        }
        return new Integer(0);
    }

    protected BlogCategory getBlogCategory(BlogUser user, HttpServletRequest httpServletRequest) {
        Blog blog = user.getBlog();
        String requestedCategory = httpServletRequest.getPathInfo();
        String userFromPath = BlojsomUtils.getUserFromPath((String)httpServletRequest.getPathInfo());
        if (userFromPath == null) {
            requestedCategory = httpServletRequest.getPathInfo();
        } else {
            _logger.debug((Object)("User: " + user.getId()));
            _logger.debug((Object)("Path: " + userFromPath));
            requestedCategory = userFromPath.equals(user.getId()) ? BlojsomUtils.getCategoryFromPath((String)httpServletRequest.getPathInfo()) : httpServletRequest.getPathInfo();
        }
        requestedCategory = BlojsomUtils.normalize((String)requestedCategory);
        _logger.debug((Object)("blojsom path info: " + requestedCategory));
        String categoryParameter = httpServletRequest.getParameter("category");
        if (categoryParameter != null && !"".equals(categoryParameter)) {
            categoryParameter = BlojsomUtils.normalize((String)categoryParameter);
            _logger.debug((Object)("Category parameter override: " + categoryParameter));
            requestedCategory = categoryParameter;
        }
        if (requestedCategory == null) {
            requestedCategory = "/";
        } else if (!requestedCategory.endsWith("/")) {
            requestedCategory = requestedCategory + "/";
        }
        requestedCategory = BlojsomUtils.urlDecode((String)requestedCategory);
        _logger.debug((Object)("User requested category: " + requestedCategory));
        BlogCategory category = this._fetcher.newBlogCategory();
        category.setCategory(requestedCategory);
        category.setCategoryURL(blog.getBlogURL() + BlojsomUtils.removeInitialSlash((String)requestedCategory));
        try {
            category.load(user);
        }
        catch (BlojsomException e) {
            _logger.error((Object)e);
        }
        return category;
    }
}

