/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.admin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.BlojsomException;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogCategory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.event.BlojsomEvent;
import org.blojsom.fetcher.BlojsomFetcher;
import org.blojsom.fetcher.BlojsomFetcherException;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.admin.BaseAdminPlugin;
import org.blojsom.plugin.admin.event.AddedBlogCategoryEvent;
import org.blojsom.plugin.admin.event.DeletedBlogCategoryEvent;
import org.blojsom.plugin.admin.event.UpdatedBlogCategoryEvent;
import org.blojsom.util.BlojsomProperties;
import org.blojsom.util.BlojsomUtils;

public class EditBlogCategoriesPlugin
extends BaseAdminPlugin {
    private static Log _logger = LogFactory.getLog((Class)EditBlogCategoriesPlugin.class);
    private static final String FAILED_PERMISSION_KEY = "failed.permission.text";
    private static final String DELETED_CATEGORY_KEY = "deleted.category.text";
    private static final String FAILED_DELETED_CATEGORY_KEY = "failed.deleted.category.text";
    private static final String FAILED_LOAD_CATEGORY_KEY = "failed.load.category.text";
    private static final String NO_CATEGORY_SPECIFIED_KEY = "no.category.specified.text";
    private static final String FAILED_CATEGORY_METADATA_READ_KEY = "failed.category.metadata.read.text";
    private static final String CATEGORY_ADD_SUCCESS_KEY = "category.add.success.text";
    private static final String CATEGORY_UPDATE_SUCCESS_KEY = "category.update.success.text";
    private static final String CATEGORY_CHANGE_FAILED_KEY = "category.change.failed.text";
    private static final String EDIT_BLOG_CATEGORIES_PAGE = "/org/blojsom/plugin/admin/templates/admin-edit-blog-categories";
    private static final String EDIT_BLOG_CATEGORY_PAGE = "/org/blojsom/plugin/admin/templates/admin-edit-blog-category";
    private static final String BLOJSOM_PLUGIN_EDIT_BLOG_CATEGORIES_CATEGORY_NAME = "BLOJSOM_PLUGIN_EDIT_BLOG_CATEGORIES_CATEGORY_NAME";
    private static final String BLOJSOM_PLUGIN_EDIT_BLOG_CATEGORIES_CATEGORY_DESCRIPTION = "BLOJSOM_PLUGIN_EDIT_BLOG_CATEGORIES_CATEGORY_DESCRIPTION";
    private static final String BLOJSOM_PLUGIN_EDIT_BLOG_CATEGORIES_CATEGORY_METADATA = "BLOJSOM_PLUGIN_EDIT_BLOG_CATEGORIES_CATEGORY_METADATA";
    private static final String BLOJSOM_PLUGIN_EDIT_BLOG_CATEGORIES_ALL_CATEGORIES = "BLOJSOM_PLUGIN_EDIT_BLOG_CATEGORIES_ALL_CATEGORIES";
    private static final String ADD_BLOG_CATEGORY_ACTION = "add-blog-category";
    private static final String DELETE_BLOG_CATEGORY_ACTION = "delete-blog-category";
    private static final String EDIT_BLOG_CATEGORY_ACTION = "edit-blog-category";
    private static final String UPDATE_BLOG_CATEGORY_ACTION = "update-blog-category";
    private static final String BLOG_CATEGORY_NAME = "blog-category-name";
    private static final String BLOG_CATEGORY_DESCRIPTION = "blog-category-description";
    private static final String BLOG_CATEGORY_META_DATA = "blog-category-meta-data";
    private static final String BLOG_CATEGORY_PARENT = "blog-category-parent";
    private static final String EDIT_BLOG_CATEGORIES_PERMISSION = "edit_blog_categories";
    private BlojsomFetcher _fetcher;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        super.init(servletConfig, blojsomConfiguration);
        String fetcherClassName = blojsomConfiguration.getFetcherClass();
        try {
            Class<?> fetcherClass = Class.forName(fetcherClassName);
            this._fetcher = (BlojsomFetcher)fetcherClass.newInstance();
            this._fetcher.init(servletConfig, blojsomConfiguration);
            _logger.info((Object)("Added blojsom fetcher: " + fetcherClassName));
        }
        catch (ClassNotFoundException e) {
            _logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
        catch (InstantiationException e) {
            _logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            _logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
        catch (BlojsomFetcherException e) {
            _logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        if (!this.authenticateUser(httpServletRequest, httpServletResponse, context, user)) {
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin-login");
            return entries;
        }
        Blog blog = user.getBlog();
        String action = BlojsomUtils.getRequestValue((String)"action", (HttpServletRequest)httpServletRequest);
        try {
            BlogCategory[] allCategories = this._fetcher.fetchCategories(null, user);
            context.put(BLOJSOM_PLUGIN_EDIT_BLOG_CATEGORIES_ALL_CATEGORIES, allCategories);
        }
        catch (BlojsomFetcherException e) {
            _logger.error((Object)e);
        }
        String username = this.getUsernameFromSession(httpServletRequest, user.getBlog());
        if (!this.checkPermission(user, null, username, EDIT_BLOG_CATEGORIES_PERMISSION)) {
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin");
            this.addOperationResultMessage(context, this.getAdminResource(FAILED_PERMISSION_KEY, FAILED_PERMISSION_KEY, user.getBlog().getBlogAdministrationLocale()));
            return entries;
        }
        if (BlojsomUtils.checkNullOrBlank((String)action)) {
            _logger.debug((Object)"User did not request edit action");
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin");
        } else if ("page".equals(action)) {
            _logger.debug((Object)"User requested edit categories page");
            httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_CATEGORIES_PAGE);
        } else if (DELETE_BLOG_CATEGORY_ACTION.equals(action)) {
            _logger.debug((Object)"User request blog category delete action");
            String blogCategoryName = BlojsomUtils.getRequestValue((String)BLOG_CATEGORY_NAME, (HttpServletRequest)httpServletRequest);
            blogCategoryName = BlojsomUtils.normalize((String)blogCategoryName);
            BlogCategory blogCategoryToDelete = this._fetcher.newBlogCategory();
            blogCategoryToDelete.setCategory(blogCategoryName);
            try {
                blogCategoryToDelete.delete(user);
                _logger.debug((Object)("Deleted blog category: " + blogCategoryName));
                this.addOperationResultMessage(context, this.formatAdminResource(DELETED_CATEGORY_KEY, DELETED_CATEGORY_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogCategoryName}));
                this._blojsomConfiguration.getEventBroadcaster().broadcastEvent((BlojsomEvent)new DeletedBlogCategoryEvent(this, new Date(), blogCategoryToDelete, user));
            }
            catch (BlojsomException e) {
                _logger.error((Object)e);
                _logger.error((Object)("Unable to delete blog category: " + blogCategoryName));
                this.addOperationResultMessage(context, this.formatAdminResource(FAILED_DELETED_CATEGORY_KEY, FAILED_DELETED_CATEGORY_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogCategoryName}));
            }
            httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_CATEGORIES_PAGE);
        } else if (EDIT_BLOG_CATEGORY_ACTION.equals(action)) {
            String blogCategoryName = BlojsomUtils.getRequestValue((String)BLOG_CATEGORY_NAME, (HttpServletRequest)httpServletRequest);
            blogCategoryName = BlojsomUtils.normalize((String)blogCategoryName);
            _logger.debug((Object)("Editing blog category: " + blogCategoryName));
            BlogCategory blogCategoryToEdit = this._fetcher.newBlogCategory();
            blogCategoryToEdit.setCategory(blogCategoryName);
            try {
                blogCategoryToEdit.load(user);
                context.put(BLOJSOM_PLUGIN_EDIT_BLOG_CATEGORIES_CATEGORY_DESCRIPTION, blogCategoryToEdit.getMetaData().get("blojsom.name"));
                StringBuffer categoryPropertiesString = new StringBuffer();
                Iterator keyIterator = blogCategoryToEdit.getMetaData().keySet().iterator();
                while (keyIterator.hasNext()) {
                    Object key = keyIterator.next();
                    categoryPropertiesString.append(key.toString()).append("=").append(blogCategoryToEdit.getMetaData().get(key)).append("\r\n");
                }
                context.put(BLOJSOM_PLUGIN_EDIT_BLOG_CATEGORIES_CATEGORY_METADATA, categoryPropertiesString.toString());
            }
            catch (BlojsomException e) {
                _logger.error((Object)e);
                this.addOperationResultMessage(context, this.formatAdminResource(FAILED_LOAD_CATEGORY_KEY, FAILED_LOAD_CATEGORY_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogCategoryName}));
            }
            context.put(BLOJSOM_PLUGIN_EDIT_BLOG_CATEGORIES_CATEGORY_NAME, blogCategoryName);
            httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_CATEGORY_PAGE);
        } else if (ADD_BLOG_CATEGORY_ACTION.equals(action) || UPDATE_BLOG_CATEGORY_ACTION.equals(action)) {
            boolean isUpdatingCategory = UPDATE_BLOG_CATEGORY_ACTION.equals(action);
            String blogCategoryName = BlojsomUtils.getRequestValue((String)BLOG_CATEGORY_NAME, (HttpServletRequest)httpServletRequest);
            if (BlojsomUtils.checkNullOrBlank((String)blogCategoryName)) {
                httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_CATEGORIES_PAGE);
                this.addOperationResultMessage(context, this.getAdminResource(NO_CATEGORY_SPECIFIED_KEY, NO_CATEGORY_SPECIFIED_KEY, user.getBlog().getBlogAdministrationLocale()));
                return entries;
            }
            blogCategoryName = BlojsomUtils.normalize((String)blogCategoryName);
            String blogCategoryParent = BlojsomUtils.getRequestValue((String)BLOG_CATEGORY_PARENT, (HttpServletRequest)httpServletRequest);
            blogCategoryParent = BlojsomUtils.normalize((String)blogCategoryParent);
            String blogCategoryDescription = BlojsomUtils.getRequestValue((String)BLOG_CATEGORY_DESCRIPTION, (HttpServletRequest)httpServletRequest);
            if (!isUpdatingCategory) {
                _logger.debug((Object)("Adding blog category: " + blogCategoryName));
            } else {
                _logger.debug((Object)("Updating blog category: " + blogCategoryName));
            }
            String blogCategoryMetaData = BlojsomUtils.getRequestValue((String)BLOG_CATEGORY_META_DATA, (HttpServletRequest)httpServletRequest);
            if (blogCategoryMetaData == null) {
                blogCategoryMetaData = "";
            }
            if (!isUpdatingCategory) {
                _logger.debug((Object)("Adding blog category meta-data: " + blogCategoryMetaData));
            }
            BufferedReader br = new BufferedReader(new StringReader(blogCategoryMetaData));
            BlojsomProperties categoryMetaData = new BlojsomProperties(blog.getBlogFileEncoding());
            try {
                String input;
                while ((input = br.readLine()) != null) {
                    String[] splitInput = input.split("=");
                    if (splitInput.length != 2) continue;
                    categoryMetaData.put((Object)splitInput[0], (Object)splitInput[1]);
                }
            }
            catch (IOException e) {
                _logger.error((Object)e);
                this.addOperationResultMessage(context, this.getAdminResource(FAILED_CATEGORY_METADATA_READ_KEY, FAILED_CATEGORY_METADATA_READ_KEY, user.getBlog().getBlogAdministrationLocale()));
            }
            BlogCategory blogCategory = this._fetcher.newBlogCategory();
            if (BlojsomUtils.checkNullOrBlank((String)blogCategoryParent)) {
                blogCategory.setCategory(BlojsomUtils.removeInitialSlash((String)blogCategoryName));
            } else {
                blogCategory.setCategory(BlojsomUtils.removeSlashes((String)blogCategoryParent) + "/" + BlojsomUtils.removeInitialSlash((String)blogCategoryName));
            }
            if (!BlojsomUtils.checkNullOrBlank((String)blogCategoryDescription)) {
                categoryMetaData.put((Object)"blojsom.name", (Object)blogCategoryDescription);
            }
            blogCategory.setMetaData((Properties)categoryMetaData);
            try {
                blogCategory.save(user);
                if (!isUpdatingCategory) {
                    _logger.debug((Object)("Successfully added new blog category: " + blogCategoryName));
                    this.addOperationResultMessage(context, this.formatAdminResource(CATEGORY_ADD_SUCCESS_KEY, CATEGORY_ADD_SUCCESS_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogCategoryName}));
                    this._blojsomConfiguration.getEventBroadcaster().broadcastEvent((BlojsomEvent)new AddedBlogCategoryEvent(this, new Date(), blogCategory, user));
                } else {
                    _logger.debug((Object)("Successfully updated blog category: " + blogCategoryName));
                    this.addOperationResultMessage(context, this.formatAdminResource(CATEGORY_UPDATE_SUCCESS_KEY, CATEGORY_UPDATE_SUCCESS_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogCategoryName}));
                    this._blojsomConfiguration.getEventBroadcaster().broadcastEvent((BlojsomEvent)new UpdatedBlogCategoryEvent(this, new Date(), blogCategory, user));
                }
            }
            catch (BlojsomException e) {
                _logger.error((Object)e);
                this.addOperationResultMessage(context, this.formatAdminResource(CATEGORY_CHANGE_FAILED_KEY, CATEGORY_CHANGE_FAILED_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogCategoryName}));
            }
            httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_CATEGORIES_PAGE);
        }
        try {
            BlogCategory[] allCategories = this._fetcher.fetchCategories(null, user);
            context.put(BLOJSOM_PLUGIN_EDIT_BLOG_CATEGORIES_ALL_CATEGORIES, allCategories);
        }
        catch (BlojsomFetcherException e) {
            _logger.error((Object)e);
        }
        return entries;
    }
}

