/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.admin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.BlojsomException;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogCategory;
import org.blojsom.blog.BlogComment;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.blog.Pingback;
import org.blojsom.blog.Trackback;
import org.blojsom.event.BlojsomEvent;
import org.blojsom.fetcher.BlojsomFetcher;
import org.blojsom.fetcher.BlojsomFetcherException;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.admin.BaseAdminPlugin;
import org.blojsom.plugin.admin.event.AddBlogEntryEvent;
import org.blojsom.plugin.admin.event.DeletedBlogEntryEvent;
import org.blojsom.plugin.admin.event.ProcessBlogEntryEvent;
import org.blojsom.plugin.admin.event.UpdatedBlogEntryEvent;
import org.blojsom.plugin.comment.event.CommentApprovedEvent;
import org.blojsom.plugin.comment.event.CommentDeletedEvent;
import org.blojsom.plugin.trackback.event.TrackbackApprovedEvent;
import org.blojsom.plugin.trackback.event.TrackbackDeletedEvent;
import org.blojsom.util.BlojsomUtils;

public class EditBlogEntriesPlugin
extends BaseAdminPlugin {
    private Log _logger = LogFactory.getLog((Class)EditBlogEntriesPlugin.class);
    public static final String BLOG_XMLRPC_ENTRY_EXTENSION_IP = "blog-xmlrpc-entry-extension";
    protected static final int MAXIMUM_FILENAME_LENGTH = 64;
    public static final String DEFAULT_BLOG_XMLRPC_ENTRY_EXTENSION = ".html";
    private static final String EDIT_BLOG_ENTRIES_PAGE = "/org/blojsom/plugin/admin/templates/admin-edit-blog-entries";
    private static final String EDIT_BLOG_ENTRIES_LIST_PAGE = "/org/blojsom/plugin/admin/templates/admin-edit-blog-entries-list";
    private static final String EDIT_BLOG_ENTRY_PAGE = "/org/blojsom/plugin/admin/templates/admin-edit-blog-entry";
    private static final String ADD_BLOG_ENTRY_PAGE = "/org/blojsom/plugin/admin/templates/admin-add-blog-entry";
    protected static final String BLOJSOM_PLUGIN_EDIT_BLOG_ENTRIES_LIST = "BLOJSOM_PLUGIN_EDIT_BLOG_ENTRIES_LIST";
    protected static final String BLOJSOM_PLUGIN_EDIT_BLOG_ENTRIES_CATEGORY = "BLOJSOM_PLUGIN_EDIT_BLOG_ENTRIES_CATEGORY";
    protected static final String BLOJSOM_PLUGIN_EDIT_BLOG_ENTRIES_ENTRY = "BLOJSOM_PLUGIN_EDIT_BLOG_ENTRIES_ENTRY";
    private static final String FAILED_PERMISSION_EDIT_KEY = "failed.permission.edit.text";
    private static final String FAILED_RETRIEVE_BLOG_ENTRY_KEY = "failed.retrieve.entry.text";
    private static final String FAILED_DELETE_BLOG_ENTRY_KEY = "failed.delete.entry.text";
    private static final String FAILED_ADD_BLOG_ENTRY_KEY = "failed.add.entry.text";
    private static final String UPDATED_BLOG_ENTRY_KEY = "updated.blog.entry.text";
    private static final String DELETED_BLOG_ENTRY_KEY = "deleted.blog.entry.text";
    private static final String ADDED_BLOG_ENTRY_KEY = "added.blog.entry.text";
    private static final String DELETED_COMMENTS_KEY = "deleted.comments.text";
    private static final String APPROVED_COMMENTS_KEY = "approved.comments.text";
    private static final String DELETED_TRACKBACKS_KEY = "deleted.trackbacks.text";
    private static final String APPROVED_TRACKBACKS_KEY = "approved.trackbacks.text";
    private static final String BLANK_ENTRY_KEY = "blank.entry.text";
    private static final String EDIT_BLOG_ENTRIES_ACTION = "edit-blog-entries";
    private static final String EDIT_BLOG_ENTRY_ACTION = "edit-blog-entry";
    private static final String UPDATE_BLOG_ENTRY_ACTION = "update-blog-entry";
    private static final String DELETE_BLOG_ENTRY_ACTION = "delete-blog-entry";
    private static final String NEW_BLOG_ENTRY_ACTION = "new-blog-entry";
    private static final String ADD_BLOG_ENTRY_ACTION = "add-blog-entry";
    private static final String DELETE_BLOG_COMMENTS = "delete-blog-comments";
    private static final String DELETE_BLOG_TRACKBACKS = "delete-blog-trackbacks";
    private static final String APPROVE_BLOG_COMMENTS = "approve-blog-comments";
    private static final String APPROVE_BLOG_TRACKBACKS = "approve-blog-trackbacks";
    protected static final String BLOG_CATEGORY_NAME = "blog-category-name";
    protected static final String BLOG_ENTRY_ID = "blog-entry-id";
    protected static final String BLOG_ENTRY_TITLE = "blog-entry-title";
    protected static final String BLOG_ENTRY_DESCRIPTION = "blog-entry-description";
    protected static final String BLOG_COMMENT_ID = "blog-comment-id";
    protected static final String BLOG_TRACKBACK_ID = "blog-trackback-id";
    protected static final String BLOG_ENTRY_PUBLISH_DATETIME = "blog-entry-publish-datetime";
    protected static final String BLOG_TRACKBACK_URLS = "blog-trackback-urls";
    protected static final String BLOG_ENTRY_PROPOSED_NAME = "blog-entry-proposed-name";
    protected static final String PING_BLOG_URLS = "ping-blog-urls";
    protected static final String UPDATED_BLOG_CATEGORY_NAME = "updated-blog-category-name";
    private static final String EDIT_BLOG_ENTRIES_PERMISSION = "edit_blog_entries";
    protected BlojsomFetcher _fetcher;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        super.init(servletConfig, blojsomConfiguration);
        String fetcherClassName = blojsomConfiguration.getFetcherClass();
        try {
            Class<?> fetcherClass = Class.forName(fetcherClassName);
            this._fetcher = (BlojsomFetcher)fetcherClass.newInstance();
            this._fetcher.init(servletConfig, blojsomConfiguration);
            this._logger.info((Object)("Added blojsom fetcher: " + fetcherClassName));
        }
        catch (ClassNotFoundException e) {
            this._logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
        catch (InstantiationException e) {
            this._logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            this._logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
        catch (BlojsomFetcherException e) {
            this._logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        if (!this.authenticateUser(httpServletRequest, httpServletResponse, context, user)) {
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin-login");
            return entries;
        }
        String username = this.getUsernameFromSession(httpServletRequest, user.getBlog());
        if (!this.checkPermission(user, null, username, EDIT_BLOG_ENTRIES_PERMISSION)) {
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin");
            this.addOperationResultMessage(context, this.getAdminResource(FAILED_PERMISSION_EDIT_KEY, FAILED_PERMISSION_EDIT_KEY, user.getBlog().getBlogAdministrationLocale()));
            return entries;
        }
        String action = BlojsomUtils.getRequestValue((String)"action", (HttpServletRequest)httpServletRequest);
        if (BlojsomUtils.checkNullOrBlank((String)action)) {
            this._logger.debug((Object)"User did not request edit action");
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin");
        } else if ("page".equals(action)) {
            this._logger.debug((Object)"User requested edit blog entries page");
            httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_ENTRIES_PAGE);
        } else if (EDIT_BLOG_ENTRIES_ACTION.equals(action)) {
            this._logger.debug((Object)"User requested edit blog entries list page");
            String blogCategoryName = BlojsomUtils.getRequestValue((String)BLOG_CATEGORY_NAME, (HttpServletRequest)httpServletRequest);
            blogCategoryName = BlojsomUtils.normalize((String)blogCategoryName);
            BlogCategory category = this._fetcher.newBlogCategory();
            category.setCategory(blogCategoryName);
            category.setCategoryURL(user.getBlog().getBlogURL() + BlojsomUtils.removeInitialSlash((String)blogCategoryName));
            HashMap<String, Object> fetchMap = new HashMap<String, Object>();
            fetchMap.put("FETCHER_CATEGORY", category);
            fetchMap.put("FETCHER_NUM_POSTS_INTEGER", new Integer(-1));
            try {
                entries = this._fetcher.fetchEntries(fetchMap, user);
                if (entries != null) {
                    this._logger.debug((Object)("Retrieved " + entries.length + " entries from category: " + blogCategoryName));
                    Arrays.sort(entries, BlojsomUtils.FILE_TIME_COMPARATOR);
                } else {
                    this._logger.debug((Object)("No entries found in category: " + blogCategoryName));
                }
            }
            catch (BlojsomFetcherException e) {
                this._logger.error((Object)e);
                entries = new BlogEntry[]{};
            }
            context.put(BLOJSOM_PLUGIN_EDIT_BLOG_ENTRIES_CATEGORY, blogCategoryName);
            context.put(BLOJSOM_PLUGIN_EDIT_BLOG_ENTRIES_LIST, entries);
            httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_ENTRIES_LIST_PAGE);
        } else if (EDIT_BLOG_ENTRY_ACTION.equals(action)) {
            this._logger.debug((Object)"User requested edit blog entry action");
            String blogCategoryName = BlojsomUtils.getRequestValue((String)BLOG_CATEGORY_NAME, (HttpServletRequest)httpServletRequest);
            blogCategoryName = BlojsomUtils.normalize((String)blogCategoryName);
            String blogEntryId = BlojsomUtils.getRequestValue((String)BLOG_ENTRY_ID, (HttpServletRequest)httpServletRequest);
            this._logger.debug((Object)("Blog entry id: " + blogEntryId));
            try {
                BlogEntry entry = BlojsomUtils.fetchEntry((BlojsomFetcher)this._fetcher, (BlogUser)user, (String)blogCategoryName, (String)blogEntryId);
                context.put(BLOJSOM_PLUGIN_EDIT_BLOG_ENTRIES_ENTRY, entry);
                this._blojsomConfiguration.getEventBroadcaster().processEvent((BlojsomEvent)new ProcessBlogEntryEvent(this, new Date(), entry, user, httpServletRequest, httpServletResponse, context));
            }
            catch (BlojsomFetcherException e) {
                this._logger.error((Object)e);
                this.addOperationResultMessage(context, this.formatAdminResource(FAILED_RETRIEVE_BLOG_ENTRY_KEY, FAILED_RETRIEVE_BLOG_ENTRY_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogEntryId}));
                entries = new BlogEntry[]{};
            }
            context.put(BLOJSOM_PLUGIN_EDIT_BLOG_ENTRIES_CATEGORY, BlojsomUtils.addSlashes((String)blogCategoryName));
            httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_ENTRY_PAGE);
        } else if (UPDATE_BLOG_ENTRY_ACTION.equals(action)) {
            this._logger.debug((Object)"User requested update blog entry action");
            Blog blog = user.getBlog();
            String blogCategoryName = BlojsomUtils.getRequestValue((String)BLOG_CATEGORY_NAME, (HttpServletRequest)httpServletRequest);
            blogCategoryName = BlojsomUtils.normalize((String)blogCategoryName);
            String updatedBlogCategoryName = BlojsomUtils.getRequestValue((String)UPDATED_BLOG_CATEGORY_NAME, (HttpServletRequest)httpServletRequest);
            updatedBlogCategoryName = BlojsomUtils.normalize((String)updatedBlogCategoryName);
            String blogEntryId = BlojsomUtils.getRequestValue((String)BLOG_ENTRY_ID, (HttpServletRequest)httpServletRequest);
            String blogEntryDescription = BlojsomUtils.getRequestValue((String)BLOG_ENTRY_DESCRIPTION, (HttpServletRequest)httpServletRequest);
            String blogEntryTitle = BlojsomUtils.getRequestValue((String)BLOG_ENTRY_TITLE, (HttpServletRequest)httpServletRequest);
            if (BlojsomUtils.checkNullOrBlank((String)blogEntryTitle)) {
                blogEntryDescription = BlojsomUtils.LINE_SEPARATOR + blogEntryDescription;
            }
            String allowComments = BlojsomUtils.getRequestValue((String)"blog-entry-comments-disabled", (HttpServletRequest)httpServletRequest);
            String allowTrackbacks = BlojsomUtils.getRequestValue((String)"blog-entry-trackbacks-disabled", (HttpServletRequest)httpServletRequest);
            String blogTrackbackURLs = BlojsomUtils.getRequestValue((String)BLOG_TRACKBACK_URLS, (HttpServletRequest)httpServletRequest);
            String pingBlogURLS = BlojsomUtils.getRequestValue((String)PING_BLOG_URLS, (HttpServletRequest)httpServletRequest);
            String sendPingbacks = BlojsomUtils.getRequestValue((String)"send-pingbacks", (HttpServletRequest)httpServletRequest);
            this._logger.debug((Object)("Blog entry id: " + blogEntryId));
            try {
                BlogEntry entryToUpdate = BlojsomUtils.fetchEntry((BlojsomFetcher)this._fetcher, (BlogUser)user, (String)blogCategoryName, (String)blogEntryId);
                entryToUpdate.setTitle(blogEntryTitle);
                entryToUpdate.setDescription(blogEntryDescription);
                boolean movingCategory = !blogCategoryName.equals(updatedBlogCategoryName);
                HashMap<String, String> entryMetaData = entryToUpdate.getMetaData();
                if (entryMetaData == null) {
                    entryMetaData = new HashMap<String, String>();
                }
                if (!BlojsomUtils.checkNullOrBlank((String)allowComments)) {
                    entryMetaData.put("blog-entry-comments-disabled", "y");
                } else {
                    entryMetaData.remove("blog-entry-comments-disabled");
                }
                if (!BlojsomUtils.checkNullOrBlank((String)allowTrackbacks)) {
                    entryMetaData.put("blog-entry-trackbacks-disabled", "y");
                } else {
                    entryMetaData.remove("blog-entry-trackbacks-disabled");
                }
                if (BlojsomUtils.checkNullOrBlank((String)pingBlogURLS)) {
                    entryMetaData.put("no-ping-weblogs", "true");
                } else {
                    entryMetaData.remove("no-ping-weblogs");
                }
                if (!BlojsomUtils.checkNullOrBlank((String)sendPingbacks)) {
                    entryMetaData.put("send-pingbacks", "true");
                } else {
                    entryMetaData.remove("send-pingbacks");
                }
                String entryPublishDateTime = httpServletRequest.getParameter(BLOG_ENTRY_PUBLISH_DATETIME);
                if (!BlojsomUtils.checkNullOrBlank((String)entryPublishDateTime)) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                    try {
                        Date publishDateTime = simpleDateFormat.parse(entryPublishDateTime);
                        this._logger.debug((Object)("Publishing blog entry at: " + publishDateTime.toString()));
                        entryMetaData.put("blog-entry-metadata-timestamp", Long.toString(publishDateTime.getTime()));
                    }
                    catch (ParseException e) {
                        this._logger.error((Object)e);
                    }
                }
                entryToUpdate.setMetaData(entryMetaData);
                this._blojsomConfiguration.getEventBroadcaster().processEvent((BlojsomEvent)new ProcessBlogEntryEvent(this, new Date(), entryToUpdate, user, httpServletRequest, httpServletResponse, context));
                if (movingCategory) {
                    this._logger.debug((Object)("Moving entry from " + blogCategoryName + " to " + updatedBlogCategoryName));
                    BlogEntry movedEntry = this._fetcher.newBlogEntry();
                    BlogCategory category = this._fetcher.newBlogCategory();
                    category.setCategory(updatedBlogCategoryName);
                    category.setCategoryURL(user.getBlog().getBlogURL() + BlojsomUtils.removeInitialSlash((String)updatedBlogCategoryName));
                    movedEntry.setTitle(blogEntryTitle);
                    movedEntry.setCategory(updatedBlogCategoryName);
                    movedEntry.setDescription(blogEntryDescription);
                    movedEntry.setBlogCategory(category);
                    movedEntry.setMetaData(entryMetaData);
                    movedEntry.setComments(entryToUpdate.getComments());
                    movedEntry.setTrackbacks(entryToUpdate.getTrackbacks());
                    movedEntry.setPingbacks(entryToUpdate.getPingbacks());
                    movedEntry.save(user);
                    this._logger.debug((Object)("Moving " + entryToUpdate.getNumComments() + " comments"));
                    List comments = entryToUpdate.getComments();
                    for (int i = 0; i < comments.size(); ++i) {
                        BlogComment blogComment = (BlogComment)comments.get(i);
                        try {
                            BlogComment movedComment = this._fetcher.newBlogComment();
                            movedComment.setAuthor(blogComment.getAuthor());
                            movedComment.setAuthorEmail(blogComment.getAuthorEmail());
                            movedComment.setAuthorURL(blogComment.getAuthorURL());
                            movedComment.setBlogEntry(movedEntry);
                            movedComment.setComment(blogComment.getComment());
                            movedComment.setMetaData(blogComment.getMetaData());
                            movedComment.setId(blogComment.getId());
                            movedComment.setCommentDateLong(blogComment.getCommentDateLong());
                            movedComment.save(user);
                            blogComment.delete(user);
                            continue;
                        }
                        catch (BlojsomException e) {
                            this._logger.error((Object)e);
                        }
                    }
                    this._logger.debug((Object)("Moving " + entryToUpdate.getNumTrackbacks() + " trackbacks"));
                    List trackbacks = entryToUpdate.getTrackbacks();
                    for (int i = 0; i < trackbacks.size(); ++i) {
                        Trackback trackback = (Trackback)trackbacks.get(i);
                        try {
                            Trackback movedTrackback = this._fetcher.newTrackback();
                            movedTrackback.setBlogEntry(movedEntry);
                            movedTrackback.setBlogName(trackback.getBlogName());
                            movedTrackback.setExcerpt(trackback.getExcerpt());
                            movedTrackback.setId(trackback.getId());
                            movedTrackback.setMetaData(trackback.getMetaData());
                            movedTrackback.setTitle(trackback.getTitle());
                            movedTrackback.setUrl(trackback.getUrl());
                            movedTrackback.setTrackbackDateLong(trackback.getTrackbackDateLong());
                            movedTrackback.save(user);
                            trackback.delete(user);
                            continue;
                        }
                        catch (BlojsomException e) {
                            this._logger.error((Object)e);
                        }
                    }
                    this._logger.debug((Object)("Moving " + entryToUpdate.getNumPingbacks() + " pingbacks"));
                    List pingbacks = entryToUpdate.getPingbacks();
                    for (int i = 0; i < pingbacks.size(); ++i) {
                        Pingback pingback = (Pingback)pingbacks.get(i);
                        try {
                            Pingback movedPingback = this._fetcher.newPingback();
                            movedPingback.setBlogEntry(movedEntry);
                            movedPingback.setBlogName(pingback.getBlogName());
                            movedPingback.setExcerpt(pingback.getExcerpt());
                            movedPingback.setId(pingback.getId());
                            movedPingback.setMetaData(pingback.getMetaData());
                            movedPingback.setTitle(pingback.getTitle());
                            movedPingback.setUrl(pingback.getUrl());
                            movedPingback.setTrackbackDateLong(pingback.getTrackbackDateLong());
                            movedPingback.save(user);
                            pingback.delete(user);
                            continue;
                        }
                        catch (BlojsomException e) {
                            this._logger.error((Object)e);
                        }
                    }
                    movedEntry.load(user);
                    entryToUpdate.delete(user);
                    entryToUpdate = movedEntry;
                } else {
                    entryToUpdate.save(user);
                }
                entryToUpdate.load(user);
                this._logger.debug((Object)("Updated blog entry: " + entryToUpdate.getLink()));
                StringBuffer entryLink = new StringBuffer();
                entryLink.append("<a href=\"").append(user.getBlog().getBlogURL()).append(BlojsomUtils.removeInitialSlash((String)entryToUpdate.getCategory())).append("?").append("permalink").append("=").append(entryToUpdate.getPermalink()).append("\">").append(entryToUpdate.getTitle()).append("</a>");
                this.addOperationResultMessage(context, this.formatAdminResource(UPDATED_BLOG_ENTRY_KEY, UPDATED_BLOG_ENTRY_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{entryLink.toString()}));
                UpdatedBlogEntryEvent updateEvent = new UpdatedBlogEntryEvent(this, new Date(), entryToUpdate, user);
                this._blojsomConfiguration.getEventBroadcaster().broadcastEvent((BlojsomEvent)updateEvent);
                if (!BlojsomUtils.checkNullOrBlank((String)blogTrackbackURLs)) {
                    this.sendTrackbackPings(blog, entryToUpdate, blogTrackbackURLs);
                }
                httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_ENTRY_PAGE);
                context.put(BLOJSOM_PLUGIN_EDIT_BLOG_ENTRIES_ENTRY, entryToUpdate);
                if (movingCategory) {
                    blogCategoryName = updatedBlogCategoryName;
                }
                blogCategoryName = BlojsomUtils.addSlashes((String)blogCategoryName);
                context.put(BLOJSOM_PLUGIN_EDIT_BLOG_ENTRIES_CATEGORY, blogCategoryName);
            }
            catch (BlojsomFetcherException e) {
                this._logger.error((Object)e);
                this.addOperationResultMessage(context, this.formatAdminResource(FAILED_RETRIEVE_BLOG_ENTRY_KEY, FAILED_RETRIEVE_BLOG_ENTRY_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogEntryId}));
                httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_ENTRIES_PAGE);
                entries = new BlogEntry[]{};
            }
            catch (BlojsomException e) {
                this._logger.error((Object)e);
                this.addOperationResultMessage(context, this.formatAdminResource(FAILED_RETRIEVE_BLOG_ENTRY_KEY, FAILED_RETRIEVE_BLOG_ENTRY_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogEntryId}));
                entries = new BlogEntry[]{};
                httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_ENTRIES_PAGE);
            }
        } else if (DELETE_BLOG_ENTRY_ACTION.equals(action)) {
            this._logger.debug((Object)"User requested delete blog entry action");
            String blogCategoryName = BlojsomUtils.getRequestValue((String)BLOG_CATEGORY_NAME, (HttpServletRequest)httpServletRequest);
            blogCategoryName = BlojsomUtils.normalize((String)blogCategoryName);
            String blogEntryId = BlojsomUtils.getRequestValue((String)BLOG_ENTRY_ID, (HttpServletRequest)httpServletRequest);
            this._logger.debug((Object)("Blog entry id: " + blogEntryId));
            try {
                BlogEntry entryToDelete = BlojsomUtils.fetchEntry((BlojsomFetcher)this._fetcher, (BlogUser)user, (String)blogCategoryName, (String)blogEntryId);
                String title = entryToDelete.getTitle();
                entryToDelete.delete(user);
                this.addOperationResultMessage(context, this.formatAdminResource(DELETED_BLOG_ENTRY_KEY, DELETED_BLOG_ENTRY_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{title}));
                DeletedBlogEntryEvent deleteEvent = new DeletedBlogEntryEvent(this, new Date(), entryToDelete, user);
                this._blojsomConfiguration.getEventBroadcaster().broadcastEvent((BlojsomEvent)deleteEvent);
            }
            catch (BlojsomFetcherException e) {
                this._logger.error((Object)e);
                this.addOperationResultMessage(context, this.formatAdminResource(FAILED_DELETE_BLOG_ENTRY_KEY, FAILED_DELETE_BLOG_ENTRY_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogEntryId}));
                entries = new BlogEntry[]{};
            }
            catch (BlojsomException e) {
                this._logger.error((Object)e);
                this.addOperationResultMessage(context, this.formatAdminResource(FAILED_DELETE_BLOG_ENTRY_KEY, FAILED_DELETE_BLOG_ENTRY_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogEntryId}));
                entries = new BlogEntry[]{};
            }
            httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_ENTRIES_PAGE);
        } else if (NEW_BLOG_ENTRY_ACTION.equals(action)) {
            this._logger.debug((Object)"User requested new blog entry action");
            String blogCategoryName = BlojsomUtils.getRequestValue((String)BLOG_CATEGORY_NAME, (HttpServletRequest)httpServletRequest);
            blogCategoryName = BlojsomUtils.normalize((String)blogCategoryName);
            this._blojsomConfiguration.getEventBroadcaster().processEvent((BlojsomEvent)new ProcessBlogEntryEvent(this, new Date(), null, user, httpServletRequest, httpServletResponse, context));
            context.put(BLOJSOM_PLUGIN_EDIT_BLOG_ENTRIES_CATEGORY, blogCategoryName);
            httpServletRequest.setAttribute("page", (Object)ADD_BLOG_ENTRY_PAGE);
        } else if (ADD_BLOG_ENTRY_ACTION.equals(action)) {
            this._logger.debug((Object)"User requested add blog entry action");
            Blog blog = user.getBlog();
            String blogCategoryName = BlojsomUtils.getRequestValue((String)BLOG_CATEGORY_NAME, (HttpServletRequest)httpServletRequest);
            blogCategoryName = BlojsomUtils.normalize((String)blogCategoryName);
            if (!blogCategoryName.endsWith("/")) {
                blogCategoryName = blogCategoryName + "/";
            }
            String blogEntryDescription = BlojsomUtils.getRequestValue((String)BLOG_ENTRY_DESCRIPTION, (HttpServletRequest)httpServletRequest);
            String blogEntryTitle = BlojsomUtils.getRequestValue((String)BLOG_ENTRY_TITLE, (HttpServletRequest)httpServletRequest);
            if (BlojsomUtils.checkNullOrBlank((String)blogEntryTitle) && BlojsomUtils.checkNullOrBlank((String)blogEntryDescription)) {
                httpServletRequest.setAttribute("page", (Object)ADD_BLOG_ENTRY_PAGE);
                this._blojsomConfiguration.getEventBroadcaster().processEvent((BlojsomEvent)new ProcessBlogEntryEvent(this, new Date(), null, user, httpServletRequest, httpServletResponse, context));
                this.addOperationResultMessage(context, this.getAdminResource(BLANK_ENTRY_KEY, BLANK_ENTRY_KEY, user.getBlog().getBlogAdministrationLocale()));
                return entries;
            }
            if (BlojsomUtils.checkNullOrBlank((String)blogEntryTitle)) {
                blogEntryDescription = BlojsomUtils.LINE_SEPARATOR + blogEntryDescription;
            }
            String allowComments = BlojsomUtils.getRequestValue((String)"blog-entry-comments-disabled", (HttpServletRequest)httpServletRequest);
            String allowTrackbacks = BlojsomUtils.getRequestValue((String)"blog-entry-trackbacks-disabled", (HttpServletRequest)httpServletRequest);
            String blogTrackbackURLs = BlojsomUtils.getRequestValue((String)BLOG_TRACKBACK_URLS, (HttpServletRequest)httpServletRequest);
            String proposedBlogFilename = BlojsomUtils.getRequestValue((String)BLOG_ENTRY_PROPOSED_NAME, (HttpServletRequest)httpServletRequest);
            String pingBlogURLS = BlojsomUtils.getRequestValue((String)PING_BLOG_URLS, (HttpServletRequest)httpServletRequest);
            String sendPingbacks = BlojsomUtils.getRequestValue((String)"send-pingbacks", (HttpServletRequest)httpServletRequest);
            BlogCategory category = this._fetcher.newBlogCategory();
            category.setCategory(blogCategoryName);
            category.setCategoryURL(user.getBlog().getBlogURL() + BlojsomUtils.removeInitialSlash((String)blogCategoryName));
            BlogEntry entry = this._fetcher.newBlogEntry();
            entry.setTitle(blogEntryTitle);
            entry.setCategory(blogCategoryName);
            entry.setDescription(blogEntryDescription);
            entry.setBlogCategory(category);
            HashMap<String, String> entryMetaData = new HashMap<String, String>();
            username = (String)httpServletRequest.getSession().getAttribute(user.getBlog().getBlogAdminURL() + "_" + "org.blojsom.plugin.admin.Username");
            entryMetaData.put("blog-entry-author", username);
            String entryPublishDateTime = httpServletRequest.getParameter(BLOG_ENTRY_PUBLISH_DATETIME);
            if (!BlojsomUtils.checkNullOrBlank((String)entryPublishDateTime)) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                try {
                    Date publishDateTime = simpleDateFormat.parse(entryPublishDateTime);
                    this._logger.debug((Object)("Publishing blog entry at: " + publishDateTime.toString()));
                    entryMetaData.put("blog-entry-metadata-timestamp", Long.toString(publishDateTime.getTime()));
                }
                catch (ParseException e) {
                    this._logger.error((Object)e);
                    entryMetaData.put("blog-entry-metadata-timestamp", Long.toString(new Date().getTime()));
                }
            } else {
                entryMetaData.put("blog-entry-metadata-timestamp", Long.toString(new Date().getTime()));
            }
            if (!BlojsomUtils.checkNullOrBlank((String)allowComments)) {
                entryMetaData.put("blog-entry-comments-disabled", "y");
            }
            if (!BlojsomUtils.checkNullOrBlank((String)allowTrackbacks)) {
                entryMetaData.put("blog-entry-trackbacks-disabled", "y");
            }
            if (BlojsomUtils.checkNullOrBlank((String)pingBlogURLS)) {
                entryMetaData.put("no-ping-weblogs", "true");
            }
            if (!BlojsomUtils.checkNullOrBlank((String)sendPingbacks)) {
                entryMetaData.put("send-pingbacks", "true");
            }
            entry.setMetaData(entryMetaData);
            try {
                this._blojsomConfiguration.getEventBroadcaster().processEvent((BlojsomEvent)new ProcessBlogEntryEvent(this, new Date(), entry, user, httpServletRequest, httpServletResponse, context));
                entry.save(user);
                entry.load(user);
                StringBuffer entryLink = new StringBuffer();
                entry.setLink(user.getBlog().getBlogURL() + BlojsomUtils.removeInitialSlash((String)entry.getCategory()) + "?" + "permalink" + "=" + entry.getPermalink());
                entryLink.append("<a href=\"").append(entry.getLink()).append("\">").append(entry.getTitle()).append("</a>");
                this.addOperationResultMessage(context, this.formatAdminResource(ADDED_BLOG_ENTRY_KEY, ADDED_BLOG_ENTRY_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{entryLink.toString()}));
                AddBlogEntryEvent addEvent = new AddBlogEntryEvent(this, new Date(), entry, user);
                this._blojsomConfiguration.getEventBroadcaster().broadcastEvent((BlojsomEvent)addEvent);
            }
            catch (BlojsomException e) {
                this._logger.error((Object)e);
                this.addOperationResultMessage(context, this.formatAdminResource(FAILED_ADD_BLOG_ENTRY_KEY, FAILED_ADD_BLOG_ENTRY_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogCategoryName}));
            }
            if (!BlojsomUtils.checkNullOrBlank((String)blogTrackbackURLs)) {
                this.sendTrackbackPings(blog, entry, blogTrackbackURLs);
            }
            httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_ENTRY_ACTION);
            context.put(BLOJSOM_PLUGIN_EDIT_BLOG_ENTRIES_ENTRY, entry);
            context.put(BLOJSOM_PLUGIN_EDIT_BLOG_ENTRIES_CATEGORY, blogCategoryName);
        } else if (DELETE_BLOG_COMMENTS.equals(action)) {
            this._logger.debug((Object)"User requested delete blog comments action");
            String blogCategoryName = BlojsomUtils.getRequestValue((String)BLOG_CATEGORY_NAME, (HttpServletRequest)httpServletRequest);
            blogCategoryName = BlojsomUtils.normalize((String)blogCategoryName);
            String blogEntryId = BlojsomUtils.getRequestValue((String)BLOG_ENTRY_ID, (HttpServletRequest)httpServletRequest);
            try {
                blogEntryId = URLDecoder.decode(blogEntryId, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this._logger.error((Object)e);
            }
            this._logger.debug((Object)("Blog entry id: " + blogEntryId));
            BlogCategory category = this._fetcher.newBlogCategory();
            category.setCategory(blogCategoryName);
            category.setCategoryURL(user.getBlog().getBlogURL() + BlojsomUtils.removeInitialSlash((String)blogCategoryName));
            HashMap<String, Object> fetchMap = new HashMap<String, Object>();
            fetchMap.put("FETCHER_CATEGORY", category);
            fetchMap.put("FETCHER_PERMALINK", blogEntryId);
            try {
                entries = this._fetcher.fetchEntries(fetchMap, user);
                if (entries != null) {
                    this._logger.debug((Object)("Retrieved " + entries.length + " entries from category: " + blogCategoryName));
                    BlogEntry entryToUpdate = entries[0];
                    String[] blogCommentIDs = httpServletRequest.getParameterValues(BLOG_COMMENT_ID);
                    if (blogCommentIDs != null && blogCommentIDs.length > 0) {
                        for (int i = 0; i < blogCommentIDs.length; ++i) {
                            String blogCommentID = blogCommentIDs[i];
                            BlogComment[] blogComments = entryToUpdate.getCommentsAsArray();
                            for (int j = 0; j < blogComments.length; ++j) {
                                BlogComment blogComment = blogComments[j];
                                if (!blogComment.getId().equals(blogCommentID)) continue;
                                try {
                                    blogComment.delete(user);
                                    this._blojsomConfiguration.getEventBroadcaster().broadcastEvent((BlojsomEvent)new CommentDeletedEvent((Object)this, new Date(), blogComment, user));
                                    continue;
                                }
                                catch (BlojsomException e) {
                                    this._logger.error((Object)e);
                                }
                            }
                        }
                        this.addOperationResultMessage(context, this.formatAdminResource(DELETED_COMMENTS_KEY, DELETED_COMMENTS_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{new Integer(blogCommentIDs.length)}));
                        entries = this._fetcher.fetchEntries(fetchMap, user);
                        entryToUpdate = entries[0];
                    }
                    context.put(BLOJSOM_PLUGIN_EDIT_BLOG_ENTRIES_ENTRY, entryToUpdate);
                    context.put(BLOJSOM_PLUGIN_EDIT_BLOG_ENTRIES_CATEGORY, blogCategoryName);
                }
            }
            catch (BlojsomFetcherException e) {
                this._logger.error((Object)e);
            }
            httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_ENTRY_PAGE);
        } else if (APPROVE_BLOG_COMMENTS.equals(action)) {
            this._logger.debug((Object)"User requested approve blog comments action");
            String blogCategoryName = BlojsomUtils.getRequestValue((String)BLOG_CATEGORY_NAME, (HttpServletRequest)httpServletRequest);
            blogCategoryName = BlojsomUtils.normalize((String)blogCategoryName);
            String blogEntryId = BlojsomUtils.getRequestValue((String)BLOG_ENTRY_ID, (HttpServletRequest)httpServletRequest);
            try {
                blogEntryId = URLDecoder.decode(blogEntryId, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this._logger.error((Object)e);
            }
            this._logger.debug((Object)("Blog entry id: " + blogEntryId));
            BlogCategory category = this._fetcher.newBlogCategory();
            category.setCategory(blogCategoryName);
            category.setCategoryURL(user.getBlog().getBlogURL() + BlojsomUtils.removeInitialSlash((String)blogCategoryName));
            HashMap<String, Object> fetchMap = new HashMap<String, Object>();
            fetchMap.put("FETCHER_CATEGORY", category);
            fetchMap.put("FETCHER_PERMALINK", blogEntryId);
            try {
                entries = this._fetcher.fetchEntries(fetchMap, user);
                if (entries != null) {
                    this._logger.debug((Object)("Retrieved " + entries.length + " entries from category: " + blogCategoryName));
                    BlogEntry entryToUpdate = entries[0];
                    String[] blogCommentIDs = httpServletRequest.getParameterValues(BLOG_COMMENT_ID);
                    if (blogCommentIDs != null && blogCommentIDs.length > 0) {
                        for (int i = 0; i < blogCommentIDs.length; ++i) {
                            String blogCommentID = blogCommentIDs[i];
                            BlogComment[] blogComments = entryToUpdate.getCommentsAsArray();
                            for (int j = 0; j < blogComments.length; ++j) {
                                BlogComment blogComment = blogComments[j];
                                if (!blogComment.getId().equals(blogCommentID)) continue;
                                Map blogCommentMetaData = blogComment.getMetaData();
                                blogCommentMetaData.put("BLOJSOM_COMMENT_MODERATION_PLUGIN_APPROVED", "true");
                                try {
                                    blogComment.save(user);
                                    this._blojsomConfiguration.getEventBroadcaster().broadcastEvent((BlojsomEvent)new CommentApprovedEvent((Object)this, new Date(), blogComment, user));
                                    continue;
                                }
                                catch (BlojsomException e) {
                                    this._logger.error((Object)e);
                                }
                            }
                        }
                        this.addOperationResultMessage(context, this.formatAdminResource(APPROVED_COMMENTS_KEY, APPROVED_COMMENTS_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{new Integer(blogCommentIDs.length)}));
                        entries = this._fetcher.fetchEntries(fetchMap, user);
                        entryToUpdate = entries[0];
                    }
                    context.put(BLOJSOM_PLUGIN_EDIT_BLOG_ENTRIES_ENTRY, entryToUpdate);
                    context.put(BLOJSOM_PLUGIN_EDIT_BLOG_ENTRIES_CATEGORY, blogCategoryName);
                }
            }
            catch (BlojsomFetcherException e) {
                this._logger.error((Object)e);
            }
            httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_ENTRY_PAGE);
        } else if (DELETE_BLOG_TRACKBACKS.equals(action)) {
            this._logger.debug((Object)"User requested delete blog trackbacks action");
            String blogCategoryName = BlojsomUtils.getRequestValue((String)BLOG_CATEGORY_NAME, (HttpServletRequest)httpServletRequest);
            blogCategoryName = BlojsomUtils.normalize((String)blogCategoryName);
            String blogEntryId = BlojsomUtils.getRequestValue((String)BLOG_ENTRY_ID, (HttpServletRequest)httpServletRequest);
            try {
                blogEntryId = URLDecoder.decode(blogEntryId, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this._logger.error((Object)e);
            }
            this._logger.debug((Object)("Blog entry id: " + blogEntryId));
            BlogCategory category = this._fetcher.newBlogCategory();
            category.setCategory(blogCategoryName);
            category.setCategoryURL(user.getBlog().getBlogURL() + BlojsomUtils.removeInitialSlash((String)blogCategoryName));
            HashMap<String, Object> fetchMap = new HashMap<String, Object>();
            fetchMap.put("FETCHER_CATEGORY", category);
            fetchMap.put("FETCHER_PERMALINK", blogEntryId);
            try {
                entries = this._fetcher.fetchEntries(fetchMap, user);
                if (entries != null) {
                    this._logger.debug((Object)("Retrieved " + entries.length + " entries from category: " + blogCategoryName));
                    BlogEntry entryToUpdate = entries[0];
                    String[] blogTrackbackIDs = httpServletRequest.getParameterValues(BLOG_TRACKBACK_ID);
                    if (blogTrackbackIDs != null && blogTrackbackIDs.length > 0) {
                        for (int i = 0; i < blogTrackbackIDs.length; ++i) {
                            String blogTrackbackID = blogTrackbackIDs[i];
                            Trackback[] trackbacks = entryToUpdate.getTrackbacksAsArray();
                            for (int j = 0; j < trackbacks.length; ++j) {
                                Trackback trackback = trackbacks[j];
                                if (!trackback.getId().equals(blogTrackbackID)) continue;
                                try {
                                    trackback.delete(user);
                                    this._blojsomConfiguration.getEventBroadcaster().broadcastEvent((BlojsomEvent)new TrackbackDeletedEvent((Object)this, new Date(), trackback, user));
                                    continue;
                                }
                                catch (BlojsomException e) {
                                    this._logger.error((Object)e);
                                }
                            }
                        }
                        this.addOperationResultMessage(context, this.formatAdminResource(DELETED_TRACKBACKS_KEY, DELETED_TRACKBACKS_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{new Integer(blogTrackbackIDs.length)}));
                        entries = this._fetcher.fetchEntries(fetchMap, user);
                        entryToUpdate = entries[0];
                    }
                    context.put(BLOJSOM_PLUGIN_EDIT_BLOG_ENTRIES_ENTRY, entryToUpdate);
                    context.put(BLOJSOM_PLUGIN_EDIT_BLOG_ENTRIES_CATEGORY, blogCategoryName);
                }
            }
            catch (BlojsomFetcherException e) {
                this._logger.error((Object)e);
            }
            httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_ENTRY_PAGE);
        } else if (APPROVE_BLOG_TRACKBACKS.equals(action)) {
            this._logger.debug((Object)"User requested approve blog trackbacks action");
            String blogCategoryName = BlojsomUtils.getRequestValue((String)BLOG_CATEGORY_NAME, (HttpServletRequest)httpServletRequest);
            blogCategoryName = BlojsomUtils.normalize((String)blogCategoryName);
            String blogEntryId = BlojsomUtils.getRequestValue((String)BLOG_ENTRY_ID, (HttpServletRequest)httpServletRequest);
            try {
                blogEntryId = URLDecoder.decode(blogEntryId, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this._logger.error((Object)e);
            }
            this._logger.debug((Object)("Blog entry id: " + blogEntryId));
            BlogCategory category = this._fetcher.newBlogCategory();
            category.setCategory(blogCategoryName);
            category.setCategoryURL(user.getBlog().getBlogURL() + BlojsomUtils.removeInitialSlash((String)blogCategoryName));
            HashMap<String, Object> fetchMap = new HashMap<String, Object>();
            fetchMap.put("FETCHER_CATEGORY", category);
            fetchMap.put("FETCHER_PERMALINK", blogEntryId);
            try {
                entries = this._fetcher.fetchEntries(fetchMap, user);
                if (entries != null) {
                    this._logger.debug((Object)("Retrieved " + entries.length + " entries from category: " + blogCategoryName));
                    BlogEntry entryToUpdate = entries[0];
                    String[] blogTrackbackIDs = httpServletRequest.getParameterValues(BLOG_TRACKBACK_ID);
                    if (blogTrackbackIDs != null && blogTrackbackIDs.length > 0) {
                        for (int i = 0; i < blogTrackbackIDs.length; ++i) {
                            String blogTrackbackID = blogTrackbackIDs[i];
                            Trackback[] trackbacks = entryToUpdate.getTrackbacksAsArray();
                            for (int j = 0; j < trackbacks.length; ++j) {
                                Trackback trackback = trackbacks[j];
                                if (!trackback.getId().equals(blogTrackbackID)) continue;
                                Map blogTrackbackMetaData = trackback.getMetaData();
                                blogTrackbackMetaData.put("BLOJSOM_TRACKBACK_MODERATION_PLUGIN_APPROVED", "true");
                                try {
                                    trackback.save(user);
                                    this._blojsomConfiguration.getEventBroadcaster().broadcastEvent((BlojsomEvent)new TrackbackApprovedEvent((Object)this, new Date(), trackback, user));
                                    continue;
                                }
                                catch (BlojsomException e) {
                                    this._logger.error((Object)e);
                                }
                            }
                        }
                        this.addOperationResultMessage(context, this.formatAdminResource(APPROVED_TRACKBACKS_KEY, APPROVED_TRACKBACKS_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{new Integer(blogTrackbackIDs.length)}));
                        entries = this._fetcher.fetchEntries(fetchMap, user);
                        entryToUpdate = entries[0];
                    }
                    context.put(BLOJSOM_PLUGIN_EDIT_BLOG_ENTRIES_ENTRY, entryToUpdate);
                    context.put(BLOJSOM_PLUGIN_EDIT_BLOG_ENTRIES_CATEGORY, blogCategoryName);
                }
            }
            catch (BlojsomFetcherException e) {
                this._logger.error((Object)e);
            }
            httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_ENTRY_PAGE);
        }
        return entries;
    }

    protected void sendTrackbackPings(Blog blog, BlogEntry entry, String blogTrackbackURLs) {
        StringBuffer trackbackPingURLParameters = new StringBuffer();
        try {
            trackbackPingURLParameters.append("&").append("url").append("=").append(entry.getLink());
            trackbackPingURLParameters.append("&").append("title").append("=").append(URLEncoder.encode(entry.getTitle(), "UTF-8"));
            trackbackPingURLParameters.append("&").append("blog_name").append("=").append(URLEncoder.encode(blog.getBlogName(), "UTF-8"));
            String excerpt = entry.getDescription().replaceAll("<.*?>", "");
            if (excerpt.length() > 255) {
                excerpt = excerpt.substring(0, 251);
                excerpt = excerpt + "...";
            }
            trackbackPingURLParameters.append("&").append("excerpt").append("=").append(URLEncoder.encode(excerpt, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            this._logger.error((Object)e);
        }
        String[] trackbackURLs = BlojsomUtils.parseDelimitedList((String)blogTrackbackURLs, (String)" \t\n\f\r");
        if (trackbackURLs != null && trackbackURLs.length > 0) {
            for (int i = 0; i < trackbackURLs.length; ++i) {
                String trackbackURL = trackbackURLs[i].trim();
                StringBuffer trackbackPingURL = new StringBuffer(trackbackURL);
                this._logger.debug((Object)("Automatically sending trackback ping to URL: " + trackbackPingURL.toString()));
                try {
                    String line;
                    URL trackbackUrl = new URL(trackbackPingURL.toString());
                    HttpURLConnection trackbackUrlConnection = (HttpURLConnection)trackbackUrl.openConnection();
                    trackbackUrlConnection.setRequestMethod("POST");
                    trackbackUrlConnection.setRequestProperty("Content-Encoding", "UTF-8");
                    trackbackUrlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    trackbackUrlConnection.setRequestProperty("Content-Length", "" + trackbackPingURLParameters.length());
                    trackbackUrlConnection.setDoOutput(true);
                    trackbackUrlConnection.getOutputStream().write(trackbackPingURLParameters.toString().getBytes("UTF-8"));
                    trackbackUrlConnection.connect();
                    BufferedReader trackbackStatus = new BufferedReader(new InputStreamReader(trackbackUrlConnection.getInputStream()));
                    StringBuffer status = new StringBuffer();
                    while ((line = trackbackStatus.readLine()) != null) {
                        status.append(line).append("\n");
                    }
                    trackbackUrlConnection.disconnect();
                    this._logger.debug((Object)("Trackback status for ping to " + trackbackURL + ": " + status.toString()));
                    continue;
                }
                catch (IOException e) {
                    this._logger.error((Object)e);
                }
            }
        }
    }
}

