/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.admin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.event.BlojsomEvent;
import org.blojsom.event.BlojsomListener;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.admin.BaseAdminPlugin;
import org.blojsom.plugin.admin.event.AddAuthorizationEvent;
import org.blojsom.plugin.admin.event.AuthorizationEvent;
import org.blojsom.plugin.admin.event.DeleteAuthorizationEvent;
import org.blojsom.util.BlojsomProperties;
import org.blojsom.util.BlojsomUtils;

public class EditBlogPermissionsPlugin
extends BaseAdminPlugin
implements BlojsomListener {
    private Log _logger = LogFactory.getLog((Class)EditBlogPermissionsPlugin.class);
    private static final String EDIT_BLOG_PERMISSIONS_PAGE = "/org/blojsom/plugin/admin/templates/admin-edit-blog-permissions";
    private static final String BLOJSOM_PLUGIN_EDIT_BLOG_PERMISSIONS_USER_MAP = "BLOJSOM_PLUGIN_EDIT_BLOG_PERMISSIONS_USER_MAP";
    private static final String BLOJSOM_PLUGIN_EDIT_BLOG_PERMISSIONS_MAP = "BLOJSOM_PLUGIN_EDIT_BLOG_PERMISSIONS_MAP";
    private static final String FAILED_PERMISSIONS_READ_KEY = "failed.read.permissions.text";
    private static final String FAILED_EDIT_PERMISSIONS_KEY = "failed.edit.permissions.text";
    private static final String PERMISSIONS_SAVED_KEY = "permissions.saved.text";
    private static final String ERROR_SAVING_PERMISSIONS_KEY = "error.saving.permissions.text";
    private static final String NO_PERMISSION_SPECIFIED_KEY = "no.permission.specified.text";
    private static final String NO_BLOG_USER_ID_PERMISSION_SPECIFIED_KEY = "no.blog.user.id.specified.permission.text";
    private static final String PERMISSION_DELETED_KEY = "permission.deleted.text";
    private static final String ADD_BLOG_PERMISSION_ACTION = "add-blog-permission";
    private static final String DELETE_BLOG_PERMISSION_ACTION = "delete-blog-permission";
    private static final String BLOG_USER_ID = "blog-user-id";
    private static final String BLOG_PERMISSION = "blog-permission";
    private static final String BLOG_PERMISSIONS = "blog-permissions";
    private static final String EDIT_BLOG_PERMISSIONS_PERMISSION = "edit_blog_permissions";
    private String _permissionConfiguration;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        super.init(servletConfig, blojsomConfiguration);
        this._permissionConfiguration = servletConfig.getInitParameter(BLOG_PERMISSIONS);
        if (BlojsomUtils.checkNullOrBlank((String)this._permissionConfiguration)) {
            this._logger.error((Object)"No permissions configuration file specified. Using default: permissions.properties");
            this._permissionConfiguration = "permissions.properties";
        }
        this._blojsomConfiguration.getEventBroadcaster().addListener((BlojsomListener)this);
    }

    private Properties readPermissionsConfiguration(String blogID) throws IOException {
        File permissionsFile = new File(this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getBaseConfigurationDirectory() + blogID + "/" + this._permissionConfiguration);
        BlojsomProperties permissionsProperties = new BlojsomProperties(true);
        FileInputStream fis = new FileInputStream(permissionsFile);
        permissionsProperties.load(fis);
        fis.close();
        return permissionsProperties;
    }

    private void writePermissionsConfiguration(String blogID, Properties permissions) throws IOException {
        File permissionsFile = new File(this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getBaseConfigurationDirectory() + blogID + "/" + this._permissionConfiguration);
        FileOutputStream fos = new FileOutputStream(permissionsFile);
        permissions.store(fos, null);
        fos.close();
    }

    private Map readPermissionsForBlog(Map context, BlogUser blog) {
        TreeMap permissions = new TreeMap();
        try {
            Properties permissionsProperties = this.readPermissionsConfiguration(blog.getId());
            permissions = new TreeMap(BlojsomUtils.blojsomPropertiesToMap((Properties)permissionsProperties));
        }
        catch (IOException e) {
            this._logger.error((Object)e);
            this.addOperationResultMessage(context, this.formatAdminResource(FAILED_PERMISSIONS_READ_KEY, FAILED_PERMISSIONS_READ_KEY, blog.getBlog().getBlogAdministrationLocale(), new Object[]{blog.getId()}));
        }
        return permissions;
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        String blogUserID;
        if (!this.authenticateUser(httpServletRequest, httpServletResponse, context, user)) {
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin-login");
            return entries;
        }
        String username = this.getUsernameFromSession(httpServletRequest, user.getBlog());
        if (!this.checkPermission(user, null, username, EDIT_BLOG_PERMISSIONS_PERMISSION)) {
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin");
            this.addOperationResultMessage(context, this.getAdminResource(FAILED_EDIT_PERMISSIONS_KEY, FAILED_EDIT_PERMISSIONS_KEY, user.getBlog().getBlogAdministrationLocale()));
            return entries;
        }
        Map permissions = this.readPermissionsForBlog(context, user);
        Map authorizedUsers = user.getBlog().getAuthorization();
        Iterator users = permissions.keySet().iterator();
        ArrayList<String> usersToRemove = new ArrayList<String>();
        while (users.hasNext()) {
            String userID = (String)users.next();
            if (authorizedUsers.containsKey(userID)) continue;
            usersToRemove.add(userID);
        }
        for (int i = 0; i < usersToRemove.size(); ++i) {
            String userID = (String)usersToRemove.get(i);
            permissions.remove(userID);
        }
        String action = BlojsomUtils.getRequestValue((String)"action", (HttpServletRequest)httpServletRequest);
        if (BlojsomUtils.checkNullOrBlank((String)action)) {
            this._logger.debug((Object)"User did not request edit permission action");
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin");
        } else if ("page".equals(action)) {
            this._logger.debug((Object)"User requested edit blog permissions page");
        } else if (ADD_BLOG_PERMISSION_ACTION.equals(action)) {
            this._logger.debug((Object)"User requested add permission action");
            blogUserID = BlojsomUtils.getRequestValue((String)BLOG_USER_ID, (HttpServletRequest)httpServletRequest);
            if (!BlojsomUtils.checkNullOrBlank((String)blogUserID)) {
                String permissionToAdd = BlojsomUtils.getRequestValue((String)BLOG_PERMISSION, (HttpServletRequest)httpServletRequest);
                if (!BlojsomUtils.checkNullOrBlank((String)permissionToAdd)) {
                    List<String> permissionList;
                    Properties updatedPermissions = BlojsomUtils.mapToBlojsomProperties((Map)permissions);
                    if (updatedPermissions.containsKey(blogUserID)) {
                        permissionList = (List)updatedPermissions.get(blogUserID);
                        if (!permissionList.contains(permissionToAdd)) {
                            permissionList.add(permissionToAdd);
                        }
                    } else {
                        permissionList = new ArrayList();
                        permissionList.add(permissionToAdd);
                        updatedPermissions.put(blogUserID, permissionList);
                    }
                    try {
                        this.writePermissionsConfiguration(user.getId(), updatedPermissions);
                        permissions = this.readPermissionsForBlog(context, user);
                        this.addOperationResultMessage(context, this.getAdminResource(PERMISSIONS_SAVED_KEY, PERMISSIONS_SAVED_KEY, user.getBlog().getBlogAdministrationLocale()));
                    }
                    catch (IOException e) {
                        this._logger.error((Object)e);
                        this.addOperationResultMessage(context, this.getAdminResource(ERROR_SAVING_PERMISSIONS_KEY, ERROR_SAVING_PERMISSIONS_KEY, user.getBlog().getBlogAdministrationLocale()));
                    }
                } else {
                    this.addOperationResultMessage(context, this.getAdminResource(NO_PERMISSION_SPECIFIED_KEY, NO_PERMISSION_SPECIFIED_KEY, user.getBlog().getBlogAdministrationLocale()));
                }
            } else {
                this.addOperationResultMessage(context, this.getAdminResource(NO_BLOG_USER_ID_PERMISSION_SPECIFIED_KEY, NO_BLOG_USER_ID_PERMISSION_SPECIFIED_KEY, user.getBlog().getBlogAdministrationLocale()));
                this._logger.debug((Object)"No blog user id specified");
            }
        } else if (DELETE_BLOG_PERMISSION_ACTION.equals(action)) {
            this._logger.debug((Object)"User requested delete permission action");
            blogUserID = BlojsomUtils.getRequestValue((String)BLOG_USER_ID, (HttpServletRequest)httpServletRequest);
            if (!BlojsomUtils.checkNullOrBlank((String)blogUserID)) {
                String permissionToDelete = BlojsomUtils.getRequestValue((String)BLOG_PERMISSION, (HttpServletRequest)httpServletRequest);
                if (!BlojsomUtils.checkNullOrBlank((String)permissionToDelete)) {
                    List permissionList;
                    Properties updatedPermissions = BlojsomUtils.mapToBlojsomProperties((Map)permissions);
                    if (updatedPermissions.containsKey(blogUserID) && (permissionList = (List)updatedPermissions.get(blogUserID)).contains(permissionToDelete)) {
                        permissionList.remove(permissionToDelete);
                    }
                    try {
                        this.writePermissionsConfiguration(user.getId(), updatedPermissions);
                        permissions = this.readPermissionsForBlog(context, user);
                        this.addOperationResultMessage(context, this.getAdminResource(PERMISSION_DELETED_KEY, PERMISSION_DELETED_KEY, user.getBlog().getBlogAdministrationLocale()));
                    }
                    catch (IOException e) {
                        this._logger.error((Object)e);
                        this.addOperationResultMessage(context, this.getAdminResource(ERROR_SAVING_PERMISSIONS_KEY, ERROR_SAVING_PERMISSIONS_KEY, user.getBlog().getBlogAdministrationLocale()));
                    }
                } else {
                    this.addOperationResultMessage(context, this.getAdminResource(NO_PERMISSION_SPECIFIED_KEY, NO_PERMISSION_SPECIFIED_KEY, user.getBlog().getBlogAdministrationLocale()));
                }
            } else {
                this.addOperationResultMessage(context, this.getAdminResource(NO_BLOG_USER_ID_PERMISSION_SPECIFIED_KEY, NO_BLOG_USER_ID_PERMISSION_SPECIFIED_KEY, user.getBlog().getBlogAdministrationLocale()));
                this._logger.debug((Object)"No blog user ID to delete from permissions");
            }
        }
        context.put(BLOJSOM_PLUGIN_EDIT_BLOG_PERMISSIONS_USER_MAP, Collections.unmodifiableMap(new TreeMap(user.getBlog().getAuthorization())));
        context.put(BLOJSOM_PLUGIN_EDIT_BLOG_PERMISSIONS_MAP, Collections.unmodifiableMap(permissions));
        httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_PERMISSIONS_PAGE);
        return entries;
    }

    public void handleEvent(BlojsomEvent event) {
    }

    public void processEvent(BlojsomEvent event) {
        if (event instanceof AuthorizationEvent && "org.blojsom.plugin.admin.EditBlogAuthorizationPlugin".equals(event.getSource().getClass().getName())) {
            if (event instanceof AddAuthorizationEvent) {
                AddAuthorizationEvent addEvent = (AddAuthorizationEvent)event;
                Map permissionsForBlog = this.readPermissionsForBlog(addEvent.getContext(), addEvent.getBlogUser());
                Properties updatedPermissions = BlojsomUtils.mapToBlojsomProperties((Map)permissionsForBlog);
                String permissions = BlojsomUtils.getRequestValue((String)BLOG_PERMISSIONS, (HttpServletRequest)addEvent.getHttpServletRequest());
                String[] parsedPermissions = BlojsomUtils.parseCommaList((String)permissions);
                if (!BlojsomUtils.checkNullOrBlank((String)permissions)) {
                    if (updatedPermissions.containsKey(addEvent.getBlogUserID())) {
                        List permissionList = (List)updatedPermissions.get(addEvent.getBlogUserID());
                        for (int i = 0; i < parsedPermissions.length; ++i) {
                            String parsedPermission = parsedPermissions[i];
                            if (permissionList.contains(parsedPermission)) continue;
                            permissionList.add(parsedPermission);
                        }
                    } else {
                        ArrayList<String> permissionList = new ArrayList<String>();
                        for (int i = 0; i < parsedPermissions.length; ++i) {
                            String parsedPermission = parsedPermissions[i];
                            permissionList.add(parsedPermission);
                        }
                        updatedPermissions.put(addEvent.getBlogUserID(), permissionList);
                        try {
                            this.writePermissionsConfiguration(addEvent.getBlogUser().getId(), updatedPermissions);
                            this._logger.debug((Object)("Added permissions for " + addEvent.getBlogUserID() + " based on add authorization event"));
                        }
                        catch (IOException e) {
                            this._logger.error((Object)e);
                            this.addOperationResultMessage(addEvent.getContext(), this.getAdminResource(ERROR_SAVING_PERMISSIONS_KEY, ERROR_SAVING_PERMISSIONS_KEY, addEvent.getBlogUser().getBlog().getBlogAdministrationLocale()));
                        }
                    }
                } else {
                    this._logger.debug((Object)"No permissions to act on for add authorization event");
                }
            } else if (event instanceof DeleteAuthorizationEvent) {
                DeleteAuthorizationEvent deleteEvent = (DeleteAuthorizationEvent)event;
                Map permissionsForBlog = this.readPermissionsForBlog(deleteEvent.getContext(), deleteEvent.getBlogUser());
                Properties updatedPermissions = BlojsomUtils.mapToBlojsomProperties((Map)permissionsForBlog);
                if (updatedPermissions.containsKey(deleteEvent.getBlogUserID())) {
                    updatedPermissions.remove(deleteEvent.getBlogUserID());
                    try {
                        this.writePermissionsConfiguration(deleteEvent.getBlogUser().getId(), updatedPermissions);
                        this._logger.debug((Object)("Deleted permissions for " + deleteEvent.getBlogUserID() + " based on delete authorization event"));
                    }
                    catch (IOException e) {
                        this._logger.error((Object)e);
                        this.addOperationResultMessage(deleteEvent.getContext(), this.getAdminResource(ERROR_SAVING_PERMISSIONS_KEY, ERROR_SAVING_PERMISSIONS_KEY, deleteEvent.getBlogUser().getBlog().getBlogAdministrationLocale()));
                    }
                } else {
                    this._logger.debug((Object)"No permissions to act on for delete authorization event");
                }
            }
            event.setEventHandled(true);
        }
    }
}

