/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.admin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.BlojsomException;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.admin.BaseAdminPlugin;
import org.blojsom.util.BlojsomUtils;

public class EditBlogPluginsPlugin
extends BaseAdminPlugin {
    private Log _logger = LogFactory.getLog((Class)EditBlogPluginsPlugin.class);
    private static final String EDIT_BLOG_PLUGINS_PAGE = "/org/blojsom/plugin/admin/templates/admin-edit-blog-plugins";
    private static final String BLOJSOM_PLUGIN_EDIT_BLOG_PLUGINS_MAP = "BLOJSOM_PLUGIN_EDIT_BLOG_PLUGINS_MAP";
    private static final String BLOJSOM_PLUGIN_EDIT_BLOG_PLUGINS_AVAILABLE_PLUGINS = "BLOJSOM_PLUGIN_EDIT_BLOG_PLUGINS_AVAILABLE_PLUGINS";
    private static final String FAILED_EDIT_PLUGINS_PERMISSION_KEY = "failed.edit.plugins.permission.text";
    private static final String SUCCESSFULLY_UPDATED_PLUGINS_KEY = "successfully.updated.plugins.text";
    private static final String FAILED_UPDATE_PLUGINS_KEY = "failed.updated.plugins.text";
    private static final String MODIFY_PLUGIN_CHAINS = "modify-plugin-chains";
    private static final String EDIT_BLOG_PLUGINS_PERMISSION = "edit_blog_plugins";
    private String _pluginConfiguration;
    private Map _plugins;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        super.init(servletConfig, blojsomConfiguration);
        this._pluginConfiguration = servletConfig.getInitParameter("plugin-configuration");
        try {
            Properties pluginProperties = BlojsomUtils.loadProperties((ServletConfig)servletConfig, (String)(this._blojsomConfiguration.getBaseConfigurationDirectory() + this._pluginConfiguration));
            this._plugins = BlojsomUtils.propertiesToMap((Properties)pluginProperties);
            Map plugins = BlojsomUtils.propertiesToMap((Properties)pluginProperties);
            Iterator pluginsIterator = plugins.keySet().iterator();
            while (pluginsIterator.hasNext()) {
                String pluginName = (String)pluginsIterator.next();
                if (pluginName.indexOf("blojsom-plugin-chain") != -1) {
                    this._plugins.remove(pluginName);
                }
                if (((String)plugins.get(pluginName)).indexOf("admin") == -1) continue;
                this._plugins.remove(pluginName);
            }
        }
        catch (BlojsomException e) {
            this._logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
        this._plugins = new TreeMap(this._plugins);
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        if (!this.authenticateUser(httpServletRequest, httpServletResponse, context, user)) {
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin-login");
            return entries;
        }
        String username = this.getUsernameFromSession(httpServletRequest, user.getBlog());
        if (!this.checkPermission(user, null, username, EDIT_BLOG_PLUGINS_PERMISSION)) {
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin");
            this.addOperationResultMessage(context, this.getAdminResource(FAILED_EDIT_PLUGINS_PERMISSION_KEY, FAILED_EDIT_PLUGINS_PERMISSION_KEY, user.getBlog().getBlogAdministrationLocale()));
            return entries;
        }
        Iterator flavorIterator = user.getFlavors().keySet().iterator();
        Map userPluginChain = user.getPluginChain();
        TreeMap<String, String> updatedPluginChain = new TreeMap<String, String>();
        while (flavorIterator.hasNext()) {
            String flavor = (String)flavorIterator.next();
            if (userPluginChain.containsKey(flavor + "." + "blojsom-plugin-chain")) {
                updatedPluginChain.put(flavor, BlojsomUtils.arrayOfStringsToString((String[])((String[])userPluginChain.get(flavor + "." + "blojsom-plugin-chain"))));
                continue;
            }
            updatedPluginChain.put(flavor, "");
        }
        if (userPluginChain.containsKey("blojsom-plugin-chain")) {
            updatedPluginChain.put("", BlojsomUtils.arrayOfStringsToString((String[])((String[])userPluginChain.get("blojsom-plugin-chain"))));
        }
        context.put(BLOJSOM_PLUGIN_EDIT_BLOG_PLUGINS_MAP, updatedPluginChain);
        context.put(BLOJSOM_PLUGIN_EDIT_BLOG_PLUGINS_AVAILABLE_PLUGINS, this._plugins);
        String action = BlojsomUtils.getRequestValue((String)"action", (HttpServletRequest)httpServletRequest);
        if (BlojsomUtils.checkNullOrBlank((String)action)) {
            this._logger.debug((Object)"User did not request edit action");
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin");
        } else if ("page".equals(action)) {
            this._logger.debug((Object)"User requested edit blog plugins page");
            httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_PLUGINS_PAGE);
        } else if (MODIFY_PLUGIN_CHAINS.equals(action)) {
            String[] updatedFlavorArray;
            String updatedFlavor;
            this._logger.debug((Object)"User requested modify blog plugins action");
            Map pluginChain = user.getPluginChain();
            HashMap<String, String> pluginChainForWriting = new HashMap<String, String>();
            HashMap<String, String> pluginChainForContext = new HashMap<String, String>();
            flavorIterator = user.getFlavors().keySet().iterator();
            while (flavorIterator.hasNext()) {
                String flavor = (String)flavorIterator.next();
                updatedFlavor = BlojsomUtils.getRequestValue((String)(flavor + "." + "blojsom-plugin-chain"), (HttpServletRequest)httpServletRequest);
                updatedFlavorArray = BlojsomUtils.parseCommaList((String)updatedFlavor);
                pluginChain.put(flavor + "." + "blojsom-plugin-chain", updatedFlavorArray);
                pluginChainForWriting.put(flavor + "." + "blojsom-plugin-chain", updatedFlavor);
                pluginChainForContext.put(flavor, updatedFlavor);
            }
            updatedFlavor = BlojsomUtils.getRequestValue((String)".blojsom-plugin-chain", (HttpServletRequest)httpServletRequest);
            updatedFlavorArray = BlojsomUtils.parseCommaList((String)updatedFlavor);
            pluginChain.put("blojsom-plugin-chain", updatedFlavorArray);
            pluginChainForWriting.put("blojsom-plugin-chain", updatedFlavor);
            pluginChainForContext.put("", updatedFlavor);
            user.setPluginChain(pluginChain);
            try {
                this.writePluginsConfiguration(user.getId(), pluginChainForWriting);
                this.addOperationResultMessage(context, this.getAdminResource(SUCCESSFULLY_UPDATED_PLUGINS_KEY, SUCCESSFULLY_UPDATED_PLUGINS_KEY, user.getBlog().getBlogAdministrationLocale()));
            }
            catch (IOException e) {
                this._logger.error((Object)e);
                this.addOperationResultMessage(context, this.getAdminResource(FAILED_UPDATE_PLUGINS_KEY, FAILED_UPDATE_PLUGINS_KEY, user.getBlog().getBlogAdministrationLocale()));
            }
            context.put(BLOJSOM_PLUGIN_EDIT_BLOG_PLUGINS_MAP, new TreeMap(pluginChainForContext));
            httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_PLUGINS_PAGE);
        }
        return entries;
    }

    private void writePluginsConfiguration(String userId, Map pluginChain) throws IOException {
        File pluginFile = new File(this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getBaseConfigurationDirectory() + userId + "/" + this._pluginConfiguration);
        FileOutputStream fos = new FileOutputStream(pluginFile);
        Properties pluginChainProperties = BlojsomUtils.mapToProperties((Map)pluginChain);
        pluginChainProperties.store(fos, null);
        fos.close();
    }
}

