/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.admin;

import java.io.File;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.BlojsomException;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.admin.BaseAdminPlugin;
import org.blojsom.util.BlojsomUtils;

public class FileUploadPlugin
extends BaseAdminPlugin {
    private Log _logger = LogFactory.getLog((Class)FileUploadPlugin.class);
    private static final String FAILED_PERMISSION_KEY = "file.upload.failed.permission.text";
    private static final String FAILED_RESOURCE_KEY = "file.upload.failed.resource.text";
    private static final String UNKNOWN_ERROR_KEY = "file.upload.unknown.error.text";
    private static final String SUCCESSFUL_UPLOAD_KEY = "successful.upload.text";
    private static final String INVALID_EXTENSION_KEY = "invalid.upload.extension.text";
    private static final String INVALID_TYPE_KEY = "invalid.upload.type.text";
    private static final String DELETED_FILES_KEY = "deleted.files.text";
    private static final String UPLOAD_LIMIT_KEY = "upload.limit.exceeded.text";
    private static final String PLUGIN_ADMIN_UPLOAD_IP = "plugin-admin-upload";
    private static final String TEMPORARY_DIRECTORY_IP = "temporary-directory";
    private static final String DEFAULT_TEMPORARY_DIRECTORY = "/tmp";
    private static final String MAXIMUM_UPLOAD_SIZE_IP = "maximum-upload-size";
    private static final long DEFAULT_MAXIMUM_UPLOAD_SIZE = 100000L;
    private static final String MAXIMUM_MEMORY_SIZE_IP = "maximum-memory-size";
    private static final int DEFAULT_MAXIMUM_MEMORY_SIZE = 50000;
    private static final String ACCEPTED_FILE_TYPES_IP = "accepted-file-types";
    private static final String[] DEFAULT_ACCEPTED_FILE_TYPES = new String[]{"image/jpeg", "image/gif", "image/png"};
    private static final String DEFAULT_RESOURCES_DIRECTORY = "/resources/";
    private static final String INVALID_FILE_EXTENSIONS_IP = "invalid-file-extensions";
    private static final String[] DEFAULT_INVALID_FILE_EXTENSIONS = new String[]{".jsp", ".jspf", ".jspi", ".jspx", ".php", ".cgi"};
    private static final String UPLOAD_QUOTA_ENABLED_IP = "upload-quota-enabled";
    private static final String UPLOAD_QUOTA_LIMIT_IP = "upload-quota-limit";
    private static final long DEFAULT_UPLOAD_QUOTA_LIMIT = 0xA00000L;
    private static final String FILE_UPLOAD_PAGE = "/org/blojsom/plugin/admin/templates/admin-file-upload";
    private static final String PLUGIN_ADMIN_FILE_UPLOAD_FILES = "PLUGIN_ADMIN_FILE_UPLOAD_FILES";
    private static final String UPLOAD_FILE_ACTION = "upload-file";
    private static final String DELETE_UPLOAD_FILES = "delete-upload-files";
    private static final String FILE_TO_DELETE = "file-to-delete";
    private static final String FILE_UPLOAD_PERMISSION = "file_upload";
    private String _temporaryDirectory;
    private long _maximumUploadSize;
    private int _maximumMemorySize;
    private Map _acceptedFileTypes;
    private String _resourcesDirectory;
    private String[] _invalidFileExtensions;
    private boolean _uploadQuotaEnabled;
    private long _uploadQuotaLimit;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        block14: {
            super.init(servletConfig, blojsomConfiguration);
            try {
                Properties configurationProperties = BlojsomUtils.loadProperties((ServletConfig)servletConfig, (String)PLUGIN_ADMIN_UPLOAD_IP, (boolean)true);
                this._temporaryDirectory = configurationProperties.getProperty(TEMPORARY_DIRECTORY_IP);
                if (BlojsomUtils.checkNullOrBlank((String)this._temporaryDirectory)) {
                    this._temporaryDirectory = DEFAULT_TEMPORARY_DIRECTORY;
                }
                this._logger.debug((Object)("Using temporary directory: " + this._temporaryDirectory));
                try {
                    this._maximumUploadSize = Long.parseLong(configurationProperties.getProperty(MAXIMUM_UPLOAD_SIZE_IP));
                }
                catch (NumberFormatException e) {
                    this._maximumUploadSize = 100000L;
                }
                this._logger.debug((Object)("Using maximum upload size: " + this._maximumUploadSize));
                try {
                    this._maximumMemorySize = Integer.parseInt(configurationProperties.getProperty(MAXIMUM_MEMORY_SIZE_IP));
                }
                catch (NumberFormatException e) {
                    this._maximumMemorySize = 50000;
                }
                this._logger.debug((Object)("Using maximum memory size: " + this._maximumMemorySize));
                String acceptedFileTypes = configurationProperties.getProperty(ACCEPTED_FILE_TYPES_IP);
                String[] parsedListOfTypes = BlojsomUtils.checkNullOrBlank((String)acceptedFileTypes) ? DEFAULT_ACCEPTED_FILE_TYPES : BlojsomUtils.parseCommaList((String)acceptedFileTypes);
                this._acceptedFileTypes = new HashMap(parsedListOfTypes.length);
                for (int i = 0; i < parsedListOfTypes.length; ++i) {
                    String type = parsedListOfTypes[i];
                    this._acceptedFileTypes.put(type, type);
                }
                this._logger.debug((Object)("Using accepted file types: " + BlojsomUtils.arrayOfStringsToString((String[])parsedListOfTypes)));
                this._resourcesDirectory = this._blojsomConfiguration.getResourceDirectory();
                if (BlojsomUtils.checkNullOrBlank((String)this._resourcesDirectory)) {
                    this._resourcesDirectory = DEFAULT_RESOURCES_DIRECTORY;
                }
                this._resourcesDirectory = BlojsomUtils.checkStartingAndEndingSlash((String)this._resourcesDirectory);
                this._logger.debug((Object)("Using resources directory: " + this._resourcesDirectory));
                String invalidFileExtensionsProperty = configurationProperties.getProperty(INVALID_FILE_EXTENSIONS_IP);
                this._invalidFileExtensions = BlojsomUtils.checkNullOrBlank((String)invalidFileExtensionsProperty) ? DEFAULT_INVALID_FILE_EXTENSIONS : BlojsomUtils.parseCommaList((String)invalidFileExtensionsProperty);
                this._logger.debug((Object)("Using invalid file extensions: " + invalidFileExtensionsProperty));
                this._uploadQuotaEnabled = Boolean.valueOf(configurationProperties.getProperty(UPLOAD_QUOTA_ENABLED_IP));
                if (!this._uploadQuotaEnabled) break block14;
                String uploadQuotaLimit = configurationProperties.getProperty(UPLOAD_QUOTA_LIMIT_IP);
                if (BlojsomUtils.checkNullOrBlank((String)uploadQuotaLimit)) {
                    this._uploadQuotaLimit = 0xA00000L;
                } else {
                    try {
                        this._uploadQuotaLimit = Long.parseLong(uploadQuotaLimit);
                        if (this._uploadQuotaLimit <= 0L) {
                            this._uploadQuotaLimit = 0xA00000L;
                        }
                    }
                    catch (NumberFormatException e) {
                        this._uploadQuotaLimit = 0xA00000L;
                    }
                }
                this._logger.debug((Object)("Upload limit enabled. Quota is : " + this._uploadQuotaLimit + " bytes"));
            }
            catch (BlojsomException e) {
                this._logger.error((Object)e);
                throw new BlojsomPluginException((Throwable)e);
            }
        }
    }

    protected long getDirectorySize(File directory) {
        if (!directory.isDirectory()) {
            return -1L;
        }
        long totalSize = 0L;
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                totalSize += this.getDirectorySize(file);
                continue;
            }
            totalSize += file.length();
        }
        return totalSize;
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        if (!this.authenticateUser(httpServletRequest, httpServletResponse, context, user)) {
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin-login");
            return entries;
        }
        String username = this.getUsernameFromSession(httpServletRequest, user.getBlog());
        if (!this.checkPermission(user, null, username, FILE_UPLOAD_PERMISSION)) {
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin");
            this.addOperationResultMessage(context, this.getAdminResource(FAILED_PERMISSION_KEY, FAILED_PERMISSION_KEY, user.getBlog().getBlogAdministrationLocale()));
            return entries;
        }
        File resourceDirectory = new File(this._blojsomConfiguration.getInstallationDirectory() + this._resourcesDirectory + user.getId() + "/");
        String action = BlojsomUtils.getRequestValue((String)"action", (HttpServletRequest)httpServletRequest);
        if (BlojsomUtils.checkNullOrBlank((String)action)) {
            this._logger.debug((Object)"User did not request edit action");
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin");
        } else if ("page".equals(action)) {
            this._logger.debug((Object)"User requested file upload page");
            httpServletRequest.setAttribute("page", (Object)FILE_UPLOAD_PAGE);
        } else if (UPLOAD_FILE_ACTION.equals(action)) {
            this._logger.debug((Object)"User requested file upload action");
            DiskFileUpload diskFileUpload = new DiskFileUpload();
            diskFileUpload.setRepositoryPath(this._temporaryDirectory);
            diskFileUpload.setSizeThreshold(this._maximumMemorySize);
            diskFileUpload.setSizeMax(this._maximumUploadSize);
            try {
                List items = diskFileUpload.parseRequest(httpServletRequest);
                Iterator itemsIterator = items.iterator();
                while (itemsIterator.hasNext()) {
                    FileItem item = (FileItem)itemsIterator.next();
                    if (item.isFormField()) continue;
                    String itemNameWithoutPath = BlojsomUtils.getFilenameFromPath((String)item.getName());
                    this._logger.debug((Object)("Found file item: " + itemNameWithoutPath + " of type: " + item.getContentType()));
                    String fileType = item.getContentType();
                    boolean isAcceptedFileType = this._acceptedFileTypes.containsKey(fileType);
                    String extension = BlojsomUtils.getFileExtension((String)itemNameWithoutPath);
                    boolean isAcceptedFileExtension = true;
                    for (int i = 0; i < this._invalidFileExtensions.length; ++i) {
                        String invalidFileExtension = this._invalidFileExtensions[i];
                        if (itemNameWithoutPath.indexOf(invalidFileExtension) == -1) continue;
                        isAcceptedFileExtension = false;
                        break;
                    }
                    if (this._uploadQuotaEnabled) {
                        boolean overQuota = true;
                        long currentLimit = this.getDirectorySize(resourceDirectory);
                        if (currentLimit != -1L && currentLimit + item.getSize() < this._uploadQuotaLimit) {
                            overQuota = false;
                        }
                        if (overQuota) {
                            this._logger.error((Object)("Upload quota exceeded trying to upload file: " + itemNameWithoutPath));
                            this.addOperationResultMessage(context, this.formatAdminResource(UPLOAD_LIMIT_KEY, UPLOAD_LIMIT_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{itemNameWithoutPath, new Long(this._uploadQuotaLimit)}));
                            break;
                        }
                    }
                    if (isAcceptedFileType && isAcceptedFileExtension) {
                        if (!resourceDirectory.exists() && !resourceDirectory.mkdirs()) {
                            this._logger.error((Object)("Unable to create resource directory for user: " + resourceDirectory.toString()));
                            this.addOperationResultMessage(context, this.getAdminResource(FAILED_RESOURCE_KEY, FAILED_RESOURCE_KEY, user.getBlog().getBlogAdministrationLocale()));
                            return entries;
                        }
                        File resourceFile = new File(resourceDirectory, itemNameWithoutPath);
                        try {
                            item.write(resourceFile);
                        }
                        catch (Exception e) {
                            this._logger.error((Object)e);
                            this.addOperationResultMessage(context, this.formatAdminResource(UNKNOWN_ERROR_KEY, UNKNOWN_ERROR_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{e.getMessage()}));
                        }
                        String resourceURL = user.getBlog().getBlogBaseURL() + this._blojsomConfiguration.getResourceDirectory() + user.getId() + "/" + item.getName();
                        this._logger.debug((Object)("Successfully uploaded resource file: " + resourceFile.toString()));
                        this.addOperationResultMessage(context, this.formatAdminResource(SUCCESSFUL_UPLOAD_KEY, SUCCESSFUL_UPLOAD_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{item.getName(), resourceURL, item.getName()}));
                        continue;
                    }
                    if (!isAcceptedFileExtension) {
                        this._logger.error((Object)("Upload file does not have an accepted extension: " + extension));
                        this.addOperationResultMessage(context, this.formatAdminResource(INVALID_EXTENSION_KEY, INVALID_EXTENSION_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{extension}));
                        continue;
                    }
                    this._logger.error((Object)("Upload file is not an accepted type: " + item.getName() + " of type: " + item.getContentType()));
                    this.addOperationResultMessage(context, this.formatAdminResource(INVALID_TYPE_KEY, INVALID_TYPE_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{item.getContentType()}));
                }
            }
            catch (FileUploadException e) {
                this._logger.error((Object)e);
                this.addOperationResultMessage(context, this.formatAdminResource(UNKNOWN_ERROR_KEY, UNKNOWN_ERROR_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{e.getMessage()}));
            }
            httpServletRequest.setAttribute("page", (Object)FILE_UPLOAD_PAGE);
        } else if (DELETE_UPLOAD_FILES.equals(action)) {
            String[] filesToDelete = httpServletRequest.getParameterValues(FILE_TO_DELETE);
            int actualFilesDeleted = 0;
            if (filesToDelete != null && filesToDelete.length > 0) {
                for (int i = 0; i < filesToDelete.length; ++i) {
                    String fileToDelete = filesToDelete[i];
                    File deletedFile = new File(resourceDirectory, fileToDelete);
                    if (!deletedFile.delete()) {
                        this._logger.debug((Object)("Unable to delete resource file: " + deletedFile.toString()));
                        continue;
                    }
                    ++actualFilesDeleted;
                }
                this.addOperationResultMessage(context, this.formatAdminResource(DELETED_FILES_KEY, DELETED_FILES_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{new Integer(actualFilesDeleted)}));
            }
            httpServletRequest.setAttribute("page", (Object)FILE_UPLOAD_PAGE);
        }
        AbstractMap resourceFilesMap = null;
        if (resourceDirectory.exists()) {
            File[] resourceFiles = resourceDirectory.listFiles();
            if (resourceFiles != null) {
                resourceFilesMap = new HashMap(resourceFiles.length);
                for (int i = 0; i < resourceFiles.length; ++i) {
                    File resourceFile = resourceFiles[i];
                    resourceFilesMap.put(resourceFile.getName(), resourceFile.getName());
                }
            }
        } else {
            resourceFilesMap = new HashMap();
        }
        resourceFilesMap = new TreeMap(resourceFilesMap);
        context.put(PLUGIN_ADMIN_FILE_UPLOAD_FILES, resourceFilesMap);
        return entries;
    }
}

