/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.admin;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.BlojsomException;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.admin.BaseAdminPlugin;
import org.blojsom.plugin.admin.WebAdminPlugin;
import org.blojsom.util.BlojsomUtils;

public class ListWebAdminPluginsPlugin
extends BaseAdminPlugin {
    private static Log _logger = LogFactory.getLog((Class)ListWebAdminPluginsPlugin.class);
    private static final String BLOJSOM_PLUGIN_WEB_ADMIN_PLUGINS_LIST = "BLOJSOM_PLUGIN_WEB_ADMIN_PLUGINS_LIST";
    private static final String LIST_WEB_ADMIN_PLUGINS_PAGE = "/org/blojsom/plugin/admin/templates/admin-list-web-admin-plugins";
    private Map _plugins;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        super.init(servletConfig, blojsomConfiguration);
        this._plugins = new TreeMap();
        String pluginConfiguration = servletConfig.getInitParameter("plugin-configuration");
        try {
            Properties pluginProperties = BlojsomUtils.loadProperties((ServletConfig)servletConfig, (String)(this._blojsomConfiguration.getBaseConfigurationDirectory() + pluginConfiguration));
            Map plugins = BlojsomUtils.propertiesToMap((Properties)pluginProperties);
            Iterator pluginsIterator = plugins.keySet().iterator();
            while (pluginsIterator.hasNext()) {
                String pluginName = (String)pluginsIterator.next();
                if (pluginName.indexOf("blojsom-plugin-chain") != -1) {
                    this._plugins.remove(pluginName);
                    continue;
                }
                Class<?> pluginClass = Class.forName((String)plugins.get(pluginName));
                BlojsomPlugin blojsomPlugin = (BlojsomPlugin)pluginClass.newInstance();
                if (!(blojsomPlugin instanceof WebAdminPlugin)) continue;
                this._plugins.put(pluginName, ((WebAdminPlugin)blojsomPlugin).getDisplayName());
                _logger.debug((Object)("Added web admin plugin: " + pluginName));
            }
        }
        catch (BlojsomException e) {
            _logger.error((Object)e);
        }
        catch (ClassNotFoundException e) {
            _logger.error((Object)e);
        }
        catch (InstantiationException e) {
            _logger.error((Object)e);
        }
        catch (IllegalAccessException e) {
            _logger.error((Object)e);
        }
        _logger.debug((Object)"Initialized list web admin plugins plugin");
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        entries = super.process(httpServletRequest, httpServletResponse, user, context, entries);
        String page = BlojsomUtils.getRequestValue((String)"page", (HttpServletRequest)httpServletRequest);
        if ("/org/blojsom/plugin/admin/templates/admin-login".equals(page)) {
            return entries;
        }
        httpServletRequest.setAttribute("page", (Object)LIST_WEB_ADMIN_PLUGINS_PAGE);
        context.put(BLOJSOM_PLUGIN_WEB_ADMIN_PLUGINS_LIST, this._plugins);
        return entries;
    }
}

