/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.admin;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfigurationException;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.admin.WebAdminPlugin;
import org.blojsom.util.BlojsomProperties;
import org.blojsom.util.BlojsomUtils;

public class ReloadBlogPropertiesPlugin
extends WebAdminPlugin {
    private Log _logger = LogFactory.getLog((Class)ReloadBlogPropertiesPlugin.class);
    private static final String FAILED_PROPERTIES_LOAD_PERMISSION_KEY = "failed.properties.load.permission.text";
    private static final String RELOADED_PROPERTIES_KEY = "reloaded.properties.text";
    private static final String FAILED_PROPERTIES_LOAD_KEY = "failed.properties.load.text";
    private static final String RELOAD_PROPERTIES_PERMISSION = "reload_properties";

    public String getDisplayName() {
        return "Reload Blog Properties plugin";
    }

    public String getInitialPage() {
        return "";
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        entries = super.process(httpServletRequest, httpServletResponse, user, context, entries);
        String username = this.getUsernameFromSession(httpServletRequest, user.getBlog());
        if (!this.checkPermission(user, null, username, RELOAD_PROPERTIES_PERMISSION)) {
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin-login");
            this.addOperationResultMessage(context, this.getAdminResource(FAILED_PROPERTIES_LOAD_PERMISSION_KEY, FAILED_PROPERTIES_LOAD_PERMISSION_KEY, user.getBlog().getBlogAdministrationLocale()));
            return entries;
        }
        String page = BlojsomUtils.getRequestValue((String)"page", (HttpServletRequest)httpServletRequest);
        if ("/org/blojsom/plugin/admin/templates/admin-login".equals(page)) {
            return entries;
        }
        try {
            BlojsomProperties blogProperties = new BlojsomProperties();
            InputStream is = this._servletConfig.getServletContext().getResourceAsStream(this._blojsomConfiguration.getBaseConfigurationDirectory() + user.getId() + '/' + "blog.properties");
            blogProperties.load(is);
            is.close();
            Blog blog = new Blog((Properties)blogProperties);
            user.setBlog(blog);
            this.addOperationResultMessage(context, this.formatAdminResource(RELOADED_PROPERTIES_KEY, RELOADED_PROPERTIES_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{user.getId()}));
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin");
        }
        catch (IOException e) {
            this._logger.error((Object)e);
            this.addOperationResultMessage(context, this.formatAdminResource(FAILED_PROPERTIES_LOAD_KEY, FAILED_PROPERTIES_LOAD_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{user.getId()}));
        }
        catch (BlojsomConfigurationException e) {
            this._logger.error((Object)e);
            this.addOperationResultMessage(context, this.formatAdminResource(FAILED_PROPERTIES_LOAD_KEY, FAILED_PROPERTIES_LOAD_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{user.getId()}));
        }
        return entries;
    }
}

