/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.calendar;

import org.blojsom.plugin.calendar.BlogCalendar;
import org.blojsom.util.BlojsomUtils;

public class VelocityHelper {
    private BlogCalendar _calendar;
    private String[][] visualcalendar = new String[6][7];
    private static final String VTL_SPACER = "&nbsp;";
    private String HREF_PREFIX = "<a href=\"";
    private String HREF_SUFFIX = "</a>";
    private String _today = "Today";

    public VelocityHelper() {
    }

    public VelocityHelper(BlogCalendar calendar) {
        this._calendar = calendar;
    }

    public void setCalendar(BlogCalendar calendar) {
        this._calendar = calendar;
    }

    public BlogCalendar getBlogCalendar() {
        return this._calendar;
    }

    public void buildCalendar() {
        int fdow = this._calendar.getFirstDayOfMonth() - this._calendar.getCalendar().getFirstDayOfWeek();
        if (fdow == -1) {
            fdow = 6;
        }
        int ldom = this._calendar.getDaysInMonth();
        int dowoffset = 0;
        for (int x = 0; x < 6; ++x) {
            for (int y = 0; y < 7; ++y) {
                if (x == 0 && y < fdow || dowoffset >= ldom) {
                    this.visualcalendar[x][y] = VTL_SPACER;
                    continue;
                }
                if (!this._calendar.dayHasEntry(++dowoffset)) {
                    this.visualcalendar[x][y] = new Integer(dowoffset).toString();
                    continue;
                }
                StringBuffer _url = new StringBuffer(this.HREF_PREFIX);
                String _calurl = BlojsomUtils.getCalendarNavigationUrl((String)this._calendar.getCalendarUrl(), (int)(this._calendar.getCurrentMonth() + 1), (int)dowoffset, (int)this._calendar.getCurrentYear());
                _url.append(_calurl);
                _url.append("\"><span>").append(dowoffset).append("</span>").append(this.HREF_SUFFIX);
                this.visualcalendar[x][y] = _url.toString();
            }
        }
    }

    public String getCalendarRow(int row) {
        return this.getCalendarRow(row, null);
    }

    public String getCalendarRow(int row, String clazz) {
        StringBuffer result = new StringBuffer();
        if (row > 0 && row <= this.visualcalendar.length) {
            for (int x = 0; x < 7; ++x) {
                if (clazz != null) {
                    result.append("<td class=\"").append(clazz).append("\">").append(this.visualcalendar[row - 1][x]).append("</td>");
                    continue;
                }
                result.append("<td>").append(this.visualcalendar[row - 1][x]).append("</td>");
            }
        }
        return result.toString();
    }

    public String getToday() {
        StringBuffer result = new StringBuffer();
        result.append(this.HREF_PREFIX).append(this._calendar.getCalendarUrl()).append("\">").append(this._calendar.getShortMonthName(this._calendar.getCurrentMonth())).append(this.HREF_SUFFIX);
        return result.toString();
    }

    public String getPreviousMonth() {
        StringBuffer result = new StringBuffer();
        this._calendar.getCalendar().add(2, -1);
        result.append(this.HREF_PREFIX);
        String prevurl = BlojsomUtils.getCalendarNavigationUrl((String)this._calendar.getCalendarUrl(), (int)(this._calendar.getCalendar().get(2) + 1), (int)-1, (int)this._calendar.getCalendar().get(1));
        result.append(prevurl);
        result.append("\"> &lt;").append(VTL_SPACER).append(VTL_SPACER);
        result.append(this._calendar.getShortMonthName(this._calendar.getCalendar().get(2)));
        result.append(this.HREF_SUFFIX);
        this._calendar.getCalendar().add(2, 1);
        return result.toString();
    }

    public String getNextMonth() {
        StringBuffer result = new StringBuffer();
        this._calendar.getCalendar().add(2, 1);
        result.append(this.HREF_PREFIX);
        String nexturl = BlojsomUtils.getCalendarNavigationUrl((String)this._calendar.getCalendarUrl(), (int)(this._calendar.getCalendar().get(2) + 1), (int)-1, (int)this._calendar.getCalendar().get(1));
        result.append(nexturl);
        result.append("\"> ");
        result.append(this._calendar.getShortMonthName(this._calendar.getCalendar().get(2)));
        result.append(VTL_SPACER).append(VTL_SPACER).append("&gt;").append(this.HREF_SUFFIX);
        this._calendar.getCalendar().add(2, -1);
        return result.toString();
    }

    public String getPreviousMonthLink() {
        StringBuffer result = new StringBuffer();
        this._calendar.getCalendar().add(2, -1);
        String prevurl = BlojsomUtils.getCalendarNavigationUrl((String)this._calendar.getCalendarUrl(), (int)(this._calendar.getCalendar().get(2) + 1), (int)-1, (int)this._calendar.getCalendar().get(1));
        result.append(prevurl);
        this._calendar.getCalendar().add(2, 1);
        return result.toString();
    }

    public String getPreviousMonthName() {
        StringBuffer result = new StringBuffer();
        this._calendar.getCalendar().add(2, -1);
        result.append(this._calendar.getMonthName(this._calendar.getCalendar().get(2)));
        this._calendar.getCalendar().add(2, 1);
        return result.toString();
    }

    public String getCurrentMonthLink() {
        StringBuffer result = new StringBuffer();
        result.append(this._calendar.getCalendarUrl());
        return result.toString();
    }

    public String getCurrentMonthName() {
        StringBuffer result = new StringBuffer();
        result.append(this._calendar.getMonthName(this._calendar.getCalendar().get(2)));
        return result.toString();
    }

    public String getNextMonthLink() {
        StringBuffer result = new StringBuffer();
        this._calendar.getCalendar().add(2, 1);
        String nexturl = BlojsomUtils.getCalendarNavigationUrl((String)this._calendar.getCalendarUrl(), (int)(this._calendar.getCalendar().get(2) + 1), (int)-1, (int)this._calendar.getCalendar().get(1));
        result.append(nexturl);
        this._calendar.getCalendar().add(2, -1);
        return result.toString();
    }

    public String getNextMonthName() {
        StringBuffer result = new StringBuffer();
        this._calendar.getCalendar().add(2, 1);
        result.append(this._calendar.getMonthName(this._calendar.getCalendar().get(2)));
        this._calendar.getCalendar().add(2, -1);
        return result.toString();
    }

    public void setTodayText(String today) {
        this._today = today;
    }

    public String getTodayText() {
        return this._today;
    }
}

