/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.email;

import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.email.EmailConstants;
import org.blojsom.plugin.email.EmailMessage;
import org.blojsom.plugin.email.EmailUtils;
import org.blojsom.plugin.email.SimpleAuthenticator;
import org.blojsom.util.BlojsomUtils;

public class SendEmailPlugin
implements BlojsomPlugin,
EmailConstants {
    private Log _logger = LogFactory.getLog((Class)SendEmailPlugin.class);
    private Session _mailsession = null;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        String hostname = servletConfig.getInitParameter("smtp-server");
        if (hostname != null) {
            if (hostname.startsWith("java:comp/env")) {
                try {
                    InitialContext context = new InitialContext();
                    this._mailsession = (Session)context.lookup(hostname);
                }
                catch (NamingException e) {
                    this._logger.error((Object)e);
                    throw new BlojsomPluginException((Throwable)e);
                }
            } else {
                String username = servletConfig.getInitParameter("smtp-server-username");
                String password = servletConfig.getInitParameter("smtp-server-password");
                Properties props = new Properties();
                props.put("mail.smtp.host", hostname);
                if (BlojsomUtils.checkNullOrBlank((String)username) || BlojsomUtils.checkNullOrBlank((String)password)) {
                    this._mailsession = Session.getInstance((Properties)props, null);
                } else {
                    props.put("mail.smtp.auth", "true");
                    props.put("mail.smtp.username", username);
                    props.put("mail.smtp.password", password);
                    this._mailsession = Session.getInstance((Properties)props, (Authenticator)new SimpleAuthenticator(username, password));
                }
            }
        }
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        List messageList;
        Blog blog = user.getBlog();
        String defaultrecipientname = null;
        String defaultrecipientemail = null;
        if (blog.getBlogOwnerEmail() != null) {
            defaultrecipientemail = blog.getBlogOwnerEmail();
        }
        if (blog.getBlogOwner() != null) {
            defaultrecipientname = blog.getBlogOwner();
        }
        if ((messageList = (List)context.get("BLOJSOM_OUTBOUNDMAIL")) != null) {
            for (int x = 0; x < messageList.size(); ++x) {
                EmailMessage message = (EmailMessage)messageList.get(x);
                if (message == null) continue;
                this.sendMailMessage(message, defaultrecipientemail, defaultrecipientname);
            }
        }
        return entries;
    }

    private void sendMailMessage(EmailMessage emailmessage, String defaultRecipientEmail, String defaultRecipientName) {
        try {
            InternetAddress defaultAddress = new InternetAddress(defaultRecipientEmail, defaultRecipientName);
            EmailUtils.sendMailMessage(this._mailsession, emailmessage, defaultAddress);
        }
        catch (UnsupportedEncodingException e) {
            this._logger.error((Object)e);
        }
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }
}

