/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.emoticons;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.util.BlojsomUtils;

public class EmoticonsPlugin
implements BlojsomPlugin {
    private static final String EMOTICONS_CONFIGURATION_IP = "plugin-emoticons";
    private static final String BLOJSOM_PLUGIN_METADATA_EMOTICONS_DISABLED = "emoticons-disabled";
    private static final String HAPPY = ":)";
    private static final String HAPPY_PARAM = "happy";
    private static final String SAD = ":(";
    private static final String SAD_PARAM = "sad";
    private static final String GRIN = ":D";
    private static final String GRIN_PARAM = "grin";
    private static final String LOVE = "<3";
    private static final String LOVE_PARAM = "love";
    private static final String MISCHIEF = ";7)";
    private static final String MISCHIEF_PARAM = "mischief";
    private static final String COOL = "])";
    private static final String COOL_PARAM = "cool";
    private static final String DEVIL = "})";
    private static final String DEVIL_PARAM = "devil";
    private static final String SILLY = ":P";
    private static final String SILLY_PARAM = "silly";
    private static final String ANGRY = ">(";
    private static final String ANGRY_PARAM = "angry";
    private static final String LAUGH = "(D";
    private static final String LAUGH_PARAM = "laugh";
    private static final String WINK = ";)";
    private static final String WINK_PARAM = "wink";
    private static final String BLUSH = "*^_^*";
    private static final String BLUSH_PARAM = "blush";
    private static final String CRY = ":'(";
    private static final String CRY_PARAM = "cry";
    private static final String CONFUSED = "`:|";
    private static final String CONFUSED_PARAM = "confused";
    private static final String SHOCKED = ":O";
    private static final String SHOCKED_PARAM = "shocked";
    private static final String PLAIN = ":|";
    private static final String PLAIN_PARAM = "plain";
    private static final String IMG_OPEN = "<img src=\"";
    private static final String IMG_CLOSE = "\"";
    private static final String IMG_ALT_START = " alt=\"";
    private static final String IMG_ALT_END = "\" />";
    private static final String EMOTICONS_CLASS = " class=\"emoticons\" ";
    private Log _logger = LogFactory.getLog((Class)EmoticonsPlugin.class);
    private ServletConfig _servletConfig;
    private BlojsomConfiguration _blojsomConfiguration;
    private String _emoticonsConfigurationFile;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        this._servletConfig = servletConfig;
        this._blojsomConfiguration = blojsomConfiguration;
        this._emoticonsConfigurationFile = servletConfig.getInitParameter(EMOTICONS_CONFIGURATION_IP);
        if (BlojsomUtils.checkNullOrBlank((String)this._emoticonsConfigurationFile)) {
            throw new BlojsomPluginException("No value given for: plugin-emoticons configuration parameter");
        }
    }

    private Map readEmoticonsMapForBlog(String blogID) {
        Map emoticonsMap = null;
        Properties emoticonsProperties = new Properties();
        String configurationFile = this._blojsomConfiguration.getBaseConfigurationDirectory() + blogID + '/' + this._emoticonsConfigurationFile;
        InputStream is = this._servletConfig.getServletContext().getResourceAsStream(configurationFile);
        if (is == null) {
            this._logger.info((Object)("No emoticons configuration file found: " + configurationFile));
        } else {
            try {
                emoticonsProperties.load(is);
                is.close();
                return BlojsomUtils.propertiesToMap((Properties)emoticonsProperties);
            }
            catch (IOException e) {
                this._logger.error((Object)e);
            }
        }
        return emoticonsMap;
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        Map emoticonsForBlog = this.readEmoticonsMapForBlog(user.getId());
        if (emoticonsForBlog == null) {
            return entries;
        }
        String blogBaseUrl = user.getBlog().getBlogBaseURL();
        for (int i = 0; i < entries.length; ++i) {
            BlogEntry entry = entries[i];
            if (BlojsomUtils.checkMapForKey((Map)entry.getMetaData(), (String)BLOJSOM_PLUGIN_METADATA_EMOTICONS_DISABLED)) continue;
            String updatedDescription = entry.getDescription();
            updatedDescription = this.replaceEmoticon(emoticonsForBlog, updatedDescription, HAPPY, HAPPY_PARAM, blogBaseUrl);
            updatedDescription = this.replaceEmoticon(emoticonsForBlog, updatedDescription, SAD, SAD_PARAM, blogBaseUrl);
            updatedDescription = this.replaceEmoticon(emoticonsForBlog, updatedDescription, GRIN, GRIN_PARAM, blogBaseUrl);
            updatedDescription = this.replaceEmoticon(emoticonsForBlog, updatedDescription, LOVE, LOVE_PARAM, blogBaseUrl);
            updatedDescription = this.replaceEmoticon(emoticonsForBlog, updatedDescription, MISCHIEF, MISCHIEF_PARAM, blogBaseUrl);
            updatedDescription = this.replaceEmoticon(emoticonsForBlog, updatedDescription, COOL, COOL_PARAM, blogBaseUrl);
            updatedDescription = this.replaceEmoticon(emoticonsForBlog, updatedDescription, DEVIL, DEVIL_PARAM, blogBaseUrl);
            updatedDescription = this.replaceEmoticon(emoticonsForBlog, updatedDescription, SILLY, SILLY_PARAM, blogBaseUrl);
            updatedDescription = this.replaceEmoticon(emoticonsForBlog, updatedDescription, ANGRY, ANGRY_PARAM, blogBaseUrl);
            updatedDescription = this.replaceEmoticon(emoticonsForBlog, updatedDescription, LAUGH, LAUGH_PARAM, blogBaseUrl);
            updatedDescription = this.replaceEmoticon(emoticonsForBlog, updatedDescription, WINK, WINK_PARAM, blogBaseUrl);
            updatedDescription = this.replaceEmoticon(emoticonsForBlog, updatedDescription, BLUSH, BLUSH_PARAM, blogBaseUrl);
            updatedDescription = this.replaceEmoticon(emoticonsForBlog, updatedDescription, CRY, CRY_PARAM, blogBaseUrl);
            updatedDescription = this.replaceEmoticon(emoticonsForBlog, updatedDescription, CONFUSED, CONFUSED_PARAM, blogBaseUrl);
            updatedDescription = this.replaceEmoticon(emoticonsForBlog, updatedDescription, SHOCKED, SHOCKED_PARAM, blogBaseUrl);
            updatedDescription = this.replaceEmoticon(emoticonsForBlog, updatedDescription, PLAIN, PLAIN_PARAM, blogBaseUrl);
            entry.setDescription(updatedDescription);
        }
        return entries;
    }

    private String replaceEmoticon(Map emoticonsForUser, String emoticonString, String emoticon, String emoticonParam, String url) {
        String emoticonImage = (String)emoticonsForUser.get(emoticonParam);
        if (emoticonImage != null && !"".equals(emoticonImage)) {
            StringBuffer imageReference = new StringBuffer(IMG_OPEN);
            imageReference.append(url);
            imageReference.append(emoticonImage);
            imageReference.append(IMG_CLOSE);
            imageReference.append(EMOTICONS_CLASS);
            imageReference.append(IMG_ALT_START);
            imageReference.append(emoticonImage);
            imageReference.append(IMG_ALT_END);
            return BlojsomUtils.replace((String)emoticonString, (String)emoticon, (String)imageReference.toString());
        }
        return emoticonString;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }
}

