/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.emoticons;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.emoticons.EmoticonsPlugin;
import org.blojsom.util.BlojsomUtils;

public class EnhancedEmoticonsPlugin
implements BlojsomPlugin {
    private static final String BLOJSOM_PLUGIN_METADATA_EMOTICONS_DISABLED = "emoticons-disabled";
    private static final String EMOTICONS_CONFIGURATION_IP = "plugin-emoticons";
    private static final String EMOTICONS_PARAM = "emoticons";
    private static final String EMOTICONS_PATTERN_POSTFIX = ".pattern";
    private static final String IMG_OPEN = "<img src=\"";
    private static final String IMG_CLOSE = "\"";
    private static final String IMG_ALT_START = " alt=\"";
    private static final String IMG_ALT_END = "\" />";
    private static final String EMOTICONS_CLASS = " class=\"emoticons\" ";
    private Log _logger = LogFactory.getLog((Class)EmoticonsPlugin.class);
    private ServletConfig _servletConfig;
    private BlojsomConfiguration _blojsomConfiguration;
    private String _emoticonsConfigurationFile;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        this._servletConfig = servletConfig;
        this._blojsomConfiguration = blojsomConfiguration;
        this._emoticonsConfigurationFile = servletConfig.getInitParameter(EMOTICONS_CONFIGURATION_IP);
        if (BlojsomUtils.checkNullOrBlank((String)this._emoticonsConfigurationFile)) {
            throw new BlojsomPluginException("No value given for: plugin-emoticons configuration parameter");
        }
    }

    private Map readEmoticonsMapForBlog(String blogID) {
        Map emoticonsMap = null;
        Properties emoticonsProperties = new Properties();
        String configurationFile = this._blojsomConfiguration.getBaseConfigurationDirectory() + blogID + '/' + this._emoticonsConfigurationFile;
        InputStream is = this._servletConfig.getServletContext().getResourceAsStream(configurationFile);
        if (is == null) {
            this._logger.info((Object)("No emoticons configuration file found: " + configurationFile));
        } else {
            try {
                emoticonsProperties.load(is);
                is.close();
                return BlojsomUtils.propertiesToMap((Properties)emoticonsProperties);
            }
            catch (IOException e) {
                this._logger.error((Object)e);
            }
        }
        return emoticonsMap;
    }

    private List parseEmoticons(String emoticons) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(emoticons, "\t\n\r\f,; ");
        while (tok.hasMoreTokens()) {
            list.add(tok.nextToken());
        }
        return list;
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        Map emoticonsForBlog = this.readEmoticonsMapForBlog(user.getId());
        if (emoticonsForBlog == null) {
            return entries;
        }
        List availableEmoticons = this.parseEmoticons((String)emoticonsForBlog.get(EMOTICONS_PARAM));
        String blogBaseUrl = user.getBlog().getBlogBaseURL();
        for (int i = 0; i < entries.length; ++i) {
            BlogEntry entry = entries[i];
            if (BlojsomUtils.checkMapForKey((Map)entry.getMetaData(), (String)BLOJSOM_PLUGIN_METADATA_EMOTICONS_DISABLED)) continue;
            String updatedDescription = entry.getDescription();
            Iterator iter = availableEmoticons.iterator();
            while (iter.hasNext()) {
                String emoticon = (String)iter.next();
                updatedDescription = this.replaceEmoticon(emoticonsForBlog, updatedDescription, emoticon, blogBaseUrl);
            }
            entry.setDescription(updatedDescription);
        }
        return entries;
    }

    private String replaceEmoticon(Map emoticonsForUser, String emoticonString, String emoticon, String url) {
        String emoticonImage = (String)emoticonsForUser.get(emoticon);
        String emoticonPattern = (String)emoticonsForUser.get(emoticon + EMOTICONS_PATTERN_POSTFIX);
        if (emoticonImage != null && !"".equals(emoticonImage)) {
            StringBuffer imageReference = new StringBuffer(IMG_OPEN);
            imageReference.append(url);
            imageReference.append(emoticonImage);
            imageReference.append(IMG_CLOSE);
            imageReference.append(EMOTICONS_CLASS);
            imageReference.append(IMG_ALT_START);
            imageReference.append(emoticonImage);
            imageReference.append(IMG_ALT_END);
            return BlojsomUtils.replace((String)emoticonString, (String)emoticonPattern, (String)imageReference.toString());
        }
        return emoticonString;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }
}

