/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.limiter;

import java.util.ArrayList;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.util.BlojsomUtils;

public class PreviewPlugin
implements BlojsomPlugin {
    private static final String PLUGIN_PREVIEW_TITLE_PREFIX_IP = "plugin-preview-title-prefix";
    private static final String PLUGIN_PREVIEW_PREVIEW_PASSWORD_IP = "plugin-preview-preview-password";
    private static final String DEFAULT_TITLE_PREFIX = "PREVIEW";
    private static final String DEFAULT_PREVIEW_PASSWORD = "true";
    private static final String PREVIEW_PARAM = "preview";

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        String previewParam;
        String previewPassword;
        String titlePrefix = user.getBlog().getBlogProperty(PLUGIN_PREVIEW_TITLE_PREFIX_IP);
        if (BlojsomUtils.checkNullOrBlank((String)titlePrefix)) {
            titlePrefix = DEFAULT_TITLE_PREFIX;
        }
        if (BlojsomUtils.checkNullOrBlank((String)(previewPassword = user.getBlog().getBlogProperty(PLUGIN_PREVIEW_PREVIEW_PASSWORD_IP)))) {
            previewPassword = DEFAULT_PREVIEW_PASSWORD;
        }
        if ((previewParam = httpServletRequest.getParameter(PREVIEW_PARAM)) != null && previewParam.equals(previewPassword)) {
            return entries;
        }
        ArrayList<BlogEntry> postedEntries = new ArrayList<BlogEntry>(entries.length);
        for (int i = 0; i < entries.length; ++i) {
            BlogEntry entry = entries[i];
            if (entry == null || entry.getTitle() == null || entry.getTitle().startsWith(titlePrefix)) continue;
            postedEntries.add(entry);
        }
        return postedEntries.toArray(new BlogEntry[postedEntries.size()]);
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }
}

