/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.markdown;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.util.BlojsomConstants;
import org.blojsom.util.BlojsomUtils;

public class MarkdownPlugin
implements BlojsomPlugin,
BlojsomConstants {
    private transient Log _logger = LogFactory.getLog((Class)MarkdownPlugin.class);
    private static final String METADATA_RUN_MARKDOWN = "run-markdown";
    private static final String MARKDOWN_EXTENSION = ".markdown";
    private static final String PLUGIN_MARKDOWN_EXECUTION_IP = "plugin-markdown-execution";
    private String _markdownExecution;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        this._markdownExecution = servletConfig.getInitParameter(PLUGIN_MARKDOWN_EXECUTION_IP);
        if (BlojsomUtils.checkNullOrBlank((String)this._markdownExecution)) {
            this._logger.error((Object)"No Markdown execution string provided. Use initialization parameter: plugin-markdown-execution");
        }
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        if (!BlojsomUtils.checkNullOrBlank((String)this._markdownExecution)) {
            for (int i = 0; i < entries.length; ++i) {
                BlogEntry entry = entries[i];
                if (!entry.getPermalink().endsWith(MARKDOWN_EXTENSION) && !BlojsomUtils.checkMapForKey((Map)entry.getMetaData(), (String)METADATA_RUN_MARKDOWN)) continue;
                this._logger.debug((Object)("Markdown processing: " + entry.getTitle()));
                try {
                    String input;
                    Process process = Runtime.getRuntime().exec(this._markdownExecution);
                    BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(process.getOutputStream(), "UTF-8"));
                    BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream(), "UTF-8"));
                    bw.write(entry.getDescription());
                    bw.close();
                    StringBuffer collectedDescription = new StringBuffer();
                    while ((input = br.readLine()) != null) {
                        collectedDescription.append(input).append(BlojsomConstants.LINE_SEPARATOR);
                    }
                    entry.setDescription(collectedDescription.toString());
                    br.close();
                    continue;
                }
                catch (IOException e) {
                    this._logger.error((Object)e);
                }
            }
        }
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }
}

