/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.meta;

import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.BlojsomException;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogCategory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.blog.FileBackedBlogCategory;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.util.BlojsomUtils;

public class AssociatedCategoriesPlugin
implements BlojsomPlugin {
    private Log _logger = LogFactory.getLog((Class)AssociatedCategoriesPlugin.class);
    private static final String META_DATA_CATEGORIES_KEY = "categories";
    public static final String BLOJSOM_PLUGIN_ASSOCIATED_CATEGORIES = "BLOJSOM_PLUGIN_ASSOCIATED_CATEGORIES";

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        Blog blog = user.getBlog();
        for (int i = 0; i < entries.length; ++i) {
            BlogEntry entry = entries[i];
            Map metadata = entry.getMetaData();
            if (metadata == null || !metadata.containsKey(META_DATA_CATEGORIES_KEY)) continue;
            String[] associatedCategoriesList = BlojsomUtils.parseCommaList((String)((String)metadata.get(META_DATA_CATEGORIES_KEY)));
            BlogCategory[] associatedCategories = new BlogCategory[associatedCategoriesList.length];
            for (int j = 0; j < associatedCategoriesList.length; ++j) {
                String associatedCategory = associatedCategoriesList[j];
                associatedCategory = BlojsomUtils.normalize((String)associatedCategory);
                if (!(associatedCategory = BlojsomUtils.removeInitialSlash((String)associatedCategory)).endsWith("/")) {
                    associatedCategory = associatedCategory + "/";
                }
                FileBackedBlogCategory fbbc = new FileBackedBlogCategory(associatedCategory, blog.getBlogURL() + associatedCategory);
                try {
                    fbbc.load(user);
                }
                catch (BlojsomException e) {
                    this._logger.error((Object)e);
                }
                associatedCategories[j] = fbbc;
            }
            metadata.put(BLOJSOM_PLUGIN_ASSOCIATED_CATEGORIES, associatedCategories);
            entry.setMetaData(metadata);
        }
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }
}

