/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.moblog.admin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.admin.WebAdminPlugin;
import org.blojsom.plugin.moblog.Mailbox;
import org.blojsom.plugin.moblog.MoblogPluginUtils;
import org.blojsom.util.BlojsomUtils;

public class MoblogAdminPlugin
extends WebAdminPlugin {
    private Log _logger = LogFactory.getLog((Class)MoblogAdminPlugin.class);
    private static final String EDIT_MOBLOG_SETTINGS_PAGE = "/org/blojsom/plugin/moblog/admin/templates/admin-edit-moblog-settings";
    private static final String FAILED_MOBLOG_PERMISSIONS_KEY = "failed.moblog.permissions.text";
    private static final String UPDATED_MOBLOG_CONFIGURATION_KEY = "updated.moblog.configuration.text";
    private static final String FAILED_WRITE_MOBLOG_CONFIGURATION_KEY = "failed.write.moblog.configuration.text";
    private static final String ADDED_AUTHORIZED_EMAIL_KEY = "added.authorized.email.text";
    private static final String FAILED_ADD_EMAIL_KEY = "failed.add.email.text";
    private static final String NO_EMAIL_ADDRESS_KEY = "no.email.address.text";
    private static final String REMOVED_AUTHORIZED_EMAIL_KEY = "removed.authorized.email.text";
    private static final String FAILED_DELETE_EMAIL_KEY = "failed.delete.email.text";
    private static final String MOBLOG_ENABLED = "moblog-enabled";
    private static final String MOBLOG_HOSTNAME = "moblog-hostname";
    private static final String MOBLOG_USERID = "moblog-userid";
    private static final String MOBLOG_PASSWORD = "moblog-password";
    private static final String MOBLOG_CATEGORY = "moblog-category";
    private static final String MOBLOG_SECRET_WORD = "moblog-secret-word";
    private static final String MOBLOG_IMAGE_MIME_TYPES = "moblog-image-mime-types";
    private static final String MOBLOG_ATTACHMENT_MIME_TYPES = "moblog-attachment-mime-types";
    private static final String MOBLOG_TEXT_MIME_TYPES = "moblog-text-mime-types";
    private static final String MOBLOG_AUTHORIZED_ADDRESS = "moblog-authorized-address";
    private static final String MOBLOG_IGNORE_EXPRESSION = "moblog-ignore-expression";
    private static final String UPDATE_MOBLOG_SETTINGS_ACTIONS = "update-moblog-settings";
    private static final String ADD_AUTHORIZED_ADDRESS_ACTION = "add-authorized-address";
    private static final String DELETE_AUTHORIZED_ADDRESS_ACTION = "delete-authorized-address";
    private static final String MOBLOG_ADMIN_PERMISSION = "moblog_admin";
    private static final String BLOJSOM_PLUGIN_MOBLOG_MAILBOX = "BLOJSOM_PLUGIN_MOBLOG_MAILBOX";

    public String getDisplayName() {
        return "Moblog plugin";
    }

    public String getInitialPage() {
        return EDIT_MOBLOG_SETTINGS_PAGE;
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        entries = super.process(httpServletRequest, httpServletResponse, user, context, entries);
        String page = BlojsomUtils.getRequestValue((String)"page", (HttpServletRequest)httpServletRequest);
        String username = this.getUsernameFromSession(httpServletRequest, user.getBlog());
        if (!this.checkPermission(user, null, username, MOBLOG_ADMIN_PERMISSION)) {
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin");
            this.addOperationResultMessage(context, this.getAdminResource(FAILED_MOBLOG_PERMISSIONS_KEY, FAILED_MOBLOG_PERMISSIONS_KEY, user.getBlog().getBlogAdministrationLocale()));
            return entries;
        }
        if ("/org/blojsom/plugin/admin/templates/admin-login".equals(page)) {
            return entries;
        }
        String action = BlojsomUtils.getRequestValue((String)"action", (HttpServletRequest)httpServletRequest);
        Mailbox mailbox = MoblogPluginUtils.readMailboxSettingsForUser(this._blojsomConfiguration, this._servletConfig, user);
        if (mailbox == null) {
            mailbox = new Mailbox();
        }
        if (UPDATE_MOBLOG_SETTINGS_ACTIONS.equals(action)) {
            String moblogConfigurationFile = this._servletConfig.getInitParameter("plugin-moblog");
            boolean mailboxEnabled = Boolean.valueOf(BlojsomUtils.getRequestValue((String)MOBLOG_ENABLED, (HttpServletRequest)httpServletRequest));
            mailbox.setEnabled(mailboxEnabled);
            String hostname = BlojsomUtils.getRequestValue((String)MOBLOG_HOSTNAME, (HttpServletRequest)httpServletRequest);
            mailbox.setHostName(hostname);
            String userID = BlojsomUtils.getRequestValue((String)MOBLOG_USERID, (HttpServletRequest)httpServletRequest);
            mailbox.setUserId(userID);
            String password = BlojsomUtils.getRequestValue((String)MOBLOG_PASSWORD, (HttpServletRequest)httpServletRequest);
            mailbox.setPassword(password);
            String category = BlojsomUtils.getRequestValue((String)MOBLOG_CATEGORY, (HttpServletRequest)httpServletRequest);
            category = BlojsomUtils.normalize((String)category);
            mailbox.setCategoryName(category);
            String textMimeTypeValue = BlojsomUtils.getRequestValue((String)MOBLOG_TEXT_MIME_TYPES, (HttpServletRequest)httpServletRequest);
            String[] textMimeTypes = BlojsomUtils.parseCommaList((String)textMimeTypeValue);
            Map textMimeMap = mailbox.getTextMimeTypes();
            for (int i = 0; i < textMimeTypes.length; ++i) {
                String textMimeType = textMimeTypes[i];
                textMimeMap.put(textMimeType, textMimeType);
            }
            String attachmentMimeTypeValue = BlojsomUtils.getRequestValue((String)MOBLOG_ATTACHMENT_MIME_TYPES, (HttpServletRequest)httpServletRequest);
            String[] attachmentMimeTypes = BlojsomUtils.parseCommaList((String)attachmentMimeTypeValue);
            Map attachmentMimeMap = mailbox.getAttachmentMimeTypes();
            for (int i = 0; i < attachmentMimeTypes.length; ++i) {
                String attachmentMimeType = attachmentMimeTypes[i];
                attachmentMimeMap.put(attachmentMimeType, attachmentMimeType);
            }
            String imageMimeTypeValue = BlojsomUtils.getRequestValue((String)MOBLOG_IMAGE_MIME_TYPES, (HttpServletRequest)httpServletRequest);
            String[] imageMimeTypes = BlojsomUtils.parseCommaList((String)imageMimeTypeValue);
            Map imageMimeMap = mailbox.getImageMimeTypes();
            for (int i = 0; i < imageMimeTypes.length; ++i) {
                String imageMimeType = imageMimeTypes[i];
                imageMimeMap.put(imageMimeType, imageMimeType);
            }
            String secretWord = BlojsomUtils.getRequestValue((String)MOBLOG_SECRET_WORD, (HttpServletRequest)httpServletRequest);
            mailbox.setSecretWord(secretWord);
            String ignoreExpression = BlojsomUtils.getRequestValue((String)MOBLOG_IGNORE_EXPRESSION, (HttpServletRequest)httpServletRequest);
            mailbox.setIgnoreExpression(ignoreExpression);
            try {
                this.writeMoblogConfiguration(user.getId(), moblogConfigurationFile, mailbox);
                this.addOperationResultMessage(context, this.getAdminResource(UPDATED_MOBLOG_CONFIGURATION_KEY, UPDATED_MOBLOG_CONFIGURATION_KEY, user.getBlog().getBlogAdministrationLocale()));
            }
            catch (IOException e) {
                this._logger.error((Object)e);
                this.addOperationResultMessage(context, this.getAdminResource(FAILED_WRITE_MOBLOG_CONFIGURATION_KEY, FAILED_WRITE_MOBLOG_CONFIGURATION_KEY, user.getBlog().getBlogAdministrationLocale()));
            }
        } else if (ADD_AUTHORIZED_ADDRESS_ACTION.equals(action)) {
            String addressToAdd = BlojsomUtils.getRequestValue((String)MOBLOG_AUTHORIZED_ADDRESS, (HttpServletRequest)httpServletRequest);
            if (!BlojsomUtils.checkNullOrBlank((String)addressToAdd)) {
                Map authorizedEmailAddresses = mailbox.getAuthorizedAddresses();
                authorizedEmailAddresses.put(addressToAdd, addressToAdd);
                try {
                    this.writeAuthorizedEmailAddresssConfiguration(user.getId(), "moblog-authorization.properties", authorizedEmailAddresses);
                    this.addOperationResultMessage(context, this.formatAdminResource(ADDED_AUTHORIZED_EMAIL_KEY, ADDED_AUTHORIZED_EMAIL_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{addressToAdd}));
                }
                catch (IOException e) {
                    this._logger.error((Object)e);
                    this.addOperationResultMessage(context, this.getAdminResource(FAILED_ADD_EMAIL_KEY, FAILED_ADD_EMAIL_KEY, user.getBlog().getBlogAdministrationLocale()));
                }
            } else {
                this.addOperationResultMessage(context, this.getAdminResource(NO_EMAIL_ADDRESS_KEY, NO_EMAIL_ADDRESS_KEY, user.getBlog().getBlogAdministrationLocale()));
            }
        } else if (DELETE_AUTHORIZED_ADDRESS_ACTION.equals(action)) {
            String addressToDelete = BlojsomUtils.getRequestValue((String)MOBLOG_AUTHORIZED_ADDRESS, (HttpServletRequest)httpServletRequest);
            if (!BlojsomUtils.checkNullOrBlank((String)addressToDelete)) {
                Map authorizedEmailAddresses = mailbox.getAuthorizedAddresses();
                authorizedEmailAddresses.remove(addressToDelete);
                try {
                    this.writeAuthorizedEmailAddresssConfiguration(user.getId(), "moblog-authorization.properties", authorizedEmailAddresses);
                    this.addOperationResultMessage(context, this.formatAdminResource(REMOVED_AUTHORIZED_EMAIL_KEY, REMOVED_AUTHORIZED_EMAIL_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{addressToDelete}));
                }
                catch (IOException e) {
                    this._logger.error((Object)e);
                    this.addOperationResultMessage(context, this.getAdminResource(FAILED_DELETE_EMAIL_KEY, FAILED_DELETE_EMAIL_KEY, user.getBlog().getBlogAdministrationLocale()));
                }
            } else {
                this.addOperationResultMessage(context, this.getAdminResource(NO_EMAIL_ADDRESS_KEY, NO_EMAIL_ADDRESS_KEY, user.getBlog().getBlogAdministrationLocale()));
            }
        }
        context.put(BLOJSOM_PLUGIN_MOBLOG_MAILBOX, mailbox);
        return entries;
    }

    private void writeAuthorizedEmailAddresssConfiguration(String userID, String authorizationConfiguration, Map authorizedEmailAddresses) throws IOException {
        File emailConfigurationFile = new File(this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getBaseConfigurationDirectory() + userID + "/" + authorizationConfiguration);
        FileOutputStream fos = new FileOutputStream(emailConfigurationFile);
        Properties emailProperties = BlojsomUtils.mapToProperties((Map)authorizedEmailAddresses);
        emailProperties.store(fos, null);
        fos.close();
    }

    private void writeMoblogConfiguration(String userID, String moblogConfiguration, Mailbox mailbox) throws IOException {
        File moblogConfigurationFile = new File(this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getBaseConfigurationDirectory() + userID + "/" + moblogConfiguration);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(moblogConfigurationFile), "UTF-8"));
        bw.write(MOBLOG_HOSTNAME);
        bw.write("=");
        bw.write(BlojsomUtils.nullToBlank((String)mailbox.getHostName()));
        bw.write(BlojsomUtils.LINE_SEPARATOR);
        bw.write(MOBLOG_USERID);
        bw.write("=");
        bw.write(BlojsomUtils.nullToBlank((String)mailbox.getUserId()));
        bw.write(BlojsomUtils.LINE_SEPARATOR);
        bw.write(MOBLOG_PASSWORD);
        bw.write("=");
        bw.write(BlojsomUtils.nullToBlank((String)mailbox.getPassword()));
        bw.write(BlojsomUtils.LINE_SEPARATOR);
        bw.write(MOBLOG_CATEGORY);
        bw.write("=");
        bw.write(BlojsomUtils.nullToBlank((String)mailbox.getCategoryName()));
        bw.write(BlojsomUtils.LINE_SEPARATOR);
        bw.write(MOBLOG_ENABLED);
        bw.write("=");
        bw.write(Boolean.toString(mailbox.isEnabled()));
        bw.write(BlojsomUtils.LINE_SEPARATOR);
        bw.write("moblog-authorization");
        bw.write("=");
        bw.write("moblog-authorization.properties");
        bw.write(BlojsomUtils.LINE_SEPARATOR);
        bw.write(MOBLOG_TEXT_MIME_TYPES);
        bw.write("=");
        bw.write(mailbox.getTextMimeTypesAsStringList());
        bw.write(BlojsomUtils.LINE_SEPARATOR);
        bw.write(MOBLOG_ATTACHMENT_MIME_TYPES);
        bw.write("=");
        bw.write(mailbox.getAttachmentMimeTypesAsStringList());
        bw.write(BlojsomUtils.LINE_SEPARATOR);
        bw.write(MOBLOG_IMAGE_MIME_TYPES);
        bw.write("=");
        bw.write(mailbox.getImageMimeTypesAsStringList());
        bw.write(BlojsomUtils.LINE_SEPARATOR);
        bw.write(MOBLOG_SECRET_WORD);
        bw.write("=");
        bw.write(BlojsomUtils.nullToBlank((String)mailbox.getSecretWord()));
        bw.write(BlojsomUtils.LINE_SEPARATOR);
        bw.write(MOBLOG_IGNORE_EXPRESSION);
        bw.write("=");
        bw.write(BlojsomUtils.nullToBlank((String)mailbox.getIgnoreExpression()));
        bw.write(BlojsomUtils.LINE_SEPARATOR);
        bw.close();
    }
}

