/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.moderation;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.event.BlojsomEvent;
import org.blojsom.event.BlojsomListener;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.comment.event.CommentResponseSubmissionEvent;
import org.blojsom.plugin.response.event.ResponseSubmissionEvent;
import org.blojsom.plugin.trackback.event.TrackbackResponseSubmissionEvent;
import org.blojsom.util.BlojsomUtils;

public class LinkSpamModerationPlugin
implements BlojsomPlugin,
BlojsomListener {
    private Log _logger = LogFactory.getLog((Class)LinkSpamModerationPlugin.class);
    private static final Pattern LINK_PATTERN = Pattern.compile("<a.*?href=.*?>", 106);
    private static final String LINKSPAM_COMMENT_THRESHOLD = "linkspam-comment-threshold";
    private static final String LINKSPAM_TRACKBACK_THRESHOLD = "linkspam-trackback-threshold";
    private static final String DELETE_LINKSPAM = "delete-linkspam";
    private static final int DEFAULT_LINK_THRESHOLD = 3;
    private static final boolean DEFAULT_DELETE_LINKSPAM = false;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        blojsomConfiguration.getEventBroadcaster().addListener((BlojsomListener)this);
        this._logger.debug((Object)"Initialized link spam moderation plugin");
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }

    public void handleEvent(BlojsomEvent event) {
    }

    public void processEvent(BlojsomEvent event) {
        if (event instanceof ResponseSubmissionEvent) {
            ResponseSubmissionEvent responseSubmissionEvent = (ResponseSubmissionEvent)event;
            String text = responseSubmissionEvent.getContent();
            Map metaData = responseSubmissionEvent.getMetaData();
            if (!BlojsomUtils.checkNullOrBlank((String)text)) {
                Matcher linkMatcher = LINK_PATTERN.matcher(text);
                int linkCount = 0;
                while (linkMatcher.find()) {
                    ++linkCount;
                }
                int linkThreshold = 3;
                String thresholdProperty = "";
                if (responseSubmissionEvent instanceof CommentResponseSubmissionEvent) {
                    thresholdProperty = LINKSPAM_COMMENT_THRESHOLD;
                } else if (responseSubmissionEvent instanceof TrackbackResponseSubmissionEvent) {
                    thresholdProperty = LINKSPAM_TRACKBACK_THRESHOLD;
                }
                String thresholdPropertyValue = responseSubmissionEvent.getBlog().getBlog().getBlogProperty(thresholdProperty);
                if (BlojsomUtils.checkNullOrBlank((String)thresholdPropertyValue)) {
                    thresholdPropertyValue = Integer.toString(3);
                }
                String deleteLinkSpamPropertyValue = responseSubmissionEvent.getBlog().getBlog().getBlogProperty(DELETE_LINKSPAM);
                boolean deleteLinkSpam = false;
                try {
                    linkThreshold = Integer.parseInt(thresholdPropertyValue);
                }
                catch (NumberFormatException e) {
                    this._logger.error((Object)e);
                }
                deleteLinkSpam = Boolean.valueOf(deleteLinkSpamPropertyValue);
                if (linkCount >= linkThreshold) {
                    this._logger.debug((Object)("Exceeded threshold for links in response: " + linkCount + " > " + linkThreshold));
                    if (responseSubmissionEvent instanceof CommentResponseSubmissionEvent) {
                        if (!deleteLinkSpam) {
                            metaData.put("BLOJSOM_COMMENT_MODERATION_PLUGIN_APPROVED", Boolean.FALSE.toString());
                        } else {
                            metaData.put("BLOJSOM_PLUGIN_COMMENT_METADATA_DESTROY", Boolean.TRUE);
                        }
                    } else if (responseSubmissionEvent instanceof TrackbackResponseSubmissionEvent) {
                        if (!deleteLinkSpam) {
                            metaData.put("BLOJSOM_TRACKBACK_MODERATION_PLUGIN_APPROVED", Boolean.FALSE.toString());
                        } else {
                            metaData.put("BLOJSOM_PLUGIN_TRACKBACK_METADATA_DESTROY", Boolean.TRUE);
                        }
                    }
                }
            }
        }
    }
}

