/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.moderation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.event.BlojsomEvent;
import org.blojsom.event.BlojsomListener;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.comment.event.CommentResponseSubmissionEvent;
import org.blojsom.plugin.response.event.ResponseSubmissionEvent;
import org.blojsom.plugin.trackback.event.TrackbackResponseSubmissionEvent;
import org.blojsom.util.BlojsomUtils;

public class SpamPhraseModerationPlugin
implements BlojsomPlugin,
BlojsomListener {
    private Log _logger = LogFactory.getLog((Class)SpamPhraseModerationPlugin.class);
    private static final String SPAM_PHRASE_BLACKLIST_IP = "spam-phrase-blacklist";
    private static final String DEFAULT_SPAM_PHRASE_BLACKLIST_FILE = "spam-phrase-blacklist.properties";
    private static final String DELETE_PHRASESPAM = "delete-phrasespam";
    private static final boolean DEFAULT_DELETE_PHRASESPAM = false;
    private BlojsomConfiguration _blojsomConfiguration;
    private String _spamPhraseBlacklist = "spam-phrase-blacklist.properties";

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        blojsomConfiguration.getEventBroadcaster().addListener((BlojsomListener)this);
        this._blojsomConfiguration = blojsomConfiguration;
        String spamPhraseBlacklist = servletConfig.getInitParameter(SPAM_PHRASE_BLACKLIST_IP);
        if (!BlojsomUtils.checkNullOrBlank((String)spamPhraseBlacklist)) {
            this._spamPhraseBlacklist = spamPhraseBlacklist;
        }
        this._logger.debug((Object)"Initialized spam phrase blacklist plugin");
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }

    public void handleEvent(BlojsomEvent event) {
    }

    public void processEvent(BlojsomEvent event) {
        block16: {
            if (event instanceof ResponseSubmissionEvent) {
                ResponseSubmissionEvent responseSubmissionEvent = (ResponseSubmissionEvent)event;
                String content = responseSubmissionEvent.getContent();
                if (!BlojsomUtils.checkNullOrBlank((String)content)) {
                    File blacklistFile = new File(this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getBaseConfigurationDirectory() + "/" + responseSubmissionEvent.getBlog().getId() + "/" + this._spamPhraseBlacklist);
                    if (blacklistFile.exists()) {
                        try {
                            String phrase;
                            FileInputStream fis = new FileInputStream(blacklistFile);
                            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
                            ArrayList<String> spamPhrases = new ArrayList<String>(25);
                            while ((phrase = br.readLine()) != null) {
                                spamPhrases.add(phrase);
                            }
                            br.close();
                            boolean deletePhraseSpam = false;
                            Map metaData = responseSubmissionEvent.getMetaData();
                            String deletePhraseSpamValue = responseSubmissionEvent.getBlog().getBlog().getBlogProperty(DELETE_PHRASESPAM);
                            if (!BlojsomUtils.checkNullOrBlank((String)deletePhraseSpamValue)) {
                                deletePhraseSpam = Boolean.valueOf(deletePhraseSpamValue);
                            }
                            Iterator phraseIterator = spamPhrases.iterator();
                            boolean phraseSpamFound = false;
                            while (phraseIterator.hasNext()) {
                                phrase = (String)phraseIterator.next();
                                if (!content.matches(phrase) && content.indexOf(phrase) == -1) continue;
                                phraseSpamFound = true;
                                break;
                            }
                            if (!phraseSpamFound) break block16;
                            if (!deletePhraseSpam) {
                                this._logger.debug((Object)"Marking response for moderation");
                            } else {
                                this._logger.debug((Object)"Marking response for automatic deletion");
                            }
                            if (responseSubmissionEvent instanceof CommentResponseSubmissionEvent) {
                                if (!deletePhraseSpam) {
                                    metaData.put("BLOJSOM_COMMENT_MODERATION_PLUGIN_APPROVED", Boolean.FALSE.toString());
                                } else {
                                    metaData.put("BLOJSOM_PLUGIN_COMMENT_METADATA_DESTROY", Boolean.TRUE);
                                }
                                break block16;
                            }
                            if (!(responseSubmissionEvent instanceof TrackbackResponseSubmissionEvent)) break block16;
                            if (!deletePhraseSpam) {
                                metaData.put("BLOJSOM_TRACKBACK_MODERATION_PLUGIN_APPROVED", Boolean.FALSE.toString());
                                break block16;
                            }
                            metaData.put("BLOJSOM_PLUGIN_TRACKBACK_METADATA_DESTROY", Boolean.TRUE);
                        }
                        catch (IOException e) {
                            this._logger.error((Object)e);
                        }
                    } else {
                        this._logger.debug((Object)("Spam phrase blacklist not found: " + this._spamPhraseBlacklist));
                    }
                } else {
                    this._logger.debug((Object)"No content to evaluate for response");
                }
            }
        }
    }
}

