/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.security;

import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.blojsom.BlojsomException;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.admin.BaseAdminPlugin;

public class BasicAuthenticationPlugin
extends BaseAdminPlugin {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String WWW_AUTHENTICATE_HEADER = "WWW-Authenticate";
    private static final String BASIC_REALM_HEADER = "Basic realm=\"{0}\"";
    private static final String FAILED_AUTHORIZATION_PAGE = "/org/blojsom/plugin/security/templates/failed-authorization";

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        super.init(servletConfig, blojsomConfiguration);
    }

    protected void setAuthenticationRequired(HttpServletResponse httpServletResponse, BlogUser blogUser) {
        httpServletResponse.setStatus(401);
        httpServletResponse.setHeader(WWW_AUTHENTICATE_HEADER, MessageFormat.format(BASIC_REALM_HEADER, blogUser.getBlog().getBlogName()));
    }

    protected boolean decodeCredentialsAndAuthenticate(HttpServletRequest httpServletRequest, BlogUser blogUser) {
        String authorization = httpServletRequest.getHeader(AUTHORIZATION_HEADER);
        if (authorization != null) {
            String encodedCredentials = authorization.substring(6).trim();
            try {
                String usernameAndPassword = new String(Base64.decodeBase64((byte[])encodedCredentials.getBytes("UTF-8")));
                int colonIndex = usernameAndPassword.indexOf(":");
                if (colonIndex > 0) {
                    String username = usernameAndPassword.substring(0, colonIndex);
                    String password = usernameAndPassword.substring(colonIndex + 1);
                    try {
                        this._authorizationProvider.loadAuthenticationCredentials(blogUser);
                        this._authorizationProvider.authorize(blogUser, null, username, password);
                        return true;
                    }
                    catch (BlojsomException e) {
                        _logger.error((Object)e);
                        return false;
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                _logger.error((Object)e);
                return false;
            }
        }
        return false;
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        if (!this.decodeCredentialsAndAuthenticate(httpServletRequest, user)) {
            this.setAuthenticationRequired(httpServletResponse, user);
            httpServletRequest.setAttribute("page", (Object)FAILED_AUTHORIZATION_PAGE);
            return new BlogEntry[0];
        }
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }
}

