/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.weather;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.plugin.weather.beans.WeatherInformation;
import org.blojsom.util.BlojsomConstants;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WeatherFetcher {
    private Log _logger = LogFactory.getLog((Class)WeatherFetcher.class);
    private DocumentBuilder _documentBuilder;

    public WeatherFetcher() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setCoalescing(true);
        documentBuilderFactory.setNamespaceAware(false);
        try {
            this._documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            this._logger.error((Object)e);
        }
    }

    public WeatherInformation retrieveForecast(WeatherInformation provider) throws IllegalArgumentException, IOException {
        URL forecastUrl = new URL(provider.getProviderUrl());
        URLConnection connection = forecastUrl.openConnection();
        if (!(connection instanceof HttpURLConnection)) {
            throw new IllegalArgumentException(forecastUrl.toExternalForm() + " is not a valid HTTP Url");
        }
        HttpURLConnection httpConnection = (HttpURLConnection)connection;
        httpConnection.setRequestProperty("Accept-Encoding", "gzip");
        httpConnection.setRequestProperty("User-Agent", "Blojsom Weather Plugin/1.0");
        httpConnection.connect();
        InputStream is = connection.getInputStream();
        BufferedInputStream bis = "gzip".equalsIgnoreCase(httpConnection.getContentEncoding()) ? new BufferedInputStream(new GZIPInputStream(is)) : new BufferedInputStream(is);
        StringBuffer buffer = new StringBuffer();
        BufferedReader br = new BufferedReader(new InputStreamReader(bis));
        String input = null;
        while ((input = br.readLine()) != null) {
            buffer.append(input).append(BlojsomConstants.LINE_SEPARATOR);
        }
        try {
            Document document = this._documentBuilder.parse(new InputSource(new StringReader(buffer.toString())));
            provider.parseDocument(document);
        }
        catch (SAXException e) {
            this._logger.error((Object)e);
        }
        bis.close();
        return provider;
    }
}

