/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.weather;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.weather.Weather;

public class WeatherPluginUtils {
    private static Log _logger = LogFactory.getLog((Class)WeatherPluginUtils.class);

    public static Weather readWeatherSettingsForUser(BlojsomConfiguration blojsomConfiguration, ServletConfig servletConfig, BlogUser blogUser) {
        String weatherConfiguration = servletConfig.getInitParameter("plugin-weather");
        Weather weather = new Weather();
        weather.setEnabled(true);
        String user = blogUser.getId();
        Properties weatherProperties = new Properties();
        String configurationFile = blojsomConfiguration.getBaseConfigurationDirectory() + user + "/" + weatherConfiguration;
        InputStream is = servletConfig.getServletContext().getResourceAsStream(configurationFile);
        if (is == null) {
            _logger.info((Object)("No weather configuration file found: " + configurationFile));
        } else {
            try {
                weatherProperties.load(is);
                is.close();
                if (weatherProperties.size() > 0) {
                    weather.setBlogUser(blogUser);
                    String stationCode = weatherProperties.getProperty("weather-station-code", "KSJC");
                    String providerClass = weatherProperties.getProperty("weather-provider", "org.blojsom.plugin.weather.beans.NWSInformation");
                    weather.setStationCode(stationCode);
                    weather.setProviderClass(providerClass);
                }
            }
            catch (IOException e) {
                _logger.error((Object)e);
                return null;
            }
        }
        return weather;
    }
}

