/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.blog;

import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlojsomConfigurationException;
import org.blojsom.util.BlojsomConstants;
import org.blojsom.util.BlojsomUtils;

public class Blog
implements BlojsomConstants {
    private Log _logger = LogFactory.getLog((Class)Blog.class);
    private String _blogHome;
    private String _blogName;
    private String _blogDescription;
    private String _blogURL;
    private String _blogAdminURL;
    private String _blogBaseURL;
    private String _blogCountry;
    private String _blogLanguage;
    private String _blogAdministrationLocale;
    private String[] _blogFileExtensions;
    private String[] _blogPropertiesExtensions;
    private int _blogDepth;
    private int _blogDisplayEntries;
    private String[] _blogDefaultCategoryMappings;
    private String[] _blogDirectoryFilter;
    private String _blogOwner;
    private String _blogOwnerEmail;
    private String _blogCommentsDirectory;
    private Boolean _blogCommentsEnabled;
    private Boolean _blogEmailEnabled;
    private Boolean _blogTrackbacksEnabled;
    private Boolean _blogPingbacksEnabled;
    private String _blogTrackbackDirectory;
    private String _blogEntryMetaDataExtension;
    private String _blogFileEncoding;
    private String _blogDefaultFlavor;
    private Boolean _linearNavigationEnabled;
    private Boolean _xmlrpcEnabled;
    private String _blogPingbacksDirectory;
    private Boolean _useEncryptedPasswords;
    private String _digestAlgorithm;
    private Map _blogProperties = new HashMap();
    private Map _authorization = null;

    public Blog(Properties blogConfiguration) throws BlojsomConfigurationException {
        Iterator<Object> keyIterator = blogConfiguration.keySet().iterator();
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            String propertyValue = blogConfiguration.getProperty(key);
            this._blogProperties.put(key, propertyValue);
        }
        this._blogHome = blogConfiguration.getProperty("blog-home");
        if (BlojsomUtils.checkNullOrBlank(this._blogHome)) {
            this._logger.error((Object)"No value supplied for blog-home");
            throw new BlojsomConfigurationException("No valued supplied for blog-home");
        }
        this._blogHome = this._blogHome.trim();
        if (!this._blogHome.endsWith("/")) {
            this._blogHome = this._blogHome + "/";
        }
        this._blogProperties.put("blog-home", this._blogHome);
        this._blogLanguage = blogConfiguration.getProperty("blog-language");
        if (this._blogLanguage == null) {
            this._logger.info((Object)"No value supplied for blog-language. Defaulting to: en");
            this._blogLanguage = "en";
        }
        this._blogProperties.put("blog-language", this._blogLanguage);
        this._blogCountry = blogConfiguration.getProperty("blog-country");
        if (this._blogCountry == null) {
            this._logger.info((Object)"No value supplied for blog-country. Defaulting to: US");
            this._blogCountry = "US";
        }
        this._blogProperties.put("blog-country", this._blogCountry);
        this._blogDescription = blogConfiguration.getProperty("blog-description");
        if (this._blogDescription == null) {
            this._logger.info((Object)"No value supplied for blog-description");
            this._blogDescription = "";
        }
        this._blogProperties.put("blog-description", this._blogDescription);
        this._blogName = blogConfiguration.getProperty("blog-name");
        if (this._blogName == null) {
            this._logger.info((Object)"No value supplied for blog-name");
            this._blogName = "";
        }
        this._blogProperties.put("blog-name", this._blogName);
        this._blogDepth = Integer.parseInt(blogConfiguration.getProperty("blog-directory-depth", Integer.toString(-1)));
        this._blogProperties.put("blog-directory-depth", new Integer(this._blogDepth));
        this._blogURL = blogConfiguration.getProperty("blog-url");
        if (BlojsomUtils.checkNullOrBlank(this._blogURL)) {
            this._logger.info((Object)"No value supplied for blog-url");
        } else if (!this._blogURL.endsWith("/")) {
            this._blogURL = this._blogURL + "/";
        }
        this._blogProperties.put("blog-url", this._blogURL);
        this._blogAdminURL = blogConfiguration.getProperty("blog-admin-url");
        if (BlojsomUtils.checkNullOrBlank(this._blogAdminURL)) {
            this._logger.info((Object)"No value supplied for blog-admin-url");
            this._blogAdminURL = this._blogURL;
        } else if (!this._blogAdminURL.endsWith("/")) {
            this._blogAdminURL = this._blogAdminURL + "/";
        }
        this._blogProperties.put("blog-admin-url", this._blogAdminURL);
        this._blogBaseURL = blogConfiguration.getProperty("blog-base-url");
        if (BlojsomUtils.checkNullOrBlank(this._blogBaseURL)) {
            this._logger.info((Object)"No value supplied for blog-base-url");
        } else if (this._blogBaseURL.endsWith("/")) {
            this._blogBaseURL = this._blogBaseURL.substring(0, this._blogBaseURL.length() - 1);
        }
        this._blogProperties.put("blog-base-url", this._blogBaseURL);
        this._blogFileExtensions = BlojsomUtils.parseCommaList(blogConfiguration.getProperty("blog-file-extensions"));
        this._blogProperties.put("blog-file-extensions", blogConfiguration.getProperty("blog-file-extensions"));
        String blogPropertiesExtensions = blogConfiguration.getProperty("blog-properties-extensions");
        if (BlojsomUtils.checkNullOrBlank(blogPropertiesExtensions)) {
            this._blogPropertiesExtensions = DEFAULT_PROPERTIES_EXTENSIONS;
        }
        this._blogPropertiesExtensions = BlojsomUtils.parseCommaList(blogPropertiesExtensions);
        this._blogProperties.put("blog-properties-extensions", this._blogPropertiesExtensions);
        this._blogEntryMetaDataExtension = blogConfiguration.getProperty("blog-entry-meta-data-extension");
        this._blogProperties.put("blog-entry-meta-data-extension", this._blogEntryMetaDataExtension);
        this._blogDisplayEntries = Integer.parseInt(blogConfiguration.getProperty("blog-entries-display", Integer.toString(-1)));
        this._blogProperties.put("blog-entries-display", new Integer(this._blogDisplayEntries));
        String blogDefaultCategoryMapping = blogConfiguration.getProperty("blog-default-category-mapping");
        if (BlojsomUtils.checkNullOrBlank(blogDefaultCategoryMapping)) {
            this._blogDefaultCategoryMappings = null;
            this._logger.debug((Object)"No mapping supplied for the default category '/'");
        } else {
            this._blogDefaultCategoryMappings = BlojsomUtils.parseCommaList(blogDefaultCategoryMapping);
            this._logger.debug((Object)(this._blogDefaultCategoryMappings.length + " directories mapped to the default category '/'"));
            if (this._blogDefaultCategoryMappings.length == 0) {
                this._blogDefaultCategoryMappings = null;
            }
        }
        this._blogProperties.put("blog-default-category-mapping", blogDefaultCategoryMapping);
        this._blogCommentsDirectory = blogConfiguration.getProperty("blog-comments-directory");
        if (this._blogCommentsDirectory == null || "".equals(this._blogCommentsDirectory)) {
            this._blogCommentsDirectory = ".comments";
        }
        this._logger.debug((Object)("blojsom comments directory: " + this._blogCommentsDirectory));
        this._blogProperties.put("blog-comments-directory", this._blogCommentsDirectory);
        String commentsDirectoryRegex = ".*" + File.separator + this._blogCommentsDirectory;
        this._blogTrackbackDirectory = blogConfiguration.getProperty("blog-trackbacks-directory");
        if (this._blogTrackbackDirectory == null || "".equals(this._blogTrackbackDirectory)) {
            this._blogTrackbackDirectory = ".trackbacks";
        }
        this._logger.debug((Object)("blojsom trackback directory: " + this._blogTrackbackDirectory));
        this._blogProperties.put("blog-trackbacks-directory", this._blogTrackbackDirectory);
        String trackbackDirectoryRegex = ".*" + File.separator + this._blogTrackbackDirectory;
        this._blogPingbacksDirectory = blogConfiguration.getProperty("blog-pingbacks-directory");
        if (BlojsomUtils.checkNullOrBlank(this._blogPingbacksDirectory)) {
            this._blogPingbacksDirectory = ".pingbacks";
        }
        this._logger.debug((Object)("blojsom pingbacks directory: " + this._blogPingbacksDirectory));
        this._blogProperties.put("blog-pingbacks-directory", this._blogPingbacksDirectory);
        String pingbacksDirectoryRegex = ".*" + File.separator + this._blogPingbacksDirectory;
        String blogDirectoryFilter = blogConfiguration.getProperty("blog-directory-filter");
        if (BlojsomUtils.checkNullOrBlank(blogDirectoryFilter)) {
            blogDirectoryFilter = commentsDirectoryRegex + ", " + trackbackDirectoryRegex + ", " + pingbacksDirectoryRegex;
        } else {
            if (blogDirectoryFilter.indexOf(commentsDirectoryRegex) == -1) {
                blogDirectoryFilter = blogDirectoryFilter + ", " + commentsDirectoryRegex;
            }
            if (blogDirectoryFilter.indexOf(trackbackDirectoryRegex) == -1) {
                blogDirectoryFilter = blogDirectoryFilter + ", " + trackbackDirectoryRegex;
            }
            if (blogDirectoryFilter.indexOf(pingbacksDirectoryRegex) == -1) {
                blogDirectoryFilter = blogDirectoryFilter + ", " + pingbacksDirectoryRegex;
            }
        }
        this._logger.debug((Object)("Comments directory regex: " + commentsDirectoryRegex));
        this._logger.debug((Object)("Trackbacks directory regex: " + trackbackDirectoryRegex));
        this._logger.debug((Object)("Pingbacks directory regex: " + pingbacksDirectoryRegex));
        this._blogDirectoryFilter = BlojsomUtils.parseCommaList(blogDirectoryFilter);
        for (int i = 0; i < this._blogDirectoryFilter.length; ++i) {
            this._logger.debug((Object)("blojsom to filter: " + this._blogDirectoryFilter[i]));
        }
        this._logger.debug((Object)("blojsom filtering " + this._blogDirectoryFilter.length + " directories"));
        this._blogProperties.put("blog-directory-filter", this._blogDirectoryFilter);
        this._blogOwner = blogConfiguration.getProperty("blog-owner");
        this._blogProperties.put("blog-owner", this._blogOwner);
        this._blogOwnerEmail = blogConfiguration.getProperty("blog-owner-email");
        this._blogProperties.put("blog-owner-email", this._blogOwnerEmail);
        String blogCommentsEnabled = blogConfiguration.getProperty("blog-comments-enabled");
        this._blogCommentsEnabled = Boolean.valueOf(blogCommentsEnabled);
        this._blogProperties.put("blog-comments-enabled", this._blogCommentsEnabled);
        String blogTrackbacksEnabled = blogConfiguration.getProperty("blog-trackbacks-enabled");
        this._blogTrackbacksEnabled = Boolean.valueOf(blogTrackbacksEnabled);
        this._blogProperties.put("blog-trackbacks-enabled", this._blogTrackbacksEnabled);
        String blogPingbacksEnabled = blogConfiguration.getProperty("blog-pingbacks-enabled");
        this._blogPingbacksEnabled = Boolean.valueOf(blogPingbacksEnabled);
        this._blogProperties.put("blog-pingbacks-enabled", this._blogPingbacksEnabled);
        String blogEmailEnabled = blogConfiguration.getProperty("blog-email-enabled");
        this._blogEmailEnabled = "true".equalsIgnoreCase(blogEmailEnabled) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        this._blogProperties.put("blog-email-enabled", this._blogEmailEnabled);
        String blogFileEncoding = blogConfiguration.getProperty("blog-file-encoding");
        if (BlojsomUtils.checkNullOrBlank(blogFileEncoding)) {
            blogFileEncoding = "UTF-8";
        }
        this._blogFileEncoding = blogFileEncoding;
        this._blogProperties.put("blog-file-encoding", blogFileEncoding);
        String blogDefaultFlavor = blogConfiguration.getProperty("blog-default-flavor");
        if (BlojsomUtils.checkNullOrBlank(blogDefaultFlavor)) {
            blogDefaultFlavor = "html";
        }
        this._blogDefaultFlavor = blogDefaultFlavor;
        this._blogProperties.put("blog-default-flavor", this._blogDefaultFlavor);
        String linearNavigationEnabled = blogConfiguration.getProperty("linear-navigation-enabled");
        this._linearNavigationEnabled = Boolean.valueOf(linearNavigationEnabled);
        this._blogProperties.put("linear-navigation-enabled", this._linearNavigationEnabled);
        String xmlrpcEnabled = blogConfiguration.getProperty("xmlrpc-enabled");
        if (BlojsomUtils.checkNullOrBlank(xmlrpcEnabled)) {
            xmlrpcEnabled = "true";
        }
        this._xmlrpcEnabled = Boolean.valueOf(xmlrpcEnabled);
        this._blogProperties.put("xmlrpc-enabled", this._xmlrpcEnabled);
        String blogAdministrationLocale = blogConfiguration.getProperty("blog-administration-locale");
        if (BlojsomUtils.checkNullOrBlank(blogAdministrationLocale)) {
            blogAdministrationLocale = "en_US";
        }
        this._blogAdministrationLocale = blogAdministrationLocale;
        this._blogProperties.put("blog-administration-locale", this._blogAdministrationLocale);
        String useEncryptedPasswords = blogConfiguration.getProperty("use-encrypted-passwords");
        this._useEncryptedPasswords = Boolean.valueOf(useEncryptedPasswords);
        this._blogProperties.put("use-encrypted-passwords", this._useEncryptedPasswords);
        String digestAlgorithm = blogConfiguration.getProperty("digest-algorithm");
        if (BlojsomUtils.checkNullOrBlank(digestAlgorithm)) {
            digestAlgorithm = "MD5";
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(digestAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            digestAlgorithm = "MD5";
        }
        this._digestAlgorithm = digestAlgorithm;
        this._blogProperties.put("digest-algorithm", this._digestAlgorithm);
        this._logger.info((Object)("blojsom home: " + this._blogHome));
    }

    public boolean checkAuthorization(String username, String password) {
        return false;
    }

    public String getAuthorizedUserEmail(String username) {
        if (this._authorization.containsKey(username)) {
            String[] parsedPasswordAndEmail = BlojsomUtils.parseLastComma((String)this._authorization.get(username));
            if (parsedPasswordAndEmail.length < 2) {
                return this.getBlogOwnerEmail();
            }
            return parsedPasswordAndEmail[1];
        }
        return null;
    }

    public void setAuthorizedUserEmail(String username, String email) {
        if (this._authorization.containsKey(username)) {
            String[] parsedPasswordAndEmail = BlojsomUtils.parseLastComma((String)this._authorization.get(username));
            StringBuffer updatedPasswordAndEmail = new StringBuffer();
            updatedPasswordAndEmail.append(parsedPasswordAndEmail[0]);
            updatedPasswordAndEmail.append(",");
            updatedPasswordAndEmail.append(email);
            this._authorization.put(username, updatedPasswordAndEmail.toString());
            this._logger.debug((Object)("Set authorized user: " + username + " with e-mail address: " + email));
        }
    }

    public void setAuthorizedUserPassword(String username, String password) {
        if (this._authorization.containsKey(username)) {
            String[] parsedPasswordAndEmail = BlojsomUtils.parseLastComma((String)this._authorization.get(username));
            StringBuffer updatedPasswordAndEmail = new StringBuffer();
            updatedPasswordAndEmail.append(password);
            if (parsedPasswordAndEmail.length == 2) {
                updatedPasswordAndEmail.append(",");
                updatedPasswordAndEmail.append(parsedPasswordAndEmail[1]);
            }
            this._authorization.put(username, updatedPasswordAndEmail.toString());
        } else {
            this._authorization.put(username, password + ",");
        }
    }

    public String getBlogHome() {
        return this._blogHome;
    }

    public String[] getBlogFileExtensions() {
        return this._blogFileExtensions;
    }

    public String[] getBlogPropertiesExtensions() {
        return this._blogPropertiesExtensions;
    }

    public int getBlogDepth() {
        return this._blogDepth;
    }

    public String getBlogName() {
        return this._blogName;
    }

    public String getEscapedBlogName() {
        return BlojsomUtils.escapeString(this._blogName);
    }

    public String getBlogDescription() {
        return this._blogDescription;
    }

    public String getEscapedBlogDescription() {
        return BlojsomUtils.escapeString(this._blogDescription);
    }

    public String getBlogURL() {
        return this._blogURL;
    }

    public String getBlogAdminURL() {
        return this._blogAdminURL;
    }

    public String getBlogBaseURL() {
        return this._blogBaseURL;
    }

    public String getBlogLanguage() {
        return this._blogLanguage;
    }

    public String getBlogCountry() {
        return this._blogCountry;
    }

    public int getBlogDisplayEntries() {
        return this._blogDisplayEntries;
    }

    public String[] getBlogDefaultCategoryMappings() {
        return this._blogDefaultCategoryMappings;
    }

    public String getBlogDefaultCategoryMappingsAsString() {
        if (this._blogDefaultCategoryMappings == null) {
            return "";
        }
        return BlojsomUtils.arrayOfStringsToString(this._blogDefaultCategoryMappings);
    }

    public boolean setAuthorization(Map authorization) {
        boolean result = false;
        this._authorization = authorization;
        return result;
    }

    public Map getAuthorization() {
        return this._authorization;
    }

    public String getBlogOwnerEmail() {
        return this._blogOwnerEmail;
    }

    public String getBlogOwner() {
        return this._blogOwner;
    }

    public Map getBlogProperties() {
        return Collections.unmodifiableMap(this._blogProperties);
    }

    public String getBlogCommentsDirectory() {
        return this._blogCommentsDirectory;
    }

    public String[] getBlogDirectoryFilter() {
        return this._blogDirectoryFilter;
    }

    public String getBlogTrackbackDirectory() {
        return this._blogTrackbackDirectory;
    }

    public String getBlogPingbacksDirectory() {
        return this._blogPingbacksDirectory;
    }

    public Boolean getBlogCommentsEnabled() {
        return this._blogCommentsEnabled;
    }

    public Boolean getBlogTrackbacksEnabled() {
        return this._blogTrackbacksEnabled;
    }

    public Boolean getBlogPingbacksEnabled() {
        return this._blogPingbacksEnabled;
    }

    public Boolean getBlogEmailEnabled() {
        return this._blogEmailEnabled;
    }

    public String getBlogEntryMetaDataExtension() {
        return this._blogEntryMetaDataExtension;
    }

    public String getBlogFileEncoding() {
        return this._blogFileEncoding;
    }

    public String getBlogProperty(String propertyName) {
        if (this._blogProperties.containsKey(propertyName)) {
            return this._blogProperties.get(propertyName).toString();
        }
        return null;
    }

    public String getBlogDefaultFlavor() {
        return this._blogDefaultFlavor;
    }

    public void setBlogName(String blogName) {
        this._blogName = blogName;
        this._blogProperties.put("blog-name", blogName);
    }

    public void setBlogDescription(String blogDescription) {
        this._blogDescription = blogDescription;
        this._blogProperties.put("blog-description", blogDescription);
    }

    public void setBlogURL(String blogURL) {
        this._blogURL = blogURL;
        this._blogProperties.put("blog-url", blogURL);
    }

    public void setAdminBlogURL(String blogAdminURL) {
        this._blogAdminURL = blogAdminURL;
        this._blogProperties.put("blog-admin-url", blogAdminURL);
    }

    public void setBlogBaseURL(String blogBaseURL) {
        this._blogBaseURL = blogBaseURL;
        this._blogProperties.put("blog-base-url", blogBaseURL);
    }

    public void setBlogCountry(String blogCountry) {
        this._blogCountry = blogCountry;
        this._blogProperties.put("blog-country", blogCountry);
    }

    public void setBlogLanguage(String blogLanguage) {
        this._blogLanguage = blogLanguage;
        this._blogProperties.put("blog-language", blogLanguage);
    }

    public void setBlogDepth(int blogDepth) {
        this._blogDepth = blogDepth;
        this._blogProperties.put("blog-directory-depth", new Integer(blogDepth));
    }

    public void setBlogDisplayEntries(int blogDisplayEntries) {
        this._blogDisplayEntries = blogDisplayEntries;
        this._blogProperties.put("blog-entries-display", new Integer(blogDisplayEntries));
    }

    public void setBlogDefaultCategoryMappings(String[] blogDefaultCategoryMappings) {
        this._blogDefaultCategoryMappings = blogDefaultCategoryMappings;
        this._blogProperties.put("blog-default-category-mapping", blogDefaultCategoryMappings);
    }

    public void setBlogOwner(String blogOwner) {
        this._blogOwner = blogOwner;
        this._blogProperties.put("blog-owner", blogOwner);
    }

    public void setBlogOwnerEmail(String blogOwnerEmail) {
        this._blogOwnerEmail = blogOwnerEmail;
        this._blogProperties.put("blog-owner-email", blogOwnerEmail);
    }

    public void setBlogCommentsEnabled(Boolean blogCommentsEnabled) {
        this._blogCommentsEnabled = blogCommentsEnabled;
        this._blogProperties.put("blog-comments-enabled", blogCommentsEnabled);
    }

    public void setBlogEmailEnabled(Boolean blogEmailEnabled) {
        this._blogEmailEnabled = blogEmailEnabled;
        this._blogProperties.put("blog-email-enabled", blogEmailEnabled);
    }

    public void setBlogTrackbacksEnabled(Boolean blogTrackbacksEnabled) {
        this._blogTrackbacksEnabled = blogTrackbacksEnabled;
        this._blogProperties.put("blog-trackbacks-enabled", blogTrackbacksEnabled);
    }

    public void setBlogPingbacksEnabled(Boolean blogPingbacksEnabled) {
        this._blogPingbacksEnabled = blogPingbacksEnabled;
        this._blogProperties.put("blog-pingbacks-enabled", blogPingbacksEnabled);
    }

    public void setBlogFileEncoding(String blogFileEncoding) {
        this._blogFileEncoding = blogFileEncoding;
        this._blogProperties.put("blog-file-encoding", blogFileEncoding);
    }

    public void setBlogDefaultCategoryMappingForFlavor(String flavorKey, String blogDefaultCategoryMapping) {
        if (flavorKey.endsWith("blog-default-category-mapping")) {
            this._blogProperties.put(flavorKey, blogDefaultCategoryMapping);
        }
    }

    public void setBlogFileExtensions(String blogFileExtensions) {
        this._blogFileExtensions = BlojsomUtils.parseCommaList(blogFileExtensions);
        this._blogProperties.put("blog-file-extensions", blogFileExtensions);
    }

    public void setBlogDefaultFlavor(String blogDefaultFlavor) {
        this._blogDefaultFlavor = blogDefaultFlavor;
        this._blogProperties.put("blog-default-flavor", this._blogDefaultFlavor);
    }

    public void setBlogProperty(String key, String value) {
        if (!(key == null || value == null || key.equals("blog-home") || key.equals("blog-comments-directory") || key.equals("blog-trackbacks-directory") || key.equals("blog-pingbacks-directory"))) {
            this._blogProperties.put(key, value);
        }
    }

    public Boolean getLinearNavigationEnabled() {
        return this._linearNavigationEnabled;
    }

    public void setLinearNavigationEnabled(Boolean linearNavigationEnabled) {
        this._linearNavigationEnabled = linearNavigationEnabled;
        this._blogProperties.put("linear-navigation-enabled", this._linearNavigationEnabled);
    }

    public Boolean getXmlrpcEnabled() {
        return this._xmlrpcEnabled;
    }

    public void setXmlrpcEnabled(Boolean xmlrpcEnabled) {
        this._xmlrpcEnabled = xmlrpcEnabled;
        this._blogProperties.put("xmlrpc-enabled", this._xmlrpcEnabled);
    }

    public String getBlogAdministrationLocaleAsString() {
        return this._blogAdministrationLocale;
    }

    public Locale getBlogAdministrationLocale() {
        return BlojsomUtils.getLocaleFromString(this._blogAdministrationLocale);
    }

    public void setBlogAdministrationLocale(String blogAdministrationLocale) {
        this._blogAdministrationLocale = blogAdministrationLocale;
        this._blogProperties.put("blog-administration-locale", this._blogAdministrationLocale);
    }

    public Locale getBlogLocale() {
        return new Locale(this._blogLanguage, this._blogCountry);
    }

    public Boolean getUseEncryptedPasswords() {
        return this._useEncryptedPasswords;
    }

    public void setUseEncryptedPasswords(Boolean useEncryptedPasswords) {
        this._useEncryptedPasswords = useEncryptedPasswords;
    }

    public void setBlogAdminURL(String blogAdminURL) {
        this._blogAdminURL = blogAdminURL;
        this._blogProperties.put("blog-admin-url", blogAdminURL);
    }

    public String getDigestAlgorithm() {
        return this._digestAlgorithm;
    }

    public void setDigestAlgorithm(String digestAlgorithm) {
        if (BlojsomUtils.checkNullOrBlank(digestAlgorithm)) {
            digestAlgorithm = "MD5";
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(digestAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            digestAlgorithm = "MD5";
        }
        this._digestAlgorithm = digestAlgorithm;
        this._blogProperties.put("digest-algorithm", this._digestAlgorithm);
    }
}

