/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.blog;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.BlojsomException;
import org.blojsom.authorization.AuthorizationProvider;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfigurationException;
import org.blojsom.event.BlojsomEventBroadcaster;
import org.blojsom.event.BlojsomListener;
import org.blojsom.util.BlojsomConstants;
import org.blojsom.util.BlojsomProperties;
import org.blojsom.util.BlojsomUtils;

public class BlojsomConfiguration
implements BlojsomConstants {
    private Log _logger = LogFactory.getLog((Class)BlojsomConfiguration.class);
    private String _blojsomUsers;
    private String _defaultUser;
    private String _baseConfigurationDirectory;
    private String _fetcherClass;
    private String _installationDirectory;
    private String _templatesDirectory;
    private String _resourceDirectory;
    private String _qualifiedResourceDirectory;
    private String _resourceManager;
    private String _authorizationProviderClass;
    private static AuthorizationProvider _authorizationProvider = null;
    private String _globalBlogHome;
    private static BlojsomEventBroadcaster _eventBroadcaster = null;
    private String _installedLocales;
    private ServletConfig _servletConfig;
    private Map _blogUsers;
    private Map _blojsomConfiguration;
    private Map _blogIDs;

    public BlojsomConfiguration(ServletConfig servletConfig, Map blojsomConfiguration) throws BlojsomConfigurationException {
        String[] users;
        Object listOfUsers;
        this._blojsomConfiguration = blojsomConfiguration;
        this._servletConfig = servletConfig;
        this._installationDirectory = servletConfig.getServletContext().getRealPath("/");
        if (BlojsomUtils.checkNullOrBlank(this._installationDirectory)) {
            this._logger.error((Object)"No installation directory set for blojsom");
            throw new BlojsomConfigurationException("No installation directory set for blojsom");
        }
        if (!this._installationDirectory.endsWith("/")) {
            this._installationDirectory = this._installationDirectory + "/";
        }
        try {
            System.setProperty("blojsom.installation.directory", this._installationDirectory);
        }
        catch (Exception e) {
            this._logger.error((Object)e);
        }
        this._logger.debug((Object)("Using installation directory: " + this._installationDirectory));
        this._baseConfigurationDirectory = this.getBlojsomPropertyAsString("blojsom-configuration-base-directory");
        this._baseConfigurationDirectory = BlojsomUtils.checkNullOrBlank(this._baseConfigurationDirectory) ? "/WEB-INF/" : BlojsomUtils.checkStartingAndEndingSlash(this._baseConfigurationDirectory);
        this._baseConfigurationDirectory = this._baseConfigurationDirectory.trim();
        this._logger.debug((Object)("Using base configuration directory: " + this._baseConfigurationDirectory));
        this._templatesDirectory = this.getBlojsomPropertyAsString("blojsom-templates-directory");
        if (BlojsomUtils.checkNullOrBlank(this._templatesDirectory)) {
            this._templatesDirectory = "/templates";
        } else if (!this._templatesDirectory.startsWith("/")) {
            this._templatesDirectory = '/' + this._templatesDirectory;
        }
        this._templatesDirectory = this._templatesDirectory.trim();
        this._logger.debug((Object)("Using templates directory: " + this._templatesDirectory));
        this._resourceDirectory = this.getBlojsomPropertyAsString("blojsom-resource-directory");
        if (BlojsomUtils.checkNullOrBlank(this._resourceDirectory)) {
            this._resourceDirectory = "/resources";
        } else if (!this._resourceDirectory.startsWith("/")) {
            this._resourceDirectory = '/' + this._resourceDirectory;
        }
        this._resourceDirectory = this._resourceDirectory.trim();
        this._logger.debug((Object)("Using resources directory: " + this._resourceDirectory));
        String eventBroadcaster = this.getBlojsomPropertyAsString("blojsom-broadcaster");
        if (BlojsomUtils.checkNullOrBlank(eventBroadcaster)) {
            eventBroadcaster = "org.blojsom.event.SimpleBlojsomEventBroadcaster";
        }
        try {
            Class<?> broadcasterClass = Class.forName(eventBroadcaster);
            if (_eventBroadcaster == null) {
                _eventBroadcaster = (BlojsomEventBroadcaster)broadcasterClass.newInstance();
            }
            this._logger.debug((Object)("Using event broadcaster: " + eventBroadcaster));
            String listenerConfiguration = servletConfig.getInitParameter("listener-configuration");
            if (!BlojsomUtils.checkNullOrBlank(listenerConfiguration)) {
                Properties listenerProperties = BlojsomUtils.loadProperties(servletConfig, "listener-configuration", true);
                Iterator<Object> listenerIterator = listenerProperties.keySet().iterator();
                while (listenerIterator.hasNext()) {
                    Object key = listenerIterator.next();
                    String listenerClassname = listenerProperties.getProperty(key.toString());
                    Class<?> listenerClass = Class.forName(listenerClassname);
                    BlojsomListener listener = (BlojsomListener)listenerClass.newInstance();
                    _eventBroadcaster.addListener(listener);
                }
            }
        }
        catch (BlojsomException e) {
            this._logger.error((Object)e);
            throw new BlojsomConfigurationException(e);
        }
        catch (ClassNotFoundException e) {
            this._logger.error((Object)e);
            throw new BlojsomConfigurationException("Unable to instantiate event broadcaster: " + eventBroadcaster, e);
        }
        catch (InstantiationException e) {
            this._logger.error((Object)e);
            throw new BlojsomConfigurationException("Unable to instantiate event broadcaster: " + eventBroadcaster, e);
        }
        catch (IllegalAccessException e) {
            this._logger.error((Object)e);
            throw new BlojsomConfigurationException("Unable to instantiate event broadcaster: " + eventBroadcaster, e);
        }
        this._qualifiedResourceDirectory = servletConfig.getServletContext().getRealPath(this._resourceDirectory);
        this._logger.debug((Object)("Using qualified resource directory: " + this._qualifiedResourceDirectory));
        this._globalBlogHome = this.getBlojsomPropertyAsString("blojsom-blog-home");
        if (!BlojsomUtils.checkNullOrBlank(this._globalBlogHome)) {
            if (this._globalBlogHome.startsWith("{")) {
                int closingBraceIndex = this._globalBlogHome.indexOf("}");
                String property = this._globalBlogHome.substring(1, closingBraceIndex);
                if (BlojsomUtils.checkNullOrBlank(property = System.getProperty(property))) {
                    this._logger.error((Object)("Global blog home directory property not found: " + property));
                    this._globalBlogHome = null;
                } else {
                    String afterProperty = this._globalBlogHome.substring(closingBraceIndex + 1);
                    this._globalBlogHome = property + afterProperty;
                    this._globalBlogHome = BlojsomUtils.replace(this._globalBlogHome, "\\", "/");
                }
            }
            if (!BlojsomUtils.checkNullOrBlank(this._globalBlogHome)) {
                File blogHomeDirectory;
                this._globalBlogHome = this._globalBlogHome.trim();
                if (!this._globalBlogHome.endsWith("/")) {
                    this._globalBlogHome = this._globalBlogHome + "/";
                }
                if (!(blogHomeDirectory = new File(this._globalBlogHome)).exists() && !blogHomeDirectory.mkdirs()) {
                    this._logger.error((Object)("Unable to create global blog home directory: " + this._globalBlogHome));
                    this._globalBlogHome = null;
                }
            }
            if (!BlojsomUtils.checkNullOrBlank(this._globalBlogHome)) {
                this._logger.debug((Object)("Using global blog-home directory: " + this._globalBlogHome));
            }
        } else {
            this._globalBlogHome = "";
        }
        if ((listOfUsers = this.getBlojsomProperty("blojsom-users")) instanceof List) {
            List blojsomUsers = this.getBlojsomPropertyAsList("blojsom-users");
            users = blojsomUsers.toArray(new String[blojsomUsers.size()]);
            this._blojsomUsers = BlojsomUtils.arrayOfStringsToString(users);
        } else {
            this._blojsomUsers = this.getBlojsomPropertyAsString("blojsom-users");
            users = BlojsomUtils.parseCommaList(this._blojsomUsers);
        }
        if (users.length == 0) {
            this._logger.error((Object)"No users defined for this blojsom blog");
            throw new BlojsomConfigurationException("No users defined for this blojsom blog");
        }
        this._blogUsers = new HashMap();
        this._blogIDs = new HashMap();
        for (int i = 0; i < users.length; ++i) {
            String user = users[i];
            this._blogIDs.put(user, user);
        }
        String defaultUser = this.getBlojsomPropertyAsString("blojsom-default-user");
        if (BlojsomUtils.checkNullOrBlank(defaultUser)) {
            this._logger.error((Object)"No default user defined in configuration property: blojsom-default-user");
            throw new BlojsomConfigurationException("No default user defined in configuration property: blojsom-default-user");
        }
        if (!this._blogIDs.containsKey(defaultUser)) {
            this._logger.error((Object)("Default user does not match any of the registered blojsom users: " + defaultUser));
            throw new BlojsomConfigurationException("Default user does not match any of the registered blojsom users: " + defaultUser);
        }
        this._defaultUser = defaultUser;
        this._logger.debug((Object)("blojsom default user: " + this._defaultUser));
        this._fetcherClass = this.getBlojsomPropertyAsString("blojsom-fetcher");
        if (this._fetcherClass == null || "".equals(this._fetcherClass)) {
            this._fetcherClass = "org.blojsom.fetcher.StandardFetcher";
        }
        this._resourceManager = this.getBlojsomPropertyAsString("blojsom-resource-manager");
        if (BlojsomUtils.checkNullOrBlank(this._resourceManager)) {
            this._resourceManager = "org.blojsom.util.resources.ResourceBundleResourceManager";
        }
        this._logger.debug((Object)("Using resource manager: " + this._resourceManager));
        this._installedLocales = this.getBlojsomPropertyAsString("blojsom-installed-locales");
        if (BlojsomUtils.checkNullOrBlank(this._installedLocales)) {
            this._installedLocales = "en_US";
        }
        this._logger.debug((Object)("Using installed locales: " + this._installedLocales));
        this._authorizationProviderClass = this.getBlojsomPropertyAsString("blojsom-authorization-provider");
        if (BlojsomUtils.checkNullOrBlank(this._authorizationProviderClass)) {
            this._authorizationProviderClass = "org.blojsom.authorization.PropertiesAuthorizationProvider";
        }
        this._logger.debug((Object)("Using authorization provider: " + this._authorizationProviderClass));
        try {
            Class<?> authorizationProviderClass = Class.forName(this._authorizationProviderClass);
            _authorizationProvider = (AuthorizationProvider)authorizationProviderClass.newInstance();
            _authorizationProvider.init(this._servletConfig, this);
        }
        catch (ClassNotFoundException e) {
            throw new BlojsomConfigurationException(e);
        }
        catch (InstantiationException e) {
            throw new BlojsomConfigurationException(e);
        }
        catch (IllegalAccessException e) {
            throw new BlojsomConfigurationException(e);
        }
        catch (BlojsomConfigurationException e) {
            throw new BlojsomConfigurationException(e);
        }
    }

    public Map getBlojsomConfiguration() {
        return Collections.unmodifiableMap(this._blojsomConfiguration);
    }

    public String getBlojsomPropertyAsString(String propertyKey) {
        if (this._blojsomConfiguration.containsKey(propertyKey)) {
            return (String)this._blojsomConfiguration.get(propertyKey);
        }
        return null;
    }

    public List getBlojsomPropertyAsList(String propertyKey) {
        if (this._blojsomConfiguration.containsKey(propertyKey)) {
            Object value = this._blojsomConfiguration.get(propertyKey);
            if (value instanceof List) {
                return (List)value;
            }
            ArrayList values = new ArrayList();
            values.add(value);
            return values;
        }
        return null;
    }

    public Object getBlojsomProperty(String propertyKey) {
        return this._blojsomConfiguration.get(propertyKey);
    }

    public String getDefaultUser() {
        return this._defaultUser;
    }

    public String getBaseConfigurationDirectory() {
        return this._baseConfigurationDirectory;
    }

    public String getFetcherClass() {
        return this._fetcherClass;
    }

    public String getInstallationDirectory() {
        return this._installationDirectory;
    }

    public String getTemplatesDirectory() {
        return this._templatesDirectory;
    }

    public String getResourceDirectory() {
        return this._resourceDirectory;
    }

    public String getQualifiedResourceDirectory() {
        return this._qualifiedResourceDirectory;
    }

    public String[] getBlojsomUsers() {
        Iterator blogs = this._blogIDs.keySet().iterator();
        ArrayList<String> blogsList = new ArrayList<String>();
        while (blogs.hasNext()) {
            String blogID = (String)blogs.next();
            blogsList.add(blogID);
        }
        return blogsList.toArray(new String[blogsList.size()]);
    }

    public Map getBlogUsers() {
        return this._blogUsers;
    }

    public String getResourceManager() {
        return this._resourceManager;
    }

    public String getAuthorizationProvider() {
        return this._authorizationProviderClass;
    }

    public String getGlobalBlogHome() {
        return this._globalBlogHome;
    }

    public BlojsomEventBroadcaster getEventBroadcaster() {
        return _eventBroadcaster;
    }

    public String[] getInstalledLocalesAsStrings() {
        return BlojsomUtils.parseCommaList(this._installedLocales);
    }

    public Locale[] getInstalledLocales() {
        String[] localeStrings = this.getInstalledLocalesAsStrings();
        Locale[] locales = new Locale[localeStrings.length];
        for (int i = 0; i < localeStrings.length; ++i) {
            String localeString = localeStrings[i];
            locales[i] = BlojsomUtils.getLocaleFromString(localeString);
        }
        return locales;
    }

    public boolean checkBlogIDExists(String blogID) {
        return this._blogIDs.containsKey(blogID);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BlogUser loadBlog(String blogID) throws BlojsomException {
        BlogUser blogUser = new BlogUser();
        blogUser.setId(blogID);
        BlojsomProperties userProperties = new BlojsomProperties();
        this._logger.info((Object)("Attemping to load " + this._baseConfigurationDirectory + blogID + '/' + "blog.properties"));
        InputStream is = this._servletConfig.getServletContext().getResourceAsStream(this._baseConfigurationDirectory + blogID + '/' + "blog.properties");
        if (is == null) throw new BlojsomConfigurationException("Unable to load blog configuration for blog: " + blogUser.getId());
        try {
            ((Properties)userProperties).load(is);
            is.close();
        }
        catch (IOException e) {
            this._logger.error((Object)e);
            throw new BlojsomConfigurationException(e);
        }
        Blog userBlog = null;
        try {
            if (!BlojsomUtils.checkNullOrBlank(this._globalBlogHome) && !userProperties.containsKey("blog-home")) {
                String usersBlogHome = this._globalBlogHome + blogID + "/";
                File blogHomeDirectory = new File(usersBlogHome);
                if (!blogHomeDirectory.exists() && !blogHomeDirectory.mkdirs()) {
                    this._logger.error((Object)("Unable to create blog-home directory for blog: " + blogHomeDirectory.toString()));
                    throw new BlojsomConfigurationException("Unable to create blog-home directory for blog: " + blogHomeDirectory.toString());
                }
                userProperties.setProperty("blog-home", usersBlogHome);
                this._logger.debug((Object)("Setting blog blog-home directory: " + usersBlogHome));
            }
            userBlog = new Blog(userProperties);
            blogUser.setBlog(userBlog);
            _authorizationProvider.loadAuthenticationCredentials(blogUser);
            this._logger.debug((Object)("Added blojsom blog: " + blogUser.getId()));
            File resourceDirectory = new File(this._qualifiedResourceDirectory + File.separator + blogID);
            if (resourceDirectory.exists()) return blogUser;
            this._logger.debug((Object)("Creating resource directory for blog " + blogID));
            resourceDirectory.mkdirs();
            return blogUser;
        }
        catch (BlojsomConfigurationException e) {
            this._logger.error((Object)e);
            this._logger.error((Object)("Marking blog as invalid: " + blogUser.getId()));
            throw new BlojsomConfigurationException(e);
        }
    }

    public Map getBlogIDs() {
        return Collections.unmodifiableMap(this._blogIDs);
    }

    public void addBlogID(String blogID) {
        this._blogIDs.put(blogID, blogID);
    }

    public void removeBlogID(String blogID) {
        this._blogIDs.remove(blogID);
    }
}

