/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.filter.GZIPResponseWrapper;
import org.blojsom.util.BlojsomConstants;

public class CompressionFilter
implements Filter,
BlojsomConstants {
    private Log _logger = LogFactory.getLog((Class)CompressionFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (!(req instanceof HttpServletRequest)) return;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String ae = request.getHeader("accept-encoding");
        if (ae != null && ae.indexOf("gzip") != -1) {
            this._logger.debug((Object)"GZIP supported, compressing.");
            GZIPResponseWrapper wrappedResponse = new GZIPResponseWrapper(response);
            try {
                chain.doFilter(req, (ServletResponse)wrappedResponse);
                return;
            }
            catch (IOException e) {
                this._logger.error((Object)e);
                if (e.getCause() == null) return;
                this._logger.error((Object)e.getCause());
                return;
            }
            catch (ServletException e) {
                this._logger.error((Object)e);
                if (e.getRootCause() == null) return;
                this._logger.error((Object)e.getRootCause());
                return;
            }
            finally {
                wrappedResponse.finishResponse();
            }
        } else {
            chain.doFilter(req, res);
        }
    }

    public void destroy() {
    }
}

