/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.blojsom.BlojsomException;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogCategory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.fetcher.BlojsomFetcher;
import org.blojsom.fetcher.BlojsomFetcherException;
import org.blojsom.util.BlojsomConstants;
import org.blojsom.util.BlojsomProperties;

public class BlojsomUtils
implements BlojsomConstants {
    private static final FileFilter DIRECTORY_FILTER = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    };
    private static final FileFilter FILE_FILTER = new FileFilter(){

        public boolean accept(File pathname) {
            return !pathname.isDirectory();
        }
    };
    private static final ThreadLocal RFC_822_DATE_FORMAT_OBJECT = new ThreadLocal(){

        protected Object initialValue() {
            return new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US);
        }
    };
    private static final ThreadLocal ISO_8601_DATE_FORMAT_OBJECT = new ThreadLocal(){

        protected Object initialValue() {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
            sdf.getTimeZone().setID("+00:00");
            return sdf;
        }
    };
    private static final ThreadLocal UTC_DATE_FORMAT_OBJECT = new ThreadLocal(){

        protected Object initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        }
    };
    public static final Comparator FILE_TIME_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            long f2;
            long f1;
            if (o1 instanceof BlogEntry && o2 instanceof BlogEntry) {
                f1 = ((BlogEntry)o1).getLastModified();
                f2 = ((BlogEntry)o2).getLastModified();
            } else {
                f1 = ((File)o1).lastModified();
                f2 = ((File)o2).lastModified();
            }
            if (f1 > f2) {
                return -1;
            }
            if (f1 < f2) {
                return 1;
            }
            if (o1 instanceof BlogEntry && o2 instanceof BlogEntry) {
                return ((BlogEntry)o1).getTitle().compareTo(((BlogEntry)o2).getTitle());
            }
            return ((File)o1).getName().compareTo(((File)o2).getName());
        }
    };
    public static final Comparator FILE_TIME_ASCENDING_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            long f2;
            long f1;
            if (o1 instanceof BlogEntry && o2 instanceof BlogEntry) {
                f1 = ((BlogEntry)o1).getLastModified();
                f2 = ((BlogEntry)o2).getLastModified();
            } else {
                f1 = ((File)o1).lastModified();
                f2 = ((File)o2).lastModified();
            }
            if (f1 > f2) {
                return 1;
            }
            if (f1 < f2) {
                return -1;
            }
            if (o1 instanceof BlogEntry && o2 instanceof BlogEntry) {
                return ((BlogEntry)o1).getTitle().compareTo(((BlogEntry)o2).getTitle());
            }
            return ((File)o1).getName().compareTo(((File)o2).getName());
        }
    };
    public static final Comparator FILE_NAME_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            return s1.compareTo(s2);
        }
    };
    static final byte[] HEX_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    private BlojsomUtils() {
    }

    public static FileFilter getDirectoryFilter() {
        return DIRECTORY_FILTER;
    }

    public static FileFilter getDirectoryFilter(final String[] excludedDirectories) {
        if (excludedDirectories == null) {
            return DIRECTORY_FILTER;
        }
        return new FileFilter(){

            public boolean accept(File pathname) {
                if (!pathname.isDirectory()) {
                    return false;
                }
                for (int i = 0; i < excludedDirectories.length; ++i) {
                    String excludedDirectory = excludedDirectories[i];
                    if (!pathname.toString().matches(excludedDirectory)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static String getRFC822Date(Date date) {
        return ((SimpleDateFormat)RFC_822_DATE_FORMAT_OBJECT.get()).format(date);
    }

    public static String getFormattedDate(Date date, String format, Locale locale) {
        SimpleDateFormat sdf = new SimpleDateFormat(format, locale);
        return sdf.format(date);
    }

    public static String getISO8601Date(Date date) {
        return ((SimpleDateFormat)ISO_8601_DATE_FORMAT_OBJECT.get()).format(date).replaceAll("GMT", "");
    }

    public static String getUTCDate(Date date) {
        return ((SimpleDateFormat)UTC_DATE_FORMAT_OBJECT.get()).format(date);
    }

    public static FileFilter getRegularExpressionFilter(final String[] expressions) {
        return new FileFilter(){
            private Date today = new Date();

            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    return false;
                }
                for (int i = 0; i < expressions.length; ++i) {
                    String expression = expressions[i];
                    if (!pathname.getName().matches(expression)) continue;
                    return pathname.lastModified() <= this.today.getTime();
                }
                return false;
            }
        };
    }

    public static FileFilter getExtensionsFilter(final String[] extensions) {
        return new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    return false;
                }
                for (int i = 0; i < extensions.length; ++i) {
                    String extension = extensions[i];
                    if (!pathname.getName().endsWith(extension)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static FileFilter getExtensionsFilter(final String[] extensions, final String[] excludedDirectories, final boolean returnDirectories) {
        return new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname.isDirectory() && returnDirectories) {
                    String path = pathname.toString();
                    for (int i = 0; i < excludedDirectories.length; ++i) {
                        String excludedDirectory = excludedDirectories[i];
                        if (!path.matches(excludedDirectory)) continue;
                        return false;
                    }
                    return true;
                }
                for (int i = 0; i < extensions.length; ++i) {
                    String extension = extensions[i];
                    if (!pathname.getName().matches(extension)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static FileFilter getExtensionFilter(String extension) {
        return BlojsomUtils.getExtensionsFilter(new String[]{extension});
    }

    public static void visitFilesAndDirectories(Date today, String[] extensions, String[] excludedDirectories, File directoryOrFile, List items) {
        File[] subDirectories = directoryOrFile.listFiles(BlojsomUtils.getExtensionsFilter(extensions, excludedDirectories, true));
        for (int i = 0; i < subDirectories.length; ++i) {
            if (subDirectories[i].isDirectory()) {
                BlojsomUtils.visitFilesAndDirectories(today, extensions, excludedDirectories, subDirectories[i], items);
                continue;
            }
            if (subDirectories[i].lastModified() > today.getTime()) continue;
            items.add(subDirectories[i]);
        }
    }

    public static String[] parseCommaList(String commaList) {
        return BlojsomUtils.parseDelimitedList(commaList, ", ");
    }

    public static String[] parseOnlyCommaList(String commaList) {
        return BlojsomUtils.parseDelimitedList(commaList, ",");
    }

    public static String[] parseLastComma(String value) {
        if (BlojsomUtils.checkNullOrBlank(value)) {
            return new String[]{value};
        }
        int lastCommaIndex = value.lastIndexOf(",");
        if (lastCommaIndex == -1) {
            return new String[]{value};
        }
        return new String[]{value.substring(0, lastCommaIndex), value.substring(lastCommaIndex + 1)};
    }

    public static String[] parseDelimitedList(String delimitedList, String delimiter) {
        if (delimitedList == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(delimitedList, delimiter);
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        if (list.size() == 0) {
            return new String[0];
        }
        return list.toArray(new String[list.size()]);
    }

    public static String convertRequestParams(HttpServletRequest request) {
        Enumeration paramNames = request.getParameterNames();
        StringBuffer buffer = new StringBuffer();
        while (paramNames.hasMoreElements()) {
            String name = (String)paramNames.nextElement();
            String value = request.getParameter(name);
            try {
                buffer.append(URLEncoder.encode(name, "UTF-8")).append("=").append(URLEncoder.encode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            if (!paramNames.hasMoreElements()) continue;
            buffer.append("&");
        }
        return buffer.toString();
    }

    public static String convertRequestParams(HttpServletRequest request, Map ignoreParams) {
        Enumeration paramNames = request.getParameterNames();
        StringBuffer buffer = new StringBuffer();
        while (paramNames.hasMoreElements()) {
            String name = (String)paramNames.nextElement();
            String value = request.getParameter(name);
            try {
                if (ignoreParams.containsKey(name)) continue;
                buffer.append(URLEncoder.encode(name, "UTF-8")).append("=").append(URLEncoder.encode(value, "UTF-8")).append("&");
            }
            catch (UnsupportedEncodingException e) {}
        }
        return buffer.toString();
    }

    public static String getBlogCategory(String blogHome, String requestedCategory) {
        int indexOfBlogHome = (requestedCategory = requestedCategory.replace('\\', '/')).indexOf(blogHome);
        if (indexOfBlogHome == -1) {
            return "";
        }
        String returnCategory = requestedCategory.substring(indexOfBlogHome += blogHome.length());
        returnCategory = BlojsomUtils.removeInitialSlash(returnCategory);
        return '/' + returnCategory;
    }

    public static String getBlogSiteURL(String blogURL, String servletPath) {
        if (servletPath == null || "".equals(servletPath)) {
            return blogURL;
        }
        int servletPathIndex = blogURL.indexOf(servletPath, 7);
        if (servletPathIndex == -1) {
            return blogURL;
        }
        return blogURL.substring(0, servletPathIndex);
    }

    public static String escapeString(String input) {
        if (input == null) {
            return null;
        }
        String unescaped = BlojsomUtils.replace(input, "&", "&amp;");
        unescaped = BlojsomUtils.replace(unescaped, "<", "&lt;");
        unescaped = BlojsomUtils.replace(unescaped, ">", "&gt;");
        unescaped = BlojsomUtils.replace(unescaped, "\"", "&quot;");
        unescaped = BlojsomUtils.replace(unescaped, "'", "&#39;");
        return unescaped;
    }

    public static String escapeStringSimple(String input) {
        if (input == null) {
            return null;
        }
        String unescaped = BlojsomUtils.replace(input, "&", "&amp;");
        unescaped = BlojsomUtils.replace(unescaped, "<", "&lt;");
        unescaped = BlojsomUtils.replace(unescaped, ">", "&gt;");
        return unescaped;
    }

    public static String escapeMetaAndLink(String input) {
        if (input == null) {
            return null;
        }
        String cleanedInput = input.replaceAll("<[mM][eE][tT][aA]", "&lt;meta");
        cleanedInput = cleanedInput.replaceAll("<[lL][iI][nN][kK]", "&lt;link");
        return cleanedInput;
    }

    public static String replace(String str, String pattern, String replace) {
        if (str == null || "".equals(str)) {
            return str;
        }
        if (replace == null) {
            return str;
        }
        if ("".equals(pattern)) {
            return str;
        }
        int s = 0;
        int e = 0;
        StringBuffer result = new StringBuffer();
        while ((e = str.indexOf(pattern, s)) >= 0) {
            result.append(str.substring(s, e));
            result.append(replace);
            s = e + pattern.length();
        }
        result.append(str.substring(s));
        return result.toString();
    }

    public static String getFileExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int dotIndex = filename.lastIndexOf(".");
        if (dotIndex == -1) {
            return null;
        }
        return filename.substring(dotIndex + 1);
    }

    public static String getFilename(String filename) {
        int dotIndex = filename.lastIndexOf(".");
        if (dotIndex == -1) {
            return filename;
        }
        return filename.substring(0, dotIndex);
    }

    public static String getFilenameFromPath(String filenameWithPath) {
        String fileName = new File(filenameWithPath).getName();
        int colonIndex = fileName.indexOf(":");
        if (colonIndex == -1) {
            colonIndex = fileName.indexOf("\\\\");
        }
        int backslashIndex = fileName.lastIndexOf("\\");
        if (colonIndex > -1 && backslashIndex > -1) {
            fileName = fileName.substring(backslashIndex + 1);
        }
        return fileName;
    }

    public static String getDateKey(Date date) {
        StringBuffer value = new StringBuffer();
        Calendar calendar = Calendar.getInstance();
        long l = 0L;
        calendar.setTime(date);
        value.append(calendar.get(1));
        l = calendar.get(2) + 1;
        if (l < 10L) {
            value.append("0");
        }
        value.append(l);
        l = calendar.get(5);
        if (l < 10L) {
            value.append("0");
        }
        value.append(l);
        return value.toString();
    }

    public static String removeInitialSlash(String input) {
        if (input == null) {
            return null;
        }
        if (!input.startsWith("/")) {
            return input;
        }
        return input.substring(1);
    }

    public static String removeTrailingSlash(String input) {
        if (input == null) {
            return null;
        }
        if (!input.endsWith("/")) {
            return input;
        }
        return input.substring(0, input.length() - 1);
    }

    public static final String removeSlashes(String input) {
        input = BlojsomUtils.removeInitialSlash(input);
        input = BlojsomUtils.removeTrailingSlash(input);
        return input;
    }

    public static String getFirstLine(String input, int length) {
        String lineSeparator = LINE_SEPARATOR;
        int titleIndex = input.indexOf(lineSeparator);
        String result = titleIndex == -1 ? input.substring(0, length) + "..." : input.substring(0, titleIndex);
        return result;
    }

    public static final String getTemplateForPage(String flavorTemplate, String page) {
        int dotIndex = flavorTemplate.lastIndexOf(".");
        if (dotIndex == -1) {
            return flavorTemplate + '-' + page;
        }
        StringBuffer newTemplate = new StringBuffer();
        if (page.startsWith("/")) {
            newTemplate.append(BlojsomUtils.removeInitialSlash(page));
        } else {
            newTemplate.append(flavorTemplate.substring(0, dotIndex));
            newTemplate.append("-");
            newTemplate.append(page);
        }
        newTemplate.append(".");
        newTemplate.append(flavorTemplate.substring(dotIndex + 1, flavorTemplate.length()));
        return newTemplate.toString();
    }

    public static final String getRequestValue(String key, HttpServletRequest httpServletRequest) {
        return BlojsomUtils.getRequestValue(key, httpServletRequest, false);
    }

    public static final String getRequestValue(String key, HttpServletRequest httpServletRequest, boolean preferAttributes) {
        if (!preferAttributes) {
            if (httpServletRequest.getParameter(key) != null) {
                return httpServletRequest.getParameter(key);
            }
            if (httpServletRequest.getAttribute(key) != null) {
                return httpServletRequest.getAttribute(key).toString();
            }
        } else {
            if (httpServletRequest.getAttribute(key) != null) {
                return httpServletRequest.getAttribute(key).toString();
            }
            if (httpServletRequest.getParameter(key) != null) {
                return httpServletRequest.getParameter(key);
            }
        }
        return null;
    }

    public static final String getFilenameForPermalink(String permalink, String[] blogEntryExtensions) {
        if (permalink == null) {
            return null;
        }
        boolean matchesExtension = false;
        for (int i = 0; i < blogEntryExtensions.length; ++i) {
            String blogEntryExtension = blogEntryExtensions[i];
            if (!permalink.matches(blogEntryExtension)) continue;
            matchesExtension = true;
            break;
        }
        if (!matchesExtension) {
            return null;
        }
        int indexOfSlash = permalink.lastIndexOf("/");
        if (indexOfSlash == -1) {
            indexOfSlash = permalink.lastIndexOf("\\");
        }
        if (indexOfSlash == -1) {
            return permalink;
        }
        String sanitizedPermalink = permalink.substring(indexOfSlash + 1, permalink.length());
        if (sanitizedPermalink.startsWith("..")) {
            sanitizedPermalink = sanitizedPermalink.substring(2, sanitizedPermalink.length());
        } else if (sanitizedPermalink.startsWith(".")) {
            sanitizedPermalink = sanitizedPermalink.substring(1, sanitizedPermalink.length());
        }
        return sanitizedPermalink;
    }

    public static final String urlEncode(String input) {
        if (input == null) {
            return null;
        }
        try {
            return URLEncoder.encode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return input;
        }
    }

    public static final String urlEncodeForLink(String input) {
        if (input == null) {
            return null;
        }
        try {
            String result = URLEncoder.encode(input, "UTF-8");
            result = BlojsomUtils.replace(result, "%2F", "/");
            result = BlojsomUtils.replace(result, "%20", "+");
            return result;
        }
        catch (UnsupportedEncodingException e) {
            return input;
        }
    }

    public static final String urlDecode(String input) {
        if (input == null) {
            return null;
        }
        try {
            return URLDecoder.decode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String getCalendarNavigationUrl(String prefix, int month, int day, int year) {
        StringBuffer dateurl = new StringBuffer(prefix);
        if (month != -1) {
            dateurl.append("?month=").append(month);
        }
        if (day != -1) {
            dateurl.append("&amp;day=").append(day);
        }
        if (year != -1) {
            dateurl.append("&amp;year=").append(year);
        }
        return dateurl.toString();
    }

    public static String digestString(String data) {
        return BlojsomUtils.digestString(data, "MD5");
    }

    public static String digestString(String data, String algorithm) {
        String result = null;
        if (data != null) {
            try {
                String _ds;
                MessageDigest _md = MessageDigest.getInstance(algorithm);
                _md.update(data.getBytes());
                byte[] _digest = _md.digest();
                result = _ds = BlojsomUtils.toHexString(_digest, 0, _digest.length);
            }
            catch (NoSuchAlgorithmException e) {
                result = null;
            }
        }
        return result;
    }

    private static void toHexValue(byte[] buf, int offset, int length, int value) {
        do {
            buf[offset + --length] = HEX_DIGITS[value & 0xF];
        } while ((value >>>= 4) != 0 && length > 0);
        while (--length >= 0) {
            buf[offset + length] = HEX_DIGITS[0];
        }
    }

    public static String toHexString(byte[] buf, int offset, int length) {
        byte[] buf1 = new byte[length * 2];
        for (int i = 0; i < length; ++i) {
            BlojsomUtils.toHexValue(buf1, i * 2, 2, buf[i + offset]);
        }
        return new String(buf1);
    }

    public static Properties loadProperties(ServletConfig servletConfig, String configurationIP, boolean required) throws BlojsomException {
        return BlojsomUtils.loadProperties(servletConfig, configurationIP, required, false);
    }

    public static Properties loadProperties(ServletConfig servletConfig, String configurationIP, boolean required, boolean allowMultipleValues) throws BlojsomException {
        String configuration = servletConfig.getInitParameter(configurationIP);
        BlojsomProperties properties = new BlojsomProperties(allowMultipleValues);
        if (configuration == null || "".equals(configuration)) {
            if (required) {
                throw new BlojsomException("No value given for: " + configurationIP + " configuration parameter");
            }
            return properties;
        }
        InputStream is = servletConfig.getServletContext().getResourceAsStream(configuration);
        if (is == null) {
            throw new BlojsomException("Could not load configuration file: " + configuration);
        }
        try {
            ((Properties)properties).load(is);
        }
        catch (IOException e) {
            throw new BlojsomException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new BlojsomException(e);
            }
        }
        return properties;
    }

    public static Properties loadProperties(ServletConfig servletConfig, String configurationFile) throws BlojsomException {
        BlojsomProperties properties = new BlojsomProperties();
        InputStream is = servletConfig.getServletContext().getResourceAsStream(configurationFile);
        if (is == null) {
            throw new BlojsomException("Unable to load configuration file: " + configurationFile);
        }
        try {
            ((Properties)properties).load(is);
        }
        catch (IOException e) {
            throw new BlojsomException(e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new BlojsomException(e);
            }
        }
        return properties;
    }

    public static String normalize(String path) {
        if (path == null) {
            return null;
        }
        String value = path;
        value = value.replaceAll("\\.*", "");
        value = value.replaceAll("/{2,}", "");
        return value;
    }

    public static String nullToBlank(String input) {
        return input == null ? "" : input;
    }

    public static Map propertiesToMap(Properties properties) {
        if (properties == null) {
            return new HashMap();
        }
        Iterator<Object> keyIterator = properties.keySet().iterator();
        HashMap<String, Object> convertedProperties = new HashMap<String, Object>();
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            Object value = properties.get(key);
            convertedProperties.put(key, value);
        }
        return convertedProperties;
    }

    public static Map blojsomPropertiesToMap(Properties properties) {
        if (properties == null) {
            return new HashMap();
        }
        Iterator<Object> keyIterator = properties.keySet().iterator();
        HashMap<String, Object> convertedProperties = new HashMap<String, Object>();
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            Object value = properties.get(key);
            if (value instanceof List) {
                convertedProperties.put(key, value);
                continue;
            }
            ArrayList<String> values = new ArrayList<String>();
            values.add(value.toString());
            convertedProperties.put(key, values);
        }
        return convertedProperties;
    }

    public static String arrayOfStringsToString(String[] array, String separator) {
        if (array == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        if (array.length > 0) {
            result.append(array[0]);
            for (int i = 1; i < array.length; ++i) {
                result.append(separator);
                result.append(array[i]);
            }
        }
        return result.toString();
    }

    public static String arrayOfStringsToString(String[] array) {
        return BlojsomUtils.arrayOfStringsToString(array, ", ");
    }

    public static Properties mapToProperties(Map map, String encoding) {
        if (map == null) {
            return new BlojsomProperties();
        }
        Iterator keyIterator = map.keySet().iterator();
        BlojsomProperties convertedProperties = new BlojsomProperties(encoding);
        while (keyIterator.hasNext()) {
            Object key = keyIterator.next();
            Object value = map.get(key);
            if (key != null && value != null && value instanceof String[]) {
                convertedProperties.put(key, BlojsomUtils.arrayOfStringsToString((String[])value));
                continue;
            }
            if (key != null && value != null) {
                convertedProperties.put(key, value.toString());
                continue;
            }
            if (key == null || value != null) continue;
            convertedProperties.put(key, "");
        }
        return convertedProperties;
    }

    public static Properties mapToBlojsomProperties(Map map) {
        if (map == null) {
            return new BlojsomProperties();
        }
        Iterator keyIterator = map.keySet().iterator();
        BlojsomProperties convertedProperties = new BlojsomProperties(true);
        while (keyIterator.hasNext()) {
            Object key = keyIterator.next();
            Object value = map.get(key);
            convertedProperties.put(key, value);
        }
        return convertedProperties;
    }

    public static Properties mapToProperties(Map map) {
        return BlojsomUtils.mapToProperties(map, "UTF-8");
    }

    public static final String getCategoryFromPath(String pathInfo) {
        if (pathInfo == null || "/".equals(pathInfo)) {
            return "/";
        }
        int categoryStart = pathInfo.indexOf("/", 1);
        if (categoryStart == -1) {
            return "/";
        }
        return pathInfo.substring(categoryStart);
    }

    public static final String getUserFromPath(String pathInfo) {
        if (pathInfo == null || "/".equals(pathInfo)) {
            return null;
        }
        int userEnd = pathInfo.indexOf("/", 1);
        if (userEnd == -1) {
            return pathInfo.substring(1);
        }
        return pathInfo.substring(1, userEnd);
    }

    public static boolean deleteDirectory(File directoryOrFile) {
        return BlojsomUtils.deleteDirectory(directoryOrFile, true);
    }

    public static boolean deleteDirectory(File directoryOrFile, boolean removeDirectoryOrFile) {
        File[] children;
        if (directoryOrFile.isDirectory() && (children = directoryOrFile.listFiles()) != null && children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                boolean success = BlojsomUtils.deleteDirectory(children[i]);
                if (success) continue;
                return false;
            }
        }
        if (removeDirectoryOrFile) {
            return directoryOrFile.delete();
        }
        return true;
    }

    public static void copyDirectory(File sourceDirectory, File targetDirectory) throws IOException {
        int i;
        File[] sourceFiles = sourceDirectory.listFiles(FILE_FILTER);
        File[] sourceDirectories = sourceDirectory.listFiles(DIRECTORY_FILTER);
        targetDirectory.mkdirs();
        if (sourceFiles != null && sourceFiles.length > 0) {
            for (i = 0; i < sourceFiles.length; ++i) {
                File sourceFile = sourceFiles[i];
                FileInputStream fis = new FileInputStream(sourceFile);
                FileOutputStream fos = new FileOutputStream(targetDirectory + File.separator + sourceFile.getName());
                FileChannel fcin = fis.getChannel();
                FileChannel fcout = fos.getChannel();
                ByteBuffer buf = ByteBuffer.allocateDirect(8192);
                long size = fcin.size();
                for (long n = 0L; n < size; n += (long)fcout.write(buf)) {
                    buf.clear();
                    if (fcin.read(buf) < 0) break;
                    buf.flip();
                }
                fcin.close();
                fcout.close();
                fis.close();
                fos.close();
            }
        }
        if (sourceDirectories != null && sourceDirectories.length > 0) {
            for (i = 0; i < sourceDirectories.length; ++i) {
                File directory = sourceDirectories[i];
                File newTargetDirectory = new File(targetDirectory, directory.getName());
                BlojsomUtils.copyDirectory(directory, newTargetDirectory);
            }
        }
    }

    public static Map arrayOfStringsToMap(String[] array) {
        if (array == null) {
            return new HashMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < array.length; ++i) {
            result.put(array[i], array[i]);
        }
        return result;
    }

    public static String checkStartingAndEndingSlash(String input) {
        if (input == null) {
            return null;
        }
        if (!input.startsWith("/")) {
            input = "/" + input;
        }
        if (!input.endsWith("/")) {
            input = input + "/";
        }
        return input;
    }

    public static boolean checkNullOrBlank(String input) {
        return input == null || "".equals(input.trim());
    }

    public static void setNoCacheControlHeaders(HttpServletResponse httpServletResponse) {
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setHeader("Cache-Control", "no-cache");
    }

    public static boolean checkMapForKey(Map map, String key) {
        if (map == null) {
            return false;
        }
        if (key == null) {
            return false;
        }
        return map.containsKey(key);
    }

    public static int daysBetweenDates(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return 0;
        }
        Calendar calendarStartDate = Calendar.getInstance();
        calendarStartDate.setTime(startDate);
        int startDay = calendarStartDate.get(6);
        int startYear = calendarStartDate.get(1);
        Calendar calendarEndDate = Calendar.getInstance();
        calendarEndDate.setTime(endDate);
        int endDay = calendarEndDate.get(6);
        int endYear = calendarEndDate.get(1);
        return Math.abs(endDay - startDay + (endYear - startYear) * 365);
    }

    public static File getFilenameForDate(String filename) {
        String filenameWithoutExtension = BlojsomUtils.getFilename(filename);
        String fileExtension = BlojsomUtils.getFileExtension(filename);
        if (fileExtension == null) {
            return null;
        }
        return new File(filenameWithoutExtension + "-" + new Date().getTime() + "." + fileExtension);
    }

    public static String stripLineTerminators(String input) {
        if (input == null) {
            return null;
        }
        return input.replaceAll("[\n\r\f]", "");
    }

    public static String getKeysAsStringList(Map input) {
        StringBuffer result = new StringBuffer();
        if (input == null || input.size() == 0) {
            return result.toString();
        }
        Iterator keyIterator = input.keySet().iterator();
        int counter = 0;
        while (keyIterator.hasNext()) {
            Object key = keyIterator.next();
            result.append(key);
            if (counter < input.size() - 1) {
                result.append(", ");
            }
            ++counter;
        }
        return result.toString();
    }

    public static String listToCSV(List values) {
        StringBuffer result = new StringBuffer();
        if (values != null && values.size() > 0) {
            for (int i = 0; i < values.size(); ++i) {
                if (values.get(i) == null) {
                    result.append(" ");
                } else {
                    result.append(values.get(i));
                }
                if (i >= values.size() - 1) continue;
                result.append(", ");
            }
        }
        return result.toString();
    }

    public static Map listToMap(List values) {
        HashMap valueMap = new HashMap();
        if (values != null && values.size() > 0) {
            Iterator valueIterator = values.iterator();
            while (valueIterator.hasNext()) {
                Object value = valueIterator.next();
                if (value == null) continue;
                valueMap.put(value, value);
            }
        }
        return valueMap;
    }

    public static List csvToList(String valuesAsString) {
        String[] values = BlojsomUtils.parseOnlyCommaList(valuesAsString);
        ArrayList<String> updated = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            String value = values[i].trim();
            updated.add(value);
        }
        return updated;
    }

    public static String constructBaseURL(HttpServletRequest httpServletRequest) {
        StringBuffer result = new StringBuffer();
        result.append(httpServletRequest.getScheme()).append("://");
        result.append(httpServletRequest.getServerName());
        if (httpServletRequest.getServerPort() != 80) {
            result.append(":").append(httpServletRequest.getServerPort());
        }
        result.append(httpServletRequest.getContextPath());
        return result.toString();
    }

    public static String constructBlogURL(HttpServletRequest httpServletRequest, String blogID) {
        StringBuffer result = new StringBuffer(BlojsomUtils.constructBaseURL(httpServletRequest));
        result.append(httpServletRequest.getServletPath()).append("/").append(blogID).append("/");
        return result.toString();
    }

    public static void resolveDynamicBaseAndBlogURL(HttpServletRequest httpServletRequest, Blog blog, String blogID) {
        if (BlojsomUtils.checkNullOrBlank(blog.getBlogBaseURL())) {
            blog.setBlogBaseURL(BlojsomUtils.constructBaseURL(httpServletRequest));
        }
        if (BlojsomUtils.checkNullOrBlank(blog.getBlogURL())) {
            blog.setBlogURL(BlojsomUtils.constructBlogURL(httpServletRequest, blogID));
        }
        if (BlojsomUtils.checkNullOrBlank(blog.getBlogAdminURL())) {
            blog.setBlogAdminURL(BlojsomUtils.constructBlogURL(httpServletRequest, blogID));
        }
    }

    public static String getHashableContent(String content) {
        String hashable = content;
        if (content.length() > 300) {
            hashable = hashable.substring(0, 300);
        }
        return BlojsomUtils.digestString(hashable).toUpperCase();
    }

    public static String getBlogEntryFilename(String title, String content) {
        String filename;
        if (!BlojsomUtils.checkNullOrBlank(title)) {
            filename = title.replaceAll("\\s", "_");
            filename = filename.replaceAll("'", "");
            filename = filename.replaceAll("\\p{Punct}", "_");
            filename = filename.replaceAll("_{2,}", "_");
            String backup = filename = filename.replaceAll("_", "-");
            filename = filename.replaceAll("^-{1,}", "");
            if (BlojsomUtils.checkNullOrBlank(filename = filename.replaceAll("-{1,}$", ""))) {
                filename = backup;
            }
        } else {
            filename = BlojsomUtils.getHashableContent(content);
        }
        return filename;
    }

    public static Locale getLocaleFromString(String locale) {
        if (BlojsomUtils.checkNullOrBlank(locale)) {
            return Locale.getDefault();
        }
        String language = locale;
        String country = "";
        String variant = "";
        int index = language.indexOf(95);
        if (index >= 0) {
            country = language.substring(index + 1);
            language = language.substring(0, index);
        }
        if ((index = country.indexOf(95)) >= 0) {
            variant = country.substring(index + 1);
            country = country.substring(0, index);
        }
        return new Locale(language, country, variant);
    }

    public static String[] getLanguagesForSystem(Locale locale) {
        Locale[] installedLocales = Locale.getAvailableLocales();
        ArrayList<String> languageList = new ArrayList<String>(installedLocales.length);
        String[] languages = null;
        for (int i = 0; i < installedLocales.length; ++i) {
            Locale installedLocale = installedLocales[i];
            String language = installedLocale.getLanguage();
            if (languageList.contains(language) || BlojsomUtils.checkNullOrBlank(language)) continue;
            languageList.add(language);
        }
        languages = languageList.toArray(new String[languageList.size()]);
        Collator collator = Collator.getInstance(locale);
        Arrays.sort(languages, collator);
        return languages;
    }

    public static String[] getCountriesForSystem(Locale locale) {
        Locale[] installedLocales = Locale.getAvailableLocales();
        ArrayList<String> countryList = new ArrayList<String>(installedLocales.length);
        String[] countries = null;
        for (int i = 0; i < installedLocales.length; ++i) {
            Locale installedLocale = installedLocales[i];
            String country = installedLocale.getCountry();
            if (countryList.contains(country) || BlojsomUtils.checkNullOrBlank(country)) continue;
            countryList.add(country);
        }
        countries = countryList.toArray(new String[countryList.size()]);
        Collator collator = Collator.getInstance(locale);
        Arrays.sort(countries, collator);
        return countries;
    }

    public static String[] getTimeZonesForSystem(Locale locale) {
        String[] timezones = TimeZone.getAvailableIDs();
        Collator collator = Collator.getInstance(locale);
        Arrays.sort(timezones, collator);
        return timezones;
    }

    public static void listFilesInSubdirectories(File directory, String parentDirectory, List files) {
        if (directory.isDirectory()) {
            String[] children = directory.list();
            for (int i = 0; i < children.length; ++i) {
                BlojsomUtils.listFilesInSubdirectories(new File(directory, children[i]), parentDirectory, files);
            }
        } else if (directory.getPath().startsWith(parentDirectory)) {
            files.add(new File(directory.getPath().substring(parentDirectory.length() + 1)));
        }
    }

    public static void listDirectoriesInSubdirectories(File directory, String parentDirectory, List directories) {
        if (directory.isDirectory()) {
            String[] children = directory.list();
            for (int i = 0; i < children.length; ++i) {
                BlojsomUtils.listDirectoriesInSubdirectories(new File(directory, children[i]), parentDirectory, directories);
            }
            if (directory.getPath().startsWith(parentDirectory)) {
                directories.add(new File(directory.getPath().substring(parentDirectory.length())));
            }
        }
    }

    public static BlogEntry fetchEntry(BlojsomFetcher fetcher, BlogUser blogUser, String category, String permalink) throws BlojsomFetcherException {
        BlogEntry fetchedEntry = null;
        BlogCategory blogCategory = fetcher.newBlogCategory();
        blogCategory.setCategory(category);
        blogCategory.setCategoryURL(blogUser.getBlog().getBlogURL() + BlojsomUtils.removeInitialSlash(category));
        HashMap<String, Object> fetchMap = new HashMap<String, Object>();
        fetchMap.put("FETCHER_CATEGORY", blogCategory);
        fetchMap.put("FETCHER_PERMALINK", permalink);
        BlogEntry[] entries = fetcher.fetchEntries(fetchMap, blogUser);
        if (entries == null || entries.length != 1) {
            throw new BlojsomFetcherException("Unable to retrieve entry: " + permalink + " from category: " + category);
        }
        fetchedEntry = entries[0];
        return fetchedEntry;
    }

    public static String stripHTML(String text) {
        if (BlojsomUtils.checkNullOrBlank(text)) {
            return text;
        }
        return text.replaceAll("\\<.*?\\>", "");
    }

    public static List arrayToList(String[] input) {
        if (input == null || input.length == 0) {
            return new ArrayList();
        }
        ArrayList<String> value = new ArrayList<String>(input.length);
        for (int i = 0; i < input.length; ++i) {
            String s = input[i];
            value.add(s);
        }
        return value;
    }

    public static List removeNullValues(List input) {
        if (input == null) {
            return new ArrayList();
        }
        ArrayList sanitizedList = new ArrayList(input.size());
        for (int i = 0; i < input.size(); ++i) {
            if (input.get(i) == null) continue;
            sanitizedList.add(input.get(i));
        }
        return sanitizedList;
    }

    public static String addSlashes(String input) {
        if (input == null) {
            return "/";
        }
        if (!input.startsWith("/")) {
            input = "/" + input;
        }
        if (!input.endsWith("/")) {
            input = input + "/";
        }
        return input;
    }
}

