/**
 * Copyright (c) 2003-2005, David A. Czarnecki
 * All rights reserved.
 *
 * Portions Copyright (c) 2003-2005 by Mark Lussier
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
 * Neither the name of the "David A. Czarnecki" and "blojsom" nor the names of
 * its contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Products derived from this software may not be called "blojsom",
 * nor may "blojsom" appear in their name, without prior written permission of
 * David A. Czarnecki.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.blojsom.blog;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.BlojsomDataBase;
import org.blojsom.BlojsomException;
import org.blojsom.util.BlojsomUtils;
import org.blojsom.util.BlojsomProperties;
import org.blojsom.util.BlojsomConstants;

import java.io.*;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Date;
import java.util.Vector;
import java.text.DateFormat;

/**
 * FileBackedBlogComment
 *
 * @author David Czarnecki
 * @version $Id: FileBackedBlogComment.java,v 1.3 2005/09/18 20:57:26 czarneckid Exp $
 * @since blojsom 2.26
 */
public class FileBackedBlogComment extends BlogComment {

    private transient Log _logger = LogFactory.getLog(FileBackedBlogComment.class);

    protected transient File _source;

    
    /**
     * Default constructor
     */
    public FileBackedBlogComment() {
        super();
    }

    /**
     * Retrieve the source file for this comment
     *
     * @return {@link File} backing this comment
     */
    public File getSource() {
        return _source;
    }

    /**
     * Set the source file for this comment
     *
     * @param source {@link File} backing this comment
     */
    public void setSource(File source) {
        _source = source;
    }

    /**
     * Load the blog comment
     *
     * @param blogUser {@link BlogUser}
     * @since blojsom 2.26
     */
    public void load(BlogUser blogUser) throws BlojsomException {
        if (_source == null) {
            throw new BlojsomException("No source file set for this comment");
        }
        Blog blog = blogUser.getBlog();
        File category_path = new File(_source.toString());
        String blog_home = BlojsomUtils.replace(category_path.getParent(),"\\","/");
        String blog_homedir = blog.getBlogHome();
        String category_name = blog_home.replace(blog_homedir,"");
        category_name = BlojsomUtils.removeSlashes(category_name.substring(0,category_name.indexOf(".comment")));
        //File category_name = new File(category_path);
        //int commentSwitch = 0;//DBpRgAEg
        //setCommentDateLong(_source.lastModified());//DBpRgAEg
        //StringBuffer commentDescription = new StringBuffer();
        //String separator = BlojsomConstants.LINE_SEPARATOR;//DBpRgAEg
        
        BlojsomDataBase blojsomdb = new BlojsomDataBase();
        blojsomdb.startDB();
        ResultSet rs = null;
    	if(category_name.equals("")){
    		rs = blojsomdb.myExecuteQuery("SELECT * FROM comment_cmt WHERE weblog_id='"+blogUser._id+"' and comment_cmt_name='"+_source.getName()+"' and category_name is null");
    	}else{
    		rs = blojsomdb.myExecuteQuery("SELECT * FROM comment_cmt WHERE weblog_id='"+blogUser._id+"' and comment_cmt_name='"+_source.getName()+"' and category_name='"+category_name+"'");
    	}	
    	try {
    		while (rs.next()) {
				setAuthor(rs.getString("author"));
				setAuthorEmail(rs.getString("email"));
				setAuthorURL(rs.getString("url"));
				setComment(rs.getString("comment"));
				setCommentDate(rs.getTimestamp("blojsom_date"));//(short)rs.getInt("TIMESTAMP")
				setCommentDateLong(rs.getDate("blojsom_date").getTime());
				setId(_source.getName());
			}
    	}catch(Exception e){
    		e.printStackTrace();
    	}
    	blojsomdb.stopDB();       
        /*
        //String commentLine;//DBpRgAEg
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(_source), blogUser.getBlog().getBlogFileEncoding()));
            while ((commentLine = br.readLine()) != null) {
                switch (commentSwitch) {
                    case 0:
                        {
                            setAuthor(commentLine);
                            commentSwitch++;
                            break;
                        }
                    case 1:
                        {
                            setAuthorEmail(commentLine);
                            commentSwitch++;
                            break;
                        }
                    case 2:
                        {
                            setAuthorURL(commentLine);
                            commentSwitch++;
                            break;
                        }
                    default:
                        {
                            commentDescription.append(commentLine).append(separator);
                        }
                }
            }
            */
            //setComment(commentDescription.toString());//DBpRgAEg
            
            //setCommentDate(new Date(_source.lastModified()));
            //setId(_source.getName());//DBpRgAEg
            //br.close();//DBpRgAEg

            // Load comment meta-data if available
            File commentMetaData = new File(BlojsomUtils.getFilename(_source.toString()) + ".meta");
            //if (commentMetaData.exists()) {
                _logger.debug("Loading comment meta-data: " + commentMetaData.toString());
                BlojsomProperties commentMetaDataProperties = new BlojsomProperties();
                //FileInputStream fis = new FileInputStream(commentMetaData);
                //DBpRg
                //commentMetaDataProperties.getProperty(commentMetaData.getAbsolutePath(),"COMMENT_META");
                //commentMetaDataProperties.load(fis);
                //fis.close();
                
                blojsomdb.startDB();
                int categoryPropertyFiles = 0;
                ResultSet rs1 = null;
                Vector columnName = null;
                try {
                	if(category_name.equals("")){
                		rs1 = blojsomdb.myExecuteQuery("SELECT * FROM comment_meta where weblog_id='"+blogUser._id+"' and comment_meta_name='"+commentMetaData.getName()+"' and category_name is null");
                	}else{
                		rs1 = blojsomdb.myExecuteQuery("SELECT * FROM comment_meta where weblog_id='"+blogUser._id+"' and comment_meta_name='"+commentMetaData.getName()+"' and category_name='"+category_name+"'");
                	}
                	rs1.last();
                	categoryPropertyFiles = rs1.getRow();
                	ResultSetMetaData rsmd;
					rsmd = rs1.getMetaData();
					int iCols = rsmd.getColumnCount();
					int column = 6;
					columnName = new Vector();
					while (column <= iCols) {
						columnName.add(rsmd.getColumnName(column));
						column++;
					}
				} catch (SQLException e1) {
					// TODO ꂽ catch ubN
					e1.printStackTrace();
				}
    			blojsomdb.stopDB();
    			blojsomdb.startDB();
    			//ResultSet rs = null;
                try {
                	if(category_name.equals("")){
                		rs = blojsomdb.myExecuteQuery("SELECT * FROM comment_meta where weblog_id='"+blogUser._id+"' and comment_meta_name='"+commentMetaData.getName()+"' and category_name is null");
                	}else{
                		rs = blojsomdb.myExecuteQuery("SELECT * FROM comment_meta where weblog_id='"+blogUser._id+"' and comment_meta_name='"+commentMetaData.getName()+"' and category_name='"+category_name+"'");
                	}
                	            	}catch(Exception e){
            		e.printStackTrace();
            	} 

                // Load properties file for category (if present)
                //File[] categoryPropertyFiles = blog.listFiles(BlojsomUtils.getExtensionsFilter(propertiesExtensions));
                if ((categoryPropertyFiles != 0) && (categoryPropertyFiles > 0)) {
                    for (int i = 0; i < categoryPropertyFiles; i++) {
                        try {
        					// ꂽs[v
                        	while (rs.next()) {
        						for (int j = 0; j < columnName.size(); j++) {
        							String line = columnName.get(j).toString();
        							//line = BlojsomUtils.replace(line, "_", ".");
        							if(line.equals("MODERATION_PLUGIN_APPROVED")){
        								line = "blojsom_comment_moderation_plugin_approved";
        							}
        							if(line.equals("COMMENT_PLUGIN_METADATA_IP")){
        								line = "blojsom_comment_plugin_metadata_ip";
        							}
        							line = line + "=" + rs.getString(columnName.get(j).toString());
        							if (line != null) {
        								if (line.length() > 0) {
        									if (line.charAt(0) != '#') {
        										int len = line.length();
        										int keyIndex;
        										for (keyIndex = 0; keyIndex < len; keyIndex++) {
        											if (line.charAt(keyIndex) == '\\')
        												keyIndex += 2;
        											else if (BlojsomProperties.whiteSpaceChars
        													.indexOf(line
        															.charAt(keyIndex)) == -1)
        												break;
        										}

        										int separatorIndex;
        										for (separatorIndex = keyIndex; separatorIndex < len; separatorIndex++) {
        											char currentChar = line
        													.charAt(separatorIndex);
        											if (currentChar == '\\')
        												separatorIndex++;
        											else if (BlojsomProperties.keyValueSeparators
        													.indexOf(currentChar) != -1)
        												break;
        										}

        										int valueIndex;
        										for (valueIndex = separatorIndex; valueIndex < len; valueIndex++)
        											if (BlojsomProperties.whiteSpaceChars
        													.indexOf(line
        															.charAt(valueIndex)) == -1)
        												break;

        										if (valueIndex < len)
        											if (BlojsomProperties.strictKeyValueSeparators
        													.indexOf(line
        															.charAt(valueIndex)) != -1)
        												valueIndex++;

        										while (valueIndex < len) {
        											if (BlojsomProperties.whiteSpaceChars
        													.indexOf(line
        															.charAt(valueIndex)) == -1)
        												break;
        											valueIndex++;
        										}

        										String key;
        										String value;

        										key = line.substring(keyIndex,
        												separatorIndex);
        										key = BlojsomUtils.replace(key, "\\",
        												"");// key="BLOJSOM_COMMENT_PLUGIN_METADATA_IP"
        										value = (separatorIndex < len) ? line
        												.substring(valueIndex, len)
        												: "";// value="127.0.0.1"

        										List values;
        										if (commentMetaDataProperties.containsKey(key)
        												&& commentMetaDataProperties.allowMultipleValues) {
        											Object previousValue = commentMetaDataProperties
        													.get(key);

        											if (previousValue instanceof List) {
        												values = (List) previousValue;
        												values.add(value);
        											} else {
        												values = new ArrayList(1);
        												values.add(previousValue);
        												values.add(value);
        											}

        											commentMetaDataProperties.put(key, values);
        										} else {
        											commentMetaDataProperties.put(key, value);
        										}
        									}
        								}
        							}
        						}
        					}
        					//rs.absolute(categoryPropertyFiles);
        					//str = rs.getString("category_name");
                        } catch (Exception e) {
                        	e.printStackTrace();
        					_logger.warn("Failed loading properties from: " + e);
                            continue;
        				}
                    }
                    setMetaData(commentMetaDataProperties);
                }
                blojsomdb.stopDB();

                
                //setMetaData(BlojsomUtils.propertiesToMap(commentMetaDataProperties));
            //}
        //} catch (Exception e) {
        //    _logger.error(e);
        //}
    }

    /**
     * Save the blog comment
     *
     * @param blogUser {@link BlogUser}
     * @since blojsom 2.26
     */
    public void save(BlogUser blogUser) throws BlojsomException {
        if (_blogEntry == null) {
            throw new BlojsomException("Blog entry for this comment not available");
        }

        Blog blog = blogUser.getBlog();
        long originalTimestamp = -1;
        originalTimestamp = _commentDateLong;

        File commentEntry;
        String commentDir = "";
        if (_source == null) {
            StringBuffer commentDirectory = new StringBuffer();
            String permalinkFilename = _blogEntry.getPermalink();
            permalinkFilename = BlojsomUtils.urlDecode(permalinkFilename);
            if (permalinkFilename == null) {
                _logger.debug("Invalid permalink comment for: " + _blogEntry.getPermalink());

                throw new BlojsomException("Invalid permalink comment for: " + _blogEntry.getPermalink());
            }

            commentDirectory.append(blog.getBlogHome());
            commentDirectory.append(BlojsomUtils.removeInitialSlash(_blogEntry.getCategory()));
            commentDir = BlojsomUtils.removeInitialSlash(_blogEntry.getCategory());
            //File blogEntry = new File(commentDirectory.toString() + File.separator + permalinkFilename);
            /*if (!blogEntry.exists()) {
                _logger.error("Trying to create comment for invalid blog entry: " + _blogEntry.getPermalink());

                throw new BlojsomException("Trying to create comment for invalid blog entry: " + _blogEntry.getPermalink());
            }*/

            commentDirectory.append(blog.getBlogCommentsDirectory());
            commentDirectory.append(File.separator);
            commentDirectory.append(permalinkFilename);
            commentDirectory.append(File.separator);
            commentDir += blog.getBlogCommentsDirectory() +"/"+ permalinkFilename;

            String commentHashable = _author + _comment;
            String hashedComment = BlojsomUtils.digestString(commentHashable).toUpperCase();
            String commentFilename = commentDirectory.toString() + hashedComment + BlojsomConstants.COMMENT_EXTENSION;

            setId(hashedComment + BlojsomConstants.COMMENT_EXTENSION);

            //File commentDir = new File(commentDirectory.toString());
            /*
            //RgfBNg̍쐬
            if (!commentDir.exists()) {
                if (!commentDir.mkdirs()) {
                    _logger.error("Could not create directory for comments: " + commentDirectory);

                    throw new BlojsomException("Could not create directory for comments: " + commentDirectory);
                }
            }
            */

            commentEntry = new File(commentFilename);
        } else {
            commentEntry = _source;
            originalTimestamp = _commentDateLong;
        }
        String category_condition = "";
        if(_blogEntry.getCategory().equals("/")){
        	category_condition = "and category_name is null";
        }else{
        	category_condition = "and category_name='"+BlojsomUtils.removeSlashes(_blogEntry.getCategory())+"'";
        }
        try {
        	BlojsomDataBase blojsomdb = new BlojsomDataBase();
        	blojsomdb.startDB();
        	int i = blojsomdb
					.myExecuteUpdate("UPDATE comment_cmt SET EMAIL='"
							+ BlojsomUtils.nullToBlank(getAuthorEmail()).trim()
							+ "', URL='"
							+ BlojsomUtils.nullToBlank(getAuthorURL()).trim()
							+ "' , blojsom_date=current_timestamp WHERE weblog_id='"+blogUser._id+"' and comment_cmt_name='" + commentEntry.getName()
							+ "' "+category_condition);		
        	if(i <= 0){
            	i = blojsomdb.myExecuteUpdate("INSERT INTO comment_cmt VALUES ('"+blogUser._id+"','"
                			+ commentEntry.getName() +"','"
        					+ BlojsomUtils.removeSlashes(_blogEntry.getCategory()) + "','"
        					+ BlojsomUtils.nullToBlank(getAuthor()).trim() + "','"
        					+ BlojsomUtils.nullToBlank(getAuthorEmail()).trim() + "','"
        					+ BlojsomUtils.nullToBlank(getAuthorURL()).trim() + "','"
        					+ BlojsomUtils.nullToBlank(getComment()).trim() + "',current_timestamp)");
        	}
        	blojsomdb.stopDB();
        	/*
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(commentEntry), blog.getBlogFileEncoding()));
            bw.write(BlojsomUtils.nullToBlank(getAuthor()).trim());
            bw.newLine();
            bw.write(BlojsomUtils.nullToBlank(getAuthorEmail()).trim());
            bw.newLine();
            bw.write(BlojsomUtils.nullToBlank(getAuthorURL()).trim());
            bw.newLine();
            bw.write(BlojsomUtils.nullToBlank(getComment()).trim());
            bw.newLine();
            bw.close();
            */
            _logger.debug("Added blog comment: " + _id);

            BlojsomProperties commentMetaDataProperties = (BlojsomProperties)BlojsomUtils.mapToProperties(_metaData, BlojsomConstants.UTF8);
            String commentMetaDataFilename = BlojsomUtils.getFilename(commentEntry.toString()) + BlojsomConstants.DEFAULT_METADATA_EXTENSION;
            //FileOutputStream fos = new FileOutputStream(new File(commentMetaDataFilename));
            //Rgmetat@C̕ۑ
            //commentMetaDataProperties.getProperty(commentMetaDataFilename,"COMMENT_META");
            //commentMetaDataProperties.store(fos, null);
            //fos.close();
            
            blojsomdb.startDB();
    		i = blojsomdb.myExecuteUpdate("UPDATE comment_meta set blojsom_date=CURRENT_TIMESTAMP WHERE weblog_id='"+blogUser._id+"' and comment_meta_name='" + commentEntry.getName().replaceAll("cmt","meta")+ "' "+category_condition);
    		if(i <= 0){
            	blojsomdb.myExecuteUpdate("INSERT INTO comment_meta (weblog_id,comment_meta_name,category_name,blojsom_date) VALUES ('"+blogUser._id+"','" + commentEntry.getName().replaceAll("cmt","meta")+ "','"+BlojsomUtils.removeSlashes(_blogEntry.getCategory())+"',CURRENT_TIMESTAMP)");
    		}
    		for (Enumeration e = commentMetaDataProperties.keys(); e.hasMoreElements();) {
    			String key = e.nextElement().toString();
    			Object value = commentMetaDataProperties.get(key);
    			key = BlojsomUtils.replace(key, " ", "\\ ");
    			key = BlojsomUtils.replace(key,"-","_");
    			key = BlojsomUtils.replace(key,".","_");
    			key = key.toLowerCase();
    			if(key.length() > 30){
					if(key.equals("blojsom_comment_plugin_metadata_ip")){
						key = "COMMENT_PLUGIN_METADATA_IP";
					}
					if(key.equals("blojsom_comment_moderation_plugin_approved")){
						key = "MODERATION_PLUGIN_APPROVED";
					}
				}
    			if (value != null && value instanceof List
    					&& commentMetaDataProperties.allowMultipleValues) {
    				List values = (List) value;
    				for ( i = 0; i < values.size(); i++) {
    					value = values.get(i);
    					// writer.write(key + "=" + value);writer.newLine();
    					int j = blojsomdb.myExecuteUpdate("UPDATE comment_meta SET " + key + "='" + value + "' WHERE weblog_id='"+blogUser._id+"' and comment_meta_name='" + commentEntry.getName().replaceAll("cmt","meta")+ "' "+category_condition);
    	        		if(j <= 0){
    	        			blojsomdb.myExecuteUpdate("ALTER TABLE comment_meta ADD " + key + " varchar2(4000)");
    	        			blojsomdb.myExecuteUpdate("UPDATE comment_meta SET " + key + "='" + value + "' WHERE weblog_id='"+blogUser._id+"' and comment_meta_name='" + commentEntry.getName().replaceAll("cmt","meta")+ "' "+category_condition);
    	        		}
    				}
    			} else {
    				value = (value != null) ? value.toString() : "";
    				// writer.write(key + "=" + value);writer.newLine();
    				i = blojsomdb.myExecuteUpdate("UPDATE comment_meta SET " + key + "='" + value + "' WHERE weblog_id='"+blogUser._id+"' and comment_meta_name='" + commentEntry.getName().replaceAll("cmt","meta")+ "' "+category_condition);
            		if(i <= 0){
            			blojsomdb.myExecuteUpdate("ALTER TABLE comment_meta ADD " + key + " varchar2(4000)");
            			blojsomdb.myExecuteUpdate("UPDATE comment_meta SET " + key + "='" + value + "' WHERE weblog_id='"+blogUser._id+"' and comment_meta_name='" + commentEntry.getName().replaceAll("cmt","meta")+ "' "+category_condition);
            		}
    			}
    		}
            blojsomdb.stopDB();
            
            _logger.debug("Wrote comment meta-data: " + commentMetaDataFilename);

            _source = commentEntry;

            if (originalTimestamp != -1) {
                _source.setLastModified(originalTimestamp);
                
                blojsomdb.startDB();
                blojsomdb
				.myExecuteUpdate("UPDATE comment_cmt SET EMAIL='"
						+ BlojsomUtils.nullToBlank(getAuthorEmail()).trim()
						+ "', URL='"
						+ BlojsomUtils.nullToBlank(getAuthorURL()).trim()
						+ "', blojsom_date=current_timestamp WHERE weblog_id='"+blogUser._id+"' and comment_cmt_name='" + commentEntry.getName()
						+ "' "+category_condition);	
                blojsomdb.stopDB();
                
                File commentMetaData = new File(commentMetaDataFilename);
                commentMetaData.setLastModified(originalTimestamp);
            }
        } catch (Exception e) {
            _logger.error(e);

            throw new BlojsomException(e);
        }
    }

    /**
     * Delete the blog comment
     *
     * @param blogUser {@link BlogUser}
     * @since blojsom 2.26
     */
    public void delete(BlogUser blogUser) throws BlojsomException {
        Blog blog = blogUser.getBlog();
        BlojsomDataBase blojsomdb = new BlojsomDataBase();
        blojsomdb.startDB();
 
        if (_source == null || _blogEntry == null) {
            throw new BlojsomException("No source file found to delete comment");
        }

        _logger.debug("Deleting comment " + _source.getAbsolutePath());
        String _category = _blogEntry.getCategory();// + blog.getBlogCommentsDirectory() + "/" + _blogEntry.getPermalink();
        
        String category_condition = "";
        if(_category.equals("/")){
        	category_condition = "and category_name is null";
        }else{
        	category_condition = "and category_name='"+BlojsomUtils.removeSlashes(_category)+"'";
        }
        
        int i = blojsomdb.myExecuteUpdate("DELETE FROM comment_cmt WHERE weblog_id='"+blogUser._id+"' and comment_cmt_name='"+_source.getName()+"' "+category_condition);
		if(i <= 0){
			throw new BlojsomException("Unable to delete commnent: " + getId());
        }

        // Delete meta-data
        File metaFile = new File(blog.getBlogHome() + _blogEntry.getCategory() + blog.getBlogCommentsDirectory()
                + File.separatorChar + _blogEntry.getPermalink() + File.separatorChar + BlojsomUtils.getFilename(_source.getName())
                + blog.getBlogEntryMetaDataExtension());
        
        i = blojsomdb.myExecuteUpdate("DELETE FROM comment_meta WHERE weblog_id='"+blogUser._id+"' and comment_meta_name='"+metaFile.getName()+"' "+category_condition);
		if(i <= 0){
			throw new BlojsomException("Unable to delete comment meta-data: " + metaFile);
		}
		blojsomdb.stopDB();
    }
}