/**
 * Copyright (c) 2003-2005, David A. Czarnecki
 * All rights reserved.
 *
 * Portions Copyright (c) 2003-2005 by Mark Lussier
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
 * Neither the name of the "David A. Czarnecki" and "blojsom" nor the names of
 * its contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Products derived from this software may not be called "blojsom",
 * nor may "blojsom" appear in their name, without prior written permission of
 * David A. Czarnecki.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.blojsom.blog;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlrpc.XmlRpcException;
import org.blojsom.BlojsomDataBase;
import org.blojsom.BlojsomException;
import org.blojsom.util.BlojsomUtils;
import org.blojsom.util.BlojsomProperties;
import org.blojsom.util.BlojsomConstants;

import java.io.*;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

/**
 * FileBackedTrackback
 *
 * @author David Czarnecki
 * @version $Id: FileBackedTrackback.java,v 1.3 2005/09/18 20:57:50 czarneckid Exp $
 * @since blojsom 2.26
 */
public class FileBackedTrackback extends Trackback {

    private transient Log _logger = LogFactory.getLog(FileBackedTrackback.class);

    protected transient File _source;

    /**
     * Default constructor
     */
    public FileBackedTrackback() {
        super();
    }

    /**
     * Trackback constructor to take a title, excerpt, url, and blog name
     *
     * @param title    Title of the trackback
     * @param excerpt  Excerpt from the trackback
     * @param url      Url for the trackback
     * @param blogName Blog name of the trackback
     */
    public FileBackedTrackback(String title, String excerpt, String url, String blogName) {
        super(title, excerpt, url, blogName);
    }

    /**
     * Retrieve the source file for this trackback
     *
     * @return {@link File} backing this trackback
     */
    public File getSource() {
        return _source;
    }

    /**
     * Set the source file for this trackback
     *
     * @param source {@link File} backing this trackback
     */
    public void setSource(File source) {
        _source = source;
    }

    /**
     * Load the trackback
     *
     * @param blogUser {@link BlogUser}
     * @since blojsom 2.26
     */
    public void load(BlogUser blogUser) throws BlojsomException {
        if (_source == null) {
			throw new BlojsomException("No source file set for this trackback");
		}
		Blog blog = blogUser.getBlog();
		File category_path = new File(_source.toString());
		String blog_home = BlojsomUtils.replace(category_path.getParent(),
				"\\", "/");
		String blog_homedir = blog.getBlogHome();
		String category_name = blog_home.replace(blog_homedir,"");
        category_name = BlojsomUtils.removeSlashes(category_name.substring(0,category_name.indexOf(".trackback")));
		
		
		BlojsomDataBase blojsomdb = new BlojsomDataBase();
		blojsomdb.startDB();
		ResultSet rs = null;
    	if(category_name.equals("")){
    		rs = blojsomdb.myExecuteQuery("SELECT * FROM trackback_tb WHERE weblog_id='"+blogUser._id
    				+"' and trackback_tb_name='" + _source.getName()
    				+ "' AND category_name is null");
		}else{
			rs = blojsomdb.myExecuteQuery("SELECT * FROM trackback_tb WHERE weblog_id='"+blogUser._id
					+"' and trackback_tb_name='" + _source.getName()
					+ "' AND category_name='" + category_name + "'");
    	}
				try {
			while (rs.next()) {
				setTitle(rs.getString("title"));
				setUrl(rs.getString("url"));
				setBlogName(rs.getString("blogname"));
				setExcerpt(rs.getString("excerpt"));
				setTrackbackDateLong(rs.getDate("blojsom_date").getTime());
				setId(_source.getName());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		blojsomdb.stopDB();

		// Load trackback meta-data if available
		File trackbackMetaData = new File(BlojsomUtils.getFilename(_source
				.toString())
				+ ".meta");

		_logger.debug("Loading trackback meta-data: "
				+ trackbackMetaData.toString());
		BlojsomProperties trackbackMetaDataProperties = new BlojsomProperties();

		blojsomdb.startDB();
		int categoryPropertyFiles = 0;
		ResultSet rs1 = null;
		Vector columnName = null;
		try {
	    	if(category_name.equals("")){
	    		rs1 = blojsomdb.myExecuteQuery("SELECT * FROM trackback_meta where weblog_id='"+blogUser._id+"' and trackback_meta_name='"
						+ trackbackMetaData.getName() + "' AND category_name is null");
			}else{
				rs1 = blojsomdb.myExecuteQuery("SELECT * FROM trackback_meta where weblog_id='"+blogUser._id+"' and trackback_meta_name='"
						+ trackbackMetaData.getName() + "' AND category_name='"
						+ category_name + "'");
	    	}			
						rs1.last();
			categoryPropertyFiles = rs1.getRow();
			ResultSetMetaData rsmd;
			rsmd = rs1.getMetaData();
			int iCols = rsmd.getColumnCount();
			int column = 6;
			columnName = new Vector();
			while (column <= iCols) {
				columnName.add(rsmd.getColumnName(column));
				column++;
			}
		} catch (SQLException e1) {
			// TODO ꂽ catch ubN
			e1.printStackTrace();
		}
		blojsomdb.stopDB();
		blojsomdb.startDB();
		// ResultSet rs = null;
		try {
	    	if(category_name.equals("")){
	    		rs = blojsomdb.myExecuteQuery("SELECT * FROM trackback_meta where weblog_id='"+blogUser._id+"' and trackback_meta_name='"
						+ trackbackMetaData.getName() + "' AND category_name is null");
			}else{
				rs = blojsomdb.myExecuteQuery("SELECT * FROM trackback_meta where weblog_id='"+blogUser._id+"' and trackback_meta_name='"
						+ trackbackMetaData.getName() + "' AND category_name='"
						+ category_name + "'");
	    	}	
		} catch (Exception e) {
			e.printStackTrace();
		}

		// Load properties file for category (if present)
		// File[] categoryPropertyFiles =
		// blog.listFiles(BlojsomUtils.getExtensionsFilter(propertiesExtensions));
		if ((categoryPropertyFiles != 0) && (categoryPropertyFiles > 0)) {
			for (int i = 0; i < categoryPropertyFiles; i++) {
				try {
					// ꂽs[v
					while (rs.next()) {
						for (int j = 0; j < columnName.size(); j++) {
							String line = columnName.get(j).toString();
							// line = BlojsomUtils.replace(line, "_", ".");
							if(line.equals("MODERATION_PLUGIN_APPROVED")){
								line = "blojsom_trackback_moderation_plugin_approved";
							}
							if(line.equals("TRACKBACK_PLUGIN_METADATA_IP")){
								line = "blojsom_trackback_plugin_metadata_ip";
							}
							line = line+ "=" + rs.getString(columnName.get(j).toString());
							if (line != null) {
								if (line.length() > 0) {
									if (line.charAt(0) != '#') {
										int len = line.length();
										int keyIndex;
										for (keyIndex = 0; keyIndex < len; keyIndex++) {
											if (line.charAt(keyIndex) == '\\')
												keyIndex += 2;
											else if (BlojsomProperties.whiteSpaceChars
													.indexOf(line
															.charAt(keyIndex)) == -1)
												break;
										}

										int separatorIndex;
										for (separatorIndex = keyIndex; separatorIndex < len; separatorIndex++) {
											char currentChar = line
													.charAt(separatorIndex);
											if (currentChar == '\\')
												separatorIndex++;
											else if (BlojsomProperties.keyValueSeparators
													.indexOf(currentChar) != -1)
												break;
										}

										int valueIndex;
										for (valueIndex = separatorIndex; valueIndex < len; valueIndex++)
											if (BlojsomProperties.whiteSpaceChars
													.indexOf(line
															.charAt(valueIndex)) == -1)
												break;

										if (valueIndex < len)
											if (BlojsomProperties.strictKeyValueSeparators
													.indexOf(line
															.charAt(valueIndex)) != -1)
												valueIndex++;

										while (valueIndex < len) {
											if (BlojsomProperties.whiteSpaceChars
													.indexOf(line
															.charAt(valueIndex)) == -1)
												break;
											valueIndex++;
										}

										String key;
										String value;

										key = line.substring(keyIndex,
												separatorIndex);
										key = BlojsomUtils.replace(key, "\\",
												"");// key="BLOJSOM_trackback_PLUGIN_METADATA_IP"
										value = (separatorIndex < len) ? line
												.substring(valueIndex, len)
												: "";// value="127.0.0.1"

										List values;
										if (trackbackMetaDataProperties
												.containsKey(key)
												&& trackbackMetaDataProperties.allowMultipleValues) {
											Object previousValue = trackbackMetaDataProperties
													.get(key);

											if (previousValue instanceof List) {
												values = (List) previousValue;
												values.add(value);
											} else {
												values = new ArrayList(1);
												values.add(previousValue);
												values.add(value);
											}

											trackbackMetaDataProperties.put(key,
													values);
										} else {
											trackbackMetaDataProperties.put(key,
													value);
										}
									}
								}
							}
						}
					}
				} catch (Exception e) {
					e.printStackTrace();
					_logger.warn("Failed loading properties from: " + e);
					continue;
				}
			}
			setMetaData(trackbackMetaDataProperties);
		}
		blojsomdb.stopDB();
    }

    /**
     * Save the trackback
     *
     * @param blogUser {@link BlogUser}
     * @since blojsom 2.26
     */
    public void save(BlogUser blogUser) throws BlojsomException {
        if (_blogEntry == null) {
            throw new BlojsomException("Blog entry for this trackback not available");
        }
        
        Blog blog = blogUser.getBlog();
        long originalTimestamp = -1;
        originalTimestamp = _trackbackDateLong;

        File trackbackEntry;
        String trackbackDir = "";
        if (_source == null) {
            StringBuffer trackbackDirectory = new StringBuffer();
            String permalinkFilename = _blogEntry.getPermalink();
            permalinkFilename = BlojsomUtils.urlDecode(permalinkFilename);
            if (permalinkFilename == null) {
                _logger.debug("Invalid permalink trackback for: " + _blogEntry.getPermalink());

                throw new BlojsomException("Invalid permalink trackback for: " + _blogEntry.getPermalink());
            }

            trackbackDirectory.append(blog.getBlogHome());
            trackbackDirectory.append(BlojsomUtils.removeInitialSlash(_blogEntry.getCategory()));
            trackbackDir = BlojsomUtils.removeInitialSlash(_blogEntry.getCategory());
            // File blogEntry = new File(trackbackDirectory.toString() +
			// File.separator + permalinkFilename);
            /*
			 * if (!blogEntry.exists()) { _logger.error("Trying to create
			 * trackback for invalid blog entry: " + _blogEntry.getPermalink());
			 * 
			 * throw new BlojsomException("Trying to create trackback for invalid
			 * blog entry: " + _blogEntry.getPermalink()); }
			 */

            trackbackDirectory.append(blog.getBlogTrackbackDirectory());
            trackbackDirectory.append(File.separator);
            trackbackDirectory.append(permalinkFilename);
            trackbackDirectory.append(File.separator);
            trackbackDir += blog.getBlogTrackbackDirectory() +"/"+ permalinkFilename;
            String trackbackFilename = trackbackDirectory.toString() + getTrackbackDateLong() + BlojsomConstants.TRACKBACK_EXTENSION;
            setId(getTrackbackDateLong() + BlojsomConstants.TRACKBACK_EXTENSION);

            trackbackEntry = new File(trackbackFilename);
        } else {
            trackbackEntry = _source;
            originalTimestamp = _trackbackDateLong;
        }
        String category_condition = "";
        if(_blogEntry.getCategory().equals("/")){
        	category_condition = "and category_name is null";
        }else{
        	category_condition = "and category_name='"+BlojsomUtils.removeSlashes(_blogEntry.getCategory())+"'";
        }
        try {
        	BlojsomDataBase blojsomdb = new BlojsomDataBase();
        	blojsomdb.startDB();
        	int i = blojsomdb
					.myExecuteUpdate("UPDATE trackback_tb SET title='"
							+ BlojsomUtils.nullToBlank(getTitle()).trim()
							+ "', url='" + BlojsomUtils.nullToBlank(getUrl()).trim()
							+ "', blogname='" + BlojsomUtils.nullToBlank(getBlogName()).trim()
							+ "', excerpt='" + BlojsomUtils.nullToBlank(getExcerpt()).trim()
							+ "' WHERE weblog_id='"+blogUser._id+"' and trackback_tb_name='" + trackbackEntry.getName()
							+ "' "+category_condition);		
        	if(i <= 0){
            	i = blojsomdb.myExecuteUpdate("INSERT INTO trackback_tb VALUES ('"+blogUser._id+"','"
                			+ trackbackEntry.getName() +"','"
        					+ BlojsomUtils.removeSlashes(_blogEntry.getCategory()) + "','"
        					+ BlojsomUtils.nullToBlank(getTitle()).trim() + "','"
        					+ BlojsomUtils.nullToBlank(getExcerpt()).trim() + "','"
        					+ BlojsomUtils.nullToBlank(getUrl()).trim() + "','"
        					+ BlojsomUtils.nullToBlank(getBlogName()).trim() + "',CURRENT_TIMESTAMP)");
        	}
        	blojsomdb.stopDB();

            _logger.debug("Added blog trackback: " + _id);

            BlojsomProperties trackbackMetaDataProperties = (BlojsomProperties)BlojsomUtils.mapToProperties(_metaData, BlojsomConstants.UTF8);
            String trackbackMetaDataFilename = BlojsomUtils.getFilename(trackbackEntry.toString()) + BlojsomConstants.DEFAULT_METADATA_EXTENSION;
            //FileOutputStream fos = new FileOutputStream(new File(trackbackMetaDataFilename));
            //Rgmetat@C̕ۑ
            //trackbackMetaDataProperties.getProperty(trackbackMetaDataFilename,"trackback_META");
            //trackbackMetaDataProperties.store(fos, null);
            //fos.close();
            
            blojsomdb.startDB();
    		i = blojsomdb.myExecuteUpdate("UPDATE trackback_meta set blojsom_date=CURRENT_TIMESTAMP WHERE weblog_id='"+blogUser._id+"' and trackback_meta_name='" + trackbackEntry.getName().replaceAll("tb","meta")+ "' "+category_condition);
    		if(i <= 0){
            	blojsomdb.myExecuteUpdate("INSERT INTO trackback_meta (weblog_id,trackback_meta_name,category_name,blojsom_date) VALUES ('"+blogUser._id+"','" + trackbackEntry.getName().replaceAll("tb","meta")+ "','"+BlojsomUtils.removeSlashes(_blogEntry.getCategory())+"',CURRENT_TIMESTAMP)");
    		}
    		for (Enumeration e = trackbackMetaDataProperties.keys(); e.hasMoreElements();) {
    			String key = e.nextElement().toString();
    			Object value = trackbackMetaDataProperties.get(key);
    			key = BlojsomUtils.replace(key, " ", "\\ ");
    			key = BlojsomUtils.replace(key,"-","_");
    			key = BlojsomUtils.replace(key,".","_");
    			key = key.toLowerCase();
    			if(key.length() > 30){
					if(key.equals("blojsom_trackback_plugin_metadata_ip")){
						key = "TRACKBACK_PLUGIN_METADATA_IP";
					}
					if(key.equals("blojsom_trackback_moderation_plugin_approved")){
						key = "MODERATION_PLUGIN_APPROVED";
					}
				}
    			if (value != null && value instanceof List
    					&& trackbackMetaDataProperties.allowMultipleValues) {
    				List values = (List) value;
    				for ( i = 0; i < values.size(); i++) {
    					value = values.get(i);
    					// writer.write(key + "=" + value);writer.newLine();
    					int j = blojsomdb.myExecuteUpdate("UPDATE trackback_meta SET " + key + "='" + value + "' WHERE weblog_id='"+blogUser._id+"' and trackback_meta_name='" + trackbackEntry.getName().replaceAll("tb","meta")+ "' "+category_condition);
    	        		if(j <= 0){
    	        			blojsomdb.myExecuteUpdate("ALTER TABLE trackback_meta ADD " + key + " varchar2(2000)");
    	        			blojsomdb.myExecuteUpdate("UPDATE trackback_meta SET " + key + "='" + value + "' WHERE weblog_id='"+blogUser._id+"' and trackback_meta_name='" + trackbackEntry.getName().replaceAll("tb","meta")+ "' "+category_condition);
    	        		}
    				}
    			} else {
    				value = (value != null) ? value.toString() : "";
    				// writer.write(key + "=" + value);writer.newLine();
    				i = blojsomdb.myExecuteUpdate("UPDATE trackback_meta SET " + key + "='" + value + "' WHERE weblog_id='"+blogUser._id+"' and trackback_meta_name='" + trackbackEntry.getName().replaceAll("tb","meta")+ "' "+category_condition);
            		if(i <= 0){
            			blojsomdb.myExecuteUpdate("ALTER TABLE trackback_meta ADD " + key + " varchar2(2000)");
            			blojsomdb.myExecuteUpdate("UPDATE trackback_meta SET " + key + "='" + value + "' WHERE weblog_id='"+blogUser._id+"' and trackback_meta_name='" + trackbackEntry.getName().replaceAll("tb","meta")+ "' "+category_condition);
            		}
    			}
    		}
            blojsomdb.stopDB();
            
            _logger.debug("Wrote trackback meta-data: " + trackbackMetaDataFilename);

            _source = trackbackEntry;

            if (originalTimestamp != -1) {
                _source.setLastModified(originalTimestamp);
                
                blojsomdb.startDB();
                blojsomdb.myExecuteUpdate("UPDATE trackback_meta SET blojsom_date=CURRENT_TIMESTAMP"
						+ " WHERE weblog_id='"+blogUser._id+"' and trackback_meta_name='"
						+ trackbackEntry.getName().replaceAll("tb", "meta")
						+ "' "+category_condition);	
                blojsomdb.stopDB();
            }
        } catch (Exception e) {
            _logger.error(e);

            throw new BlojsomException(e.getMessage());
        }
    }

    /**
     * Delete the trackback
     *
     * @param blogUser {@link BlogUser}
     * @since blojsom 2.26
     */
    public void delete(BlogUser blogUser) throws BlojsomException {
        Blog blog = blogUser.getBlog();
        BlojsomDataBase blojsomdb = new BlojsomDataBase();
        blojsomdb.startDB();
        if (_source == null || _blogEntry == null) {
            throw new BlojsomException("No source file found to delete trackback");
        }

        _logger.debug("Deleting trackback " + _source.getAbsolutePath());
        String _category = _blogEntry.getCategory();// + blog.getBlogTrackbackDirectory() + "/" + _blogEntry.getPermalink();
        String category_condition = "";
        if(_category.equals("/")){
        	category_condition = "and category_name is null";
        }else{
        	category_condition = "and category_name='"+BlojsomUtils.removeSlashes(_category)+"'";
        }
        int i = blojsomdb.myExecuteUpdate("DELETE FROM trackback_tb WHERE weblog_id='"+blogUser._id+"' and trackback_tb_name='"+_source.getName()+"' "+category_condition);
		if(i <= 0){
			throw new BlojsomException("Unable to delete trackback: " + getId());
        }

        // Delete meta-data
        File metaFile = new File(blog.getBlogHome() + _blogEntry.getCategory() + blog.getBlogTrackbackDirectory()
                + File.separatorChar + _blogEntry.getPermalink() + File.separatorChar + BlojsomUtils.getFilename(_source.getName())
                + blog.getBlogEntryMetaDataExtension());
        
        i = blojsomdb.myExecuteUpdate("DELETE FROM trackback_meta WHERE weblog_id='"+blogUser._id+"' and trackback_meta_name='"+metaFile.getName()+"' "+category_condition);
		if(i <= 0){
			throw new BlojsomException("Unable to delete trackback meta-data: " + metaFile);
		}
		blojsomdb.stopDB();
    }
}