
require 'testcase'

class NodeTest < BRbTestCase

  [
    'alias',
    'and',
    'array',
    'args', # unexpected local variable
    'begin',
    'block',
    'block_pass', # unexpected block argument
    'break', # unexpected local variable assignment
    'case',
    'class',
    'colon2',
    'colon3',
    'const',
    'cvar',
    'cvdecl',
    'dasgn_curr', # unexpected local variable assignment
    'defined',
    'defn',
    'defs',
    'dot2',
    'dot3',
    'dregx',
    'dregx_once',
    'dstr',
    'dvar', # unexpected local variable assignment
    'ensure',
    'evstr',
    'false',
    'fcall',
    'flip2', # unexpected local variable
    'flip3', # unexpected local variable
    'for', # unexpected local variable assignment
    'gasgn',
    'gvar',
    'hash', # unexpected local variable assignment
    'iasgn', # unexpected local variable assignment
    'if',
    'iter',
    'ivar', # unexpected local variable assignment
    'lasgn', # unexpected local variable assignment
    'lit',
    'lvar', # unexpected local variable assignment
    'masgn', # unexpected local variable assignment
    'match',
    'match2',
    'match3',
    'module',
    'newline',
    'next', # unexpected local variable assignment
    'nil',
    'not',
    'nth_ref', # unexpected local variable assignment
    'op_asgn_and', # unexpected local variable assignment
    'op_asgn_or', # unexpected local variable assignment
    'or',
    'postexe',
    'redo', # unexpected local variable assignment
    'rescue',
    'restargs', # unexpected local variable assignment
    'retry',
    'return',
    'sclass',
    'scope',
    'self', # unexpected local variable
    'str',
    'super', # unexpected local variable assignment
    'true',
    'undef',
    'until',
    'valias',
    'vcall',
    'when',
    'while',
    'yield',
    'zarray',
    'zsuper',
  ].each { |name|
    self.module_eval(<<-EOS)
      def test_#{name}
        assert(verify('#{name}'))
      end
    EOS
  }

end
