# $Id: testcase.rb,v 1.6 2002/12/04 09:46:51 yuya Exp $

require 'test/unit'
require 'test/unit/testcase'
require 'bruby'

class BRbTestCase < Test::Unit::TestCase

  def verify(name, dir = '')
     rbfile  = dir + 'src/' + name + '.rb'
     rbbfile = dir + 'bin/' + name + '.rbb'

     if BRb.verifyfile(rbfile)
       File.open(rbbfile, 'wb') { |file|
         file.print(BRb.dumpfile(rbfile))
       }

       return exec_ruby(rbfile) == exec_bruby(rbbfile)
     else
       return false
     end
  end

  def exec_ruby(file)
    return `ruby #{file}`
  end

  def exec_bruby(file)
    return `ruby ../bin/bruby.rb -e #{file}`
  end

end
