#!/usr/local/bin/ruby

#==============================================================================#
# bin/brbexe.rb
# $Id: brbexe.rb,v 1.3 2003/02/03 05:57:46 yuya Exp $
#==============================================================================#

require 'bruby'
require 'getoptlong'

#==============================================================================#
# BRbExeCommand Module
module BRbExeCommand

  def self.main
    options = parse_argv

    if options[:help] || ARGV.size < 1
      print_usage
    end

    inputfile = ARGV[0]

    BRb.debug = options[:debug]
    BRb.loadfile(inputfile)
  end

  def self.parse_argv
    parser = GetoptLong.new
    parser.set_options(
      ['--debug',  '-g', GetoptLong::NO_ARGUMENT],
      ['--help',   '-h', GetoptLong::NO_ARGUMENT]
    )

    options = {}
    parser.each_option { |name, argument|
      options[name.sub(/^--/, '').intern] = argument
    }

    options[:debug] = !!options[:debug]
    options[:help]  = !!options[:help]

    return options
  rescue GetoptLong::InvalidOption
    exit(1)
  end

  def self.print_usage
    STDERR.puts "bRuby #{BRb::VERSION}"
    STDERR.puts "Usage: brbexe.rb [options] file"
    STDERR.puts "Options:"
    STDERR.puts "  -g  --debug    enable debug mode."
    STDERR.puts "  -h  --help     display this information."
    exit(1)
  end

end # BRbExeCommand

#==============================================================================#

BRbExeCommand.main

#==============================================================================#
#==============================================================================#
