// $Id: BRbDebug.h,v 1.10 2003/02/21 02:19:10 yuya Exp $

#ifndef _BRbDebug_h_
#define _BRbDebug_h_

////////////////////////////////////////////////////////////////////////////////

#include "BRbBase.h"

////////////////////////////////////////////////////////////////////////////////

typedef void (*BRB_EXCEPTION)(const char*);

////////////////////////////////////////////////////////////////////////////////

class BRbDebug
{

public:
	BRbDebug(bool debug, FILE* out, VALUE exception);
	virtual ~BRbDebug();

public:
	virtual void printf(const char* format, ...);
	virtual void raise(const char* fmt, ...);
	virtual void dumpnode(NODE* node);

protected:
#ifdef DEBUG
	virtual void p(const char *fmt, ...);
	virtual void lp(int indent, const char* fmt, ...);
	virtual void lpdump(int indent, char *name, NODE *node);
	virtual void nl();
	virtual VALUE noex_name(int flag);
	virtual void dump_literal(long lit, int level);
	virtual void dump_node(NODE* n, int level);
#endif

protected:
	bool  m_debug;
	FILE* m_out;
	VALUE m_exception;

};

////////////////////////////////////////////////////////////////////////////////

#endif

////////////////////////////////////////////////////////////////////////////////
