/*****************************************************************************/
/* The development of this program is partly supported by IPA                */
/* (Information-Technology Promotion Agency, Japan).                         */
/*****************************************************************************/

/*****************************************************************************/
/*  bt_on_off.c - branch trace module on-off driver                          */
/*  Copyright: Copyright (c) Hitachi, Ltd. 2005-2006                         */
/*             Authors: Yumiko Sugita (sugita@sdl.hitachi.co.jp),            */
/*                      Satoshi Fujiwara (sa-fuji@sdl.hitachi.co.jp)         */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either version 2 of the License, or        */
/*  (at your option) any later version.                                      */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA      */
/*****************************************************************************/

#include <linux/version.h>
#include <linux/module.h>
#include "djprobe.h"
#include "bt.h"

static unsigned long on_addr;
static int on_size;
static unsigned long off_addr;
static int off_size;

static struct djprobe on_djp, off_djp;
static int bt_on_called, bt_off_called;

//#define DBG_PRINT
#ifdef DBG_PRINT
#  define dprintk(...)	printk(__VA_ARGS__)
#else
#  define dprintk(...)	
#endif

static void bt_on_probe(struct djprobe *djp, struct pt_regs *regs)
{
	if (!bt_on_called) {
		dprintk("bt_on_probe called.\n");
		bt_enable();
		bt_on_called = 1;
	}
}

static void bt_off_probe(struct djprobe *djp, struct pt_regs *regs)
{
	if (!bt_off_called) {
		dprintk("bt_off_probe called.\n");
		bt_disable();
		bt_off_called = 1;
	}
}

static int bt_on_off_init(void)
{
	int rc;

	if (on_addr) {
		if (!on_size)
			return -EINVAL;
		on_djp.addr = (void*)on_addr;
		on_djp.handler = bt_on_probe;
		on_djp.size = on_size;
		if ((rc = register_djprobe(&on_djp)) < 0)
			return rc;
		dprintk("bt_on_probe registered.\n");
	}
	if (off_addr) {
		if (!off_size)
			return -EINVAL;
		off_djp.addr = (void*)off_addr;
		off_djp.handler = bt_off_probe;
		off_djp.size = off_size;
		if ((rc = register_djprobe(&off_djp)) < 0)
			return rc;
		dprintk("bt_off_probe registered.\n");
	}
	return 0;
}

static void bt_on_off_cleanup(void)
{
	if (on_addr && on_size) {
		unregister_djprobe(&on_djp);
		dprintk("bt_on_probe unregistered.\n");
	}
	if (off_addr && off_size) {
		unregister_djprobe(&off_djp);
		dprintk("bt_off_probe unregistered.\n");
	}
	return;
}

module_init(bt_on_off_init);
module_exit(bt_on_off_cleanup);

module_param(on_addr, ulong, 0);
MODULE_PARM_DESC(on_addr, "Btrax ON probe address.");
module_param(on_size, int, 0);
MODULE_PARM_DESC(on_size, "Btrax ON probe size.");
module_param(off_addr, ulong, 0);
MODULE_PARM_DESC(off_addr, "Btrax OFF probe address.");
module_param(off_size, int, 0);
MODULE_PARM_DESC(off_size, "Btrax OFF probe size.");

MODULE_AUTHOR("Yumiko Sugita <sugita@sdl.hitachi.co.jp>,\n" \
	      "\t\tSatoshi Fujiwara <sa-fuji@sdl.hitachi.co.jp>");
MODULE_DESCRIPTION("Btrax ON/OFF probe controller");
MODULE_LICENSE("GPL");
