/*
 call table redirection
 Copyright (c) 2005 Hitachi,Ltd.,
 Created by Satoru Moriya <s-moriya@sdl.hitachi.co.jp>
 Updated by Masami Hiramatsu <hiramatu@sdl.hitachi.co.jp>
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <linux/module.h>
#include <asm/unistd.h>
#include "ctredirect.h"
#include "ctr_stub.h"

/*
 *  global variable
 */
static syscall_handler_t pre_handler = NULL;
static syscall_handler_t post_handler = NULL;
static call_table_t *true_sys_call_addr = NULL;

void pre_sys_call(const struct pt_regs regs)
{
	if (pre_handler)
		pre_handler(regs);
}

void post_sys_call(const struct pt_regs regs)
{
	if (post_handler)
		post_handler(regs);
}

static int change_sys_call_table(call_table_t * saddr)
{
	int i;

	if (true_sys_call_addr != NULL)
		return -1;
	true_sys_call_addr = saddr;

	for (i = 0; i < NR_syscalls; i++) {
		true_sys_call_table[i] = saddr[i];
		saddr[i] = (call_table_t) sys_call_stub;
	}
	return 0;
}

/* this code is so dangerous */
static void restore_sys_call_table(void)
{
	int i;
	call_table_t *sys_call_table;

	if (true_sys_call_addr == NULL)
		return;
	sys_call_table = (void *)true_sys_call_addr;

	for (i = 0; i < NR_syscalls; i++)
		sys_call_table[i] = true_sys_call_table[i];

	true_sys_call_addr = NULL;
}

/*------------------------------------------------------------------------
 *  module interface
 */

int register_ctr(syscall_handler_t pre, syscall_handler_t post)
{
	if (pre == NULL && post == NULL)
		return -EINVAL;
	pre_handler = pre;
	post_handler = post;
	return 0;
}

void unregister_ctr(void)
{
	pre_handler = NULL;
	post_handler = NULL;
}

/*------------------------------------------------------------------------
 *  module init/exit
 */

#ifdef SPLIT_MODULE
#define CTR_INIT static int __init
#define CTR_EXIT static void
#else	/* SPLIT_MODULE */
#define CTR_INIT int
#define CTR_EXIT void
#endif	/* SPLIT_MODULE */

/*
 *  global variable and parameter
 */
static unsigned long addr;
module_param(addr, ulong, 0444);
MODULE_PARM_DESC(addr, "Address of system call table(sys_call_table).");

CTR_EXIT exit_ctr(void)
{
	/* Undo sys_call_table */
	restore_sys_call_table();
}

CTR_INIT init_ctr(void)
{
	/* check parameter */
	if ((void *)addr == NULL) {
		printk(KERN_ERR "error(init):Invalid parameter\n");
		return -EINVAL;
	}

	/* call table redirection */
	if (change_sys_call_table((void *)addr) != 0) {
		exit_ctr();
		printk(KERN_ERR "error(init):Failed to change system call table\n");
		return -EINVAL;
	}
	try_module_get(THIS_MODULE);	// add (sa-fuji)

	return 0;
}

#ifdef SPLIT_MODULE
module_init(init_ctr);
module_exit(exit_ctr);
MODULE_AUTHOR("S.Moriya <s-moriya@sdl.hitachi.co.jp>");
MODULE_LICENSE("GPL");
EXPORT_SYMBOL_GPL(register_ctr);
EXPORT_SYMBOL_GPL(unregister_ctr);
#endif	/*SPLIT_MODULE */
