/*
 djprobe -- Direct jmp-insertion probe
 Copyright (c) 2005 Hitachi,Ltd.,
 Created by Masami Hiramatsu<hiramatu@sdl.hitachi.co.jp>
  
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __DJPROBE_H__
#define __DJPROBE_H__

#include <linux/ptrace.h>

typedef unsigned char kprobe_opcode_t;

/*
 * architecture depending code (must be in asm-i386)
 */
/* stub template code */
extern kprobe_opcode_t arch_tmpl_stub_entry;
extern kprobe_opcode_t arch_tmpl_stub_val;
extern kprobe_opcode_t arch_tmpl_stub_call;
extern kprobe_opcode_t arch_tmpl_stub_inst;
extern kprobe_opcode_t arch_tmpl_stub_end;

#define ARCH_STUB_VAL_IDX ((long)&arch_tmpl_stub_val - (long)&arch_tmpl_stub_entry + 1)
#define ARCH_STUB_CALL_IDX ((long)&arch_tmpl_stub_call - (long)&arch_tmpl_stub_entry + 1)
#define ARCH_STUB_INST_IDX ((long)&arch_tmpl_stub_inst - (long)&arch_tmpl_stub_entry)
#define ARCH_STUB_SIZE ((long)&arch_tmpl_stub_end - (long)&arch_tmpl_stub_entry)
#define __ARCH_STUB_SIZE 96

#define ARCH_STUB_INSN_MAX 20
#define ARCH_STUB_INSN_MIN 5

struct arch_djprobe_stub {
	kprobe_opcode_t insn[__ARCH_STUB_SIZE];
	int size;
};
#define DJPI_ARCH_SIZE(djpi) (djpi->stub.size)

#define RELATIVEJUMP_INSTRUCTION 0xe9

struct djprobe_instance;
extern void asmlinkage djprobe_callback(struct djprobe_instance * djpi,
					struct pt_regs *regs);

/*
 * common code 
 */
/* djprobe's instance (internal use)*/
struct djprobe_instance {
	struct list_head plist; /* list of djprobes for multiprobe support */
	struct arch_djprobe_stub stub;
	void * addr;
	/*struct kprobe kp;*/
	struct list_head list; /* list of djprobe_instances */
	atomic_t checked;
	atomic_t failed;
};
#define DJPI_EMPTY(djpi)  (list_empty(&djpi->plist))
#define DJPI_CHECKED(djpi) (atomic_read(&djpi->checked) == num_online_cpus())
#define DJPI_READY(djpi) (atomic_read(&djpi->checked) == num_online_cpus()-1)
#define DJPI_FAILED(djpi) (atomic_read(&djpi->failed) != 0)

struct djprobe;
typedef void (*djprobe_handler_t)(struct djprobe *, struct pt_regs *);
/*
 * Direct Jump probe interface structure
 */
struct djprobe {
	/* list of djprobes */
	struct list_head plist;

	/* probing handler (pre-executed) */
	djprobe_handler_t handler;

	/* location of the probe point */
	void * addr;
	
	/* sum of length of the replacing codes */
	int size;
	
	/* pointer for instance */
	struct djprobe_instance * inst;
};

int register_djprobe(struct djprobe *djp);
void unregister_djprobe(struct djprobe *djp);

#endif
