/*
 * Crackerjack Project
 *
 * Copyright (C) 2007-2008, Hitachi, Ltd.
 * Author(s): Takahiro Yasui <takahiro.yasui.mp@hitachi.com>,
 *            Yumiko Sugita <yumiko.sugita.yf@hitachi.com>,
 *            Satoshi Fujiwara <sa-fuji@sdl.hitachi.co.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * $Id:$
 *
 */
#ifndef __CJK_SYSCALL_SYSCTL__
#define __CJK_SYSCALL_SYSCTL__


#define REG_RESULT_LOG_FP	stdout
#define REG_DETAIL_LOG_FP	stderr


/*
 * RPRINTF : macro to output test result
 */
#define RPRINTF(...)						\
	do {							\
		fprintf(REG_RESULT_LOG_FP, __VA_ARGS__);	\
	} while (0)


/*
 * PRINTF : macro to output detail log
 */
#define PRINTF(...)						\
	do {							\
		fprintf(REG_DETAIL_LOG_FP, __VA_ARGS__);	\
	} while (0)


/*
 * EPRINTF : macro to output error message
 */
#define EPRINTF(...)						\
	do {							\
		fprintf(REG_DETAIL_LOG_FP, __VA_ARGS__);	\
	} while (0)


/*
 * DPRINTF : macro to output debug message
 */
#define DPRINTF(...)						\
	do {							\
		if (opt_debug)					\
			PRINTF("[DEBUG] " __VA_ARGS__);		\
	} while (0)


/*
 * Definitions
 */
enum result_val {
	RESULT_OK,
	RESULT_NG
};


/*
 * Proto-type
 */
////_syscall1(int, _sysctl, struct __sysctl_args *, args);
////int _sysctl(struct __sysctl_args *args);


#endif /* __CJK_SYSCALL_SYSCTL__ */
